/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.DataArea;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.IllegalObjectTypeException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.Serializable;

public class LocalDataArea
extends DataArea
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    static final int DEFAULT_LENGTH = 1024;
    static final String DEFAULT_PATH = "/QSYS.LIB/          .LIB/*LDA.DTAARA";

    public LocalDataArea() {
        try {
            super.setPath(DEFAULT_PATH);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.length_ = 1024;
        this.dataAreaType_ = 3;
    }

    public LocalDataArea(AS400 aS400) {
        super(aS400, DEFAULT_PATH);
        this.length_ = 1024;
        this.dataAreaType_ = 3;
    }

    public void clear() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        this.impl_.clear();
        this.fireCleared();
    }

    public String read() throws AS400SecurityException, ErrorCompletingRequestException, IllegalObjectTypeException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        String string = this.impl_.retrieve(-1, 1);
        this.fireRead();
        return string;
    }

    public String read(int n) throws AS400SecurityException, ErrorCompletingRequestException, IllegalObjectTypeException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        String string = this.impl_.retrieve(-1, 1, n);
        this.fireRead();
        return string;
    }

    public String read(int n, int n2) throws AS400SecurityException, ErrorCompletingRequestException, IllegalObjectTypeException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (n < 0 || n >= this.length_) {
            throw new ExtendedIllegalArgumentException("dataAreaOffset", 2);
        }
        if (n2 < 1 || n2 > this.length_) {
            throw new ExtendedIllegalArgumentException("dataLength", 2);
        }
        if (n + n2 > this.length_) {
            throw new ExtendedIllegalArgumentException("dataLength", 2);
        }
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        String string = this.impl_.retrieve(n, n2);
        this.fireRead();
        return string;
    }

    public String read(int n, int n2, int n3) throws AS400SecurityException, ErrorCompletingRequestException, IllegalObjectTypeException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (n < 0 || n >= this.length_) {
            throw new ExtendedIllegalArgumentException("dataAreaOffset", 2);
        }
        if (n2 < 1 || n2 > this.length_) {
            throw new ExtendedIllegalArgumentException("dataLength", 2);
        }
        if (n + n2 > this.length_) {
            throw new ExtendedIllegalArgumentException("dataLength", 2);
        }
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        String string = this.impl_.retrieve(n, n2, n3);
        this.fireRead();
        return string;
    }

    public int read(byte[] byArray, int n, int n2, int n3) throws AS400SecurityException, ErrorCompletingRequestException, IllegalObjectTypeException, InterruptedException, IOException, ObjectDoesNotExistException {
        return super.read(byArray, n, n2, n3);
    }

    public void write(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (string == null) {
            throw new NullPointerException("data");
        }
        if (string.length() < 1 || string.length() > this.length_) {
            throw new ExtendedIllegalArgumentException("data", 1);
        }
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        this.impl_.write(string, 0);
        this.fireWritten();
    }

    public void write(String string, int n) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (string == null) {
            throw new NullPointerException("data");
        }
        if (string.length() < 1 || string.length() > this.length_) {
            throw new ExtendedIllegalArgumentException("data", 1);
        }
        if (n < 0 || n >= this.length_) {
            throw new ExtendedIllegalArgumentException("dataAreaOffset", 2);
        }
        if (n + string.length() > this.length_) {
            throw new ExtendedIllegalArgumentException("data", 1);
        }
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        this.impl_.write(string, n);
        this.fireWritten();
    }

    public void write(String string, int n, int n2) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (string == null) {
            throw new NullPointerException("data");
        }
        if (string.length() < 1 || string.length() > this.length_) {
            throw new ExtendedIllegalArgumentException("data", 1);
        }
        if (n < 0 || n >= this.length_) {
            throw new ExtendedIllegalArgumentException("dataAreaOffset", 2);
        }
        if (n + string.length() > this.length_) {
            throw new ExtendedIllegalArgumentException("data", 1);
        }
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        this.impl_.write(string, n, n2);
        this.fireWritten();
    }

    public void write(byte[] byArray, int n, int n2, int n3) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        super.write(byArray, n, n2, n3);
    }
}

