/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.properties;

import com.ibm.xsl.composer.csstypes.CSSLength;
import com.ibm.xsl.composer.csstypes.LengthRange;
import com.ibm.xsl.composer.properties.FieldInformationTableEntry;
import com.ibm.xsl.composer.properties.Propertied;
import com.ibm.xsl.composer.properties.parser.EvaluationContext;
import com.ibm.xsl.composer.properties.parser.EvaluationResult;
import com.ibm.xsl.composer.properties.parser.LexStream;
import com.ibm.xsl.composer.properties.parser.Parser;
import com.ibm.xsl.composer.properties.parser.Scanner;
import java.util.Hashtable;

public class PropertyHolderSupport {
    static Hashtable fieldInformationTable = new Hashtable();
    static Hashtable fieldToIDMap = new Hashtable();
    Hashtable propertyFieldExpressions = new Hashtable();
    Hashtable propertyCache = new Hashtable();
    private Propertied owner;

    public PropertyHolderSupport(Propertied newOwner) {
        this.owner = newOwner;
    }

    private Object defaultForField(int fieldID) {
        FieldInformationTableEntry entry = (FieldInformationTableEntry)fieldInformationTable.get(new Integer(fieldID));
        if (entry != null) {
            return entry.getDefault();
        }
        return null;
    }

    static void defineField(int fieldID, boolean isInherited, Object defaultValue) {
        fieldInformationTable.put(new Integer(fieldID), new FieldInformationTableEntry(false, null));
    }

    Object getCachedProperty(int fieldID) {
        return this.propertyCache.get(new Integer(fieldID));
    }

    protected int getEnumeration(int propertyID) {
        return 0;
    }

    protected int getInteger(int propertyID) {
        return 0;
    }

    protected CSSLength getLength(EvaluationContext context, int propertyID) {
        CSSLength result = (CSSLength)this.getCachedProperty(propertyID);
        if (result != null) {
            return result;
        }
        String expression = this.getPropertyFieldExpression(propertyID);
        if (expression == null) {
            Propertied parent = this.owner.getParent();
            if (parent != null && this.isFieldInherited(propertyID)) {
                return null;
            }
            return (CSSLength)this.defaultForField(propertyID);
        }
        try {
            LexStream lex_stream = new LexStream();
            Scanner scanner = new Scanner(lex_stream);
            scanner.setInput(expression);
            scanner.scan();
            Parser parser = new Parser(lex_stream);
            parser.setEvaluationContext(context);
            EvaluationResult evaluationResult = parser.parse();
            if (evaluationResult == null) {
                System.out.println("parsing failed on expression: " + expression);
                return new CSSLength("1pt");
            }
            result = new CSSLength();
            result.setLength((float)evaluationResult.getAsDouble(), (short)6);
            this.setCachedProperty(propertyID, result);
            return result;
        }
        catch (Exception e) {
            System.out.println(e);
            return new CSSLength("1pt");
        }
    }

    protected LengthRange getLengthRange(int propertyID) {
        return null;
    }

    String getPropertyFieldExpression(int fieldID) {
        return (String)this.propertyFieldExpressions.get(new Integer(fieldID));
    }

    protected String getString(int propertyID) {
        return "UNFINISHED";
    }

    private boolean isFieldInherited(int fieldID) {
        FieldInformationTableEntry entry = (FieldInformationTableEntry)fieldInformationTable.get(new Integer(fieldID));
        if (entry != null) {
            return entry.isInherited();
        }
        return false;
    }

    public void setAttribute(String fieldName, String expression) throws Exception {
        Object fieldIDObject = fieldToIDMap.get(fieldName);
        if (fieldIDObject == null) {
            System.out.println("Development: Added field for " + fieldName);
            fieldIDObject = new Integer(fieldToIDMap.size());
            fieldToIDMap.put(fieldName, fieldIDObject);
        }
        this.propertyFieldExpressions.put(fieldIDObject, expression);
    }

    void setCachedProperty(int fieldID, Object newValue) {
        this.propertyCache.put(new Integer(fieldID), newValue);
    }
}

