/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.properties;

import com.ibm.xsl.composer.csstypes.CSSLength;
import com.ibm.xsl.composer.prim.ShortMap;
import com.ibm.xsl.composer.properties.parse.ParseBase;

public class PaginationAndLayoutProperty {
    private boolean inheritBlankOrNotBlank = false;
    public String blankOrNotBlank = "any";
    private boolean inheritColumnCount = false;
    public String columnCount = "1";
    private boolean inheritColumnGap = false;
    public String columnGap = "12.0pt";
    private boolean inheritExtent = false;
    public String extent = "0.0pt";
    private boolean inheritFlowName = false;
    public String flowName = "an empty name";
    private boolean inheritForcePageCount = false;
    public String forcePageCount = "auto";
    private boolean inheritInitialPageNumber = false;
    public String initialPageNumber = "auto";
    private boolean inheritMasterName = false;
    public String masterName = "an empty name";
    private boolean inheritMaximumRepeats = false;
    public String maximumRepeats = "no-limit";
    private boolean inheritOddOREven = false;
    public String oddOREven = "any";
    private static final String AUTO = "auto";
    public static final short PAGE_INHERIT = 0;
    public static final short PAGE_INDEFINITE = 1;
    public static final short PAGE_AUTO = 2;
    public static final short PAGE_LONGEST = 3;
    public static final short PAGE_IS_A_LENGTH = 4;
    private static final ShortMap pageMap = new ShortMap(new String[]{"inherit", "indefinite", "auto", "longest", "is_a_length"});
    public short pageWidthValue = (short)2;
    public short pageHeightValue = (short)2;
    public final CSSLength pageWidth = new CSSLength(2);
    public final CSSLength pageHeight = new CSSLength(2);
    private boolean inheritPagePosition = false;
    public String pagePosition = "any";
    private boolean inheritPrecedence = false;
    public String precedence = "false";
    public String regionName;

    public boolean cmpPaginationAndLayoutProperty(PaginationAndLayoutProperty pp) {
        boolean state = false;
        if (this.blankOrNotBlank.equalsIgnoreCase(pp.blankOrNotBlank) && this.columnCount.equalsIgnoreCase(pp.columnCount) && this.columnGap.equalsIgnoreCase(pp.columnGap) && this.extent.equalsIgnoreCase(pp.extent) && this.flowName.equalsIgnoreCase(pp.flowName) && this.forcePageCount.equalsIgnoreCase(pp.forcePageCount) && this.initialPageNumber.equalsIgnoreCase(pp.initialPageNumber) && this.masterName.equalsIgnoreCase(pp.masterName) && this.maximumRepeats.equalsIgnoreCase(pp.maximumRepeats) && this.pageHeightValue == pp.pageHeightValue && this.pageHeight.equals(pp.pageHeight) && this.pageWidthValue == pp.pageWidthValue && this.pageWidth.equals(pp.pageWidth) && this.oddOREven.equalsIgnoreCase(pp.oddOREven) && this.pagePosition.equalsIgnoreCase(pp.pagePosition) && this.precedence.equalsIgnoreCase(pp.precedence) && this.regionName.equalsIgnoreCase(pp.regionName)) {
            state = true;
        }
        return state;
    }

    public boolean equals(Object obj) {
        boolean isEquals = false;
        if (this == obj) {
            isEquals = true;
        } else if (obj != null && obj instanceof PaginationAndLayoutProperty) {
            isEquals = this.cmpPaginationAndLayoutProperty((PaginationAndLayoutProperty)obj);
        }
        return isEquals;
    }

    public String getBlankOrNotBlank() {
        return this.blankOrNotBlank;
    }

    public String getColumnCount() {
        return this.columnCount;
    }

    public String getColumnGap() {
        return this.columnGap;
    }

    public String getExtent() {
        return this.extent;
    }

    public String getFlowName() {
        return this.flowName;
    }

    public String getForcePageCount() {
        return this.forcePageCount;
    }

    public String getInitialPageNumber() {
        return this.initialPageNumber;
    }

    public String getMasterName() {
        return this.masterName;
    }

    public String getMaximumRepeats() {
        return this.maximumRepeats;
    }

    public String getOddOREven() {
        return this.oddOREven;
    }

    public String getPageHeight() {
        if (this.pageHeightValue == 4) {
            return this.pageHeight.getLength();
        }
        return pageMap.getName(this.pageHeightValue);
    }

    public String getPageHeightAttribute() {
        return this.getPageHeight();
    }

    public String getPagePosition() {
        return this.pagePosition;
    }

    public String getPageWidth() {
        if (this.pageWidthValue == 4) {
            return this.pageWidth.getLength();
        }
        return pageMap.getName(this.pageWidthValue);
    }

    public String getPageWidthAttribute() {
        return this.getPageWidth();
    }

    public boolean getPrecedence() {
        boolean returnPrecedence = this.precedence.compareToIgnoreCase("false") != 0;
        return returnPrecedence;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public String getSize() {
        return "width:" + this.getPageWidth() + " height:" + this.getPageHeight();
    }

    public boolean inherit(PaginationAndLayoutProperty parent) {
        boolean altered = false;
        if (this.inheritBlankOrNotBlank && !this.blankOrNotBlank.equals(parent.blankOrNotBlank)) {
            altered = true;
        }
        if (this.inheritColumnCount && !this.columnCount.equals(parent.columnCount)) {
            altered = true;
        }
        if (this.inheritColumnGap && !this.columnGap.equals(parent.columnGap)) {
            altered = true;
        }
        if (this.inheritExtent && !this.extent.equals(parent.extent)) {
            altered = true;
        }
        if (this.inheritFlowName && !this.flowName.equals(parent.flowName)) {
            altered = true;
        }
        if (this.inheritForcePageCount && !this.forcePageCount.equals(parent.forcePageCount)) {
            altered = true;
        }
        if (this.inheritInitialPageNumber && !this.initialPageNumber.equals(parent.initialPageNumber)) {
            altered = true;
        }
        if (this.inheritMasterName && !this.masterName.equals(parent.masterName)) {
            altered = true;
        }
        if (this.inheritMaximumRepeats && !this.maximumRepeats.equals(parent.maximumRepeats)) {
            altered = true;
        }
        if (this.inheritOddOREven && !this.oddOREven.equals(parent.oddOREven)) {
            altered = true;
        }
        if (this.pageHeightValue == 0 && this.pageHeightValue != parent.pageHeightValue) {
            this.pageHeightValue = parent.pageHeightValue;
            this.pageHeight.copy(parent.pageWidth);
            altered = true;
        }
        if (this.pageWidthValue == 0 && this.pageWidthValue != parent.pageWidthValue) {
            this.pageWidthValue = parent.pageWidthValue;
            this.pageWidth.copy(parent.pageWidth);
            altered = true;
        }
        if (this.inheritPagePosition && !this.pagePosition.equals(parent.pagePosition)) {
            altered = true;
        }
        if (this.inheritPrecedence && !this.precedence.equals(parent.precedence)) {
            altered = true;
        }
        return altered;
    }

    public void setBlankOrNotBlank(String blankOrNotBlank) {
        this.blankOrNotBlank = blankOrNotBlank;
    }

    public void setColumnCount(String columnCount) {
        this.columnCount = columnCount;
    }

    public void setColumnGap(String columnGap) {
        this.columnGap = columnGap;
    }

    public void setExtent(String extent) {
        this.extent = extent;
    }

    public void setFlowName(String flowName) {
        this.flowName = flowName;
    }

    public void setForcePageCount(String forcePageCount) {
        this.forcePageCount = forcePageCount;
    }

    public void setInitialPageNumber(String initialPageNumber) {
        this.initialPageNumber = initialPageNumber;
    }

    public void setMasterName(String masterName) {
        this.masterName = masterName;
    }

    public void setMaximumRepeats(String maximumRepeats) {
        this.maximumRepeats = maximumRepeats;
    }

    public void setOddOREven(String oddOREven) {
        this.oddOREven = oddOREven;
    }

    public void setPageHeight(String pageHeight) {
        pageHeight = pageHeight.trim().toLowerCase();
        try {
            this.pageHeightValue = pageMap.decodeName(pageHeight);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (CSSLength.isValid(pageHeight, 2)) {
                this.pageHeightValue = (short)4;
                this.pageHeight.setLength(pageHeight);
            }
            new ParseBase().dontUnderstand("page-height", pageHeight);
        }
        System.out.println("setPageHeight:" + this.getPageHeight());
    }

    public void setPagePosition(String pagePosition) {
        this.pagePosition = pagePosition;
    }

    public void setPageWidth(String pageWidth) {
        pageWidth = pageWidth.trim().toLowerCase();
        try {
            this.pageWidthValue = pageMap.decodeName(pageWidth);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (CSSLength.isValid(pageWidth, 2)) {
                this.pageWidthValue = (short)4;
                this.pageWidth.setLength(pageWidth);
            }
            new ParseBase().dontUnderstand("page-width", pageWidth);
        }
        System.out.println("setPageWidth:" + this.getPageWidth());
    }

    public void setPrecedence(String precedence) {
        this.precedence = precedence;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    public void setSizeShorthandProperty(String size) {
        if ((size = size.toLowerCase()).equals("inherit")) {
            this.setPageHeight("inherit");
            this.setPageWidth("inherit");
        } else if (size.equals(AUTO)) {
            this.setPageHeight(AUTO);
            this.setPageWidth(AUTO);
        } else if (size.equals("landscape")) {
            this.setPageHeight(AUTO);
            this.setPageWidth("longest");
        } else if (size.equals("portrait")) {
            this.setPageHeight("longest");
            this.setPageWidth(AUTO);
        } else {
            ParseBase p = new ParseBase();
            p.setParseString(size);
            p.scanAndTokenize();
            String width = p.nextToken();
            if (width != null && CSSLength.isValid(width, 2)) {
                boolean one = true;
                String height = p.nextToken();
                if (height != null && CSSLength.isValid(height, 2)) {
                    one = false;
                }
                if (one) {
                    this.setPageWidth(width);
                    this.setPageHeight(width);
                } else {
                    this.setPageWidth(width);
                    this.setPageHeight(height);
                }
            } else {
                new ParseBase().dontUnderstand("size", size);
            }
        }
        System.out.println("getSize:" + this.getSize());
    }
}

