/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.properties;

import com.ibm.xsl.composer.csstypes.CSSLength;
import com.ibm.xsl.composer.csstypes.IpdBpdCDT;
import com.ibm.xsl.composer.prim.ShortMap;
import com.ibm.xsl.composer.properties.parse.ParseBase;

public class AreaDimensionProperty {
    public static final short HEIGHT_WIDTH_INHERIT = 0;
    public static final short HEIGHT_WIDTH_AUTO = 1;
    public static final short HEIGHT_WIDTH_ISLENGTH = 2;
    private static final ShortMap heightWidthMap = new ShortMap(new String[]{"inherit", "auto"});
    public short heightValue = 1;
    public final CSSLength heightLength = new CSSLength(3);
    public short widthValue = 1;
    public final CSSLength widthLength = new CSSLength(3);
    public short contentHeightValue = 1;
    public final CSSLength contentHeightLength = new CSSLength(3);
    public short contentWidthValue = 1;
    public final CSSLength contentWidthLength = new CSSLength(3);
    private boolean inheritMaxHeight = false;
    private boolean isMaxHeightNone = true;
    private boolean inheritMaxWidth = false;
    private boolean isMaxWidthNone = true;
    private boolean inheritMinHeight = false;
    private boolean inheritMinWidth = false;
    public static final short SCALING_INHERIT = 0;
    public static final short SCALING_UNIFORM = 1;
    public static final short SCALING_NONUNIFORM = 2;
    private static final ShortMap scalingMap = new ShortMap(new String[]{"inherit", "uniform", "non-uniform"});
    public short scalingValue = 1;
    private boolean inheritScalingMethod = false;
    private boolean isAutoScalingMethod = true;
    private IpdBpdCDT blockProgressionDimension = new IpdBpdCDT();
    private IpdBpdCDT inlineProgressionDimension = new IpdBpdCDT();
    private CSSLength maxHeight = new CSSLength(3);
    private CSSLength maxWidth = new CSSLength(3);
    private CSSLength minHeight = new CSSLength(3);
    private CSSLength minWidth = new CSSLength(3);
    private CSSLength scalingMethod = new CSSLength();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean cmpAreaDimensionProperty(AreaDimensionProperty ap) {
        if (this.blockProgressionDimension.isInherited() != ap.blockProgressionDimension.isInherited()) return false;
        if (!this.blockProgressionDimension.isInherited()) {
            if (!ap.blockProgressionDimension.equals(this.blockProgressionDimension)) return false;
        }
        if (this.inlineProgressionDimension.isInherited() != ap.inlineProgressionDimension.isInherited()) return false;
        if (!this.inlineProgressionDimension.isInherited()) {
            if (!ap.inlineProgressionDimension.equals(this.inlineProgressionDimension)) return false;
        }
        if (this.contentHeightValue != ap.contentHeightValue) return false;
        if (!(this.contentHeightValue == 0 || this.contentHeightValue != 2 ? true : this.contentHeightLength.equals(ap.contentHeightLength))) return false;
        if (this.heightValue != ap.heightValue) return false;
        if (!(this.heightValue == 0 || this.heightValue != 2 ? true : this.heightLength.equals(ap.heightLength))) return false;
        if (this.widthValue != ap.widthValue) return false;
        if (!(this.widthValue == 0 || this.widthValue != 2 ? true : this.widthLength.equals(ap.widthLength))) return false;
        if (this.contentWidthValue != ap.contentWidthValue) return false;
        if (!(this.contentWidthValue == 0 || this.contentWidthValue != 2 ? true : this.contentWidthLength.equals(ap.contentWidthLength))) return false;
        if (this.inheritMaxHeight != ap.inheritMaxHeight) return false;
        if (this.isMaxHeightNone != ap.isMaxHeightNone) return false;
        if (!this.inheritMaxHeight) {
            if (!ap.maxHeight.equals(this.maxHeight)) return false;
        }
        if (this.inheritMaxWidth != ap.inheritMaxWidth) return false;
        if (this.isMaxWidthNone != ap.isMaxWidthNone) return false;
        if (!this.inheritMaxWidth) {
            if (!ap.maxWidth.equals(this.maxWidth)) return false;
        }
        if (this.inheritMinHeight != ap.inheritMinHeight) return false;
        if (!this.inheritMinHeight) {
            if (!ap.minHeight.equals(this.minHeight)) return false;
        }
        if (this.inheritMinWidth != ap.inheritMinWidth) return false;
        if (!this.inheritMinWidth) {
            if (!ap.minWidth.equals(this.minWidth)) return false;
        }
        if (this.scalingValue != 0) {
            if (this.scalingValue != ap.scalingValue) return false;
        }
        if (this.inheritScalingMethod != ap.inheritScalingMethod) return false;
        if (this.isAutoScalingMethod != ap.isAutoScalingMethod) return false;
        if (this.inheritScalingMethod) return true;
        if (ap.scalingMethod.equals(this.scalingMethod)) return true;
        return false;
    }

    public boolean equals(Object obj) {
        boolean isEquals = false;
        if (this == obj) {
            isEquals = true;
        } else if (obj != null && obj instanceof AreaDimensionProperty) {
            isEquals = this.cmpAreaDimensionProperty((AreaDimensionProperty)obj);
        }
        return isEquals;
    }

    public CSSLength getBlockProgressionDimension() {
        return this.blockProgressionDimension.getOptimum();
    }

    public String getBlockProgressionDimensionAttribute() {
        return this.blockProgressionDimension.getString();
    }

    public String getContentHeight() {
        String s = this.contentHeightValue == 2 ? this.contentHeightLength.getLength() : heightWidthMap.getName(this.contentHeightValue);
        return s;
    }

    public String getContentHeightAttribute() {
        return this.getContentHeight();
    }

    public String getContentWidth() {
        String s = this.contentWidthValue == 2 ? this.contentWidthLength.getLength() : heightWidthMap.getName(this.contentWidthValue);
        return s;
    }

    public String getContentWidthAttribute() {
        return this.getContentWidth();
    }

    public String getHeight() {
        String s = this.heightValue == 2 ? this.heightLength.getLength() : heightWidthMap.getName(this.heightValue);
        return s;
    }

    public String getHeightAttribute() {
        return this.getHeight();
    }

    public CSSLength getInlineProgressionDimension() {
        return this.inlineProgressionDimension.getOptimum();
    }

    public String getInlineProgressionDimensionAttribute() {
        return this.inlineProgressionDimension.getString();
    }

    public CSSLength getMaxHeight() {
        return this.maxHeight;
    }

    public String getMaxHeightAttribute() {
        String result = this.inheritMaxHeight ? "inherit" : (this.isMaxHeightNone ? "none" : this.maxHeight.getLength());
        return result;
    }

    public CSSLength getMaxWidth() {
        return this.maxWidth;
    }

    public String getMaxWidthAttribute() {
        String result = this.inheritMaxWidth ? "inherit" : (this.isMaxWidthNone ? "none" : this.maxWidth.getLength());
        return result;
    }

    public CSSLength getMinHeight() {
        return this.minHeight;
    }

    public String getMinHeightAttribute() {
        String result = this.inheritMinHeight ? "inherit" : this.minHeight.getLength();
        return result;
    }

    public CSSLength getMinWidth() {
        return this.minWidth;
    }

    public String getMinWidthAttribute() {
        String result = this.inheritMinWidth ? "inherit" : this.minWidth.getLength();
        return result;
    }

    public short getScaling() {
        return this.scalingValue;
    }

    public String getScalingAttribute() {
        return scalingMap.getName(this.scalingValue);
    }

    public CSSLength getScalingMethod() {
        return this.scalingMethod;
    }

    public String getScalingMethodAttribute() {
        String result = this.inheritScalingMethod ? "inherit" : (this.isAutoScalingMethod ? "auto" : this.scalingMethod.getLength());
        return result;
    }

    public String getWidth() {
        String s = this.widthValue == 2 ? this.widthLength.getLength() : heightWidthMap.getName(this.widthValue);
        return s;
    }

    public String getWidthAttribute() {
        return this.getWidth();
    }

    public boolean inherit(AreaDimensionProperty ap) {
        boolean altered = false;
        if (this.blockProgressionDimension.isInherited() && !ap.blockProgressionDimension.equals(this.blockProgressionDimension)) {
            this.blockProgressionDimension.copy(ap.blockProgressionDimension);
            altered = true;
        }
        if (this.inlineProgressionDimension.isInherited() && !ap.inlineProgressionDimension.equals(this.inlineProgressionDimension)) {
            this.inlineProgressionDimension.copy(ap.inlineProgressionDimension);
            altered = true;
        }
        if (this.heightValue == 0) {
            this.heightValue = ap.heightValue;
            this.heightLength.copy(ap.heightLength);
            altered = true;
        }
        if (this.contentHeightValue == 0) {
            this.contentHeightValue = ap.contentHeightValue;
            this.contentHeightLength.copy(ap.contentHeightLength);
            altered = true;
        }
        if (this.widthValue == 0) {
            this.widthValue = ap.widthValue;
            this.widthLength.copy(ap.widthLength);
            altered = true;
        }
        if (this.contentWidthValue == 0) {
            this.contentWidthValue = ap.contentWidthValue;
            this.contentWidthLength.copy(ap.contentWidthLength);
            altered = true;
        }
        if (this.inheritMaxHeight && (this.isMaxHeightNone != ap.isMaxHeightNone || !ap.maxHeight.equals(this.maxHeight))) {
            this.isMaxHeightNone = ap.isMaxHeightNone;
            this.maxHeight.copy(ap.maxHeight);
            altered = true;
        }
        if (this.inheritMaxWidth && this.isMaxWidthNone != ap.isMaxWidthNone || !ap.maxWidth.equals(this.maxWidth)) {
            this.isMaxWidthNone = ap.isMaxWidthNone;
            this.maxWidth.copy(ap.maxWidth);
            altered = true;
        }
        if (this.inheritMinHeight && !ap.minHeight.equals(this.minHeight)) {
            this.minHeight.copy(ap.minHeight);
            altered = true;
        }
        if (this.inheritMinWidth && !ap.minWidth.equals(this.minWidth)) {
            this.minWidth.copy(ap.minWidth);
            altered = true;
        }
        if (this.scalingValue == 0) {
            this.scalingValue = ap.scalingValue;
            altered = true;
        }
        if (this.inheritScalingMethod && (this.isAutoScalingMethod != ap.isAutoScalingMethod || !ap.scalingMethod.equals(this.scalingMethod))) {
            this.isAutoScalingMethod = ap.isAutoScalingMethod;
            this.scalingMethod.copy(ap.scalingMethod);
            altered = true;
        }
        return altered;
    }

    public boolean isAutoBlockProgressionDimension() {
        return this.blockProgressionDimension.isOptimumAuto();
    }

    public boolean isAutoInlineProgressionDimension() {
        return this.inlineProgressionDimension.isOptimumAuto();
    }

    public void setBlockProgressionDimension(String value) {
        this.blockProgressionDimension.setLength(value);
    }

    public void setBlockProgressionDimensionMaximum(String value) {
        this.blockProgressionDimension.setMaximum(value);
    }

    public void setBlockProgressionDimensionMinimum(String value) {
        this.blockProgressionDimension.setMinimum(value);
    }

    public void setBlockProgressionDimensionOptimum(String value) {
        this.blockProgressionDimension.setOptimum(value);
    }

    public void setContentHeight(String contentHeight) {
        String value = contentHeight.trim().toLowerCase();
        try {
            this.contentHeightValue = heightWidthMap.decodeName(value);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (CSSLength.isValid(value, 3)) {
                this.contentHeightLength.setLength(value);
                this.contentHeightValue = (short)2;
            }
            new ParseBase().dontUnderstand("content-height", value);
        }
    }

    public void setContentWidth(String contentWidth) {
        String value = contentWidth.trim().toLowerCase();
        try {
            this.contentWidthValue = heightWidthMap.decodeName(value);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (CSSLength.isValid(value, 3)) {
                this.contentWidthLength.setLength(value);
                this.contentWidthValue = (short)2;
            }
            new ParseBase().dontUnderstand("content-width", value);
        }
    }

    public void setHeight(String height) {
        String value = height.trim().toLowerCase();
        try {
            this.heightValue = heightWidthMap.decodeName(value);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (CSSLength.isValid(value, 3)) {
                this.heightLength.setLength(value);
                this.heightValue = (short)2;
            }
            new ParseBase().dontUnderstand("height", value);
        }
    }

    public void setInlineProgressionDimension(String value) {
        this.inlineProgressionDimension.setLength(value);
    }

    public void setInlineProgressionDimensionMaximum(String value) {
        this.inlineProgressionDimension.setMaximum(value);
    }

    public void setInlineProgressionDimensionMinimum(String value) {
        this.inlineProgressionDimension.setMinimum(value);
    }

    public void setInlineProgressionDimensionOptimum(String value) {
        this.inlineProgressionDimension.setOptimum(value);
    }

    public void setMaxHeight(String value) {
        if ((value = value.trim().toLowerCase()).equals("inherit")) {
            this.inheritMaxHeight = true;
        } else if (value.equals("none")) {
            this.inheritMaxHeight = false;
            this.isMaxHeightNone = true;
        } else if (CSSLength.isValid(value, 3)) {
            this.inheritMaxHeight = false;
            this.isMaxHeightNone = false;
            this.maxHeight.setLength(value);
        } else {
            new ParseBase().dontUnderstand("max-height", value);
        }
    }

    public void setMaxWidth(String value) {
        if ((value = value.trim().toLowerCase()).equals("inherit")) {
            this.inheritMaxWidth = true;
        } else if (value.equals("none")) {
            this.inheritMaxWidth = false;
            this.isMaxWidthNone = true;
        } else if (CSSLength.isValid(value, 3)) {
            this.inheritMaxWidth = false;
            this.isMaxWidthNone = false;
            this.maxWidth.setLength(value);
        } else {
            new ParseBase().dontUnderstand("max-width", value);
        }
    }

    public void setMinHeight(String value) {
        if ((value = value.trim().toLowerCase()).equals("inherit")) {
            this.inheritMinHeight = true;
        } else if (CSSLength.isValid(value, 3)) {
            this.inheritMinHeight = false;
            this.minHeight.setLength(value);
        } else {
            new ParseBase().dontUnderstand("min-height", value);
        }
    }

    public void setMinWidth(String value) {
        if ((value = value.trim().toLowerCase()).equals("inherit")) {
            this.inheritMinWidth = true;
        } else if (CSSLength.isValid(value, 3)) {
            this.inheritMinWidth = false;
            this.minWidth.setLength(value);
        } else {
            new ParseBase().dontUnderstand("min-width", value);
        }
    }

    public void setScaling(String scaling) {
        String value = scaling.trim().toLowerCase();
        try {
            this.scalingValue = scalingMap.decodeName(value);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            new ParseBase().dontUnderstand("scaling", value);
        }
    }

    public void setScalingMethod(String value) {
        if ((value = value.trim().toLowerCase()).equals("inherit")) {
            this.inheritScalingMethod = true;
        } else if (value.equals("auto")) {
            this.isAutoScalingMethod = true;
        } else {
            this.scalingMethod.setLength(value);
        }
    }

    public void setWidth(String width) {
        String value = width.trim().toLowerCase();
        try {
            this.widthValue = heightWidthMap.decodeName(value);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (CSSLength.isValid(value, 3)) {
                this.widthLength.setLength(value);
                this.widthValue = (short)2;
            }
            new ParseBase().dontUnderstand("width", value);
        }
    }
}

