/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.prim;

public class ShortMap {
    public String[] names;
    public short[] values;

    public ShortMap(String[] names) {
        this.names = names;
    }

    public ShortMap(String[] names, short[] values) {
        this.names = names;
        this.values = values;
        if (values.length != names.length) {
            throw new IllegalArgumentException("names and values arrays do not contain an equal number of elements");
        }
    }

    public final short decodeName(String name) {
        boolean found = false;
        int value = 0;
        int i = 0;
        while (!found && i < this.names.length) {
            if (name.equals(this.names[i])) {
                found = true;
                value = this.values == null ? i : this.values[i];
            }
            i = (short)(i + 1);
        }
        if (!found) {
            throw new IllegalArgumentException("Invalid mapped name, " + name);
        }
        return (short)value;
    }

    public final String getName(short value) {
        String name = null;
        if (this.values == null && value >= 0 && value < this.names.length) {
            name = this.names[value];
        } else if (this.values != null) {
            int i = 0;
            while (name == null && i < this.values.length) {
                if (this.values[i] == value) {
                    name = this.names[i];
                }
                i = (short)(i + 1);
            }
        }
        if (name == null) {
            throw new IllegalArgumentException("Invalid mapped value, " + value);
        }
        return name;
    }
}

