/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.java2d;

import com.ibm.xsl.composer.csstypes.CSSColor;
import com.ibm.xsl.composer.java2d.J2DFourEdgeBorder;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;

public class J2DRidgeGrooveBorder
extends J2DFourEdgeBorder {
    public static final int NO_STYLE = 0;
    public static final int RIDGE = 1;
    public static final int GROOVE = 2;
    protected int topStyle = 0;
    protected int bottomStyle = 0;
    protected int rightStyle = 0;
    protected int leftStyle = 0;

    protected void drawBottom(Graphics g, Color innerColor, Color middleColor, Color outerColor, int w, int h) {
        if (this.bottomWidth <= 2) {
            g.setColor(this.bottomStyle == 2 ? this.bottomColor.brighter().brighter() : this.bottomColor);
            g.drawLine(0, h - 1, w - 1, h - 1);
            if (this.bottomWidth == 1) {
                return;
            }
            g.setColor(this.bottomStyle == 2 ? this.bottomColor : this.bottomColor.brighter().brighter());
            g.drawLine(w - 2, h - 2, 0, h - 2);
            return;
        }
        int outerWidth = this.bottomWidth / 3;
        int middleWidth = outerWidth * 2;
        g.setColor(outerColor);
        int i = 0;
        while (i <= outerWidth) {
            g.drawLine(i, h - 1 - i, w - 1 - i, h - 1 - i);
            ++i;
        }
        g.setColor(middleColor);
        while (i < middleWidth) {
            g.drawLine(i, h - 1 - i, w - 1 - i, h - 1 - i);
            ++i;
        }
        g.setColor(innerColor);
        while (i < this.bottomWidth) {
            g.drawLine(i, h - 1 - i, w - 1 - i, h - 1 - i);
            ++i;
        }
    }

    protected void drawLeft(Graphics g, Color innerColor, Color middleColor, Color outerColor, int w, int h) {
        if (this.leftWidth <= 2) {
            g.setColor(this.leftStyle == 2 ? this.leftColor.darker() : this.leftColor.brighter());
            g.drawLine(0, h - 2, 0, 0);
            if (this.leftWidth == 1) {
                return;
            }
            g.setColor(this.leftStyle == 2 ? this.leftColor.brighter() : this.leftColor.darker());
            g.drawLine(1, h - 3, 1, 1);
            return;
        }
        int outerWidth = this.leftWidth / 3;
        int middleWidth = outerWidth * 2;
        g.setColor(outerColor);
        int i = 0;
        while (i <= outerWidth) {
            g.drawLine(i, i, i, h - 1 - i);
            ++i;
        }
        g.setColor(middleColor);
        while (i < middleWidth) {
            g.drawLine(i, i, i, h - 1 - i);
            ++i;
        }
        g.setColor(innerColor);
        while (i < this.leftWidth) {
            g.drawLine(i, i, i, h - 1 - i);
            ++i;
        }
    }

    protected void drawRight(Graphics g, Color innerColor, Color middleColor, Color outerColor, int w, int h) {
        if (this.rightWidth <= 2) {
            g.setColor(this.rightStyle == 2 ? this.rightColor.brighter().brighter() : this.rightColor);
            g.drawLine(w - 1, h - 1, w - 1, 0);
            if (this.rightWidth == 1) {
                return;
            }
            g.setColor(this.rightStyle == 2 ? this.rightColor : this.rightColor.brighter().brighter());
            g.drawLine(w - 2, 0, w - 2, h - 2);
            return;
        }
        int outerWidth = this.rightWidth / 3;
        int middleWidth = outerWidth * 2;
        g.setColor(outerColor);
        int i = 0;
        while (i <= outerWidth) {
            g.drawLine(w - 1 - i, i, w - 1 - i, h - 1 - i);
            ++i;
        }
        g.setColor(middleColor);
        while (i < middleWidth) {
            g.drawLine(w - 1 - i, i, w - 1 - i, h - 1 - i);
            ++i;
        }
        g.setColor(innerColor);
        while (i < this.rightWidth) {
            g.drawLine(w - 1 - i, i, w - 1 - i, h - 1 - i);
            ++i;
        }
    }

    protected void drawTop(Graphics g, Color innerColor, Color middleColor, Color outerColor, int w, int h) {
        if (this.topWidth <= 2) {
            g.setColor(this.topStyle == 2 ? this.topColor : this.topColor.brighter().brighter());
            g.drawLine(0, 0, w - 2, 0);
            if (this.topWidth == 1) {
                return;
            }
            g.setColor(this.topStyle == 2 ? this.topColor.brighter().brighter() : this.topColor);
            g.drawLine(1, 1, w - 3, 1);
            return;
        }
        int outerWidth = this.topWidth / 3;
        int middleWidth = outerWidth * 2;
        g.setColor(outerColor);
        int i = 0;
        while (i <= outerWidth) {
            g.drawLine(i, i, w - 1 - i, i);
            ++i;
        }
        g.setColor(middleColor);
        while (i < middleWidth) {
            g.drawLine(i, i, w - 1 - i, i);
            ++i;
        }
        g.setColor(innerColor);
        while (i < this.topWidth) {
            g.drawLine(i, i, w - 1 - i, i);
            ++i;
        }
    }

    public void paintBorder(Graphics2D g, int x, int y, int width, int height) {
        Stroke oldStroke = g.getStroke();
        g.setStroke(new BasicStroke());
        if (this.topEdge && this.topStyle == 1 && this.topWidth > 0) {
            this.paintTopRidge(g, x, y, width, height);
        }
        if (this.bottomEdge && this.bottomStyle == 1 && this.bottomWidth > 0) {
            this.paintBottomRidge(g, x, y, width, height);
        }
        if (this.rightEdge && this.rightStyle == 1 && this.rightWidth > 0) {
            this.paintRightRidge(g, x, y, width, height);
        }
        if (this.leftEdge && this.leftStyle == 1 && this.leftWidth > 0) {
            this.paintLeftRidge(g, x, y, width, height);
        }
        if (this.topEdge && this.topStyle == 2 && this.topWidth > 0) {
            this.paintTopGroove(g, x, y, width, height);
        }
        if (this.bottomEdge && this.bottomStyle == 2 && this.bottomWidth > 0) {
            this.paintBottomGroove(g, x, y, width, height);
        }
        if (this.rightEdge && this.rightStyle == 2 && this.rightWidth > 0) {
            this.paintRightGroove(g, x, y, width, height);
        }
        if (this.leftEdge && this.leftStyle == 2 && this.leftWidth > 0) {
            this.paintLeftGroove(g, x, y, width, height);
        }
        g.setStroke(oldStroke);
    }

    protected void paintBottomGroove(Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        g.translate(x, y);
        Color innerColor = this.bottomColor.darker().darker();
        Color middleColor = this.bottomColor;
        Color outerColor = this.bottomColor.darker().darker();
        this.drawBottom(g, innerColor, middleColor, outerColor, width, height);
        g.translate(-x, -y);
        g.setColor(oldColor);
    }

    protected void paintBottomRidge(Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        g.translate(x, y);
        Color innerColor = this.bottomColor.darker();
        Color middleColor = this.bottomColor;
        Color outerColor = this.bottomColor.darker();
        this.drawBottom(g, innerColor, middleColor, outerColor, width, height);
        g.translate(-x, -y);
        g.setColor(oldColor);
    }

    protected void paintLeftGroove(Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        g.translate(x, y);
        Color innerColor = this.leftColor.darker();
        Color middleColor = this.leftColor;
        Color outerColor = this.leftColor.darker();
        this.drawLeft(g, innerColor, middleColor, outerColor, width, height);
        g.translate(-x, -y);
        g.setColor(oldColor);
    }

    protected void paintLeftRidge(Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        g.translate(x, y);
        Color innerColor = this.leftColor.brighter();
        Color middleColor = this.leftColor;
        Color outerColor = this.leftColor.brighter();
        this.drawLeft(g, innerColor, middleColor, outerColor, width, height);
        g.translate(-x, -y);
        g.setColor(oldColor);
    }

    protected void paintRightGroove(Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        g.translate(x, y);
        Color innerColor = this.rightColor.darker().darker();
        Color middleColor = this.rightColor;
        Color outerColor = this.rightColor.darker().darker();
        this.drawRight(g, innerColor, middleColor, outerColor, width, height);
        g.translate(-x, -y);
        g.setColor(oldColor);
    }

    protected void paintRightRidge(Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        g.translate(x, y);
        Color innerColor = this.rightColor.darker();
        Color middleColor = this.rightColor;
        Color outerColor = this.rightColor.darker();
        this.drawRight(g, innerColor, middleColor, outerColor, width, height);
        g.translate(-x, -y);
        g.setColor(oldColor);
    }

    protected void paintTopGroove(Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        g.translate(x, y);
        Color innerColor = this.topColor.darker();
        Color middleColor = this.topColor;
        Color outerColor = this.topColor.darker();
        this.drawTop(g, innerColor, middleColor, outerColor, width, height);
        g.translate(-x, -y);
        g.setColor(oldColor);
    }

    protected void paintTopRidge(Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        g.translate(x, y);
        Color innerColor = this.topColor.brighter();
        Color middleColor = this.topColor;
        Color outerColor = this.topColor.brighter();
        this.drawTop(g, innerColor, middleColor, outerColor, width, height);
        g.translate(-x, -y);
        g.setColor(oldColor);
    }

    public void setBottomEdge(CSSColor color, int width, int style) {
        super.setBottomEdge(color, width);
        this.bottomStyle = style;
    }

    public void setLeftEdge(CSSColor color, int width, int style) {
        super.setLeftEdge(color, width);
        this.leftStyle = style;
    }

    public void setRightEdge(CSSColor color, int width, int style) {
        super.setRightEdge(color, width);
        this.rightStyle = style;
    }

    public void setTopEdge(CSSColor color, int width, int style) {
        super.setTopEdge(color, width);
        this.topStyle = style;
    }
}

