/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.java2d;

import com.ibm.xsl.composer.areas.AreaTree;
import com.ibm.xsl.composer.areas.AreaTreeNode;
import com.ibm.xsl.composer.csstypes.CSSPoint;
import com.ibm.xsl.composer.flo.FLODocument;
import com.ibm.xsl.composer.java2d.J2DContext;
import com.ibm.xsl.composer.util.EventNotifySupport;
import com.ibm.xsl.composer.util.EventNotifyTarget;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;

public class J2DGenericView
extends JPanel {
    private J2DContext context = new J2DContext();
    private boolean fbMustDraw = true;
    private int currentPage = 0;
    private EventNotifySupport recomposeListeners;
    private FLODocument doc;
    private AreaTree drawTree;
    private final EventNotifySupport clickListeners = new EventNotifySupport();

    public J2DGenericView() {
        this.context.setParentView(this);
        this.recomposeListeners = new EventNotifySupport(this);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent ev) {
                AreaTreeNode node = J2DGenericView.this.findNodeAtLocation(ev.getPoint());
                J2DGenericView.this.clickListeners.notifyListeners(node.getProgenitor());
            }
        });
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fontNames = ge.getAvailableFontFamilyNames();
    }

    public void addNodeSelectionListener(EventNotifyTarget listener) {
        this.clickListeners.addListener(listener);
    }

    public void addRecompositionListener(EventNotifyTarget notifyTarget) {
        this.recomposeListeners.addListener(notifyTarget);
    }

    private void draw(Graphics g) {
        if (this.drawTree != null && this.fbMustDraw) {
            this.drawTree.drawPage(this.context, this.currentPage);
            this.fbMustDraw = false;
        }
        ((Graphics2D)g).drawImage((Image)this.context.getBufferedImage(), 0, 0, this);
    }

    public AreaTreeNode findNodeAtLocation(Point pt) {
        AreaTreeNode node = null;
        if (this.drawTree != null) {
            long upp = this.context.getUnitsPerPixel();
            CSSPoint hitPoint = new CSSPoint((long)pt.x * upp, (long)pt.y * upp);
            node = this.drawTree.findNodeAtLocation(this.context, hitPoint, this.currentPage);
        }
        return node;
    }

    public J2DContext getContext() {
        return this.context;
    }

    private Frame getFrame() {
        Container c = this.getParent();
        while (c != null && !(c instanceof Frame)) {
            c = c.getParent();
        }
        return (Frame)c;
    }

    public void paintComponent(Graphics g) {
        Cursor savedCursor;
        Frame f;
        block7: {
            f = this.getFrame();
            savedCursor = null;
            if (f != null) {
                savedCursor = this.getFrame().getCursor();
            }
            try {
                if (f != null) {
                    this.getFrame().setCursor(Cursor.getPredefinedCursor(3));
                }
                if (this.doc == null) break block7;
                if (this.drawTree == null || FLODocument.K_RECOMPOSED != this.doc.getCompositionStatus()) {
                    Dimension size = this.getSize();
                    this.context.initialize(this, size.width, size.height);
                    this.drawTree = this.doc.composeDocument(this.context);
                    this.recomposeListeners.notifyListeners(this.drawTree);
                    this.fbMustDraw = true;
                }
                this.draw(g);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (f != null) {
                    f.setCursor(savedCursor);
                }
                throw throwable;
            }
        }
        Object var5_5 = null;
        if (f != null) {
            f.setCursor(savedCursor);
        }
    }

    public void redrawCurrentPage() {
        this.fbMustDraw = true;
        this.repaint();
    }

    public void setDisplayedPage(int page) {
        if (page != this.currentPage) {
            this.setPageNumber(page);
            this.repaint();
        }
    }

    public void setDocument(FLODocument document) {
        this.doc = document;
        this.drawTree = null;
    }

    private void setPageNumber(int page) {
        if (page != this.currentPage) {
            this.currentPage = page;
            this.fbMustDraw = true;
        }
    }

    public void setSize(int width, int height) {
        if (this.doc != null) {
            this.doc.setCompositionStatus(FLODocument.K_MUSTRECOMPOSEFULLY);
        }
        super.setSize(width, height);
    }

    public void setSize(Dimension d) {
        this.setSize(d.width, d.height);
    }
}

