/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.java2d;

import com.ibm.xsl.composer.csstypes.CSSColor;
import com.ibm.xsl.composer.csstypes.CSSExtent;
import com.ibm.xsl.composer.csstypes.CSSPoint;
import com.ibm.xsl.composer.csstypes.Repeat;
import com.ibm.xsl.composer.framework.Context;
import com.ibm.xsl.composer.framework.ExtendedFont;
import com.ibm.xsl.composer.java2d.ImageHolder;
import com.ibm.xsl.composer.java2d.J2DExtendedFont;
import com.ibm.xsl.composer.java2d.J2DFourEdgeBorder;
import com.ibm.xsl.composer.java2d.J2DOutsetInsetBorder;
import com.ibm.xsl.composer.java2d.J2DRidgeGrooveBorder;
import com.ibm.xsl.composer.java2d.J2DVariableWidthDoubleBorder;
import com.ibm.xsl.composer.java2d.TBRL;
import com.ibm.xsl.composer.prim.Border;
import com.ibm.xsl.composer.properties.FontProperty;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ActionListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.text.AttributedString;
import java.util.Vector;
import javax.swing.JComponent;

public class J2DContext
implements Context {
    private volatile JComponent parentView;
    public volatile Vector textFieldVector = new Vector();
    private CSSColor currentColor = new CSSColor();
    private ExtendedFont currentFont;
    private BufferedImage bufferedImage;
    private Graphics2D graphics;
    private J2DExtendedFont extendedFont;
    private ActionListener actionListener;
    private ImageHolder imageHolder = new ImageHolder();
    private FontRenderContext fontRenderContext = new FontRenderContext(new AffineTransform(), true, true);

    public void drawBorder(Border inTop, Border inLeft, Border inBottom, Border inRight, CSSPoint inLocation, CSSExtent inSize) {
        long endY;
        long startY;
        long startY2;
        long endX;
        long startX;
        J2DFourEdgeBorder db = null;
        J2DOutsetInsetBorder oi = null;
        J2DRidgeGrooveBorder rg = null;
        TBRL tbrl = new TBRL();
        CSSPoint location = new CSSPoint(inLocation.x, inLocation.y);
        location.x /= this.getUnitsPerPixel();
        location.y /= this.getUnitsPerPixel();
        CSSExtent size = new CSSExtent(inSize.width, inSize.height);
        size.width /= this.getUnitsPerPixel();
        size.height /= this.getUnitsPerPixel();
        Border top = new Border(inTop.color, inTop.width, inTop.style);
        top.width /= this.getUnitsPerPixel();
        Border left = new Border(inLeft.color, inLeft.width, inLeft.style);
        left.width /= this.getUnitsPerPixel();
        Border bottom = new Border(inBottom.color, inBottom.width, inBottom.style);
        bottom.width /= this.getUnitsPerPixel();
        Border right = new Border(inRight.color, inRight.width, inRight.style);
        right.width /= this.getUnitsPerPixel();
        inLocation.x += inLeft.width;
        inLocation.y += inTop.width;
        if (top.style != 0 && top.style != 1 && top.color != null && top.width != 0L) {
            if (top.style == 4 || top.style == 3 || top.style == 2) {
                startX = location.x;
                endX = location.x + size.width;
                startY2 = location.y + top.width / 2L;
                this.drawSDDBorderEdge(this.graphics, top, startX, startY2, endX, startY2, location, size);
                tbrl.setTop((int)top.width, top.style);
            } else if (top.style == 5) {
                if (db == null) {
                    db = new J2DVariableWidthDoubleBorder();
                }
                db.setTopEdge(top.color, (int)top.width);
            } else if (top.style == 7 || top.style == 6) {
                if (rg == null) {
                    rg = new J2DRidgeGrooveBorder();
                }
                int style = top.style == 6 ? 2 : 1;
                rg.setTopEdge(top.color, (int)top.width, style);
                tbrl.setTop((int)top.width, top.style);
            } else if (top.style == 9 || top.style == 8) {
                if (oi == null) {
                    oi = new J2DOutsetInsetBorder();
                }
                int style = top.style == 9 ? 1 : 2;
                oi.setTopEdge(top.color, (int)top.width, style);
                tbrl.setTop((int)top.width, top.style);
            }
        }
        if (bottom.style != 0 && bottom.style != 1 && bottom.color != null && bottom.width != 0L) {
            if (bottom.style == 4 || bottom.style == 3 || bottom.style == 2) {
                startX = location.x + size.width;
                endX = location.x;
                startY2 = location.y + size.height - (bottom.width + 1L) / 2L;
                this.drawSDDBorderEdge(this.graphics, bottom, startX, startY2, endX, startY2, location, size);
                tbrl.setBottom((int)bottom.width, bottom.style);
            } else if (bottom.style == 5) {
                if (db == null) {
                    db = new J2DVariableWidthDoubleBorder();
                }
                db.setBottomEdge(bottom.color, (int)bottom.width);
            } else if (bottom.style == 7 || bottom.style == 6) {
                if (rg == null) {
                    rg = new J2DRidgeGrooveBorder();
                }
                int style = bottom.style == 6 ? 2 : 1;
                rg.setBottomEdge(bottom.color, (int)bottom.width, style);
                tbrl.setBottom((int)bottom.width, bottom.style);
            } else if (bottom.style == 9 || bottom.style == 8) {
                if (oi == null) {
                    oi = new J2DOutsetInsetBorder();
                }
                int style = bottom.style == 9 ? 1 : 2;
                oi.setBottomEdge(bottom.color, (int)bottom.width, style);
                tbrl.setBottom((int)bottom.width, bottom.style);
            }
        }
        if (right.style != 0 && right.style != 1 && right.color != null && right.width != 0L) {
            if (right.style == 4 || right.style == 3 || right.style == 2) {
                long startX2 = location.x + size.width - (right.width + 1L) / 2L;
                startY = location.y;
                endY = location.y + size.height;
                this.drawSDDBorderEdge(this.graphics, right, startX2, startY, startX2, endY, location, size);
                tbrl.setRight((int)right.width, right.style);
            } else if (right.style == 5) {
                if (db == null) {
                    db = new J2DVariableWidthDoubleBorder();
                }
                db.setRightEdge(right.color, (int)right.width);
            } else if (right.style == 7 || right.style == 6) {
                if (rg == null) {
                    rg = new J2DRidgeGrooveBorder();
                }
                int style = right.style == 6 ? 2 : 1;
                rg.setRightEdge(right.color, (int)right.width, style);
                tbrl.setRight((int)right.width, right.style);
            } else if (right.style == 9 || right.style == 8) {
                if (oi == null) {
                    oi = new J2DOutsetInsetBorder();
                }
                int style = right.style == 9 ? 1 : 2;
                oi.setRightEdge(right.color, (int)right.width, style);
                tbrl.setRight((int)right.width, right.style);
            }
        }
        if (left.style != 0 && left.style != 1 && left.color != null && left.width != 0L) {
            if (left.style == 4 || left.style == 3 || left.style == 2) {
                long startX3 = location.x + left.width / 2L;
                startY = location.y + size.height;
                endY = location.y;
                this.drawSDDBorderEdge(this.graphics, left, startX3, startY, startX3, endY, location, size);
                tbrl.setLeft((int)left.width, left.style);
            } else if (left.style == 5) {
                if (db == null) {
                    db = new J2DVariableWidthDoubleBorder();
                }
                db.setLeftEdge(left.color, (int)left.width);
            } else if (left.style == 7 || left.style == 6) {
                if (rg == null) {
                    rg = new J2DRidgeGrooveBorder();
                }
                int style = left.style == 6 ? 2 : 1;
                rg.setLeftEdge(left.color, (int)left.width, style);
                tbrl.setLeft((int)left.width, left.style);
            } else if (left.style == 9 || left.style == 8) {
                if (oi == null) {
                    oi = new J2DOutsetInsetBorder();
                }
                int style = left.style == 9 ? 1 : 2;
                oi.setLeftEdge(left.color, (int)left.width, style);
                tbrl.setLeft((int)left.width, left.style);
            }
        }
        if (db != null) {
            db.setDependancies(tbrl);
            ((J2DVariableWidthDoubleBorder)db).paintBorder(this.graphics, (int)location.x, (int)location.y, (int)size.width, (int)size.height);
        }
        if (rg != null) {
            rg.paintBorder(this.graphics, (int)location.x, (int)location.y, (int)size.width, (int)size.height);
        }
        if (oi != null) {
            oi.paintBorder(this.graphics, (int)location.x, (int)location.y, (int)size.width, (int)size.height);
        }
        this.restoreCurrentColor();
    }

    public void drawGlyph(char code, CSSPoint location) {
        char[] s = new char[]{code, '\u0000'};
        location.x /= this.getUnitsPerPixel();
        location.y /= this.getUnitsPerPixel();
        this.graphics.drawChars(s, 0, 1, (int)location.x, (int)location.y);
    }

    public void drawGraphic(String Uri, CSSPoint inLocation, CSSExtent inSize) {
        CSSPoint location = new CSSPoint(inLocation.x, inLocation.y);
        CSSExtent size = new CSSExtent(inSize.width, inSize.height);
        location.x /= this.getUnitsPerPixel();
        location.y /= this.getUnitsPerPixel();
        Image image = this.imageHolder.getImage(Uri);
        if (image != null) {
            this.graphics.drawImage(image, (int)location.x, (int)location.y, null);
        }
    }

    public void drawOrientatedGlyph(char code, CSSPoint location, short referenceOrientation) {
        location.x /= this.getUnitsPerPixel();
        location.y /= this.getUnitsPerPixel();
        Character chara = new Character(code);
        String text = chara.toString();
        Font font = this.graphics.getFont();
        Font rotatedFont = null;
        AttributedString string = new AttributedString(text);
        if (referenceOrientation == 90) {
            rotatedFont = font.deriveFont(AffineTransform.getRotateInstance(-1.5707963267948966));
        } else if (referenceOrientation == 180) {
            rotatedFont = font.deriveFont(AffineTransform.getRotateInstance(Math.PI));
        } else if (referenceOrientation == 270) {
            rotatedFont = font.deriveFont(AffineTransform.getRotateInstance(1.5707963267948966));
        }
        string.addAttribute(TextAttribute.FONT, rotatedFont);
        this.graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.graphics.drawString(string.getIterator(), (float)location.x, (float)location.y);
    }

    public void drawRule(CSSPoint startIn, CSSPoint endIn, Border border) {
        float on;
        BasicStroke stroke;
        CSSPoint start = new CSSPoint(startIn.x, startIn.y);
        start.x /= this.getUnitsPerPixel();
        start.y /= this.getUnitsPerPixel();
        CSSPoint end = new CSSPoint(endIn.x, endIn.y);
        end.x /= this.getUnitsPerPixel();
        end.y /= this.getUnitsPerPixel();
        int width = (int)(border.width / this.getUnitsPerPixel());
        Line2D.Float segment = new Line2D.Float(start.x, start.y, end.x, end.y);
        Stroke oldStroke = this.graphics.getStroke();
        if (border.style == 4) {
            stroke = new BasicStroke(width, 0, 0);
        } else if (border.style == 3) {
            on = width;
            float off = width;
            stroke = new BasicStroke(width, 0, 0, 1.0f, new float[]{on, off}, 0.0f);
        } else if (border.style == 2) {
            on = 0.0f;
            float off = width * 2;
            float[] fArray = new float[2];
            fArray[1] = off;
            stroke = new BasicStroke(width, 1, 1, 1.0f, fArray, 0.0f);
        } else {
            System.out.println("style is not supported");
            return;
        }
        Paint oldPaint = this.graphics.getPaint();
        this.graphics.setPaint(new Color(border.color.red, border.color.green, border.color.blue));
        this.graphics.setStroke(stroke);
        Object oldClip = null;
        this.graphics.draw(segment);
        if (oldStroke != null) {
            this.graphics.setStroke(oldStroke);
        }
        this.graphics.setPaint(oldPaint);
    }

    private void drawSDDBorderEdge(Graphics2D g, Border border, long x1, long y1, long x2, long y2, CSSPoint location, CSSExtent size) {
        BasicStroke stroke;
        g.setPaint(new Color(border.color.red, border.color.green, border.color.blue));
        long adjustment = 0L;
        if (border.width == 1L) {
            adjustment = 1L;
        }
        Line2D.Float segment = x1 == x2 ? (y1 > y2 ? new Line2D.Float(x1, y1 - adjustment, x2, y2) : new Line2D.Float(x1, y1, x2, y2 - adjustment)) : (y1 == y2 ? (x1 > x2 ? new Line2D.Float(x1 - adjustment, y1, x2, y2) : new Line2D.Float(x1, y1, x2 - adjustment, y2)) : new Line2D.Float(x1, y1, x2, y2));
        Stroke oldStroke = g.getStroke();
        if (border.style == 4) {
            stroke = new BasicStroke(border.width, 0, 2);
        } else if (border.style == 3) {
            float on = border.width;
            float off = border.width;
            stroke = new BasicStroke(border.width, 0, 2, 1.0f, new float[]{on, off}, 0.0f);
        } else if (border.style == 2) {
            float on = 0.0f;
            float off = border.width * 2L;
            float[] fArray = new float[2];
            fArray[1] = off;
            stroke = new BasicStroke(border.width, 1, 1, 1.0f, fArray, 0.0f);
        } else {
            System.out.println("style is not supported");
            return;
        }
        g.setStroke(stroke);
        Object old = null;
        g.draw(segment);
        if (oldStroke != null) {
            g.setStroke(oldStroke);
        }
    }

    public void drawString(String series, CSSPoint location) {
        location.x /= this.getUnitsPerPixel();
        location.y /= this.getUnitsPerPixel();
        this.graphics.drawString(series, (int)location.x, (int)location.y);
    }

    public void endDocument() {
    }

    public void fillBackground(CSSPoint location, CSSExtent size, CSSColor color) {
        location.x /= this.getUnitsPerPixel();
        location.y /= this.getUnitsPerPixel();
        size.width /= this.getUnitsPerPixel();
        size.height /= this.getUnitsPerPixel();
        this.graphics.setPaint(new Color(color.red, color.green, color.blue));
        this.graphics.fill(new Rectangle((int)location.x, (int)location.y, (int)size.width, (int)size.height));
        this.restoreCurrentColor();
    }

    public void fillBackground(CSSPoint inLocation, CSSExtent inSize, String imageName, CSSPoint inOffset, int howToRepeat) {
        CSSPoint location = new CSSPoint(inLocation.x, inLocation.y);
        location.x /= this.getUnitsPerPixel();
        location.y /= this.getUnitsPerPixel();
        CSSExtent size = new CSSExtent(inSize.width, inSize.height);
        size.width /= this.getUnitsPerPixel();
        size.height /= this.getUnitsPerPixel();
        CSSPoint offset = new CSSPoint(inOffset.x, inOffset.y);
        offset.x /= this.getUnitsPerPixel();
        offset.y /= this.getUnitsPerPixel();
        Image image = this.imageHolder.getImage(imageName);
        if (image == null) {
            System.err.println("J2DContext.fillBackground: Image <" + imageName + "> was null");
            return;
        }
        Dimension imageSize = this.imageHolder.getDimension(imageName);
        Rectangle oldClipRect = this.graphics.getClipBounds();
        this.graphics.setClip((int)location.x, (int)location.y, (int)size.width, (int)size.height);
        switch (howToRepeat) {
            case 0: {
                int xabsolute = (int)location.x + (int)offset.x;
                int yabsolute = (int)location.y + (int)offset.y;
                this.graphics.drawImage(image, xabsolute, yabsolute, null);
                break;
            }
            case 1: {
                Dimension start = this.getStartOffset(offset, imageSize);
                int yinc = 0;
                while ((long)yinc < size.height + (long)(2 * imageSize.height)) {
                    int xinc = 0;
                    while ((long)xinc < size.width + (long)(2 * imageSize.width)) {
                        int xabsolute = (int)location.x + (int)offset.x + start.width + xinc;
                        int yabsolute = (int)location.y + (int)offset.y + start.height + yinc;
                        this.graphics.drawImage(image, xabsolute, yabsolute, null);
                        xinc += imageSize.width;
                    }
                    yinc += imageSize.height;
                }
                break;
            }
            case 2: {
                Dimension start = this.getStartOffset(offset, imageSize);
                int yabsolute = (int)location.y + (int)offset.y;
                int xinc = 0;
                while ((long)xinc < size.width + (long)(2 * imageSize.width)) {
                    int xabsolute = (int)location.x + (int)offset.x + start.width + xinc;
                    this.graphics.drawImage(image, xabsolute, yabsolute, null);
                    xinc += imageSize.width;
                }
                break;
            }
            case 3: {
                Dimension start = this.getStartOffset(offset, imageSize);
                int xabsolute = (int)location.x + (int)offset.x;
                int yinc = 0;
                while ((long)yinc < size.height + (long)(2 * imageSize.height)) {
                    int yabsolute = (int)location.y + (int)offset.y + start.height + yinc;
                    this.graphics.drawImage(image, xabsolute, yabsolute, null);
                    yinc += imageSize.height;
                }
                break;
            }
            default: {
                System.err.println("J2DContext.fillBackground: the case of Repeat <" + Repeat.getName((short)howToRepeat) + "> is not implemented");
            }
        }
        this.graphics.setClip(oldClipRect);
    }

    public BufferedImage getBufferedImage() {
        return this.bufferedImage;
    }

    public ExtendedFont getExtendedFont(FontProperty fontProperty) {
        String sFaceName = fontProperty.getFontFamily();
        String nStyle = fontProperty.getFontStyle();
        int nWeight = fontProperty.getFontWeight();
        String nVariance = fontProperty.getFontVariant();
        int nSize = (int)fontProperty.getFontSize().getNormalizedLength(new long[]{this.getUnitsPerPixel(), this.getUnitsPerPoint()});
        this.extendedFont = new J2DExtendedFont(this.graphics, sFaceName, nStyle, nWeight, nVariance, nSize /= (int)this.getUnitsPerPoint(), this.getUnitsPerPixel());
        return this.extendedFont;
    }

    public CSSExtent getGraphicDimension(String image) {
        Dimension dim = this.imageHolder.getDimension(image);
        return new CSSExtent((long)dim.width * this.getUnitsPerPixel(), (long)dim.height * this.getUnitsPerPixel());
    }

    public Graphics2D getGraphics() {
        return this.graphics;
    }

    public ActionListener getListener() {
        return this.actionListener;
    }

    public CSSExtent getPageSize() {
        CSSExtent d = new CSSExtent();
        d.setExtent((long)this.bufferedImage.getWidth() * this.getUnitsPerPixel(), (long)this.bufferedImage.getHeight() * this.getUnitsPerPixel());
        return d;
    }

    public JComponent getParentView() {
        return this.parentView;
    }

    public Dimension getStartOffset(CSSPoint offset, Dimension imageSize) {
        int yStart = 0;
        int xStart = 0;
        if (offset.x != 0L) {
            xStart = (int)(-((long)imageSize.width - offset.x % (long)imageSize.width));
        }
        if (offset.y != 0L) {
            yStart = (int)(-((long)imageSize.height - offset.y % (long)imageSize.height));
        }
        return new Dimension(xStart, yStart);
    }

    public long getUnitsPerPixel() {
        return 56864L;
    }

    public long getUnitsPerPoint() {
        return 73728L;
    }

    public void initialize(Component window, int clientWidth, int clientHeight) {
        this.bufferedImage = (BufferedImage)window.createImage(clientWidth, clientHeight);
        this.graphics = this.bufferedImage.createGraphics();
        if (this.parentView != null) {
            this.parentView.removeAll();
        }
        this.textFieldVector.removeAllElements();
    }

    public void notifyGraphic(URL image) {
        this.imageHolder.insertURI(image);
    }

    private void restoreCurrentColor() {
        this.graphics.setPaint(new Color(this.currentColor.red, this.currentColor.green, this.currentColor.blue));
    }

    public void setFont(ExtendedFont font) {
        if (this.currentFont != font) {
            Font drawFont = ((J2DExtendedFont)font).getFont();
            String style = font.getStyle();
            if (style.compareToIgnoreCase("italic") == 0) {
                drawFont = new Font(drawFont.getName(), 2, drawFont.getSize());
            }
            if (style.compareToIgnoreCase("bold") == 0) {
                drawFont = new Font(drawFont.getName(), 1, drawFont.getSize());
            }
            this.graphics.setFont(drawFont);
        }
    }

    public void setListener(ActionListener listener) {
        this.actionListener = listener;
    }

    public void setParentView(JComponent parent) {
        this.parentView = parent;
    }

    public void setTextColor(CSSColor color) {
        if (color != null && !color.equals(this.currentColor)) {
            this.currentColor.copy(color);
            this.graphics.setColor(new Color(color.red, color.green, color.blue));
        }
    }

    public void startDocument() {
        this.graphics.setColor(Color.white);
        this.graphics.fillRect(0, 0, this.bufferedImage.getWidth(), this.bufferedImage.getHeight());
        this.currentColor.setColor("black");
        this.graphics.setColor(Color.black);
    }

    public void startViewport(CSSPoint location, CSSExtent extent, boolean isPage) {
    }
}

