/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.java2d;

import com.ibm.xsl.composer.areas.AreaTree;
import com.ibm.xsl.composer.areas.PrintTagVisitor;
import com.ibm.xsl.composer.flo.FLODocument;
import com.ibm.xsl.composer.java2d.J2DContext;
import com.ibm.xsl.composer.java2d.J2DGenericView;
import com.ibm.xsl.composer.util.EventNotifyTarget;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.KeyEvent;
import java.io.PrintStream;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ComposerView
extends JPanel {
    private J2DGenericView renderPanel = new J2DGenericView();
    private JScrollBar pageSelector = new JScrollBar(1, 0, 1, 0, 1);
    private int pageCount = 1;
    private boolean isInitialDisplay = true;
    private PrintTagVisitor dumpTree;

    public ComposerView() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.add((Component)this.renderPanel, gbc);
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        gbc.fill = 3;
        this.add((Component)this.pageSelector, gbc);
        this.pageSelector.getModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent ev) {
                DefaultBoundedRangeModel rangeModel = (DefaultBoundedRangeModel)ev.getSource();
                ComposerView.this.renderPanel.setDisplayedPage(rangeModel.getValue() + 1);
            }
        });
        this.renderPanel.addRecompositionListener(new EventNotifyTarget(){

            public void notify(Object source, Object data) {
                AreaTree at = (AreaTree)data;
                ComposerView.this.pageCount = at.getPageCount();
                if (ComposerView.this.pageSelector.getValue() > ComposerView.this.pageCount - 1) {
                    ComposerView.this.pageSelector.setValue(ComposerView.this.pageCount - 1);
                }
                ComposerView.this.pageSelector.setMaximum(ComposerView.this.pageCount);
                ComposerView.this.pageSelector.getModel().setExtent(1);
                if (ComposerView.this.isInitialDisplay) {
                    ComposerView.this.renderPanel.setDisplayedPage(1);
                    ComposerView.this.isInitialDisplay = false;
                }
                if (ComposerView.this.dumpTree != null) {
                    at.visit(ComposerView.this.dumpTree);
                }
            }
        });
    }

    public void addNodeSelectionListener(EventNotifyTarget listener) {
        this.renderPanel.addNodeSelectionListener(listener);
    }

    public J2DContext getContext() {
        return this.renderPanel.getContext();
    }

    public void processKey(KeyEvent e) {
        int delta = 0;
        if (e.getID() != 401) {
            return;
        }
        switch (e.getKeyCode()) {
            case 34: {
                delta = this.pageSelector.getBlockIncrement();
                break;
            }
            case 33: {
                delta = -this.pageSelector.getBlockIncrement();
                break;
            }
            case 40: {
                delta = this.pageSelector.getUnitIncrement();
                break;
            }
            case 38: {
                delta = -this.pageSelector.getUnitIncrement();
                break;
            }
        }
        if (delta != 0) {
            this.pageSelector.setValue(this.pageSelector.getValue() + delta);
        }
    }

    public void repaintComposedView() {
        this.renderPanel.redrawCurrentPage();
    }

    public void setDocument(FLODocument doc) {
        this.renderPanel.setDocument(doc);
        this.isInitialDisplay = true;
    }

    public void setDumpAreaTree(boolean doDump) {
        this.dumpTree = doDump ? new PrintTagVisitor(new PrintStream(System.out)) : null;
    }

    public void setPage(int newPage) {
        this.pageSelector.setValueIsAdjusting(true);
        this.pageSelector.setValue(newPage);
        this.pageSelector.setValueIsAdjusting(false);
    }
}

