/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.flo.table;

import com.ibm.xsl.composer.flo.table.FLOTable;
import com.ibm.xsl.composer.flo.table.FLOTableCell;
import com.ibm.xsl.composer.flo.table.FLOTableColumn;
import com.ibm.xsl.composer.flo.table.FLOTableElement;
import com.ibm.xsl.composer.flo.table.FLOTableRow;
import com.ibm.xsl.composer.flo.table.TableLayoutBehavior;
import com.ibm.xsl.composer.flo.table.TableProgressionDirection;
import com.ibm.xsl.composer.framework.Context;
import com.ibm.xsl.composer.framework.ExtendedFont;
import com.ibm.xsl.composer.prim.Extent;
import com.ibm.xsl.composer.prim.Size;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class TableLayoutBehaviorAuto
implements TableLayoutBehavior {
    protected Context context;
    protected FLOTable table;
    protected Extent available;

    TableLayoutBehaviorAuto(Context context, FLOTable table, Extent available) {
        this.context = context;
        this.table = table;
        this.available = available;
    }

    private void adjColMeasures(boolean useMax, long extra, long remainder) {
        FLOTableColumn lastCol = null;
        FLOTableColumn col = null;
        Iterator it = this.table.getColumns().iterator();
        while (it.hasNext()) {
            col = (FLOTableColumn)it.next();
            Size cpd = col.getCPD();
            col.getCPDRef().setScalar(useMax ? cpd.getMaximum() : cpd.getMinimum() + extra);
            lastCol = col;
        }
        if (lastCol != null && remainder > 0L) {
            lastCol.getCPDRef().sum(new Size(remainder));
        }
    }

    private void adjRowMeasures(boolean useMax, long extra, long remainder) {
        FLOTableRow lastRow = null;
        FLOTableRow row = null;
        Iterator it = this.table.getRows().iterator();
        while (it.hasNext()) {
            row = (FLOTableRow)it.next();
            Size rpd = row.getRPD();
            row.getRPDRef().setScalar(useMax ? rpd.getMaximum() : rpd.getMinimum() + extra);
            lastRow = row;
        }
        if (lastRow != null && remainder > 0L) {
            lastRow.getRPDRef().sum(new Size(remainder));
        }
    }

    private void assignCellsCPD() {
        Iterator it = this.table.getColumns().iterator();
        while (it.hasNext()) {
            FLOTableColumn col = (FLOTableColumn)it.next();
            Size cpd = col.getCPDRef();
            Iterator cit = col.getCells().iterator();
            while (cit.hasNext()) {
                FLOTableCell c = (FLOTableCell)cit.next();
                c.setCPD(cpd);
            }
        }
    }

    private void assignCellsRPD() {
        Iterator it = this.table.getRows().iterator();
        while (it.hasNext()) {
            FLOTableRow row = (FLOTableRow)it.next();
            Size rpd = row.getRPDRef();
            Iterator cit = row.getCells().iterator();
            while (cit.hasNext()) {
                FLOTableCell c = (FLOTableCell)cit.next();
                c.setRPD(rpd);
            }
        }
    }

    private Size computeCellsMinMax(List cells, TableProgressionDirection dir, boolean[] rv) {
        Size mm = new Size();
        boolean sm = false;
        Iterator it = cells.iterator();
        while (it.hasNext()) {
            FLOTableCell c = (FLOTableCell)it.next();
            long constraint = dir == TableProgressionDirection.COL ? Long.MAX_VALUE : c.getCPDRef().getOptimum();
            Size xm = dir == TableProgressionDirection.COL && c.hasExplicitWidth() ? new Size(c.getWidth(this.computeUnits(c))) : (dir == TableProgressionDirection.ROW && c.hasExplicitHeight() ? new Size(c.getHeight(this.computeUnits(c))) : null);
            Size im = c.computeMinMaxMeasure(this.context, dir, constraint);
            if (xm != null) {
                im.max(xm);
            }
            if (!c.spansMultipleInDirection(dir)) {
                mm.max(im);
                continue;
            }
            sm = true;
        }
        rv[0] = sm;
        return mm;
    }

    private void computeColMeasures() {
        boolean[] rv = new boolean[1];
        Size mm = new Size();
        Vector cols = new Vector(this.table.getColumns());
        Collections.reverse(cols);
        Iterator it = cols.iterator();
        while (it.hasNext()) {
            FLOTableColumn col = (FLOTableColumn)it.next();
            Size im = this.computeCellsMinMax(col.getCells(), TableProgressionDirection.COL, rv);
            if (rv[0]) {
                throw new UnsupportedOperationException("multiple spanned columns not yet supported");
            }
            mm.copy(im);
            if (col.hasExplicitWidth()) {
                mm.max(new Size(col.getWidth(this.computeUnits(col))));
            }
            col.getCPDRef().copy(mm);
        }
        this.distributeColMeasures();
        this.table.setCPD(this.sumColMeasures());
        this.assignCellsCPD();
    }

    private void computeRowMeasures() {
        boolean[] rv = new boolean[1];
        Size mm = new Size();
        Vector rows = new Vector(this.table.getRows());
        Collections.reverse(rows);
        Iterator it = rows.iterator();
        while (it.hasNext()) {
            FLOTableRow row = (FLOTableRow)it.next();
            Size im = this.computeCellsMinMax(row.getCells(), TableProgressionDirection.ROW, rv);
            if (rv[0]) {
                throw new UnsupportedOperationException("multiple spanned rows not yet supported");
            }
            mm.copy(im);
            if (row.hasExplicitHeight()) {
                mm.max(new Size(row.getHeight(this.computeUnits(row))));
            }
            row.getRPDRef().copy(mm);
        }
        this.distributeRowMeasures();
        this.table.setRPD(this.sumRowMeasures());
        this.assignCellsRPD();
    }

    private long[] computeUnits(FLOTableElement e) {
        ExtendedFont f = this.context.getExtendedFont(e.getProperties().getFontProperty());
        return this.initUnits(new long[6], this.context.getUnitsPerPoint(), f.getCharacterHeight('x'), f.getSize() * this.context.getUnitsPerPoint(), this.context.getUnitsPerPixel(), 100L, 1L);
    }

    private void distributeColMeasures() {
        Size smm = this.sumColMeasures();
        boolean useMax = false;
        long e = 0L;
        long r = 0L;
        int n = this.table.getColumns().size();
        if (this.table.hasExplicitWidth()) {
            long d = this.table.getWidth(this.computeUnits(this.table)) - smm.getMinimum();
            if (d > 0L) {
                e = d / (long)n;
                r = d % (long)n;
            }
        } else {
            long d = smm.getMaximum() - this.available.getIPD();
            if (d > 0L) {
                d = this.available.getIPD() - smm.getMinimum();
                if (d > 0L) {
                    e = d / (long)n;
                    r = d % (long)n;
                }
            } else {
                useMax = true;
            }
        }
        this.adjColMeasures(useMax, e, r);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void distributeRowMeasures() {
        Size smm = this.sumRowMeasures();
        boolean useMax = false;
        long e = 0L;
        long r = 0L;
        int n = this.table.getRows().size();
        if (this.table.hasExplicitHeight()) {
            long d = this.table.getHeight(this.computeUnits(this.table)) - smm.getMinimum();
            if (d <= 0L) throw new UnsupportedOperationException("table geometry over constrained: height < minimum content height");
            e = d / (long)n;
            r = d % (long)n;
        } else {
            useMax = true;
        }
        this.adjRowMeasures(useMax, e, r);
    }

    private long[] initUnits(long[] units, long uPt, long uEx, long uEm, long uPx, long uPc, long uEq) {
        units[1] = uPt;
        units[3] = uEx;
        units[2] = uEm;
        units[0] = uPx;
        units[4] = uPc;
        units[5] = uEq;
        return units;
    }

    public void performBehavior() {
        this.computeColMeasures();
        this.computeRowMeasures();
    }

    private String sizeToStringInPixels(Size s) {
        return "[" + TableLayoutBehaviorAuto.toPixels(this.context, s.getMinimum()) + "px" + "," + TableLayoutBehaviorAuto.toPixels(this.context, s.getOptimum()) + "px" + "," + TableLayoutBehaviorAuto.toPixels(this.context, s.getMaximum()) + "px" + "]";
    }

    private Size sumColMeasures() {
        Size smm = new Size();
        Iterator it = this.table.getColumns().iterator();
        while (it.hasNext()) {
            FLOTableColumn col = (FLOTableColumn)it.next();
            Size cpd = col.getCPD();
            smm.sum(col.getCPDRef());
        }
        return smm;
    }

    private Size sumRowMeasures() {
        Size smm = new Size();
        Iterator it = this.table.getRows().iterator();
        while (it.hasNext()) {
            FLOTableRow row = (FLOTableRow)it.next();
            Size rpd = row.getRPD();
            smm.sum(row.getRPDRef());
        }
        return smm;
    }

    private static long toPixels(Context context, long d) {
        return d / context.getUnitsPerPixel();
    }
}

