/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.flo.table;

import com.ibm.xsl.composer.csstypes.CSSLength;
import com.ibm.xsl.composer.flo.table.FLOTable;
import com.ibm.xsl.composer.flo.table.FLOTableCell;
import com.ibm.xsl.composer.flo.table.FLOTableColumnGroup;
import com.ibm.xsl.composer.flo.table.FLOTableElement;
import com.ibm.xsl.composer.flo.table.FLOTableRow;
import com.ibm.xsl.composer.prim.Size;
import com.ibm.xsl.composer.properties.TableProperty;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.xerces.dom.DocumentImpl;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FLOTableColumn
extends FLOTableElement {
    private int columnNumber = 0;
    private Size cpd = new Size();
    private boolean prevColumnComputed;
    private FLOTableColumn prevColumn;
    private boolean follColumnComputed;
    private FLOTableColumn follColumn;
    private List cellsIntersecting;
    private List cellsStarting;

    public FLOTableColumn(DocumentImpl doc) {
        this(doc, "table-column");
    }

    public FLOTableColumn(DocumentImpl doc, String name) {
        super(doc, name);
    }

    private FLOTableColumn computeAdjacent(boolean following) {
        FLOTableColumn c = this.computeAdjacentInGroup(following);
        if (c != null) {
            return c;
        }
        FLOTableColumnGroup cg = this.getColumnGroup().getAdjacent(following);
        if (cg != null) {
            return following ? cg.getLastColumn() : cg.getFirstColumn();
        }
        return null;
    }

    private FLOTableColumn computeAdjacentInGroup(boolean following) {
        Element n;
        Element element = n = following ? this.getNextSiblingElement() : this.getPreviousSiblingElement();
        if (n instanceof FLOTableColumn) {
            return (FLOTableColumn)((Object)n);
        }
        if (n != null) {
            throw new IllegalStateException(n.toString());
        }
        return null;
    }

    private List findCells0(List l, Node n, boolean startsInColumn) {
        block6: {
            block5: {
                if (!(n instanceof FLOTableCell)) break block5;
                FLOTableCell c = (FLOTableCell)((Object)n);
                if ((!startsInColumn || !c.startsInColumn(this)) && (startsInColumn || !c.spansColumn(this))) break block6;
                l.add(n);
                break block6;
            }
            if (n instanceof FLOTableRow) {
                List cells = ((FLOTableRow)((Object)n)).getCells();
                Iterator it = cells.iterator();
                while (it.hasNext()) {
                    this.findCells0(l, (Node)it.next(), startsInColumn);
                }
            } else if (n instanceof FLOTable) {
                List rows = ((FLOTable)((Object)n)).getRows();
                Iterator it = rows.iterator();
                while (it.hasNext()) {
                    this.findCells0(l, (Node)it.next(), startsInColumn);
                }
            }
        }
        return l;
    }

    private List findCellsOrdered(boolean startsInColumn) {
        TreeSet ss = new TreeSet(new RowComparator());
        ss.addAll(this.findCellsUnordered(startsInColumn));
        return new Vector(ss);
    }

    private List findCellsUnordered(boolean startsInColumn) {
        return this.findCells0(new Vector(), (Node)((Object)this.getTable()), startsInColumn);
    }

    public FLOTableColumn getAdjacent(boolean following) {
        if (following) {
            if (!this.follColumnComputed) {
                this.follColumn = this.computeAdjacent(true);
                this.follColumnComputed = true;
            }
            return this.follColumn;
        }
        if (!this.prevColumnComputed) {
            this.prevColumn = this.computeAdjacent(false);
            this.prevColumnComputed = true;
        }
        return this.prevColumn;
    }

    public Size getCPD() {
        return new Size(this.cpd);
    }

    public Size getCPDRef() {
        return this.cpd;
    }

    public List getCells() {
        return this.getCellsStarting();
    }

    public List getCellsIntersecting() {
        return this.cellsIntersecting != null ? this.cellsIntersecting : (this.cellsIntersecting = this.findCellsOrdered(false));
    }

    public List getCellsIntersectingUnordered() {
        return this.findCellsUnordered(false);
    }

    public List getCellsStarting() {
        return this.cellsStarting != null ? this.cellsStarting : (this.cellsStarting = this.findCellsOrdered(true));
    }

    public List getCellsStartingUnordered() {
        return this.findCellsUnordered(true);
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public long getHeight(long[] units) {
        throw new UnsupportedOperationException("explicit height not supported");
    }

    public long getWidth(long[] units) {
        if (super.hasExplicitWidth()) {
            return super.getWidth(units);
        }
        TableProperty tp = this.getProperties().getTableProperty();
        CSSLength w = !tp.columnWidthIsInitialValue ? tp.getColumnWidth() : null;
        if (w == null) {
            throw new UnsupportedOperationException("width is not set");
        }
        if (w.getUnits().equals("%")) {
            throw new UnsupportedOperationException("width in percent (%) not yet supported");
        }
        return w.getNormalizedLength(units);
    }

    public boolean hasExplicitHeight() {
        return false;
    }

    public boolean hasExplicitWidth() {
        if (super.hasExplicitWidth()) {
            return true;
        }
        return this.getProperties().getTableProperty().columnWidthIsInitialValue ^ true;
    }

    public boolean isInColumnGroup(FLOTableColumnGroup cg) {
        return this.getColumnGroup() == cg;
    }

    public void setCPD(Size cpd) {
        this.cpd.copy(cpd);
    }

    public void setColumnNumber(int columnNumber) {
        if (this.columnNumber != 0) {
            throw new IllegalStateException();
        }
        this.columnNumber = columnNumber;
    }

    public String toString() {
        return "COL[" + this.getColumnNumber() + "]";
    }

    private class RowComparator
    implements Comparator {
        RowComparator() {
        }

        public int compare(Object o1, Object o2) {
            int cn2;
            int cn1 = ((FLOTableCell)o1).getRowNumber();
            if (cn1 < (cn2 = ((FLOTableCell)o2).getRowNumber())) {
                return -1;
            }
            if (cn1 > cn2) {
                return 1;
            }
            return 0;
        }
    }
}

