/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.flo.table;

import com.ibm.xsl.composer.areas.BackgroundBehavior;
import com.ibm.xsl.composer.areas.BackgroundImageBehavior;
import com.ibm.xsl.composer.areas.BorderBehavior;
import com.ibm.xsl.composer.areas.GeneralArea;
import com.ibm.xsl.composer.csstypes.CSSColorWithAlpha;
import com.ibm.xsl.composer.flo.BlockContent;
import com.ibm.xsl.composer.flo.BlockStacker;
import com.ibm.xsl.composer.flo.ComposeInfo;
import com.ibm.xsl.composer.flo.table.AreaEdge;
import com.ibm.xsl.composer.flo.table.CellArea;
import com.ibm.xsl.composer.flo.table.CollapsingBorderBehavior;
import com.ibm.xsl.composer.flo.table.FLOTable;
import com.ibm.xsl.composer.flo.table.FLOTableColumn;
import com.ibm.xsl.composer.flo.table.FLOTableColumnGroup;
import com.ibm.xsl.composer.flo.table.FLOTableElement;
import com.ibm.xsl.composer.flo.table.FLOTableRow;
import com.ibm.xsl.composer.flo.table.FLOTableRowGroup;
import com.ibm.xsl.composer.flo.table.RelationFilter;
import com.ibm.xsl.composer.flo.table.TableProgressionDirection;
import com.ibm.xsl.composer.framework.Context;
import com.ibm.xsl.composer.prim.Border;
import com.ibm.xsl.composer.prim.Extent;
import com.ibm.xsl.composer.prim.FLOPoint;
import com.ibm.xsl.composer.prim.Size;
import com.ibm.xsl.composer.prim.SpaceAlternatives;
import com.ibm.xsl.composer.prim.SpaceRequest;
import com.ibm.xsl.composer.properties.BorderPaddingBackgroundProperty;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.xerces.dom.DocumentImpl;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FLOTableCell
extends FLOTableElement
implements BlockContent {
    private int rowNumber = 0;
    private int columnNumber = 0;
    private Size rpd = new Size();
    private Size cpd = new Size();
    private static FLOTableElement[] rv = new FLOTableElement[6];
    private MeasureCache cache;
    private Border beforeBorderTraits;
    private Border afterBorderTraits;
    private Border startBorderTraits;
    private Border endBorderTraits;
    private GeneralArea area;
    private BorderBehavior borderBehavior;
    private boolean prevCellInColumnComputed;
    private FLOTableCell prevCellInColumn;
    private boolean follCellInColumnComputed;
    private FLOTableCell follCellInColumn;
    private boolean prevCellInRowComputed;
    private FLOTableCell prevCellInRow;
    private boolean follCellInRowComputed;
    private FLOTableCell follCellInRow;

    public FLOTableCell(DocumentImpl doc) {
        this(doc, "table-cell");
    }

    public FLOTableCell(DocumentImpl doc, String name) {
        super(doc, name);
    }

    protected void addBehaviorsForArea(GeneralArea a, ComposeInfo ci) {
        BorderPaddingBackgroundProperty bp = this.getProperties().getBorderPaddingBackgroundProperty();
        if (!bp.isTransparent()) {
            a.addBehavior(new BackgroundBehavior());
        }
        if (bp.getBackgroundImage() != null) {
            a.addBehavior(new BackgroundImageBehavior());
        }
        if (this.isCollapsingBorders()) {
            this.borderBehavior = new CollapsingBorderBehavior();
            a.addBehavior(this.borderBehavior);
        } else {
            this.borderBehavior = new BorderBehavior();
            a.addBehavior(this.borderBehavior);
        }
    }

    protected void addTraitsForArea(GeneralArea a, ComposeInfo ci) {
        super.addTraitsForArea(a, ci);
        if (this.borderBehavior != null) {
            this.updateBorderTraits(this.borderBehavior);
        }
    }

    private void alignInBPD(ComposeInfo ci, Extent ce, SpaceRequest r, GeneralArea a) {
        SpaceRequest tr = new SpaceRequest();
        Iterator it = r.getChildRequests();
        while (it.hasNext()) {
            tr.appendRequest((SpaceRequest)it.next());
        }
        long d = ce.getBPD() - tr.getOptimum();
        if (d > 0L) {
            String da = this.getProperties().getAreaAlignmentProperty().getDisplayAlign();
            if (da.equals("before")) {
                d = 0L;
            } else if (da.equals("center")) {
                d /= 2L;
            } else if (!da.equals("after")) {
                d = 0L;
            }
        }
        if (d > 0L) {
            Iterator it2 = r.getChildRequests();
            while (it2.hasNext()) {
                GeneralArea ca = ((SpaceRequest)it2.next()).getRequestorArea();
                FLOPoint pt = ca.getLocation();
                pt.before += d;
                ca.setLocation(pt);
            }
        }
    }

    public GeneralArea composeAreas(ComposeInfo ci, Extent ae, SpaceRequest r) {
        GeneralArea a = this.area;
        if (a == null) {
            throw new IllegalStateException();
        }
        Extent ce = new Extent(this.rpd.getOptimum(), this.cpd.getOptimum());
        a.adjustAvailable(ce);
        a.setContentBPD(ce.bpd);
        a.setContentIPD(ce.ipd);
        BlockStacker bs = new BlockStacker();
        bs.initialize((Node)((Object)this), this.getProperties());
        bs.arrangeChildren(ci, ce, r, a);
        this.alignInBPD(ci, ce, r, a);
        this.addProgeny(a);
        return a;
    }

    private FLOTableCell computeAdjacentInColumn(boolean following) {
        FLOTableCell c = null;
        FLOTableRow r = this.getRow();
        if (r == null) {
            throw new IllegalStateException("!! [TBD] need to synthesize implied row !!");
        }
        if ((r = r.getAdjacent(following)) != null) {
            NodeList nl = r.getChildNodes();
            int i = 0;
            while (i < nl.getLength()) {
                Node n = nl.item(i);
                if (n instanceof FLOTableCell && ((FLOTableCell)((Object)n)).getColumn() == this.getColumn()) {
                    c = (FLOTableCell)((Object)n);
                    break;
                }
                ++i;
            }
        }
        return c;
    }

    private FLOTableCell computeAdjacentInRow(boolean following) {
        Element n;
        Element element = n = following ? this.getNextSiblingElement() : this.getPreviousSiblingElement();
        if (n instanceof FLOTableCell) {
            return (FLOTableCell)((Object)n);
        }
        if (n != null) {
            throw new IllegalStateException();
        }
        return null;
    }

    private Size computeConstrainedMinMaxMeasure(Context context, TableProgressionDirection dir, long constraint) {
        if (dir == TableProgressionDirection.COL) {
            return this.computeMinMaxInCPD(context, constraint);
        }
        return this.computeMinMaxInRPD(context, constraint);
    }

    private Extent computeContentExtent(Context context, Extent e) {
        Extent ce;
        FLOTableCell fLOTableCell = this;
        synchronized (fLOTableCell) {
            this.area = null;
            SpaceAlternatives sa = this.composeRequest(new ComposeInfo(context, e), e, null);
            ce = this.area.getExtent();
            this.area = null;
        }
        return ce;
    }

    private Size computeMinMaxInCPD(Context context, long constraint) {
        Extent emx = this.computeContentExtent(context, new Extent(constraint, Long.MAX_VALUE));
        Extent emn = this.computeContentExtent(context, new Extent(constraint, 0L));
        return new Size(emn.getIPD(), emx.getIPD(), emn.getIPD());
    }

    private Size computeMinMaxInRPD(Context context, long constraint) {
        Extent emx = this.computeContentExtent(context, new Extent(Long.MAX_VALUE, constraint));
        Extent emn = this.computeContentExtent(context, new Extent(0L, constraint));
        return new Size(emn.getBPD(), emx.getBPD(), emn.getBPD());
    }

    public Size computeMinMaxMeasure(Context context, TableProgressionDirection dir) {
        return this.computeMinMaxMeasure(context, dir, Long.MAX_VALUE);
    }

    public Size computeMinMaxMeasure(Context context, TableProgressionDirection dir, long constraint) {
        Size s;
        if (this.cache != null && (s = this.cache.get(context, dir, constraint)) != null) {
            return s;
        }
        if (this.cache == null) {
            this.cache = new MeasureCache();
        }
        this.cache.put(context, dir, constraint, this.computeConstrainedMinMaxMeasure(context, dir, constraint));
        return this.computeMinMaxMeasure(context, dir, constraint);
    }

    protected GeneralArea createArea(ComposeInfo ci, Extent ea) {
        this.area = new CellArea();
        return this.area;
    }

    public boolean endsInColumn(FLOTableColumn column) {
        int colStart = this.getColumnNumber();
        int colEnd = colStart + this.getNumberColumnsSpanned() - 1;
        int colNum = column.getColumnNumber();
        return colNum == colEnd;
    }

    public boolean endsInRow(FLOTableRow row) {
        int rowStart = this.getRowNumber();
        int rowEnd = rowStart + this.getNumberRowsSpanned() - 1;
        int rowNum = row.getRowNumber();
        return rowNum == rowEnd;
    }

    private static long fromPixels(Context context, long d) {
        return d * context.getUnitsPerPixel();
    }

    protected int generateRequest(SpaceRequest r, ComposeInfo ci, Extent ae, SpaceRequest pr) {
        GeneralArea a = this.area;
        if (a == null) {
            throw new IllegalStateException();
        }
        Extent ce = new Extent(ae);
        a.adjustAvailable(ce);
        BlockStacker bs = new BlockStacker();
        bs.initialize((Node)((Object)this), this.getProperties());
        SpaceAlternatives sa = bs.composeRequestForArea(ci, ce, pr, a);
        r.incorporateRequest(sa.getFirstBodyRequest());
        a.elaborateRequest(r, 1);
        return sa.getFit();
    }

    public FLOTableCell getAdjacent(TableProgressionDirection dir, boolean following) {
        if (dir == TableProgressionDirection.ROW) {
            return this.getAdjacentInColumn(following);
        }
        if (dir == TableProgressionDirection.COL) {
            return this.getAdjacentInRow(following);
        }
        throw new IllegalArgumentException();
    }

    private FLOTableCell getAdjacentInColumn(boolean following) {
        if (following) {
            if (!this.follCellInColumnComputed) {
                this.follCellInColumn = this.computeAdjacentInColumn(true);
                this.follCellInColumnComputed = true;
            }
            return this.follCellInColumn;
        }
        if (!this.prevCellInColumnComputed) {
            this.prevCellInColumn = this.computeAdjacentInColumn(false);
            this.prevCellInColumnComputed = true;
        }
        return this.prevCellInColumn;
    }

    private FLOTableCell getAdjacentInRow(boolean following) {
        if (following) {
            if (!this.follCellInRowComputed) {
                this.follCellInRow = this.computeAdjacentInRow(true);
                this.follCellInRowComputed = true;
            }
            return this.follCellInRow;
        }
        if (!this.prevCellInRowComputed) {
            this.prevCellInRow = this.computeAdjacentInRow(false);
            this.prevCellInRowComputed = true;
        }
        return this.prevCellInRow;
    }

    public Size getCPD() {
        return new Size(this.cpd);
    }

    public Size getCPDRef() {
        return this.cpd;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public int getNumberColumnsSpanned() {
        return this.getProperties().getTableProperty().getNumberColumnsSpanned();
    }

    public int getNumberRowsSpanned() {
        return this.getProperties().getTableProperty().getNumberRowsSpanned();
    }

    public Size getRPD() {
        return new Size(this.rpd);
    }

    public Size getRPDRef() {
        return this.rpd;
    }

    public Set getRelations(RelationFilter rf) {
        HashSet<FLOTableElement> s = new HashSet<FLOTableElement>();
        FLOTableElement[] fLOTableElementArray = rv;
        synchronized (fLOTableElementArray) {
            FLOTableCell.rv[0] = this;
            FLOTableCell.rv[1] = this.getRow();
            FLOTableCell.rv[2] = this.getRowGroup();
            FLOTableCell.rv[3] = this.getColumn();
            FLOTableCell.rv[4] = this.getColumnGroup();
            FLOTableCell.rv[5] = this.getTable();
            int i = 0;
            while (i < rv.length) {
                FLOTableElement e = rv[i];
                if (e != null && rf != null && !rf.exclude(e)) {
                    s.add(e);
                }
                ++i;
            }
        }
        return s;
    }

    public int getRowNumber() {
        return this.rowNumber;
    }

    public boolean hasCommonEdge(FLOTableElement e, AreaEdge edge) {
        boolean b = false;
        if (e instanceof FLOTableCell) {
            b = this.equals(e);
        } else if (e instanceof FLOTableRow) {
            if (edge == AreaEdge.BEFORE) {
                b = this.startsInRow((FLOTableRow)e);
            } else if (edge == AreaEdge.AFTER) {
                b = this.endsInRow((FLOTableRow)e);
            }
        } else if (e instanceof FLOTableColumn) {
            if (edge == AreaEdge.START) {
                b = this.startsInColumn((FLOTableColumn)e);
            } else if (edge == AreaEdge.END) {
                b = this.endsInColumn((FLOTableColumn)e);
            }
        } else if (e instanceof FLOTableRowGroup) {
            if (edge == AreaEdge.BEFORE) {
                b = this.getRow() == ((FLOTableRowGroup)e).getFirstRow();
            } else if (edge == AreaEdge.AFTER) {
                b = this.getRow() == ((FLOTableRowGroup)e).getLastRow();
            }
        } else if (e instanceof FLOTableColumnGroup) {
            if (edge == AreaEdge.START) {
                b = this.getColumn() == ((FLOTableColumnGroup)e).getFirstColumn();
            } else if (edge == AreaEdge.END) {
                b = this.getColumn() == ((FLOTableColumnGroup)e).getLastColumn();
            }
        } else if (e instanceof FLOTable) {
            if (edge == AreaEdge.BEFORE) {
                b = this.isFirstInColumn();
            } else if (edge == AreaEdge.AFTER) {
                b = this.isLastInColumn();
            } else if (edge == AreaEdge.START) {
                b = this.isFirstInRow();
            } else if (edge == AreaEdge.END) {
                b = this.isLastInRow();
            }
        }
        return b;
    }

    protected void initialize() {
        super.initialize();
    }

    public boolean isFirstInColumn() {
        return this.getAdjacentInColumn(false) == null;
    }

    public boolean isFirstInRow() {
        return this.getAdjacentInRow(false) == null;
    }

    public boolean isLastInColumn() {
        return this.getAdjacentInColumn(true) == null;
    }

    public boolean isLastInRow() {
        return this.getAdjacentInRow(true) == null;
    }

    public void setBorderTraits(AreaEdge edge, CSSColorWithAlpha color, long width, int style) {
        Border b = new Border(color, width, style);
        if (edge == AreaEdge.BEFORE) {
            this.beforeBorderTraits = b;
        } else if (edge == AreaEdge.AFTER) {
            this.afterBorderTraits = b;
        } else if (edge == AreaEdge.START) {
            this.startBorderTraits = b;
        } else if (edge == AreaEdge.END) {
            this.endBorderTraits = b;
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void setCPD(Size cpd) {
        this.cpd.copy(cpd);
    }

    public void setColumnNumber(int columnNumber) {
        if (this.columnNumber != 0) {
            throw new IllegalStateException();
        }
        this.columnNumber = columnNumber;
        this.getProperties().getTableProperty().setColumnNumber(Integer.toString(columnNumber, 10));
    }

    public void setRPD(Size rpd) {
        this.rpd.copy(rpd);
    }

    public void setRowNumber(int rowNumber) {
        if (this.rowNumber != 0) {
            throw new IllegalStateException();
        }
        this.rowNumber = rowNumber;
    }

    public boolean spansColumn(FLOTableColumn column) {
        int colStart = this.getColumnNumber();
        int colEnd = colStart + this.getNumberColumnsSpanned() - 1;
        int colNum = column.getColumnNumber();
        return colStart <= colNum && colNum <= colEnd;
    }

    public boolean spansMultipleInDirection(TableProgressionDirection dir) {
        if (dir == TableProgressionDirection.ROW && this.getNumberRowsSpanned() > 1) {
            return true;
        }
        return dir == TableProgressionDirection.COL && this.getNumberColumnsSpanned() > 1;
    }

    public boolean spansRow(FLOTableRow row) {
        int rowStart = this.getRowNumber();
        int rowEnd = rowStart + this.getNumberRowsSpanned() - 1;
        int rowNum = row.getRowNumber();
        return rowStart <= rowNum && rowNum <= rowEnd;
    }

    public boolean startsInColumn(FLOTableColumn column) {
        int colStart = this.getColumnNumber();
        int colEnd = colStart + this.getNumberColumnsSpanned() - 1;
        int colNum = column.getColumnNumber();
        return colNum == colStart;
    }

    public boolean startsInRow(FLOTableRow row) {
        int rowStart = this.getRowNumber();
        int rowEnd = rowStart + this.getNumberRowsSpanned() - 1;
        int rowNum = row.getRowNumber();
        return rowNum == rowStart;
    }

    private static long toPixels(Context context, long d) {
        return d / context.getUnitsPerPixel();
    }

    public String toString() {
        return "C[" + this.getRowNumber() + "," + this.getColumnNumber() + "]";
    }

    private void updateBorderTraits(BorderBehavior bb) {
        if (bb instanceof CollapsingBorderBehavior) {
            CollapsingBorderBehavior cbb = (CollapsingBorderBehavior)bb;
            if (this.beforeBorderTraits != null) {
                cbb.setBorderTraits(AreaEdge.BEFORE, this.beforeBorderTraits);
            }
            if (this.afterBorderTraits != null) {
                cbb.setBorderTraits(AreaEdge.AFTER, this.afterBorderTraits);
            }
            if (this.startBorderTraits != null) {
                cbb.setBorderTraits(AreaEdge.START, this.startBorderTraits);
            }
            if (this.endBorderTraits != null) {
                cbb.setBorderTraits(AreaEdge.END, this.endBorderTraits);
            }
        }
    }

    private static class MeasureCache {
        private Map map;

        MeasureCache() {
        }

        public Size get(Context context, TableProgressionDirection dir, long constraint) {
            return this.map != null ? (Size)this.map.get(new Key(context, dir, constraint)) : null;
        }

        public void put(Context context, TableProgressionDirection dir, long constraint, Size s) {
            if (this.map == null) {
                this.map = new HashMap();
            }
            this.map.put(new Key(context, dir, constraint), s);
        }

        private static class Key {
            private Context context;
            private TableProgressionDirection dir;
            private Long constraint;

            public Key(Context context, TableProgressionDirection dir, long constraint) {
                this.context = context;
                this.dir = dir;
                this.constraint = new Long(constraint);
            }

            public boolean equals(Object o) {
                return this.hashCode() == o.hashCode();
            }

            public int hashCode() {
                return this.context.hashCode() + this.dir.hashCode() + this.constraint.hashCode();
            }
        }
    }
}

