/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.flo;

import com.ibm.xsl.composer.areas.GeneralArea;
import com.ibm.xsl.composer.flo.ChildNodeWalker;
import com.ibm.xsl.composer.flo.ComposeInfo;
import com.ibm.xsl.composer.flo.FLO;
import com.ibm.xsl.composer.flo.FLOElement;
import com.ibm.xsl.composer.flo.FLOListItemBody;
import com.ibm.xsl.composer.flo.FLOListItemLabel;
import com.ibm.xsl.composer.prim.Extent;
import com.ibm.xsl.composer.prim.FLOPoint;
import com.ibm.xsl.composer.prim.SpaceAlternatives;
import com.ibm.xsl.composer.prim.SpaceRequest;
import java.util.Iterator;
import org.apache.xerces.dom.DocumentImpl;
import org.w3c.dom.Node;

public class FLOListItem
extends FLOElement {
    private ChildNodeWalker walker;
    private SpaceRequest lastChildRequest;
    private long labelStartIndent;
    private long bodyEndIndent;

    public FLOListItem(DocumentImpl ownerDocument) {
        super(ownerDocument, "list-item");
    }

    public FLOListItem(DocumentImpl ownerDocument, String elementName) {
        super(ownerDocument, elementName);
    }

    public GeneralArea composeItemAreas(ComposeInfo composeInfo, Extent available, SpaceRequest chosenRequest, long labelWidth, long labelSeparation, long bodyWidth) {
        GeneralArea blockArea = new GeneralArea();
        Extent childAllocation = new Extent(available);
        Iterator blockRequests = chosenRequest.getChildRequests();
        long columnIPD = labelWidth;
        FLOPoint curPoint = new FLOPoint(this.labelStartIndent, 0L);
        while (blockRequests.hasNext()) {
            SpaceRequest blockRequest = (SpaceRequest)blockRequests.next();
            FLO blockNode = (FLO)blockRequest.getFormatter();
            childAllocation.setIPD(columnIPD);
            GeneralArea childArea = blockNode.composeAreas(composeInfo, childAllocation, blockRequest);
            childArea.setLocation(curPoint);
            blockArea.addChild(childArea);
            columnIPD = bodyWidth - this.labelStartIndent - this.bodyEndIndent;
            curPoint.start += labelWidth + labelSeparation;
        }
        return blockArea;
    }

    public SpaceAlternatives composeItemRequest(ComposeInfo composeInfo, Extent available, SpaceRequest priorRequest, long labelWidth, long bodyWidth) {
        SpaceAlternatives alternatives = new SpaceAlternatives();
        SpaceAlternatives labelAlternatives = null;
        SpaceAlternatives bodyAlternatives = null;
        if (priorRequest != null) {
            this.walker.setCurrentNode((Node)priorRequest.getCursor());
            this.lastChildRequest = priorRequest.getLastChildRequest();
        } else {
            this.walker = new ChildNodeWalker((Node)((Object)this));
            this.walker.getNext();
            while (this.walker.getCurrentNode() != null && !(this.walker.getCurrentNode() instanceof FLOListItemLabel)) {
                this.walker.getNext();
            }
        }
        if (this.walker.getCurrentNode() != null) {
            FLO label = (FLO)((Object)this.walker.getCurrentNode());
            Extent labelAvailable = new Extent(available);
            labelAvailable.ipd = labelWidth;
            labelAlternatives = label.composeRequest(composeInfo, labelAvailable, null);
            this.labelStartIndent = labelAlternatives.getStartIndent();
        }
        while (this.walker.getCurrentNode() != null && !(this.walker.getCurrentNode() instanceof FLOListItemBody)) {
            this.walker.getNext();
        }
        if (this.walker.getCurrentNode() != null) {
            FLO body = (FLO)((Object)this.walker.getCurrentNode());
            Extent bodyAvailable = new Extent(available);
            bodyAvailable.ipd = bodyWidth - this.labelStartIndent;
            bodyAlternatives = body.composeRequest(composeInfo, bodyAvailable, null);
            this.bodyEndIndent = bodyAlternatives.getEndIndent();
        }
        if (labelAlternatives == null || bodyAlternatives == null) {
            alternatives.setFit(2);
        } else {
            SpaceRequest returnRequest = new SpaceRequest(this, null);
            SpaceRequest labelRequest = labelAlternatives.getFirstBodyRequest();
            returnRequest.incorporateRequestMax(labelRequest);
            SpaceRequest bodyRequest = bodyAlternatives.getFirstBodyRequest();
            returnRequest.incorporateRequestMax(bodyRequest);
            this.lastChildRequest = bodyRequest;
            alternatives.addSpaceRequest(returnRequest);
            if (labelAlternatives.getFit() == 1 || bodyAlternatives.getFit() == 1) {
                alternatives.setFit(1);
            } else {
                alternatives.setFit(0);
            }
        }
        return alternatives;
    }

    public String toString() {
        return "[fo:list-item " + Integer.toHexString(this.hashCode()) + "]";
    }
}

