/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.flo;

import com.ibm.xsl.composer.areas.GeneralArea;
import com.ibm.xsl.composer.areas.GlyphBehavior;
import com.ibm.xsl.composer.flo.ComposeInfo;
import com.ibm.xsl.composer.flo.FLOFormattable;
import com.ibm.xsl.composer.flo.InlineContent;
import com.ibm.xsl.composer.framework.ExtendedFont;
import com.ibm.xsl.composer.prim.Extent;
import com.ibm.xsl.composer.prim.SpaceRequest;
import com.ibm.xsl.composer.properties.BorderPaddingBackgroundProperty;
import com.ibm.xsl.composer.properties.CharacterProperty;
import com.ibm.xsl.composer.properties.FontProperty;
import com.ibm.xsl.composer.properties.WritingModeRelatedProperty;
import org.apache.xerces.dom.DocumentImpl;

public class FLOCharacter
extends FLOFormattable
implements InlineContent {
    public FLOCharacter(DocumentImpl ownerDocument) {
        this(ownerDocument, "character");
    }

    public FLOCharacter(DocumentImpl ownerDocument, String elementName) {
        super(ownerDocument, elementName);
        BorderPaddingBackgroundProperty bp = this.properties.getBorderPaddingBackgroundProperty();
        bp.setDefaults();
        WritingModeRelatedProperty wm = this.properties.getWritingModeRelatedProperty();
        wm.setFontHeightOverrideAfterDefault();
        wm.setFontHeightOverrideBeforeDefault();
        wm.setGlyphOrientationHorizontalDefault();
        wm.setGlyphOrientationVerticalDefault();
    }

    protected void addBehaviorsForArea(GeneralArea area, ComposeInfo composeInfo) {
        this.addStandardBorderAndBackgroundBehavior(area);
        CharacterProperty chp = this.properties.getCharacterProperty();
        String character = chp.getCharacter();
        if (character == null) {
            System.err.println("missing character on fo:character.");
            character = " ";
        }
        char ch = character.charAt(0);
        FontProperty fp = this.properties.getFontProperty();
        ExtendedFont font = composeInfo.context.getExtendedFont(fp);
        GlyphBehavior glyph = new GlyphBehavior(font, ch);
        area.addBehavior(glyph);
    }

    protected GeneralArea createArea(ComposeInfo composeInfo, Extent available) {
        GeneralArea area = new GeneralArea();
        return area;
    }

    protected int generateRequest(SpaceRequest request, ComposeInfo composeInfo, Extent available, SpaceRequest priorRequest) {
        Extent charExtent = request.getRequestorArea().getExtent();
        request.setAreaOptimum(charExtent.ipd);
        return this.fitOrNoFit(available.doesFit(charExtent));
    }

    public String toString() {
        return "[fo:character]";
    }
}

