/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.flo;

import com.ibm.xsl.composer.areas.ButtonBehavior;
import com.ibm.xsl.composer.areas.GeneralArea;
import com.ibm.xsl.composer.csstypes.CSSColor;
import com.ibm.xsl.composer.flo.ComposeInfo;
import com.ibm.xsl.composer.flo.FLOFormattable;
import com.ibm.xsl.composer.flo.FLOText;
import com.ibm.xsl.composer.flo.InlineContent;
import com.ibm.xsl.composer.framework.ExtendedFont;
import com.ibm.xsl.composer.java2d.J2DContext;
import com.ibm.xsl.composer.java2d.J2DExtendedFont;
import com.ibm.xsl.composer.prim.Extent;
import com.ibm.xsl.composer.prim.FLOPoint;
import com.ibm.xsl.composer.prim.SpaceRequest;
import com.ibm.xsl.composer.properties.BorderPaddingBackgroundProperty;
import com.ibm.xsl.composer.properties.ColorRelatedProperty;
import com.ibm.xsl.composer.properties.FontProperty;
import java.awt.Button;
import java.awt.Color;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import org.apache.xerces.dom.DocumentImpl;
import org.w3c.dom.Node;

public class FLOButton
extends FLOFormattable
implements InlineContent {
    public Button button = new Button();
    private long fontAscent;
    public long unitsPerPixel;

    public FLOButton(DocumentImpl ownerDocument) {
        this(ownerDocument, "button");
    }

    public FLOButton(DocumentImpl ownerDocument, String name) {
        super(ownerDocument, name);
        BorderPaddingBackgroundProperty bp = this.properties.getBorderPaddingBackgroundProperty();
        bp.setDefaults();
        this.properties.getBlockAndLineRelatedProperty().setWhiteSpaceCollapse("false");
    }

    protected void addBehaviorsForArea(GeneralArea area, ComposeInfo composeInfo) {
        ColorRelatedProperty cp = this.properties.getColorRelatedProperty();
        CSSColor color = cp.getColor();
        BorderPaddingBackgroundProperty bp = this.properties.getBorderPaddingBackgroundProperty();
        CSSColor colorb = bp.getBackgroundColor();
        FontProperty fp = this.properties.getFontProperty();
        ExtendedFont font = composeInfo.context.getExtendedFont(fp);
        this.fontAscent = font.getAscent();
        JComponent jsp = ((J2DContext)composeInfo.context).getParentView();
        ActionListener listener = ((J2DContext)composeInfo.context).getListener();
        Node nextChild = null;
        nextChild = this.getFirstChild();
        if (nextChild instanceof FLOText) {
            FLOText floText = (FLOText)((Object)nextChild);
            String textString = floText.getText();
            this.button.setVisible(false);
            J2DExtendedFont ef = (J2DExtendedFont)composeInfo.context.getExtendedFont(fp);
            this.button.setFont(ef.getFont());
            this.button.setForeground(new Color(color.red, color.green, color.blue));
            this.button.setBackground(new Color(colorb.red, colorb.green, colorb.blue));
            jsp.add(this.button);
            if (listener != null) {
                this.button.addActionListener(listener);
            }
            this.unitsPerPixel = composeInfo.context.getUnitsPerPixel();
            area.addBehavior(new ButtonBehavior(this));
            this.button.setLabel(textString);
            FLOPoint curPoint = new FLOPoint(0L, 0L);
            long width = font.getTextExtent(textString).getWidth();
            long height = font.getHeight();
            this.button.setSize((int)(width / this.unitsPerPixel), (int)(height / this.unitsPerPixel));
            Extent size = new Extent(height, width);
            area.extendContentArea(curPoint, size);
        }
    }

    protected GeneralArea createArea(ComposeInfo composeInfo, Extent available) {
        GeneralArea area = new GeneralArea();
        return area;
    }

    protected int generateRequest(SpaceRequest request, ComposeInfo composeInfo, Extent available, SpaceRequest priorRequest) {
        Extent graphExtent = request.getRequestorArea().getExtent();
        request.setAreaOptimum(graphExtent.ipd);
        return this.fitOrNoFit(available.doesFit(graphExtent));
    }

    public long getHeight() {
        return this.fontAscent;
    }

    public String toString() {
        return "[ibm:button]";
    }
}

