/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.flo;

import com.ibm.xsl.composer.areas.GeneralArea;
import com.ibm.xsl.composer.csstypes.CSSLength;
import com.ibm.xsl.composer.flo.BlockContent;
import com.ibm.xsl.composer.flo.ChildNodeWalker;
import com.ibm.xsl.composer.flo.ComposeInfo;
import com.ibm.xsl.composer.flo.FLO;
import com.ibm.xsl.composer.flo.FLOElement;
import com.ibm.xsl.composer.prim.Extent;
import com.ibm.xsl.composer.prim.FLOPoint;
import com.ibm.xsl.composer.prim.SpaceAlternatives;
import com.ibm.xsl.composer.prim.SpaceRequest;
import java.util.Iterator;
import org.apache.xerces.dom.DocumentImpl;
import org.w3c.dom.Node;

public class ColumnFormatter
extends FLOElement {
    private ChildNodeWalker walker;
    private SpaceRequest lastChildRequest;

    public ColumnFormatter(DocumentImpl ownerDocument) {
        super(ownerDocument, "table-row");
    }

    public ColumnFormatter(DocumentImpl ownerDocument, String elementName) {
        super(ownerDocument, elementName);
    }

    public GeneralArea composeAreas(ComposeInfo composeInfo, Extent allocated, SpaceRequest chosenRequest) {
        long[] units = composeInfo.getUnitsForProperties(this.properties);
        GeneralArea blockArea = chosenRequest.getRequestorArea();
        blockArea.adjustAvailable(allocated);
        FLOPoint curPoint = new FLOPoint(0L, 0L);
        Extent childAllocation = new Extent(allocated);
        int curColumn = 0;
        Iterator blockRequests = chosenRequest.getChildRequests();
        while (blockRequests.hasNext()) {
            SpaceRequest blockRequest = (SpaceRequest)blockRequests.next();
            FLO blockNode = (FLO)blockRequest.getFormatter();
            CSSLength columnWidth = composeInfo.columns.getWidth(curColumn);
            long columnIPD = columnWidth.getNormalizedLength(units);
            childAllocation.setIPD(columnIPD);
            GeneralArea childArea = blockNode.composeAreas(composeInfo, childAllocation, blockRequest);
            childArea.setLocation(curPoint);
            blockArea.addChild(childArea);
            curPoint.start += columnIPD;
            ++curColumn;
        }
        return blockArea;
    }

    public SpaceAlternatives composeRequest(ComposeInfo composeInfo, Extent available, SpaceRequest priorRequest) {
        SpaceAlternatives alternatives = new SpaceAlternatives();
        if (priorRequest == null) {
            this.walker = new ChildNodeWalker((Node)((Object)this));
            this.walker.getNext();
            while (this.walker.getCurrentNode() != null && !(this.walker.getCurrentNode() instanceof BlockContent)) {
                this.walker.getNext();
            }
        } else {
            this.walker.setCurrentNode((Node)priorRequest.getCursor());
        }
        if (this.walker.getCurrentNode() != null) {
            long[] units = composeInfo.getUnitsForProperties(this.properties);
            GeneralArea blockArea = new GeneralArea();
            blockArea.initializeTraits(composeInfo, this.properties);
            blockArea.setProgenitor(this);
            blockArea.adjustAvailable(available);
            SpaceRequest returnRequest = new SpaceRequest(this, blockArea);
            long maxHeight = 0L;
            int curColumn = 0;
            SpaceRequest totalBPD = new SpaceRequest();
            Extent remaining = new Extent(available);
            CSSLength columnWidth = composeInfo.columns.getWidth(curColumn);
            remaining.setIPD(columnWidth.getNormalizedLength(units));
            SpaceAlternatives nextAlternatives = this.generateNextAlternatives(composeInfo, remaining);
            while (nextAlternatives != null) {
                int fit = nextAlternatives.getFit();
                if (fit == 0 || fit == 1) {
                    alternatives.setFit(fit);
                    SpaceRequest request = nextAlternatives.getFirstBodyRequest();
                    returnRequest.incorporateRequest(request);
                    returnRequest.setCursor(this.walker.getCurrentNode());
                    maxHeight = Math.max(maxHeight, request.getOptimum());
                } else if (fit == 2) {
                    returnRequest.setCursor(null);
                }
                nextAlternatives = this.generateNextAlternatives(composeInfo, remaining);
                ++curColumn;
            }
            returnRequest.setAreaOptimum(maxHeight);
            alternatives.addSpaceRequest(returnRequest);
        } else {
            alternatives.setFit(2);
        }
        return alternatives;
    }

    private SpaceAlternatives generateNextAlternatives(ComposeInfo composeInfo, Extent available) {
        SpaceAlternatives alternatives;
        if (this.walker.getCurrentNode() != null) {
            alternatives = ((FLO)((Object)this.walker.getCurrentNode())).composeRequest(composeInfo, available, this.lastChildRequest);
            this.walker.getNext();
            while (this.walker.getCurrentNode() != null && !(this.walker.getCurrentNode() instanceof BlockContent)) {
                this.walker.getNext();
            }
        } else {
            alternatives = null;
        }
        return alternatives;
    }

    public void reset() {
        super.reset();
    }

    public String toString() {
        return "[fo:table(ColumnFormatter) " + this.hashCode() + "]";
    }
}

