/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.csstypes;

public class WritingMode {
    public static final short LEFT_TO_RIGHT = 0;
    public static final short TOP_TO_BOTTOM = 1;
    public static final short RIGHT_TO_LEFT = 2;
    public static final short BOTTOM_TO_TOP = 3;
    public static final WritingMode RL_TB = new WritingMode();
    public static final WritingMode LR_TB = new WritingMode();
    public static final WritingMode TB_RL = new WritingMode();
    private static final String[] directions = new String[]{"lr", "tb", "rl", "bt"};
    private short bpd = 1;
    private short ipd = 0;
    private short shift = (short)3;

    static {
        RL_TB.setWritingMode("rl-tb");
        LR_TB.setWritingMode("lr-tb");
        TB_RL.setWritingMode("tb-rl");
    }

    public void copy(WritingMode writingMode) {
        this.bpd = writingMode.bpd;
        this.ipd = writingMode.ipd;
        this.shift = writingMode.shift;
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (this == o) {
            result = true;
        } else if (o instanceof WritingMode) {
            WritingMode mode = (WritingMode)o;
            result = this.ipd == mode.ipd && this.bpd == mode.bpd && this.shift == mode.shift;
        }
        return result;
    }

    public short getBlockProgressionDirection() {
        return this.bpd;
    }

    public static String getDirectionName(short direction) {
        return directions[direction];
    }

    public short getInlineProgressionDirection() {
        return this.ipd;
    }

    public short getShiftDirection() {
        return this.shift;
    }

    public String getWritingMode() {
        return String.valueOf(directions[this.ipd]) + "-" + directions[this.bpd];
    }

    public boolean isVertical() {
        return this.ipd == 1 || this.ipd == 3;
    }

    public void setWritingMode(String mode) {
        int hyph = (mode = mode.trim().toLowerCase()).indexOf(45);
        if (hyph < 0) {
            int i = 0;
            while (i < directions.length) {
                if (mode.equals(directions[i])) {
                    this.ipd = (short)i;
                    i = (short)directions.length;
                }
                i = (short)(i + 1);
            }
            this.bpd = this.ipd == 0 || this.ipd == 2 ? (short)1 : (short)2;
        } else {
            String ipdStr = mode.substring(0, hyph);
            int i = 0;
            while (i < directions.length) {
                if (ipdStr.equals(directions[i])) {
                    this.ipd = (short)i;
                    i = (short)directions.length;
                }
                i = (short)(i + 1);
            }
            String bpdStr = mode.substring(hyph + 1);
            int i2 = 0;
            while (i2 < directions.length) {
                if (bpdStr.equals(directions[i2])) {
                    this.bpd = (short)i2;
                    i2 = (short)directions.length;
                }
                i2 = (short)(i2 + 1);
            }
            if (this.ipd % 2 == this.bpd % 2) {
                this.bpd = (short)((this.bpd + 1) % 4);
            }
        }
        this.shift = (short)((this.bpd + 2) % 4);
    }

    public void setWritingMode(short ipd, short bpd) {
        this.bpd = bpd;
        this.ipd = ipd;
    }

    public String toString() {
        return "[WritingMode " + this.getWritingMode() + "]";
    }
}

