/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.csstypes;

import com.ibm.xsl.composer.csstypes.CSSLength;
import com.ibm.xsl.composer.csstypes.LengthRange;
import com.ibm.xsl.composer.prim.Space;

public class SpaceCDT {
    public static final String FORCE = "force";
    public static final String DISCARD_STRING = "discard";
    public static final String RETAIN_STRING = "retain";
    public static final String PRECEDENCE_DEFAULT = "0";
    public static final String CONDITIONALITY_DEFAULT = "discard";
    private Space space = new Space();
    private LengthRange mmo = new LengthRange(3);

    public void copy(SpaceCDT o) {
        this.mmo.copy(o.mmo);
        this.space.copy(o.space);
    }

    public boolean equals(Object object) {
        boolean isEqual = false;
        if (object instanceof SpaceCDT) {
            SpaceCDT o = (SpaceCDT)object;
            isEqual = this.mmo.equals(o.mmo) && this.space.equals(o.space);
        }
        return isEqual;
    }

    public String getAttributeString() {
        return String.valueOf(this.mmo.getString()) + " " + this.space.getPrecedenceTypeName() + " " + this.space.getConditionalityName();
    }

    public CSSLength getMaximum() {
        return new CSSLength(this.mmo.getMaximum());
    }

    public CSSLength getMinimum() {
        return new CSSLength(this.mmo.getMinimum());
    }

    public Space getNormalizedSpace(long[] units) {
        this.space.setSize(this.mmo.getNormalizedSize(units));
        return this.space;
    }

    public CSSLength getOptimum() {
        return new CSSLength(this.mmo.getOptimum());
    }

    public void setConditionality(String conditionality) {
        this.space.setConditionality(conditionality);
    }

    public void setLength(String value) {
        this.mmo.setLength(value);
    }

    public void setMaximum(String maximum) {
        this.mmo.setMaximum(maximum);
    }

    public void setMinimum(String minimum) {
        this.mmo.setMinimum(minimum);
    }

    public void setOptimum(String optimum) {
        this.mmo.setOptimum(optimum);
    }

    public void setPrecedence(String precedence) {
        this.space.setPrecedence(precedence);
    }

    public String toString() {
        return "[SpaceCDT " + this.mmo + this.space + "]";
    }
}

