/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.csstypes;

import com.ibm.xsl.composer.csstypes.CSSLength;
import com.ibm.xsl.composer.prim.Size;

public class LengthRange {
    protected CSSLength minimum;
    protected CSSLength maximum;
    protected CSSLength optimum;
    private int type;
    protected boolean minimumWasSetIndividually = false;
    protected boolean optimumWasSetIndividually = false;
    protected boolean maximumWasSetIndividually = false;

    public LengthRange() {
        this(3);
    }

    public LengthRange(int type) {
        this.minimum = new CSSLength(type);
        this.maximum = new CSSLength(type);
        this.optimum = new CSSLength(type);
        this.type = type;
    }

    public LengthRange(String min, String opt, String max) {
        this(3);
        this.minimum.setLength(min);
        this.maximum.setLength(max);
        this.optimum.setLength(opt);
    }

    public void copy(LengthRange mmo) {
        this.minimum.copy(mmo.minimum);
        this.optimum.copy(mmo.optimum);
        this.maximum.copy(mmo.maximum);
        this.minimumWasSetIndividually = mmo.minimumWasSetIndividually;
        this.optimumWasSetIndividually = mmo.optimumWasSetIndividually;
        this.maximumWasSetIndividually = mmo.maximumWasSetIndividually;
    }

    public boolean equals(Object object) {
        if (object instanceof LengthRange) {
            LengthRange o = (LengthRange)object;
            if (this.minimum.equals(o.minimum) && this.maximum.equals(o.maximum) && this.optimum.equals(o.optimum)) {
                return true;
            }
        }
        return false;
    }

    public CSSLength getMaximum() {
        return new CSSLength(this.maximum);
    }

    public String getMaximumString() {
        return this.maximum.getLength();
    }

    public CSSLength getMinimum() {
        return new CSSLength(this.minimum);
    }

    public String getMinimumString() {
        return this.minimum.getLength();
    }

    public Size getNormalizedSize(long[] units) {
        return new Size(this.minimum.getNormalizedLength(units), this.maximum.getNormalizedLength(units), this.optimum.getNormalizedLength(units));
    }

    public CSSLength getOptimum() {
        return new CSSLength(this.optimum);
    }

    public String getOptimumString() {
        return this.optimum.getLength();
    }

    public String getString() {
        return "minimum:" + this.minimum.getLength() + " optimum:" + this.optimum.getLength() + " maximum:" + this.maximum.getLength();
    }

    public void setLength(String value) {
        if (!this.minimumWasSetIndividually) {
            this.setMinimumIndividually(value, false);
        }
        if (!this.optimumWasSetIndividually) {
            this.setOptimumIndividually(value, false);
        }
        if (!this.maximumWasSetIndividually) {
            this.setMaximumIndividually(value, false);
        }
    }

    public void setMaximum(String maximum) {
        this.setMaximumIndividually(maximum, true);
    }

    private void setMaximumIndividually(String maximum, boolean individual) {
        this.maximum.setLength(maximum);
        if (individual) {
            this.maximumWasSetIndividually = true;
        }
    }

    public void setMinimum(String minimum) {
        this.setMinimumIndividually(minimum, true);
    }

    private void setMinimumIndividually(String minimum, boolean individual) {
        this.minimum.setLength(minimum);
        if (individual) {
            this.minimumWasSetIndividually = true;
        }
    }

    public void setOptimum(String optimum) {
        this.setOptimumIndividually(optimum, true);
    }

    private void setOptimumIndividually(String optimum, boolean individual) {
        this.optimum.setLength(optimum);
        if (individual) {
            this.optimumWasSetIndividually = true;
        }
    }

    public String toString() {
        return "[" + this.getString() + "]";
    }
}

