/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.csstypes;

import com.ibm.xsl.composer.properties.parse.ParseException;
import java.util.Hashtable;

public class CSSColor {
    public short red;
    public short green;
    public short blue;
    private static Hashtable colorNames = new Hashtable();

    static {
        colorNames.put("black", "000000");
        colorNames.put("silver", "C0C0C0");
        colorNames.put("grey", "808080");
        colorNames.put("white", "FFFFFF");
        colorNames.put("maroon", "800000");
        colorNames.put("red", "FF0000");
        colorNames.put("purple", "800080");
        colorNames.put("fuchsia", "FF00FF");
        colorNames.put("green", "008000");
        colorNames.put("lime", "00FF00");
        colorNames.put("olive", "808000");
        colorNames.put("yellow", "FFFF00");
        colorNames.put("navy", "000080");
        colorNames.put("blue", "0000FF");
        colorNames.put("teal", "008080");
        colorNames.put("aqua", "00FFFF");
    }

    public CSSColor() {
    }

    public CSSColor(int red, int green, int blue) {
        this.red = (short)red;
        this.green = (short)green;
        this.blue = (short)blue;
    }

    public CSSColor(CSSColor color) {
        this.copy(color);
    }

    public CSSColor(String color) throws ParseException {
        this.setColor(color);
    }

    public String attributeString() {
        return "rgb(" + Short.toString(this.red) + "," + Short.toString(this.green) + "," + Short.toString(this.blue) + ")";
    }

    public CSSColor complement() {
        return new CSSColor(this.red ^ 0xFF, this.green ^ 0xFF, this.blue ^ 0xFF);
    }

    public void copy(CSSColor color) {
        this.red = color.red;
        this.green = color.green;
        this.blue = color.blue;
    }

    public boolean equals(Object color) {
        boolean equals = false;
        if (this == color) {
            equals = true;
        } else if (color instanceof CSSColor) {
            CSSColor c = (CSSColor)color;
            equals = this.red == c.red && this.green == c.green && this.blue == c.blue;
        }
        return equals;
    }

    private String getTwoHexDigits(short number) {
        String hexString = Integer.toHexString(number);
        if (hexString.length() == 1) {
            hexString = "0" + hexString;
        }
        return hexString;
    }

    public void setColor(String color) throws ParseException {
        String hexString = null;
        if ((color = color.trim().toLowerCase()).startsWith("#")) {
            hexString = color.substring(1);
        } else if (color.startsWith("rgb")) {
            try {
                short percent;
                String pct;
                String remaining = color.substring(color.indexOf(40));
                String redStr = remaining.substring(1, remaining.indexOf(44));
                remaining = remaining.substring(remaining.indexOf(44));
                String greenStr = remaining.substring(1, remaining.indexOf(",", 1));
                remaining = remaining.substring(remaining.indexOf(",", 1));
                String blueStr = remaining.substring(1, remaining.indexOf(")"));
                if (redStr.indexOf("%") == -1) {
                    this.red = Short.parseShort(redStr);
                } else {
                    pct = redStr.substring(0, redStr.indexOf(37));
                    percent = Short.parseShort(pct);
                    this.red = (short)(percent * 255 / 100);
                }
                if (greenStr.indexOf("%") == -1) {
                    this.green = Short.parseShort(greenStr);
                } else {
                    pct = greenStr.substring(0, greenStr.indexOf(37));
                    percent = Short.parseShort(pct);
                    this.green = (short)(percent * 255 / 100);
                }
                if (blueStr.indexOf("%") == -1) {
                    this.blue = Short.parseShort(blueStr);
                }
                pct = blueStr.substring(0, blueStr.indexOf(37));
                percent = Short.parseShort(pct);
                this.blue = (short)(percent * 255 / 100);
            }
            catch (IndexOutOfBoundsException ex) {
                System.out.println(ex);
                throw new ParseException(101, color);
            }
            catch (NumberFormatException ex) {
                System.out.println(ex);
                throw new ParseException(101, color);
            }
        } else {
            hexString = (String)colorNames.get(color);
        }
        if (hexString != null) {
            if (hexString.length() == 3) {
                char[] digits = new char[6];
                char[] givenDigits = hexString.toCharArray();
                int i = 0;
                while (i < 3) {
                    digits[2 * i] = givenDigits[i];
                    digits[2 * i + 1] = givenDigits[i];
                    ++i;
                }
                hexString = new String(digits);
            }
            if (hexString.length() == 6) {
                try {
                    long value = Long.parseLong(hexString, 16);
                    this.red = (short)((value & 0xFF0000L) >> 16);
                    this.green = (short)((value & 0xFF00L) >> 8);
                    this.blue = (short)(value & 0xFFL);
                }
                catch (NumberFormatException ex) {
                    System.out.println(String.valueOf(hexString) + " invalid " + ex);
                    throw new ParseException(101, color);
                }
            } else {
                System.out.println("invalid color spec:" + hexString);
                throw new ParseException(101, color);
            }
        }
    }

    public String toHexColor() {
        return "#" + this.getTwoHexDigits(this.red) + this.getTwoHexDigits(this.green) + this.getTwoHexDigits(this.blue);
    }

    public String toString() {
        return "[CSSColor red:" + this.red + " green:" + this.green + " blue:" + this.blue + "]";
    }
}

