/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.areas;

import com.ibm.xsl.composer.areas.AreaTreeNode;
import com.ibm.xsl.composer.areas.AreaTreeVisitor;
import com.ibm.xsl.composer.areas.GeneralArea;
import com.ibm.xsl.composer.prim.Extent;
import com.ibm.xsl.composer.prim.FLOPoint;
import com.ibm.xsl.composer.prim.Transform;
import java.util.ListIterator;

public class LineArea
extends GeneralArea {
    private long maxBaselineOffset = 0L;
    private long maxDescender = 0L;

    public void addChild(AreaTreeNode child) {
        if (!(child instanceof GeneralArea)) {
            throw new IllegalArgumentException("Child must be a GeneralArea");
        }
        super.addChild(child);
        GeneralArea inlineArea = (GeneralArea)child;
        long baselineOffset = inlineArea.getBaselineOffset();
        this.maxBaselineOffset = Math.max(this.maxBaselineOffset, baselineOffset);
        Extent extent = inlineArea.getExtent();
        this.maxDescender = Math.max(this.maxDescender, extent.bpd - baselineOffset);
    }

    protected void adjustTransform(Transform tf) {
        super.adjustTransform(tf);
    }

    public void alignChildren() {
        ListIterator it = this.getChildren();
        while (it.hasNext()) {
            GeneralArea area = (GeneralArea)it.next();
            FLOPoint relLocation = area.getLocation();
            area.setLocation(this.maxBaselineOffset - area.getBaselineOffset(), relLocation.start);
        }
    }

    public String diagnostic() {
        return String.valueOf(super.diagnostic()) + "<max-baseline-offset>" + this.maxBaselineOffset + "</max-baseline-offset>" + "<max-descender>" + this.maxDescender + "</max-descender>";
    }

    public void extendContentArea(FLOPoint location, Extent extent) {
        this.contentExtent.replaceIPDIfLarger(location.start + extent.ipd);
        this.contentExtent.replaceBPDIfLarger(location.before + this.maxBaselineOffset + this.maxDescender);
    }

    public long getBaselineOffset() {
        long offset = this.maxBaselineOffset;
        if (this.behavior != null) {
            offset = this.behavior.adjustBaseline(offset);
        }
        return offset;
    }

    public void setLineHeight(long height) {
        this.maxBaselineOffset = height;
        this.contentExtent.replaceBPDIfLarger(height);
        System.out.println("setLineHeight contentExtent: " + this.contentExtent);
    }

    public String toString() {
        return "<line-area>" + this.diagnostic() + "</line-area>";
    }

    protected void visitAfter(AreaTreeVisitor v) {
        v.afterLineArea(this);
    }

    protected void visitBefore(AreaTreeVisitor v) {
        v.beforeLineArea(this);
    }
}

