/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.html.HTMLList;
import java.io.IOException;
import java.io.ObjectInputStream;

public class OrderedList
extends HTMLList {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    static final long serialVersionUID = -1082870000306640180L;
    private String type_;
    private int start_ = -1;

    public OrderedList() {
    }

    public OrderedList(String string) {
        this.setType(string);
    }

    public int getStartingSequenceNumber() {
        return this.start_;
    }

    public String getTag() {
        if (this.isUseFO()) {
            return this.getFOTag();
        }
        if (this.getItems().isEmpty()) {
            Trace.log(2, "Attempting to get tag before setting items in list.");
            throw new ExtendedIllegalStateException("items", 4);
        }
        StringBuffer stringBuffer = new StringBuffer("<ol");
        stringBuffer.append(this.getTypeAttributeTag());
        if (this.start_ > 0) {
            stringBuffer.append(" start=\"");
            stringBuffer.append(Integer.toString(this.start_));
            stringBuffer.append("\"");
        }
        if (this.isCompact()) {
            stringBuffer.append(" compact=\"compact\"");
        }
        stringBuffer.append(this.getLanguageAttributeTag());
        stringBuffer.append(this.getDirectionAttributeTag());
        stringBuffer.append(this.getAttributeString());
        stringBuffer.append(">\n");
        stringBuffer.append(this.getItemAttributeTag());
        stringBuffer.append("</ol>\n");
        return stringBuffer.toString();
    }

    public String getFOTag() {
        boolean bl = this.isUseFO();
        this.setUseFO(true);
        if (this.getItems().isEmpty()) {
            Trace.log(2, "Attempting to get XSL-FO tag before setting items in list.");
            throw new ExtendedIllegalStateException("items", 4);
        }
        if (this.type_ == null) {
            this.type_ = "numbers";
        }
        StringBuffer stringBuffer = new StringBuffer("<fo:block-container");
        stringBuffer.append(this.getDirectionAttributeTag());
        stringBuffer.append(">\n");
        stringBuffer.append("<fo:list-block>\n");
        stringBuffer.append(this.getItemAttributeFOTag(this.type_));
        stringBuffer.append("</fo:list-block>\n");
        stringBuffer.append("</fo:block-container>\n");
        this.setUseFO(bl);
        return stringBuffer.toString();
    }

    public String getType() {
        return this.type_;
    }

    private String getTypeAttributeTag() {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.type_ != null) {
            if (this.type_.equals("numbers")) {
                stringBuffer.append(" type=\"1\"");
            } else if (this.type_.equals("capitals")) {
                stringBuffer.append(" type=\"A\"");
            } else if (this.type_.equals("lower_case")) {
                stringBuffer.append(" type=\"a\"");
            } else if (this.type_.equals("large_roman")) {
                stringBuffer.append(" type=\"I\"");
            } else if (this.type_.equals("small_roman")) {
                stringBuffer.append(" type=\"i\"");
            }
            return stringBuffer.toString();
        }
        return "";
    }

    public void setType(String string) {
        if (string == null) {
            throw new NullPointerException("type");
        }
        if (!(string.equals("numbers") || string.equals("capitals") || string.equals("lower_case") || string.equals("large_roman") || string.equals("small_roman"))) {
            throw new ExtendedIllegalArgumentException("type", 2);
        }
        if (Trace.isTraceOn()) {
            Trace.log(3, "   Setting order labeling type for <ol>.");
        }
        String string2 = this.type_;
        this.type_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("type", string2, string);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    public void setStartingSequenceNumber(int n) {
        if (n < 0) {
            throw new ExtendedIllegalArgumentException("start", 4);
        }
        if (Trace.isTraceOn()) {
            Trace.log(3, "   Setting starting number for <ol>.");
        }
        int n2 = this.start_;
        this.start_ = n;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("start", new Integer(n2), new Integer(n));
        }
    }
}

