/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.html.HTMLConstants;
import com.ibm.as400.util.html.HTMLTagAttributes;
import com.ibm.as400.util.html.HTMLTagElement;
import com.ibm.as400.util.html.HTMLText;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class HTMLTableCaption
extends HTMLTagAttributes
implements HTMLConstants,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    static final long serialVersionUID = 8692666542126042315L;
    private HTMLTagElement element_;
    private String align_;
    private String lang_;
    private String dir_;
    private boolean useFO_ = false;
    private transient VetoableChangeSupport vetos_;

    public HTMLTableCaption() {
    }

    public HTMLTableCaption(HTMLTagElement hTMLTagElement) {
        if (hTMLTagElement == null) {
            throw new NullPointerException("element");
        }
        this.element_ = hTMLTagElement;
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ == null) {
            this.vetos_ = new VetoableChangeSupport(this);
        }
        this.vetos_.addVetoableChangeListener(vetoableChangeListener);
    }

    public String getAlignment() {
        return this.align_;
    }

    public String getDirection() {
        return this.dir_;
    }

    String getDirectionAttributeTag() {
        if (this.useFO_) {
            if (this.dir_ != null && this.dir_.length() > 0) {
                if (this.dir_.equals("rtl")) {
                    return " writing-mode='rl'";
                }
                return " writing-mode='lr'";
            }
            return "";
        }
        if (this.dir_ != null && this.dir_.length() > 0) {
            StringBuffer stringBuffer = new StringBuffer(" dir=\"");
            stringBuffer.append(this.dir_);
            stringBuffer.append("\"");
            return stringBuffer.toString();
        }
        return "";
    }

    public HTMLTagElement getElement() {
        return this.element_;
    }

    public String getLanguage() {
        return this.lang_;
    }

    String getLanguageAttributeTag() {
        if (this.lang_ != null && this.lang_.length() > 0) {
            StringBuffer stringBuffer = new StringBuffer(" lang=\"");
            stringBuffer.append(this.lang_);
            stringBuffer.append("\"");
            return stringBuffer.toString();
        }
        return "";
    }

    public String getTag() {
        if (this.useFO_) {
            return this.getFOTag();
        }
        if (this.element_ == null) {
            Trace.log(2, "Attempting to get tag before setting the 'element' parameter.");
            throw new ExtendedIllegalStateException("element", 4);
        }
        StringBuffer stringBuffer = new StringBuffer("<caption");
        if (this.align_ != null) {
            stringBuffer.append(" align=\"");
            stringBuffer.append(this.align_);
            stringBuffer.append("\"");
        }
        stringBuffer.append(this.getLanguageAttributeTag());
        stringBuffer.append(this.getDirectionAttributeTag());
        stringBuffer.append(this.getAttributeString());
        stringBuffer.append(">");
        stringBuffer.append(this.element_.getTag());
        stringBuffer.append("</caption>\n");
        return stringBuffer.toString();
    }

    public String getFOTag() {
        boolean bl = this.useFO_;
        this.setUseFO(true);
        if (this.element_ == null) {
            Trace.log(2, "Attempting to get XSL-FO tag before setting the 'element' parameter.");
            throw new ExtendedIllegalStateException("element", 4);
        }
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("<fo:block");
        if (this.align_ != null) {
            stringBuffer.append(" text-align=\"");
            if (this.align_.equals("center")) {
                stringBuffer.append("center\"");
            } else if (this.align_.equals("right")) {
                stringBuffer.append("end\"");
            } else if (this.align_.equals("left")) {
                stringBuffer.append("start\"");
            } else {
                stringBuffer.append("center\"");
            }
        }
        stringBuffer.append(this.getDirectionAttributeTag());
        stringBuffer.append(">");
        stringBuffer.append(this.element_.getFOTag());
        stringBuffer.append("</fo:block>\n");
        this.setUseFO(bl);
        return stringBuffer.toString();
    }

    public boolean isUseFO() {
        return this.useFO_;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ != null) {
            this.vetos_.removeVetoableChangeListener(vetoableChangeListener);
        }
    }

    public void setAlignment(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("alignment");
        }
        if (string.equalsIgnoreCase("bottom") || string.equalsIgnoreCase("top") || string.equalsIgnoreCase("left") || string.equalsIgnoreCase("right")) {
            String string2 = this.align_;
            if (this.vetos_ != null) {
                this.vetos_.fireVetoableChange("alignment", string2, string);
            }
            this.align_ = string;
            if (this.changes_ != null) {
                this.changes_.firePropertyChange("alignment", string2, string);
            }
        } else {
            throw new ExtendedIllegalArgumentException("alignment", 2);
        }
    }

    public void setDirection(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("dir");
        }
        if (!string.equals("ltr") && !string.equals("rtl")) {
            throw new ExtendedIllegalArgumentException("dir", 2);
        }
        String string2 = this.dir_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("dir", string2, string);
        }
        this.dir_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("dir", string2, string);
        }
    }

    public void setElement(String string) throws PropertyVetoException {
        this.setElement(new HTMLText(string));
    }

    public void setElement(HTMLTagElement hTMLTagElement) throws PropertyVetoException {
        if (hTMLTagElement == null) {
            throw new NullPointerException("element");
        }
        HTMLTagElement hTMLTagElement2 = this.element_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("element", hTMLTagElement2, hTMLTagElement);
        }
        this.element_ = hTMLTagElement;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("element", hTMLTagElement2, hTMLTagElement);
        }
    }

    public void setLanguage(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("lang");
        }
        String string2 = this.lang_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("lang", string2, string);
        }
        this.lang_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("lang", string2, string);
        }
    }

    public void setUseFO(boolean bl) {
        boolean bl2 = this.useFO_;
        this.useFO_ = bl;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("useFO", bl2, bl);
        }
    }

    public String toString() {
        return this.getTag();
    }
}

