/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.html.ElementEvent;
import com.ibm.as400.util.html.ElementListener;
import com.ibm.as400.util.html.HTMLParameter;
import com.ibm.as400.util.html.HTMLTagAttributes;
import com.ibm.as400.util.html.ResourceBundleLoader_h;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Vector;

public class HTMLServlet
extends HTMLTagAttributes
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    static final long serialVersionUID = -3782566892366981877L;
    private String name_;
    private String text_ = ResourceBundleLoader_h.getText("PROP_DESC_SERVLET_ALTTEXT");
    private String location_;
    private Vector list_;
    private static ResourceBundleLoader_h loader_;
    private transient Vector elementListeners;

    public HTMLServlet() {
        this.list_ = new Vector();
    }

    public HTMLServlet(String string) {
        this.setName(string);
        this.list_ = new Vector();
    }

    public HTMLServlet(String string, String string2) {
        this.setName(string);
        this.setLocation(string2);
        this.list_ = new Vector();
    }

    public void addParameter(HTMLParameter hTMLParameter) {
        if (hTMLParameter == null) {
            throw new NullPointerException("param");
        }
        this.list_.addElement(hTMLParameter);
        this.fireElementEvent(0);
    }

    public HTMLParameter addParameter(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("name");
        }
        if (string2 == null) {
            throw new NullPointerException("value");
        }
        HTMLParameter hTMLParameter = new HTMLParameter(string, string2);
        this.list_.addElement(hTMLParameter);
        this.fireElementEvent(0);
        return hTMLParameter;
    }

    public void addElementListener(ElementListener elementListener) {
        if (elementListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.elementListeners == null) {
            this.elementListeners = new Vector();
        }
        this.elementListeners.addElement(elementListener);
    }

    private void fireElementEvent(int n) {
        if (this.elementListeners == null) {
            return;
        }
        Vector vector = (Vector)this.elementListeners.clone();
        ElementEvent elementEvent = new ElementEvent(this, n);
        for (int i = 0; i < vector.size(); ++i) {
            ElementListener elementListener = (ElementListener)vector.elementAt(i);
            if (n == 0) {
                elementListener.elementAdded(elementEvent);
                continue;
            }
            if (n != 2) continue;
            elementListener.elementRemoved(elementEvent);
        }
    }

    public String getLocation() {
        return this.location_;
    }

    public String getName() {
        return this.name_;
    }

    public String getText() {
        return this.text_;
    }

    public String getFOTag() {
        Trace.log(2, "Attempting to getFOTag() for an object that doesn't support it.");
        return "<!-- An HTMLServlet was here -->";
    }

    public String getTag() {
        if (this.name_ == null) {
            Trace.log(2, "Attempting to get tag before setting servlet name.");
            throw new ExtendedIllegalStateException("name", 4);
        }
        StringBuffer stringBuffer = new StringBuffer("<servlet");
        stringBuffer.append(" name=\"" + this.getName() + "\"");
        if (this.location_ != null) {
            stringBuffer.append(" codebase=\"");
            stringBuffer.append(this.getLocation());
            stringBuffer.append("\"");
            stringBuffer.append(this.getAttributeString());
            stringBuffer.append(">\n");
        } else {
            stringBuffer.append(this.getAttributeString());
            stringBuffer.append(">\n");
        }
        for (int i = 0; i < this.list_.size(); ++i) {
            HTMLParameter hTMLParameter = (HTMLParameter)this.list_.elementAt(i);
            stringBuffer.append(hTMLParameter.getTag());
        }
        stringBuffer.append(this.getText() + "\n");
        stringBuffer.append("</servlet>\n");
        return stringBuffer.toString();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    public void removeParameter(HTMLParameter hTMLParameter) {
        if (hTMLParameter == null) {
            throw new NullPointerException("param");
        }
        if (this.list_.removeElement(hTMLParameter)) {
            this.fireElementEvent(2);
        }
    }

    public void removeElementListener(ElementListener elementListener) {
        if (elementListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.elementListeners != null) {
            this.elementListeners.removeElement(elementListener);
        }
    }

    public void setLocation(String string) {
        if (string == null) {
            throw new NullPointerException("location");
        }
        if (string.length() == 0) {
            throw new ExtendedIllegalArgumentException("location", 1);
        }
        String string2 = this.location_;
        this.location_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("location", string2, string);
        }
    }

    public void setName(String string) {
        if (string == null) {
            throw new NullPointerException("name");
        }
        if (string.length() == 0) {
            throw new ExtendedIllegalArgumentException("name", 1);
        }
        String string2 = this.name_;
        this.name_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("name", string2, string);
        }
    }

    public void setText(String string) {
        if (string == null) {
            throw new NullPointerException("text");
        }
        if (string.length() == 0) {
            throw new ExtendedIllegalArgumentException("text", 1);
        }
        String string2 = this.text_;
        this.text_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("text", string2, string);
        }
    }

    public String toString() {
        return this.getTag();
    }
}

