/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.html.HTMLTagElement;
import com.ibm.as400.util.html.LayoutFormPanel;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;

public class GridLayoutFormPanel
extends LayoutFormPanel {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private int columns_;
    private String lang_;
    private String dir_;
    private String[] columnDir_;
    private String[] columnAlign_;
    private String align_;

    public GridLayoutFormPanel() {
        this.columns_ = 1;
        this.columnDir_ = new String[this.columns_];
        this.columnAlign_ = new String[this.columns_];
    }

    public GridLayoutFormPanel(int n) {
        try {
            this.setColumns(n);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.changes_ == null) {
            this.changes_ = new PropertyChangeSupport(this);
        }
        this.changes_.addPropertyChangeListener(propertyChangeListener);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ == null) {
            this.vetos_ = new VetoableChangeSupport(this);
        }
        this.vetos_.addVetoableChangeListener(vetoableChangeListener);
    }

    public String getAlignment() {
        return this.align_;
    }

    String getAlignmentAttributeTag() {
        if (this.align_ != null && this.align_.length() > 0) {
            return " align=\"" + this.align_ + "\"";
        }
        return "";
    }

    String getCellAlignmentAttributeTag(int n) {
        if (this.columnAlign_[n] != null && this.columnAlign_[n].length() > 0) {
            return " align=\"" + this.columnAlign_[n] + "\"";
        }
        return "";
    }

    String getCellDirectionAttributeTag(int n) {
        if (this.columnDir_[n] != null && this.columnDir_[n].length() > 0) {
            return " dir=\"" + this.columnDir_[n] + "\"";
        }
        return "";
    }

    public String getColumnAlignment(int n) {
        if (n < 0 || n >= this.columns_) {
            throw new ExtendedIllegalArgumentException("column", 4);
        }
        return this.columnAlign_[n];
    }

    public String getColumnDirection(int n) {
        if (n < 0 || n >= this.columns_) {
            throw new ExtendedIllegalArgumentException("column", 4);
        }
        return this.columnDir_[n];
    }

    public int getColumns() {
        return this.columns_;
    }

    public String getDirection() {
        return this.dir_;
    }

    String getDirectionAttributeTag() {
        if (this.dir_ != null && this.dir_.length() > 0) {
            return " dir=\"" + this.dir_ + "\"";
        }
        return "";
    }

    public String getLanguage() {
        return this.lang_;
    }

    String getLanguageAttributeTag() {
        if (this.lang_ != null && this.lang_.length() > 0) {
            return " lang=\"" + this.lang_ + "\"";
        }
        return "";
    }

    public String getFOTag() {
        Trace.log(2, "Attempting to getFOTag() for an object that doesn't support it.");
        return "<!-- A GridLayoutFormPanel was here -->";
    }

    public String getTag() {
        StringBuffer stringBuffer = new StringBuffer("<table border=\"0\"");
        stringBuffer.append(this.getLanguageAttributeTag());
        stringBuffer.append(this.getDirectionAttributeTag());
        stringBuffer.append(">\n");
        int n = 0;
        for (int i = 0; i < this.getSize(); ++i) {
            if (n == 0) {
                stringBuffer.append("<tr>\n");
            }
            HTMLTagElement hTMLTagElement = this.getElement(i);
            stringBuffer.append("<td");
            stringBuffer.append(this.getCellDirectionAttributeTag(n));
            stringBuffer.append(this.getCellAlignmentAttributeTag(n));
            stringBuffer.append(">");
            stringBuffer.append(hTMLTagElement.getTag());
            stringBuffer.append("</td>\n");
            if (++n < this.columns_) continue;
            stringBuffer.append("</tr>\n");
            n = 0;
        }
        if (n != 0) {
            stringBuffer.append("</tr>\n");
        }
        stringBuffer.append("</table>\n");
        return stringBuffer.toString();
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.changes_ != null) {
            this.changes_.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ != null) {
            this.vetos_.removeVetoableChangeListener(vetoableChangeListener);
        }
    }

    public void setAlignment(String string) {
        if (string == null) {
            throw new NullPointerException("align");
        }
        if (!(string.equals("left") || string.equals("right") || string.equals("center"))) {
            throw new ExtendedIllegalArgumentException("align", 2);
        }
        this.align_ = string;
    }

    public void setColumnAlignment(int n, String string) {
        if (string == null) {
            throw new NullPointerException("align");
        }
        if (n < 0 || n >= this.columns_) {
            throw new ExtendedIllegalArgumentException("column", 4);
        }
        if (!(string.equals("left") || string.equals("right") || string.equals("center"))) {
            throw new ExtendedIllegalArgumentException("align", 2);
        }
        this.columnAlign_[n] = string;
    }

    public void setColumnDirection(int n, String string) {
        if (string == null) {
            throw new NullPointerException("dir");
        }
        if (n < 0 || n >= this.columns_) {
            throw new ExtendedIllegalArgumentException("column", 4);
        }
        if (!string.equals("ltr") && !string.equals("rtl")) {
            throw new ExtendedIllegalArgumentException("dir", 2);
        }
        this.columnDir_[n] = string;
    }

    public void setColumns(int n) throws PropertyVetoException {
        if (n < 0) {
            throw new ExtendedIllegalArgumentException("columns", 4);
        }
        int n2 = this.columns_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("columns", new Integer(n2), new Integer(n));
        }
        this.columns_ = n;
        this.columnDir_ = new String[this.columns_];
        this.columnAlign_ = new String[this.columns_];
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("columns", new Integer(n2), new Integer(n));
        }
    }

    public void setDirection(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("dir");
        }
        if (!string.equals("ltr") && !string.equals("rtl")) {
            throw new ExtendedIllegalArgumentException("dir", 2);
        }
        String string2 = this.dir_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("dir", string2, string);
        }
        this.dir_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("dir", string2, string);
        }
    }

    public void setLanguage(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("lang");
        }
        String string2 = this.lang_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("lang", string2, string);
        }
        this.lang_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("lang", string2, string);
        }
    }
}

