/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.html.HTMLTagAttributes;
import com.ibm.as400.util.html.URLEncoder;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public abstract class FormInput
extends HTMLTagAttributes
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 8967841585682519631L;
    private String name_;
    private String value_;
    private int size_ = 0;
    private String lang_;
    private String dir_;
    transient VetoableChangeSupport vetos_;

    public FormInput() {
    }

    public FormInput(String string) {
        this();
        try {
            this.setName(string);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public FormInput(String string, String string2) {
        this(string);
        try {
            this.setValue(string2);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ == null) {
            this.vetos_ = new VetoableChangeSupport(this);
        }
        this.vetos_.addVetoableChangeListener(vetoableChangeListener);
    }

    public String getDirection() {
        return this.dir_;
    }

    public String getLanguage() {
        return this.lang_;
    }

    public String getName() {
        return this.name_;
    }

    public String getValue() {
        return this.value_;
    }

    public int getSize() {
        return this.size_;
    }

    String getDirectionAttributeTag() {
        if (this.dir_ != null && this.dir_.length() > 0) {
            StringBuffer stringBuffer = new StringBuffer(" dir=\"");
            stringBuffer.append(this.dir_);
            stringBuffer.append("\"");
            return stringBuffer.toString();
        }
        return "";
    }

    String getLanguageAttributeTag() {
        if (this.lang_ != null && this.lang_.length() > 0) {
            StringBuffer stringBuffer = new StringBuffer(" lang=\"");
            stringBuffer.append(this.lang_);
            stringBuffer.append("\"");
            return stringBuffer.toString();
        }
        return "";
    }

    String getNameAttributeTag() {
        if (this.name_ != null && this.name_.length() > 0) {
            StringBuffer stringBuffer = new StringBuffer(" name=\"");
            stringBuffer.append(this.name_);
            stringBuffer.append("\"");
            return stringBuffer.toString();
        }
        return "";
    }

    String getSizeAttributeTag() {
        if (this.size_ > 0) {
            StringBuffer stringBuffer = new StringBuffer(" size=\"");
            stringBuffer.append(this.size_);
            stringBuffer.append("\"");
            return stringBuffer.toString();
        }
        return "";
    }

    String getValueAttributeTag(boolean bl) {
        if (this.value_ != null) {
            if (Trace.isTraceOn()) {
                Trace.log(1, "   URL value needs Encoding: " + bl);
            }
            if (bl) {
                this.value_ = URLEncoder.encode(this.value_);
            }
            StringBuffer stringBuffer = new StringBuffer(" value=\"");
            stringBuffer.append(this.value_);
            stringBuffer.append("\"");
            return stringBuffer.toString();
        }
        return "";
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ != null) {
            this.vetos_.removeVetoableChangeListener(vetoableChangeListener);
        }
    }

    public void setDirection(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("dir");
        }
        if (!string.equals("ltr") && !string.equals("rtl")) {
            throw new ExtendedIllegalArgumentException("dir", 2);
        }
        String string2 = this.dir_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("dir", string2, string);
        }
        this.dir_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("dir", string2, string);
        }
    }

    public void setLanguage(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("lang");
        }
        String string2 = this.lang_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("lang", string2, string);
        }
        this.lang_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("lang", string2, string);
        }
    }

    public void setName(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("name");
        }
        String string2 = this.name_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("name", string2, string);
        }
        this.name_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("name", string2, string);
        }
    }

    public void setSize(int n) throws PropertyVetoException {
        if (n < 0) {
            throw new ExtendedIllegalArgumentException("size", 4);
        }
        int n2 = this.size_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("size", new Integer(n2), new Integer(n));
        }
        this.size_ = n;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("size", new Integer(n2), new Integer(n));
        }
    }

    public void setValue(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("value");
        }
        String string2 = this.value_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("value", string2, string);
        }
        this.value_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("value", string2, string);
        }
    }

    public String toString() {
        return this.getTag();
    }
}

