/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.IFSJavaFile;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.html.FileListRenderer;
import com.ibm.as400.util.html.HTMLTable;
import com.ibm.as400.util.servlet.HTMLTableConverter;
import com.ibm.as400.util.servlet.ListRowData;
import com.ibm.as400.util.servlet.RowDataException;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.Collator;
import javax.servlet.http.HttpServletRequest;

public class FileListElement
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";
    static final long serialVersionUID = 6247154241289547698L;
    private AS400 system_;
    private HTMLTable table_;
    private HttpServletRequest request_;
    private FileListRenderer renderer_;
    private StringBuffer sharePath_;
    private StringBuffer shareName_;
    private String parameterPathInfo_;
    private boolean sort_ = true;
    private transient Collator collator_ = null;
    private transient PropertyChangeSupport changes_;
    private int patternMatching_ = -1;

    public FileListElement() {
        try {
            this.collator_ = Collator.getInstance();
            this.collator_.setStrength(0);
        }
        catch (Exception exception) {
            this.collator_ = null;
        }
        this.renderer_ = null;
        this.system_ = null;
        this.request_ = null;
        this.shareName_ = null;
        this.sharePath_ = null;
    }

    public FileListElement(HttpServletRequest httpServletRequest) {
        this();
        this.setHttpServletRequest(httpServletRequest);
        this.setRenderer(new FileListRenderer(httpServletRequest));
    }

    public FileListElement(AS400 aS400, HttpServletRequest httpServletRequest) {
        this();
        this.setSystem(aS400);
        this.setHttpServletRequest(httpServletRequest);
        this.setRenderer(new FileListRenderer(httpServletRequest));
    }

    public FileListElement(AS400 aS400, HttpServletRequest httpServletRequest, String string) {
        this();
        this.setSystem(aS400);
        this.setHttpServletRequest(httpServletRequest);
        this.setRenderer(new FileListRenderer(httpServletRequest));
        this.parameterPathInfo_ = string;
    }

    public FileListElement(AS400 aS400, HttpServletRequest httpServletRequest, HTMLTable hTMLTable) {
        this();
        this.setSystem(aS400);
        this.setHttpServletRequest(httpServletRequest);
        this.setTable(hTMLTable);
        this.setRenderer(new FileListRenderer(httpServletRequest));
    }

    public FileListElement(AS400 aS400, HttpServletRequest httpServletRequest, String string, String string2) {
        this();
        this.setSystem(aS400);
        this.setHttpServletRequest(httpServletRequest);
        this.setRenderer(new FileListRenderer(httpServletRequest, string, string2));
        this.setShareName(string);
        this.setSharePath(string2);
    }

    public FileListElement(AS400 aS400, HttpServletRequest httpServletRequest, String string, String string2, String string3) {
        this();
        this.setSystem(aS400);
        this.setHttpServletRequest(httpServletRequest);
        this.setRenderer(new FileListRenderer(httpServletRequest, string, string2));
        this.setShareName(string);
        this.setSharePath(string2);
        this.parameterPathInfo_ = string3;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.changes_ == null) {
            this.changes_ = new PropertyChangeSupport(this);
        }
        this.changes_.addPropertyChangeListener(propertyChangeListener);
    }

    public Collator getCollator() {
        return this.collator_;
    }

    public HttpServletRequest getHttpServletRequest() {
        return this.request_;
    }

    public FileListRenderer getRenderer() {
        return this.renderer_;
    }

    public String getSharePath() {
        if (this.sharePath_ == null) {
            return null;
        }
        return this.sharePath_.toString();
    }

    public String getShareName() {
        if (this.shareName_ == null) {
            return null;
        }
        return this.shareName_.toString();
    }

    public AS400 getSystem() {
        return this.system_;
    }

    public HTMLTable getTable() {
        return this.table_;
    }

    public String list() {
        return this.list(new HTMLTableConverter());
    }

    public String list(HTMLTableConverter hTMLTableConverter) {
        block23: {
            if (hTMLTableConverter == null) {
                throw new NullPointerException("conv");
            }
            if (this.request_ == null) {
                throw new ExtendedIllegalStateException("request", 4);
            }
            String string = null;
            string = this.parameterPathInfo_ == null ? this.request_.getPathInfo() : this.parameterPathInfo_;
            if (string == null) {
                string = "/";
            }
            if (this.sharePath_ != null) {
                try {
                    string = this.sharePath_.append(string.substring(string.indexOf(47, 1), string.length())).toString();
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    string = this.sharePath_.insert(0, "/").toString();
                }
            }
            try {
                ListRowData listRowData;
                File file = null;
                if (this.system_ != null) {
                    file = new IFSJavaFile(this.system_, string.replace('\\', '/'));
                    if (this.patternMatching_ != -1) {
                        try {
                            ((IFSJavaFile)file).setPatternMatching(this.patternMatching_);
                        }
                        catch (IOException iOException) {
                            if (Trace.isTraceOn()) {
                                Trace.log(2, iOException);
                            }
                        }
                    }
                } else {
                    file = new File(string);
                }
                if (Trace.isTraceOn()) {
                    Trace.log(3, "FileListElement path: " + string);
                }
                if (this.table_ == null) {
                    this.table_ = new HTMLTable();
                    this.table_.setCellPadding(7);
                    hTMLTableConverter.setUseMetaData(true);
                } else if (this.table_.getHeader() == null) {
                    hTMLTableConverter.setUseMetaData(true);
                }
                hTMLTableConverter.setTable(this.table_);
                if (this.renderer_ == null) {
                    this.renderer_ = new FileListRenderer(this.request_);
                }
                if ((listRowData = this.renderer_.getRowData(file, this.sort_, this.collator_)).length() > 0) {
                    HTMLTable[] hTMLTableArray = hTMLTableConverter.convertToTables(listRowData);
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i = 0; i < hTMLTableArray.length; ++i) {
                        stringBuffer.append(hTMLTableArray[i].getTag());
                    }
                    return stringBuffer.toString();
                }
            }
            catch (PropertyVetoException propertyVetoException) {
            }
            catch (RowDataException rowDataException) {
                if (!Trace.isTraceOn()) break block23;
                Trace.log(2, rowDataException);
            }
        }
        return "";
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        try {
            this.collator_ = Collator.getInstance();
            this.collator_.setStrength(0);
        }
        catch (Exception exception) {
            this.collator_ = null;
        }
        objectInputStream.defaultReadObject();
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.changes_ != null) {
            this.changes_.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public void setCollator(Collator collator) {
        if (collator == null) {
            throw new NullPointerException("collator");
        }
        Collator collator2 = this.collator_;
        this.collator_ = collator;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("collator", collator2, this.collator_);
        }
    }

    public void setHttpServletRequest(HttpServletRequest httpServletRequest) {
        if (httpServletRequest == null) {
            throw new NullPointerException("request");
        }
        HttpServletRequest httpServletRequest2 = this.request_;
        this.request_ = httpServletRequest;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("request", httpServletRequest2, this.request_);
        }
    }

    public void setRenderer(FileListRenderer fileListRenderer) {
        if (fileListRenderer == null) {
            throw new NullPointerException("renderer");
        }
        FileListRenderer fileListRenderer2 = this.renderer_;
        this.renderer_ = fileListRenderer;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("renderer", fileListRenderer2, this.renderer_);
        }
    }

    public void setSharePath(String string) {
        if (string == null) {
            throw new NullPointerException("sharePath");
        }
        StringBuffer stringBuffer = this.sharePath_;
        this.sharePath_ = new StringBuffer(string);
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("sharePath", stringBuffer == null ? null : stringBuffer.toString(), this.sharePath_.toString());
        }
    }

    public void setShareName(String string) {
        if (string == null) {
            throw new NullPointerException("shareName");
        }
        StringBuffer stringBuffer = this.shareName_;
        this.shareName_ = new StringBuffer(string);
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("shareName", stringBuffer == null ? null : stringBuffer.toString(), this.shareName_.toString());
        }
    }

    public void setSystem(AS400 aS400) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        AS400 aS4002 = this.system_;
        this.system_ = aS400;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("system", aS4002, this.system_);
        }
    }

    public void setTable(HTMLTable hTMLTable) {
        if (hTMLTable == null) {
            throw new NullPointerException("table");
        }
        HTMLTable hTMLTable2 = hTMLTable;
        this.table_ = hTMLTable;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("table", hTMLTable2, this.table_);
        }
    }

    public void sort(boolean bl) {
        this.sort_ = bl;
    }

    public void setPatternMatching(int n) {
        if (n < 0 || n > 2) {
            throw new ExtendedIllegalArgumentException("patternMatching", 2);
        }
        this.patternMatching_ = n;
    }
}

