/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.util;

import com.ibm.as400.ui.framework.java.MessageLog;
import com.ibm.as400.ui.util.ClCommonLayout;
import com.ibm.as400.ui.util.ClSyntax;
import java.awt.Toolkit;
import java.util.Locale;
import javax.swing.JComboBox;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import javax.swing.text.Segment;

class ClTextFieldLimit
extends PlainDocument {
    private int m_limit;
    private JComboBox m_comboBox;
    private boolean m_allowVariables = false;
    private ClCommonLayout m_commonLayout;

    ClTextFieldLimit(int n) {
        this.m_limit = n;
        this.m_comboBox = null;
        this.m_commonLayout = null;
    }

    ClTextFieldLimit(int n, boolean bl, ClCommonLayout clCommonLayout) {
        this(n);
        this.m_allowVariables = bl;
        this.m_commonLayout = clCommonLayout;
    }

    ClTextFieldLimit(int n, JComboBox jComboBox, boolean bl, ClCommonLayout clCommonLayout) {
        this(n, jComboBox, clCommonLayout);
        this.m_allowVariables = bl;
    }

    ClTextFieldLimit(int n, JComboBox jComboBox, ClCommonLayout clCommonLayout) {
        this.m_limit = n;
        this.m_comboBox = jComboBox;
        this.m_commonLayout = clCommonLayout;
        AbstractDocument abstractDocument = (AbstractDocument)((JTextComponent)this.m_comboBox.getEditor().getEditorComponent()).getDocument();
        this.setDocumentProperties(abstractDocument.getDocumentProperties());
        try {
            this.insertString(0, abstractDocument.getText(0, abstractDocument.getLength()), null);
        }
        catch (BadLocationException badLocationException) {
            MessageLog.logError((Object)"CP: Bad location exception caught");
        }
    }

    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        int n2;
        if (string == null) {
            return;
        }
        Segment segment = new Segment();
        this.getText(0, this.getLength(), segment);
        String string2 = segment.toString();
        string2 = string2.substring(0, n) + string + string2.substring(n, string2.length());
        string2 = string2.toUpperCase(Locale.ENGLISH);
        if (this.m_commonLayout.getType() == 2) {
            super.insertString(n, string, attributeSet);
            return;
        }
        if (string2 != null && this.m_allowVariables && string2.length() > 1 && (string2.charAt(0) == '$' || string2.charAt(0) == '&')) {
            super.insertString(n, string, attributeSet);
            return;
        }
        if (string2.length() > 1 && string2.charAt(0) == 'X' && string2.charAt(1) == '\'') {
            int n3 = 2;
            if (this.m_commonLayout.getType() == 12) {
                n3 = 1;
            }
            if (string2.length() <= this.m_limit * n3 + 3) {
                super.insertString(n, string, attributeSet);
                return;
            }
            return;
        }
        if (this.m_comboBox != null) {
            int n4 = this.m_comboBox.getItemCount();
            String string3 = null;
            Object var8_11 = null;
            n2 = 0;
            while (n2 < n4) {
                var8_11 = this.m_comboBox.getItemAt(n2);
                if (var8_11 instanceof String) {
                    string3 = var8_11;
                    string3 = string3.toUpperCase(Locale.ENGLISH);
                    if (string2.length() <= string3.length() && string2.equals(string3.substring(0, string2.length()))) {
                        super.insertString(n, string, attributeSet);
                        return;
                    }
                }
                ++n2;
            }
        }
        String string4 = string2;
        int n5 = 0;
        if (string4.equals(string2 = ClSyntax.stripQuotes(string2, false)) && string2.length() > 0 && string2.charAt(0) == '\'') {
            ++n5;
        }
        int n6 = string2.length() - 1;
        n2 = 0;
        while (n2 < n6) {
            if (string2.charAt(n2) == '\'' && string2.charAt(n2 + 1) == '\'') {
                ++n5;
                ++n2;
            }
            ++n2;
        }
        if (this.m_commonLayout != null && this.m_commonLayout.getType() == 1) {
            int n7;
            if (string2.length() > 1 && (string2.charAt(0) == '+' || string2.charAt(0) == '-')) {
                string2 = string2.substring(1, string2.length());
            }
            if ((n7 = string2.indexOf(46)) == -1) {
                n7 = string2.indexOf(44);
            }
            int n8 = 0;
            int n9 = 0;
            if (n7 != -1) {
                String string5;
                if (string2.indexOf(46, n7 + 1) != -1 && string.equals(".")) {
                    return;
                }
                if (string2.indexOf(44, n7 + 1) != -1 && string.equals(",")) {
                    return;
                }
                if (n7 + 1 < string2.length()) {
                    string5 = string2.substring(n7 + 1, string2.length());
                    n8 = string5.length();
                }
                string5 = string2.substring(0, n7);
                n9 = string5.length();
            } else {
                n9 = string2.length();
            }
            if (n9 <= this.m_commonLayout.getLen1() && n8 <= this.m_commonLayout.getLen2()) {
                super.insertString(n, string, attributeSet);
                return;
            }
        } else {
            if (string2.length() - n5 <= this.m_limit) {
                super.insertString(n, string, attributeSet);
                return;
            }
            if (this.getLength() < this.m_limit) {
                String string6 = string.substring(0, this.m_limit - this.getLength());
                super.insertString(n, string6, attributeSet);
            }
        }
        Toolkit.getDefaultToolkit().beep();
    }

    int getLimit() {
        return this.m_limit;
    }

    void setLimit(int n) {
        this.m_limit = n;
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 1999";
    }
}

