/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.util;

import com.ibm.as400.ui.framework.java.MessageLog;
import com.ibm.as400.ui.util.ClAttributeList;
import com.ibm.as400.ui.util.ClButtonGroup;
import com.ibm.as400.ui.util.ClComboBox;
import com.ibm.as400.ui.util.ClCommonLayout;
import com.ibm.as400.ui.util.ClElem;
import com.ibm.as400.ui.util.ClPanel;
import com.ibm.as400.ui.util.ClParseException;
import com.ibm.as400.ui.util.ClSyntax;
import com.ibm.as400.ui.util.ClTextArea;
import com.ibm.as400.ui.util.ClTextFieldLimit;
import com.ibm.as400.ui.util.ClValues;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

class ClQual
extends ClCommonLayout {
    ClQual() {
    }

    ClQual(ClAttributeList clAttributeList) {
        super(clAttributeList);
        this.setNodeType(4);
    }

    void layoutPanel(ClPanel clPanel) throws ClParseException {
        this.layoutPanel(clPanel, 0);
    }

    void layoutPanel(ClPanel clPanel, int n) throws ClParseException {
        this.m_guiControls.removeAllElements();
        GridBagConstraints gridBagConstraints = ClPanel.createGridBagConstraints();
        int n2 = 21;
        if (this.getParent() instanceof ClElem) {
            n2 = 42;
        }
        gridBagConstraints.insets = new Insets(3, n2, 0, 7);
        JLabel jLabel = null;
        jLabel = this.getPrompt() != null ? new JLabel(this.getPrompt() + ":") : new JLabel(" ");
        jLabel.setFont(ClPanel.m_scaledFont);
        clPanel.add((Component)jLabel, gridBagConstraints);
        this.m_labels.addElement(jLabel);
        this.addKwdName(clPanel, " ", false);
        this.displayField(clPanel, n);
    }

    void layoutPanel(ClPanel clPanel, ClValues clValues, String string) throws ClParseException {
        this.layoutPanel(clPanel, clValues, string, 0);
    }

    void layoutPanel(ClPanel clPanel, ClValues clValues, String string, int n) throws ClParseException {
        this.m_guiControls.removeAllElements();
        if (clValues != null) {
            ClComboBox clComboBox = new ClComboBox(clValues.getStrings());
            clComboBox.getEditor().getEditorComponent().setFont(ClPanel.m_scaledFont);
            clComboBox.setFont(ClPanel.m_scaledFont);
            clComboBox.setEditable(true);
            if (this.getLen1() > 0) {
                Component component = clComboBox.getEditor().getEditorComponent();
                int n2 = this.getLen1();
                if (this.getType() == 12) {
                    n2 *= 2;
                }
                ((JTextField)component).setDocument(new ClTextFieldLimit(n2, clComboBox, this.getAlwVar(), this));
            }
            if (string == null) {
                string = this.getDft();
            }
            ClPanel.setComboText(clComboBox, string);
            this.setDft(string);
            clComboBox.getEditor().getEditorComponent().addFocusListener(this.m_focus);
            this.m_guiControls.addElement(clComboBox);
            this.addListenersToControl(clComboBox);
            int n3 = ClPanel.getColumns(this.getLen1());
            Dimension dimension = clComboBox.getPreferredSize();
            dimension.width = 120;
            clComboBox.setPreferredSize(dimension);
            this.addComboBox(clPanel, clComboBox, n, false);
        } else {
            GridBagConstraints gridBagConstraints = ClPanel.createGridBagConstraints();
            gridBagConstraints.insets = new Insets(7, 7, 0, 7);
            JLabel jLabel = null;
            if (n == 0) {
                n = ClPanel.getGridWidth(ClPanel.getColumns(this.getLen1()));
                jLabel = new JLabel(this.getChoice());
                jLabel.setFont(ClPanel.m_scaledFont);
            }
            gridBagConstraints.gridwidth = n;
            JComponent jComponent = this.createTextField();
            Dimension dimension = jComponent.getPreferredSize();
            dimension.width -= 7;
            jComponent.setPreferredSize(dimension);
            clPanel.add((Component)jComponent, gridBagConstraints);
            this.m_guiControls.addElement(jComponent);
            this.addListenersToControl(jComponent);
            if (string == null) {
                string = this.getDft();
            }
            this.setText(string);
            this.setDft(string);
            if (jLabel != null) {
                gridBagConstraints.insets = new Insets(7 + 3, 7, 0, 0);
                gridBagConstraints.gridwidth = 0;
                clPanel.add((Component)jLabel, gridBagConstraints);
                this.m_labels.addElement(jLabel);
            }
        }
    }

    String getText() {
        return this.getText(true);
    }

    String getText(boolean bl) {
        String string = "";
        if (this.m_guiControls.size() == 1) {
            Object e = this.m_guiControls.firstElement();
            if (e instanceof JTextComponent) {
                string = ((JTextComponent)e).getText();
            } else if (e instanceof ClTextArea) {
                string = ((ClTextArea)e).getTextComponent().getText();
            } else if (e instanceof ButtonGroup) {
                ButtonModel buttonModel = ((ButtonGroup)e).getSelection();
                if (buttonModel != null) {
                    string = buttonModel.getActionCommand();
                }
            } else if (e instanceof JComboBox) {
                string = ClPanel.getComboText((JComboBox)e);
                string = ClSyntax.getChoicePgmValue(string, this.getChoicePgmValues());
            }
            if (e instanceof ClButtonGroup) {
                if (!((ClButtonGroup)e).isEnabled() && bl) {
                    string = this.getDft();
                }
            } else if (!((JComponent)e).isEnabled() && bl) {
                string = this.getDft();
            }
        } else {
            MessageLog.logError((Object)("CP: Bad object number in ClQual " + this.m_guiControls.size()));
        }
        string = ClSyntax.quote(this.getType(), string);
        string = ClSyntax.upperCase(this.getType(), string);
        return string;
    }

    void setText(String string) {
        if (this.m_guiControls.size() == 1) {
            Object e = this.m_guiControls.firstElement();
            if (e instanceof JTextComponent) {
                ((JTextComponent)e).setText(string);
            } else if (e instanceof ClTextArea) {
                ((ClTextArea)e).getTextComponent().setText(string);
            } else if (e instanceof JComboBox) {
                ClPanel.setComboText((JComboBox)e, string);
            }
        } else {
            MessageLog.logError((Object)("CP: Bad object number in ClQual " + this.m_guiControls.size()));
        }
    }

    void blankControls() {
        if (this.m_guiControls.size() == 1) {
            Object e = this.m_guiControls.firstElement();
            if (e instanceof JTextComponent) {
                ((JTextComponent)e).setText("");
            } else if (e instanceof ClTextArea) {
                ((ClTextArea)e).getTextComponent().setText("");
            } else if (e instanceof JComboBox) {
                ClPanel.setComboText((JComboBox)e, "");
            } else if (e instanceof ClButtonGroup) {
                String string = this.getDft();
                Enumeration<AbstractButton> enumeration = ((ButtonGroup)e).getElements();
                while (enumeration.hasMoreElements()) {
                    JRadioButton jRadioButton = (JRadioButton)enumeration.nextElement();
                    if (!jRadioButton.getActionCommand().equals(string)) continue;
                    ((ButtonGroup)e).setSelected(jRadioButton.getModel(), true);
                    jRadioButton.setSelected(true);
                    return;
                }
                if (string == null) {
                    ((ClButtonGroup)e).deselectButtons();
                }
            }
        } else {
            MessageLog.logError((Object)("CP: Bad object number in ClQual " + this.m_guiControls.size()));
        }
    }

    void setEnabled(boolean bl) {
        if (this.m_guiControls.size() == 1) {
            Object e = this.m_guiControls.firstElement();
            if (e instanceof ClTextArea) {
                ClPanel.setEnabled(((ClTextArea)e).getTextComponent(), bl);
            } else if (e instanceof ButtonGroup) {
                Enumeration<AbstractButton> enumeration = ((ButtonGroup)e).getElements();
                ((ClButtonGroup)e).setEnabled(bl);
                JRadioButton jRadioButton = null;
                while (enumeration.hasMoreElements()) {
                    jRadioButton = (JRadioButton)enumeration.nextElement();
                    jRadioButton.setEnabled(bl);
                }
            } else {
                ClPanel.setEnabled((Component)e, bl);
            }
        }
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 1999";
    }
}

