/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.util;

import com.ibm.as400.ui.util.ClCommonLayout;
import com.ibm.as400.ui.util.ClList;
import com.ibm.as400.ui.util.ClListKeyListener;
import com.ibm.as400.ui.util.ClNode;
import com.ibm.as400.ui.util.ClPanel;
import com.ibm.as400.ui.util.ClPanelFocusListener;
import com.ibm.as400.ui.util.ClParm;
import com.ibm.as400.ui.util.ClParmListPanel;
import com.ibm.as400.ui.util.ClParseException;
import com.ibm.as400.ui.util.ClSyntax;
import com.ibm.as400.ui.util.ClTextArea;
import com.ibm.as400.ui.util.ClValues;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;

class ClParmListPanel
extends ClPanel
implements ActionListener,
ItemListener,
ListSelectionListener,
DocumentListener {
    private JButton m_add;
    private JButton m_remove;
    private JButton m_moveup;
    private JButton m_movedown;
    private ClList m_list;
    private Vector m_listData;
    private Vector m_sngValues;
    private ClValues m_choicePgmValues;
    private JComponent m_entryField;
    private JScrollPane m_scrollList;
    private int m_max;
    private boolean m_bVisible;
    private ClCommonLayout m_parent;
    private boolean m_bRestricted;

    ClParmListPanel(JComponent jComponent, int n, ClCommonLayout clCommonLayout) throws ClParseException {
        this(jComponent, n, null, null, clCommonLayout);
    }

    ClParmListPanel(JComponent jComponent, int n, ClValues clValues, ClValues clValues2, ClCommonLayout clCommonLayout) throws ClParseException {
        Object object;
        this.setLayout(new GridBagLayout());
        this.m_max = n;
        this.m_entryField = jComponent;
        this.m_bVisible = true;
        this.m_listData = new Vector();
        this.m_parent = clCommonLayout;
        this.m_bRestricted = clCommonLayout.getRstd();
        Dimension dimension = this.m_entryField.getPreferredSize();
        dimension.width = 120;
        if (this.m_entryField instanceof JComboBox || this.m_entryField instanceof JTextComponent) {
            this.m_entryField.setPreferredSize(dimension);
        } else {
            object = this.m_entryField.getPreferredSize();
            ((Dimension)object).width = dimension.width;
            this.m_entryField.setPreferredSize((Dimension)object);
        }
        if (clValues != null || this.m_bRestricted) {
            this.m_sngValues = clValues != null ? clValues.getStrings() : null;
            ((JComboBox)this.m_entryField).addItemListener(this);
            ((JTextComponent)((JComboBox)this.m_entryField).getEditor().getEditorComponent()).getDocument().addDocumentListener(this);
        } else {
            this.m_sngValues = null;
            if (this.m_entryField instanceof JTextComponent) {
                ((JTextField)this.m_entryField).getDocument().addDocumentListener(this);
            } else if (this.m_entryField instanceof ClTextArea) {
                ((ClTextArea)this.m_entryField).getTextComponent().getDocument().addDocumentListener(this);
            } else if (this.m_entryField instanceof JComboBox) {
                ((JTextComponent)((JComboBox)this.m_entryField).getEditor().getEditorComponent()).getDocument().addDocumentListener(this);
            }
        }
        this.m_list = new ClList(this.m_listData);
        this.m_list.setVisibleRowCount(4);
        this.m_list.setFixedCellWidth(this.m_entryField.getPreferredSize().width);
        object = new ClPanelFocusListener();
        this.m_scrollList = new JScrollPane();
        this.m_scrollList.getViewport().add(this.m_list);
        this.m_list.addFocusListener((FocusListener)object);
        if (ClPanel.m_addString == null) {
            ClPanel.m_addString = ClPanel.loadString("IDS_LIST_ADD");
        }
        if (ClPanel.m_removeString == null) {
            ClPanel.m_removeString = ClPanel.loadString("IDS_LIST_REMOVE");
        }
        if (ClPanel.m_moveupString == null) {
            ClPanel.m_moveupString = ClPanel.loadString("IDS_LIST_MOVEUP");
        }
        if (ClPanel.m_movedownString == null) {
            ClPanel.m_movedownString = ClPanel.loadString("IDS_LIST_MOVEDOWN");
        }
        this.m_add = new JButton(ClPanel.m_addString);
        this.m_remove = new JButton(ClPanel.m_removeString);
        this.m_moveup = new JButton(ClPanel.m_moveupString);
        this.m_movedown = new JButton(ClPanel.m_movedownString);
        this.m_add.setFont(ClPanel.m_scaledFont);
        this.m_remove.setFont(ClPanel.m_scaledFont);
        this.m_moveup.setFont(ClPanel.m_scaledFont);
        this.m_movedown.setFont(ClPanel.m_scaledFont);
        ClListKeyListener clListKeyListener = new ClListKeyListener(this);
        this.m_list.addKeyListener(clListKeyListener);
        this.m_list.addListSelectionListener(this);
        if (this.m_entryField instanceof JTextComponent) {
            ((JTextComponent)this.m_entryField).addKeyListener(clListKeyListener);
        } else if (this.m_entryField instanceof ClTextArea) {
            ((ClTextArea)this.m_entryField).getTextComponent().addKeyListener(clListKeyListener);
        } else if (this.m_entryField instanceof JComboBox) {
            ((JTextComponent)((JComboBox)this.m_entryField).getEditor().getEditorComponent()).addKeyListener(clListKeyListener);
        }
        this.m_add.setActionCommand("Add");
        this.m_remove.setActionCommand("Remove");
        this.m_moveup.setActionCommand("MoveUp");
        this.m_movedown.setActionCommand("MoveDown");
        this.m_add.addFocusListener((FocusListener)object);
        this.m_remove.addFocusListener((FocusListener)object);
        this.m_moveup.addFocusListener((FocusListener)object);
        this.m_movedown.addFocusListener((FocusListener)object);
        Dimension dimension2 = this.m_add.getPreferredSize();
        Dimension dimension3 = this.m_remove.getPreferredSize();
        Dimension dimension4 = this.m_moveup.getPreferredSize();
        Dimension dimension5 = this.m_movedown.getPreferredSize();
        if (dimension3.width > dimension2.width) {
            dimension2.width = dimension3.width;
        }
        if (dimension5.width > dimension4.width) {
            dimension4.width = dimension5.width;
        }
        if (dimension4.width > dimension2.width) {
            dimension2.width = dimension4.width;
        }
        if (dimension3.height > dimension2.height) {
            dimension2.height = dimension3.height;
        }
        if (dimension5.height > dimension4.height) {
            dimension4.height = dimension5.height;
        }
        if (dimension4.height > dimension2.height) {
            dimension2.height = dimension4.height;
        }
        this.m_add.setPreferredSize(dimension2);
        this.m_remove.setPreferredSize(dimension2);
        this.m_moveup.setPreferredSize(dimension2);
        this.m_movedown.setPreferredSize(dimension2);
        this.m_add.addActionListener(this);
        this.m_remove.addActionListener(this);
        this.m_moveup.addActionListener(this);
        this.m_movedown.addActionListener(this);
        GridBagConstraints gridBagConstraints = ClPanel.createGridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridwidth = ClPanel.getGridWidth(ClPanel.getColumns(this.m_parent.getLen1()));
        this.add((Component)this.m_entryField, gridBagConstraints);
        gridBagConstraints = ClPanel.createGridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(0, 7, 0, 7);
        this.add((Component)this.m_add, gridBagConstraints);
        gridBagConstraints = ClPanel.createGridBagConstraints();
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.add((Component)this.m_scrollList, gridBagConstraints);
        gridBagConstraints = ClPanel.createGridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(3, 7, 0, 7);
        this.add((Component)this.m_remove, gridBagConstraints);
        gridBagConstraints = ClPanel.createGridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(3, 7, 0, 7);
        this.add((Component)this.m_moveup, gridBagConstraints);
        gridBagConstraints = ClPanel.createGridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(3, 7, 0, 7);
        this.add((Component)this.m_movedown, gridBagConstraints);
        this.m_remove.setEnabled(false);
        this.m_moveup.setEnabled(false);
        this.m_movedown.setEnabled(false);
        this.m_list.setEnabled(false);
        this.setStartingValue(this.m_parent.getStartingValue());
        this.validateControls();
        if (this.m_sngValues != null || this.m_bRestricted) {
            this.itemStateChanged(new ItemEvent((JComboBox)this.m_entryField, 0, this.m_entryField, 701));
        }
    }

    void setStartingValue(String string) throws ClParseException {
        if (string == null) {
            return;
        }
        this.blankControls();
        String string2 = null;
        boolean bl = false;
        boolean bl2 = true;
        while (string != null && !string.equals("")) {
            String string3;
            string = string.trim();
            int n = string.length();
            int n2 = 0;
            int n3 = 0;
            int n4 = -1;
            while (n2 < n) {
                char c = string.charAt(n2);
                if (c == '\'') {
                    ++n3;
                } else if (c == ' ' && n3 % 2 == 0) {
                    n4 = n2;
                    break;
                }
                ++n2;
            }
            if (n4 == -1) {
                string2 = string;
                bl = true;
            } else {
                string2 = string.substring(0, n4);
            }
            if (string2 == null) break;
            string2 = ClSyntax.quote(this.m_parent.getType(), string2);
            string2 = ClSyntax.upperCase(this.m_parent.getType(), string2);
            if (string2.length() > 0 && string2.charAt(0) != '*' && ClSyntax.stripQuotes(string2, false).length() > this.m_parent.getLen1() && this.m_parent.getType() != 1 && this.m_parent.getType() != 12 && this.m_parent.getType() != 2 && (string2.length() <= 1 || string2.charAt(0) != 'x' && string2.charAt(0) != 'X' || string2.charAt(1) != '\'') && (string2.length() <= 1 || string2.charAt(0) != '$' && string2.charAt(0) != '&')) {
                ClNode clNode = this.m_parent;
                while (!(clNode instanceof ClParm)) {
                    clNode = clNode.getParent();
                }
                this.m_parent.getPanel().displayAS400Message(74, (Object)((ClParm)clNode).getKwd(), (Object)("'" + string2 + "'"), (Object)new Integer(this.m_parent.getLen1()));
                throw new ClParseException();
            }
            if (this.isSingleValue(string2)) {
                if (!bl2 || this.m_listData.size() > 0 || n4 != -1) {
                    ClNode clNode = this.m_parent;
                    while (!(clNode instanceof ClParm)) {
                        clNode = clNode.getParent();
                    }
                    this.m_parent.getPanel().displayAS400Message(94, (Object)((ClParm)clNode).getKwd(), (Object)string2);
                    throw new ClParseException();
                }
                if (this.m_entryField instanceof JTextComponent) {
                    ((JTextComponent)this.m_entryField).setText(string2);
                } else if (this.m_entryField instanceof ClTextArea) {
                    ((ClTextArea)this.m_entryField).getTextComponent().setText(string2);
                } else if (this.m_entryField instanceof JComboBox) {
                    ClPanel.setComboText((JComboBox)this.m_entryField, string2);
                }
                this.validateControls();
                this.m_parent.setStartingValue(this.getCLString());
                return;
            }
            if (this.m_entryField instanceof JTextComponent) {
                JTextComponent jTextComponent = (JTextComponent)this.m_entryField;
                string3 = jTextComponent.getText();
                jTextComponent.setText(string2);
                if (!ClSyntax.verifyTextField(this, jTextComponent, this.m_parent, this.m_parent.getMin(), true)) {
                    throw new ClParseException();
                }
                jTextComponent.setText(string3);
            } else if (this.m_entryField instanceof ClTextArea) {
                JTextComponent jTextComponent = ((ClTextArea)this.m_entryField).getTextComponent();
                string3 = jTextComponent.getText();
                jTextComponent.setText(string2);
                if (!ClSyntax.verifyTextField(this, jTextComponent, this.m_parent, this.m_parent.getMin(), true)) {
                    throw new ClParseException();
                }
                jTextComponent.setText(string3);
            } else if (this.m_entryField instanceof JComboBox) {
                String string4 = ClPanel.getComboText((JComboBox)this.m_entryField);
                ClPanel.setComboText((JComboBox)this.m_entryField, string2);
                if (!ClSyntax.verifyComboBox(this, (JComboBox)this.m_entryField, this.m_parent, this.m_parent.getMin(), true)) {
                    throw new ClParseException();
                }
                ClPanel.setComboText((JComboBox)this.m_entryField, string4);
            }
            bl2 = false;
            this.m_listData.addElement(string2);
            if (this.m_listData.size() > this.m_parent.getMax()) {
                ClNode clNode = this.m_parent;
                while (!(clNode instanceof ClParm)) {
                    clNode = clNode.getParent();
                }
                this.m_parent.getPanel().displayAS400Message(46, (Object)((ClParm)clNode).getKwd(), (Object)"");
                throw new ClParseException();
            }
            if (n4 == -1) break;
            string = string.substring(n4 + 1, string.length());
        }
        this.m_list.setListData(this.m_listData);
        this.m_scrollList.revalidate();
        this.m_scrollList.repaint();
        this.validateControls();
        this.m_parent.setStartingValue(this.getCLString());
    }

    public void setVisible(boolean bl) {
        this.m_bVisible = bl;
        this.m_entryField.setVisible(bl);
        super.setVisible(bl);
    }

    boolean verify() {
        return this.verify(true);
    }

    boolean verify(boolean bl) {
        if (!this.m_bVisible) {
            return true;
        }
        int n = this.m_listData.size();
        if (!bl) {
            n = this.m_parent.getMin();
        } else {
            String string = null;
            if (this.m_entryField instanceof JTextComponent) {
                string = ((JTextComponent)this.m_entryField).getText();
            } else if (this.m_entryField instanceof ClTextArea) {
                string = ((ClTextArea)this.m_entryField).getTextComponent().getText();
            } else if (this.m_entryField instanceof JComboBox) {
                string = ClPanel.getComboText((JComboBox)this.m_entryField);
                string = ClSyntax.getChoicePgmValue(string, this.m_parent.getChoicePgmValues());
            }
            if (string != null && !string.equals("")) {
                string = ClSyntax.quote(this.m_parent.getType(), string);
                string = ClSyntax.upperCase(this.m_parent.getType(), string);
            }
        }
        if (this.m_entryField instanceof JTextComponent) {
            return ClSyntax.verifyTextField((ClPanel)this.getParent(), (JTextComponent)this.m_entryField, this.m_parent, n, bl);
        }
        if (this.m_entryField instanceof ClTextArea) {
            return ClSyntax.verifyTextField((ClPanel)this.getParent(), ((ClTextArea)this.m_entryField).getTextComponent(), this.m_parent, n, bl);
        }
        if (this.m_entryField instanceof JComboBox) {
            return ClSyntax.verifyComboBox((ClPanel)this.getParent(), (JComboBox)this.m_entryField, this.m_parent, n, bl);
        }
        return true;
    }

    String getCLString() {
        int n;
        String string = "";
        if (this.m_entryField instanceof JTextComponent) {
            string = ((JTextComponent)this.m_entryField).getText();
        } else if (this.m_entryField instanceof ClTextArea) {
            string = ((ClTextArea)this.m_entryField).getTextComponent().getText();
        } else if (this.m_entryField instanceof JComboBox) {
            string = ClPanel.getComboText((JComboBox)this.m_entryField);
            string = ClSyntax.getChoicePgmValue(string, this.m_choicePgmValues);
        }
        string = ClSyntax.quote(this.m_parent.getType(), string);
        string = ClSyntax.upperCase(this.m_parent.getType(), string);
        if (this.m_list.m_enabled && (n = this.m_listData.size()) > 0) {
            String string2 = "";
            int n2 = 0;
            while (n2 < n) {
                string2 = string2 + this.m_listData.elementAt(n2) + " ";
                ++n2;
            }
            string = string2 + string;
        }
        return string.trim();
    }

    String getCompareValue() {
        int n = this.m_listData.size();
        if (n == 0) {
            return this.getCLString();
        }
        String string = "";
        if (this.m_entryField instanceof JTextComponent) {
            string = ((JTextComponent)this.m_entryField).getText();
        } else if (this.m_entryField instanceof ClTextArea) {
            string = ((ClTextArea)this.m_entryField).getTextComponent().getText();
        } else if (this.m_entryField instanceof JComboBox) {
            string = ClPanel.getComboText((JComboBox)this.m_entryField);
            string = ClSyntax.getChoicePgmValue(string, this.m_choicePgmValues);
        }
        string = string.trim();
        if (!string.equals("") && this.isSingleValue(string)) {
            return string;
        }
        return (String)this.m_listData.firstElement();
    }

    void assignFocus() {
        if (this.m_entryField instanceof JComboBox) {
            ClPanel.comboRequestFocus((JComboBox)this.m_entryField);
        } else if (this.m_entryField instanceof ClTextArea) {
            ((ClTextArea)this.m_entryField).getTextComponent().requestFocus();
        } else {
            this.m_entryField.requestFocus();
        }
    }

    void blankControls() {
        if (this.m_entryField instanceof JTextComponent) {
            ((JTextComponent)this.m_entryField).setText("");
        } else if (this.m_entryField instanceof ClTextArea) {
            ((ClTextArea)this.m_entryField).getTextComponent().setText("");
        } else if (this.m_entryField instanceof JComboBox) {
            ClPanel.setComboText((JComboBox)this.m_entryField, "");
        }
        this.m_listData.removeAllElements();
        this.m_list.setListData(this.m_listData);
        this.m_scrollList.revalidate();
        this.m_scrollList.repaint();
        this.validateControls();
    }

    void refresh() {
        this.blankControls();
        String string = this.m_parent.getDft();
        if (this.m_entryField instanceof JTextComponent) {
            ((JTextComponent)this.m_entryField).setText(string);
        } else if (this.m_entryField instanceof ClTextArea) {
            ((ClTextArea)this.m_entryField).getTextComponent().setText(string);
        } else if (this.m_entryField instanceof JComboBox) {
            ClPanel.setComboText((JComboBox)this.m_entryField, string);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Add")) {
            int n;
            String string2 = "";
            if (this.m_add == null || !this.m_add.isEnabled()) {
                return;
            }
            if (!this.verify(false)) {
                return;
            }
            if (this.m_entryField instanceof JTextComponent) {
                string2 = ((JTextComponent)this.m_entryField).getText();
                ((JTextComponent)this.m_entryField).setText("");
            } else if (this.m_entryField instanceof ClTextArea) {
                string2 = ((ClTextArea)this.m_entryField).getTextComponent().getText();
                ((JTextArea)((ClTextArea)this.m_entryField).getTextComponent()).setText("");
            } else if (this.m_entryField instanceof JComboBox) {
                string2 = ClPanel.getComboText((JComboBox)this.m_entryField);
                string2 = ClSyntax.getChoicePgmValue(string2, this.m_parent.getChoicePgmValues());
                if (((JComboBox)this.m_entryField).isEditable()) {
                    ClPanel.setComboText((JComboBox)this.m_entryField, "");
                } else {
                    n = ((JComboBox)this.m_entryField).getSelectedIndex();
                    if (((JComboBox)this.m_entryField).getItemCount() > ++n) {
                        ((JComboBox)this.m_entryField).setSelectedIndex(n);
                    }
                }
            }
            if (string2 != null && !string2.equals("")) {
                string2 = ClSyntax.quote(this.m_parent.getType(), string2);
                string2 = ClSyntax.upperCase(this.m_parent.getType(), string2);
                n = this.m_list.getSelectedIndex();
                if (this.m_listData.size() == 0 || n == -1) {
                    this.m_listData.addElement(string2);
                } else {
                    this.m_listData.insertElementAt(string2, n + 1);
                }
                this.m_list.setListData(this.m_listData);
                if (this.m_listData.size() == 1 || n == -1) {
                    this.m_list.setSelectedIndex(this.m_listData.size() - 1);
                } else {
                    this.m_list.setSelectedIndex(n + 1);
                }
                this.m_list.ensureIndexIsVisible(this.m_list.getSelectedIndex());
                this.m_scrollList.repaint();
                this.m_scrollList.revalidate();
                this.validateControls();
            }
            this.assignFocus();
        } else if (string.equals("Remove")) {
            int n = this.m_listData.size();
            ListSelectionModel listSelectionModel = this.m_list.getSelectionModel();
            int n2 = listSelectionModel.getMaxSelectionIndex();
            if (n2 == -1) {
                return;
            }
            ++n2;
            int n3 = n;
            while (n3 >= 0) {
                if (listSelectionModel.isSelectedIndex(n3)) {
                    --n2;
                    this.m_listData.removeElementAt(n3);
                }
                --n3;
            }
            this.m_list.setListData(this.m_listData);
            n = this.m_listData.size();
            if (n2 >= n) {
                n2 = n - 1;
            }
            if (n2 >= 0) {
                this.m_list.setSelectedIndex(n2);
                this.m_list.ensureIndexIsVisible(this.m_list.getSelectedIndex());
            }
            this.m_scrollList.revalidate();
            this.m_scrollList.repaint();
            this.validateControls();
            this.m_remove.requestFocus();
        } else if (string.equals("MoveUp")) {
            int n = this.m_list.getSelectedIndex();
            if (n == -1 || n == 0) {
                return;
            }
            Object e = this.m_listData.elementAt(n);
            this.m_listData.removeElementAt(n);
            this.m_listData.insertElementAt(e, n - 1);
            this.m_list.setListData(this.m_listData);
            this.m_list.setSelectedIndex(n - 1);
            this.m_list.ensureIndexIsVisible(this.m_list.getSelectedIndex());
            this.m_scrollList.revalidate();
            this.m_scrollList.repaint();
            this.validateControls();
            this.m_moveup.requestFocus();
        } else if (string.equals("MoveDown")) {
            int n = this.m_list.getSelectedIndex();
            if (n == -1 || n == this.m_listData.size() - 1) {
                return;
            }
            Object e = this.m_listData.elementAt(n);
            this.m_listData.removeElementAt(n);
            this.m_listData.insertElementAt(e, n + 1);
            this.m_list.setListData(this.m_listData);
            this.m_list.setSelectedIndex(n + 1);
            this.m_list.ensureIndexIsVisible(this.m_list.getSelectedIndex());
            this.m_scrollList.revalidate();
            this.m_scrollList.repaint();
            this.validateControls();
            this.m_movedown.requestFocus();
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.documentChanged();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.documentChanged();
    }

    public void documentChanged() {
        class Me
        implements Runnable {
            private final /* synthetic */ ClParmListPanel this$0;

            Me(ClParmListPanel clParmListPanel) {
                this.this$0 = clParmListPanel;
            }

            public void run() {
                this.this$0.validateControls();
            }
        }
        SwingUtilities.invokeLater(new Me(this));
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.validateControls();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.validateControls();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (bl) {
            this.validateControls();
        } else {
            this.m_add.setEnabled(false);
            if (this.m_entryField instanceof ClTextArea) {
                ClPanel.setEnabled(((ClTextArea)this.m_entryField).getTextComponent(), false);
            } else {
                ClPanel.setEnabled(this.m_entryField, false);
            }
            this.m_moveup.setEnabled(false);
            this.m_movedown.setEnabled(false);
            this.m_remove.setEnabled(false);
            this.m_list.setEnabled(false);
        }
    }

    void validateControls() {
        if (!this.isEnabled()) {
            return;
        }
        if (this.m_listData.size() >= this.m_max) {
            this.m_add.setEnabled(false);
            if (this.m_entryField instanceof ClTextArea) {
                ClPanel.setEnabled(((ClTextArea)this.m_entryField).getTextComponent(), false);
            } else {
                ClPanel.setEnabled(this.m_entryField, false);
            }
        } else {
            this.m_add.setEnabled(true);
            if (this.m_entryField instanceof ClTextArea) {
                ClPanel.setEnabled(((ClTextArea)this.m_entryField).getTextComponent(), true);
            } else {
                ClPanel.setEnabled(this.m_entryField, true);
            }
        }
        if (this.m_list.getSelectedIndex() != -1) {
            if (this.m_list.getSelectedIndex() != 0) {
                this.m_moveup.setEnabled(this.m_listData.size() > 1);
            } else {
                this.m_moveup.setEnabled(false);
            }
            if (this.m_list.getSelectedIndex() != this.m_listData.size() - 1) {
                this.m_movedown.setEnabled(this.m_listData.size() > 1);
            } else {
                this.m_movedown.setEnabled(false);
            }
            if (this.m_listData.size() > 0) {
                this.m_remove.setEnabled(true);
            }
        } else {
            this.m_moveup.setEnabled(false);
            this.m_movedown.setEnabled(false);
            this.m_remove.setEnabled(false);
        }
        this.m_list.setEnabled(true);
        String string = "";
        if (this.m_entryField instanceof JTextComponent) {
            string = ((JTextComponent)this.m_entryField).getText();
        } else if (this.m_entryField instanceof ClTextArea) {
            string = ((ClTextArea)this.m_entryField).getTextComponent().getText();
        } else if (this.m_entryField instanceof JComboBox) {
            string = ClPanel.getComboText((JComboBox)this.m_entryField);
        }
        string = string.toUpperCase(Locale.ENGLISH);
        string = string.trim();
        if (string.equals("")) {
            this.m_add.setEnabled(false);
        }
        this.checkSingleValues(string);
    }

    boolean isSingleValue(String string) {
        if (this.m_sngValues != null) {
            int n = this.m_sngValues.size();
            int n2 = 0;
            while (n2 < n) {
                if (string.equals(this.m_sngValues.elementAt(n2))) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    void checkSingleValues(String string) {
        if (this.m_sngValues == null && !this.m_bRestricted) {
            return;
        }
        boolean bl = this.isSingleValue(string);
        if (bl) {
            this.m_list.setEnabled(false);
            this.m_add.setEnabled(false);
            this.m_remove.setEnabled(false);
            this.m_moveup.setEnabled(false);
            this.m_movedown.setEnabled(false);
        } else {
            if (this.m_listData.size() > 0) {
                this.m_list.setEnabled(true);
            }
            if (this.m_bRestricted) {
                int n = ((JComboBox)this.m_entryField).getItemCount();
                int n2 = 0;
                while (n2 < n) {
                    if (string.equals(((JComboBox)this.m_entryField).getItemAt(n2))) {
                        this.m_add.setEnabled(this.m_listData.size() < this.m_max);
                        return;
                    }
                    ++n2;
                }
                this.m_add.setEnabled(false);
            }
            if (string.equals("") && this.m_add != null) {
                this.m_add.setEnabled(false);
            }
        }
    }

    boolean canUserAdd() {
        if (this.m_add == null) {
            return false;
        }
        return this.m_add.isEnabled();
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 1999";
    }
}

