/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.util;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.Job;
import com.ibm.as400.access.MessageFile;
import com.ibm.as400.access.ServerStartupException;
import com.ibm.as400.data.PcmlException;
import com.ibm.as400.ui.framework.java.DataBean;
import com.ibm.as400.ui.framework.java.DisplayManagerException;
import com.ibm.as400.ui.framework.java.DynamicPanelManager;
import com.ibm.as400.ui.framework.java.IllegalUserDataException;
import com.ibm.as400.ui.framework.java.MessageBoxDialog;
import com.ibm.as400.ui.framework.java.MessageLog;
import com.ibm.as400.ui.framework.java.PanelManager;
import com.ibm.as400.ui.framework.java.WindowManager;
import com.ibm.as400.ui.util.ClCmd;
import com.ibm.as400.ui.util.ClCommandException;
import com.ibm.as400.ui.util.ClCommonLayout;
import com.ibm.as400.ui.util.ClContextMenuManager;
import com.ibm.as400.ui.util.ClCopyKeyListener;
import com.ibm.as400.ui.util.ClFieldMouseHandler;
import com.ibm.as400.ui.util.ClHelp;
import com.ibm.as400.ui.util.ClMessageBean;
import com.ibm.as400.ui.util.ResourceLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;

class ClPanel
extends JPanel {
    static final int MAXCOLUMNS = 20;
    static final int SPANCOLUMNS = 3;
    static final boolean INDENT_QUALIFIEDS = false;
    static AS400 m_system = null;
    static Font m_scaledFont = null;
    static String m_dateFormat = null;
    static String m_dateSeparator = null;
    static String m_timeSeparator = null;
    static int m_commandCCSID = 37;
    static final boolean SHOWDESCRIPTIONS = true;
    static String m_addString;
    static String m_addDotString;
    static String m_removeString;
    static String m_moveupString;
    static String m_movedownString;
    static String m_editDotString;
    static ClHelp m_help;
    static Image m_icon;
    static boolean m_bAllowPrograms;
    static boolean m_bPromptInteractive;
    static final String CL_MRI_FILE = "com.ibm.as400.ui.util.ClMRI";
    static final String CL_MRI_EDIT_MENU = "EDIT_MENU";
    static final String CL_MRI_COPY_MENU = "COPY_MENU";
    static final String CL_MRI_MAIN_FILE_MENU = "MAIN_FILE_MENU";
    static final String CL_MRI_MAIN_EDIT_MENU = "MAIN_EDIT_MENU";
    static final String CL_MRI_MAIN_VIEW_MENU = "MAIN_VIEW_MENU";
    static final String CL_MRI_MAIN_HELP_MENU = "MAIN_HELP_MENU";
    static final String CL_MRI_EDIT_COPY = "MAIN_EDIT_COPY";
    static final String CL_MRI_EDIT_CUT = "MAIN_EDIT_CUT";
    static final String CL_MRI_EDIT_PASTE = "MAIN_EDIT_PASTE";
    static final String CL_MRI_EDIT_SELECT_ALL = "MAIN_EDIT_SELECT_ALL";
    static final String CL_MRI_VIEW_ADVANCED = "MAIN_VIEW_ADVANCED";
    static final String CL_MRI_VIEW_ALLPARAMETERS = "MAIN_VIEW_ALL_PARAMETERS";
    static final String HELP_HOW_TO_USE = "com/ibm/as400/ui/util/guiprompt";
    static final String INFO_APAR = "II12532";
    static final String INFO_APAR_ADDRESS = "http://www.ibm.com/servers/eserver/iseries/oper_nav/infoapars.htm";
    static final ResourceLoader m_loader;
    static boolean m_loaded;
    static Color m_disabledBackgroundColor;
    static Color m_enabledBackgroundColor;
    static final String PMTCTL_ADVANCED = "PMTRQS";
    static final int INDENT_BASE = 7;
    static final int INDENT_TOP = 7;
    static final int INDENT_LEFT = 7;
    static final int INDENT_BOTTOM = 0;
    static final int INDENT_RIGHT = 7;
    static final int INDENT_PROMPTTOP = 3;
    static final int INDENT_LISTTOP = 3;
    static final int INDENT_QUAL = 21;
    static final int INDENT_QUALTOP = 0;
    static final int INDENT_ELEMQUAL = 42;
    static final int INDENT_ELEM = 21;
    static final int INDENT_ADDTOP = 3;
    static final String PROMPT_TEXT_SEPERATOR = ":";
    static final int COLUMN_WIDTH_ONE = 20;
    static final int COLUMN_WIDTH_TWO = 20;
    static final int COLUMN_WIDTH_THREE = 25;
    static final int MULTILINE = 49;
    static final int MAXTEXTROWS = 4;
    static final int ELEM_LIST_ROWS = 5;
    static final int ELEM_LIST_WIDTH = 20;
    static int MAX_DIALOG_SIZE_WIDTH;
    static int MAX_DIALOG_SIZE_HEIGHT;
    static final int INIT_DIALOG_INCREMENT = 50;
    static final int MIN_DIALOG_SIZE_WIDTH = 362;
    static final int MIN_DIALOG_SIZE_HEIGHT = 300;
    static final int SCROLLBAR_INCREMENT = 50;
    static final int SCROLLBAR_BLOCK_INCREMENT = 200;
    static final int ERROR_ALREADY_IN_LIST = 1;
    static final int ERROR_MISMATCHED_DOUBLE_QUOTES = 3;
    static final int ERROR_NO_PARAMETERS = 4;
    static final int ERROR_RUNNING_PROGRAM = 5;
    static final int ERROR_PROMPT_CHAR_NOT_SUPPORTED = 6;
    static final int ERROR_NO_HELP = 7;
    static final int ERROR_CONTACT_SYSTEM = 8;
    static final int ERROR_PROMPT_NO_COMMAND = 9;
    static final int ERROR_INTERACTIVE_NOT_ALLOWED = 10;
    static final int ERROR_PTF_REQUIRED = 11;
    static final int ERROR_NOT_SUPPORTED = 12;
    String m_cmdTitle;

    public static void cleanupStatics() {
        m_system = null;
        m_scaledFont = null;
        m_dateFormat = null;
        m_dateSeparator = null;
        m_timeSeparator = null;
        m_addString = null;
        m_addDotString = null;
        m_removeString = null;
        m_moveupString = null;
        m_movedownString = null;
        m_editDotString = null;
        m_help = null;
        m_icon = null;
        m_disabledBackgroundColor = null;
        m_enabledBackgroundColor = null;
    }

    ClPanel() {
        if (MAX_DIALOG_SIZE_WIDTH == 0) {
            Dimension dimension = this.getToolkit().getScreenSize();
            MAX_DIALOG_SIZE_WIDTH = dimension.width - (int)((double)dimension.width * 0.1);
            MAX_DIALOG_SIZE_HEIGHT = dimension.height - (int)((double)dimension.height * 0.15);
        }
        this.setLayout(new GridBagLayout());
    }

    void setCmdTitle(String string) {
        this.m_cmdTitle = string;
    }

    static final Dimension getInitDialogSize(Dimension dimension) {
        return ClPanel.getDialogSize(dimension);
    }

    static final Dimension getDialogSize(Dimension dimension) {
        dimension.width += 50;
        dimension.height += 50;
        if (dimension.width > MAX_DIALOG_SIZE_WIDTH) {
            dimension.width = MAX_DIALOG_SIZE_WIDTH;
        } else if (dimension.width < 362) {
            dimension.width = 362;
        }
        if (dimension.height > MAX_DIALOG_SIZE_HEIGHT) {
            dimension.height = MAX_DIALOG_SIZE_HEIGHT;
        } else if (dimension.height < 300) {
            dimension.height = 300;
        }
        return dimension;
    }

    static final int getColumns(int n) {
        n = n <= 20 ? 20 : (n <= 20 ? 20 : (n <= 25 ? 20 : 25));
        return n;
    }

    static final int getGridWidth(int n) {
        if (n <= 20) {
            return 3;
        }
        if (n <= 20) {
            return 3;
        }
        return 6;
    }

    final boolean isAlreadyInList(Vector vector, String string, ClCommonLayout clCommonLayout) {
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            if (vector.elementAt(n2).equals(string)) {
                this.error(1, string, "", clCommonLayout.getPanel());
                return true;
            }
            ++n2;
        }
        return false;
    }

    final void error(int n) {
        this.error(n, "", "", null);
    }

    final void error(int n, String string) {
        this.error(n, string, "", null);
    }

    final void error(int n, String string, String string2) {
        this.error(n, string, string2, null);
    }

    final void error(int n, String string, String string2, Component component) {
        String string3 = "";
        switch (n) {
            case 1: {
                string3 = ClPanel.formatString("IDS_ERROR_ALREADY_IN_LIST", string);
                break;
            }
            case 3: {
                string3 = ClPanel.formatString("IDS_ERROR_MISMATCHED_DOUBLE_QUOTES", string);
                break;
            }
            case 10: {
                string3 = ClPanel.formatString("IDS_ERROR_INTERACTIVE_NOT_ALLOWED", string);
                break;
            }
            case 9: {
                string3 = ClPanel.loadString("IDS_ERROR_PROMPT_NO_COMMAND");
                break;
            }
            case 4: {
                string3 = ClPanel.formatString("IDS_ERROR_NO_PARAMETERS", string);
                break;
            }
            case 6: {
                string3 = ClPanel.formatString("IDS_ERROR_PROMPT_CHAR_NOT_SUPPORTED", string);
                break;
            }
            case 7: {
                string3 = ClPanel.loadString("IDS_ERROR_NO_HELP");
                break;
            }
            case 8: {
                string3 = ClPanel.formatString("IDS_ERROR_CONTACT_SYSTEM", string);
                break;
            }
            case 5: {
                string3 = ClPanel.formatString("IDS_ERROR_RUNNING_PROGRAM", string);
                break;
            }
            case 11: {
                string3 = ClPanel.formatString("IDS_PTF_REQUIRED", string, string2);
                break;
            }
            case 12: {
                string3 = ClPanel.formatString("IDS_NOT_SUPPORTED", string);
            }
        }
        String string4 = this.m_cmdTitle;
        if (string4 == null || string4.equals("")) {
            string4 = ClPanel.loadString("IDS_MESSAGE_ERROR");
        }
        MessageBoxDialog.showMessageDialog((Component)this.getTopLevelAncestor(), (String)string3, (String)string4, (int)0);
        if (component == null) {
            ClPanel.repaintDialog(this);
        } else {
            ClPanel.repaintDialog(component);
        }
    }

    void displayAS400Message(String string) {
        this.displayAS400Message(string, "QCPFMSG");
    }

    void displayAS400Message(int n) {
        this.displayAS400Message(n, (Object)"QCPFMSG");
    }

    void displayAS400Message(int n, Object object) {
        this.displayAS400Message(n, object, null, null, null);
    }

    void displayAS400Message(int n, Object object, Object object2) {
        this.displayAS400Message(n, object, object2, null, null);
    }

    void displayAS400Message(int n, Object object, Object object2, Object object3) {
        this.displayAS400Message(n, object, object2, object3, null);
    }

    void displayAS400Message(int n, Object object, Object object2, Object object3, Object object4) {
        String string = n < 100 ? "CPD00" + n : (n < 1000 ? "CPD0" + n : "CPD" + n);
        this.displayAS400Message(string, "QCPFMSG", null, null, object, object2, object3, object4);
    }

    void displayAS400Message(String string, String string2) {
        this.displayAS400Message(string, string2, null, null, null, null, null, null);
    }

    void displayAS400Message(String string, String string2, Object object) {
        this.displayAS400Message(string, string2, null, null, object, null, null, null);
    }

    void displayAS400Message(String string, String string2, Object object, Object object2) {
        this.displayAS400Message(string, string2, null, null, object, object2, null, null);
    }

    void displayAS400Message(String string, String string2, Object object, Object object2, Object object3) {
        this.displayAS400Message(string, string2, null, null, object, object2, object3, null);
    }

    void displayAS400Message(String string, ClCmd clCmd) {
        this.displayAS400Message(string, clCmd.getMsgF(), clCmd.getMsgFLib(), clCmd, null, null, null, null);
    }

    void displayAS400Message(String string, String string2, String string3, ClCmd clCmd, Object object, Object object2, Object object3, Object object4) {
        Object object5;
        Object object6;
        DataBean[] dataBeanArray;
        Object object7;
        ClPanel.setCursor(this, true);
        if (string2 == null) {
            string2 = "QCPFMSG";
        }
        if (string3 == null || string3.equals("__LIBL")) {
            string3 = "%LIBL%";
        }
        AS400Message aS400Message = null;
        try {
            string2 = string3.equals("QSYS") ? "/" + string3 + ".LIB/" + string2 + ".MSGF" : "/QSYS.LIB/" + string3 + ".LIB/" + string2 + ".MSGF";
            MessageLog.logError((Object)("CP: Message file being used: " + string2 + "  " + string));
            object7 = new MessageFile(m_system, string2);
            object7.setHelpTextFormatting(1);
            aS400Message = object7.getMessage(string);
        }
        catch (Exception exception) {
            try {
                if (clCmd == null) {
                    MessageLog.logError((Object)("CP: Exception on AS/400 message " + string));
                    exception.printStackTrace();
                    ClPanel.setCursor(this, false);
                    return;
                }
                string3 = clCmd.getPrdLib();
                string2 = clCmd.getMsgF();
                string2 = string3.equals("QSYS") ? "/" + string3 + ".LIB/" + string2 + ".MSGF" : "/QSYS.LIB/" + string3 + ".LIB/" + string2 + ".MSGF";
                MessageLog.logError((Object)("CP: Message file being used: " + string2 + "  " + string));
                dataBeanArray = new MessageFile(m_system, string2);
                dataBeanArray.setHelpTextFormatting(1);
                aS400Message = dataBeanArray.getMessage(string);
            }
            catch (Exception exception2) {
                MessageLog.logError((Object)("CP: Exception on AS/400 message " + string));
                exception2.printStackTrace();
                ClPanel.setCursor(this, false);
                return;
            }
        }
        object7 = new ClMessageBean(aS400Message, object, object2, object3, object4);
        dataBeanArray = new DataBean[]{object7};
        DynamicPanelManager dynamicPanelManager = null;
        ClPanel clPanel = this;
        Window window = null;
        if (clPanel != null) {
            window = clPanel instanceof Window ? (Window)((Object)clPanel) : SwingUtilities.getWindowAncestor(clPanel);
        }
        if (window == null) {
            window = new Frame();
            ((Frame)window).setIconImage(m_icon);
        }
        try {
            if (window instanceof Dialog) {
                dynamicPanelManager = new DynamicPanelManager(CL_MRI_FILE, "PANEL_AS400MESSAGE", dataBeanArray, (Frame)null);
                object6 = (Dialog)window;
                dynamicPanelManager.setModalRelativeTo(new WindowManager((Dialog)object6){
                    private final /* synthetic */ Dialog val$dialog;
                    {
                        this.val$dialog = dialog;
                    }

                    public Window getWindow() {
                        return this.val$dialog;
                    }

                    public void setModalRelativeTo(WindowManager windowManager) {
                    }

                    public WindowManager getOwnerManager() {
                        return null;
                    }

                    public void addCommitListener(ActionListener actionListener) {
                    }

                    public void addCommitListener(Object object) {
                    }

                    public void addCancelListener(ActionListener actionListener) {
                    }

                    public void addCancelListener(Object object) {
                    }

                    public void dispose() {
                    }

                    public void handleDataException(IllegalUserDataException illegalUserDataException) {
                    }

                    public void setVisible(boolean bl) {
                    }

                    public boolean isVisible() {
                        return this.val$dialog.isVisible();
                    }
                });
            } else {
                dynamicPanelManager = new DynamicPanelManager(CL_MRI_FILE, "PANEL_AS400MESSAGE", dataBeanArray, (Frame)window);
            }
        }
        catch (DisplayManagerException displayManagerException) {
            displayManagerException.displayUserMessage(null);
            ClPanel.setCursor(this, false);
            return;
        }
        object6 = null;
        try {
            object6 = new ClContextMenuManager(CL_MRI_FILE, null, CL_MRI_COPY_MENU, null);
        }
        catch (DisplayManagerException displayManagerException) {
            displayManagerException.displayUserMessage(null);
        }
        JTextComponent jTextComponent = (JTextComponent)dynamicPanelManager.getComponent("AM_TEXT_MESSAGE");
        jTextComponent.setEditable(false);
        jTextComponent.addMouseListener(new ClFieldMouseHandler(jTextComponent, (ClContextMenuManager)((Object)object6)));
        jTextComponent.addKeyListener(new ClCopyKeyListener());
        jTextComponent = (JTextComponent)dynamicPanelManager.getComponent("AM_TEXT_HELP");
        jTextComponent.setEditable(false);
        jTextComponent.addMouseListener(new ClFieldMouseHandler(jTextComponent, (ClContextMenuManager)((Object)object6)));
        jTextComponent.addKeyListener(new ClCopyKeyListener());
        if (jTextComponent.getLocale().getLanguage().equals("ar") || jTextComponent.getLocale().getLanguage().equals("he")) {
            jTextComponent.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            object5 = (JTextComponent)dynamicPanelManager.getComponent("AM_TEXT_MESSAGE");
            if (object5 != null) {
                ((JTextComponent)object5).setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            }
        }
        object5 = ClPanel.loadString("IDS_MESSAGE_ERROR");
        dynamicPanelManager.setTitle((String)object5);
        dynamicPanelManager.setVisible(true);
        ClPanel.setCursor(this, false);
        ClPanel.repaintDialog(this);
    }

    static final void repaintDialog(Component component) {
        while (!(component instanceof JDialog)) {
            if (component == null) {
                return;
            }
            component = component.getParent();
        }
        component.repaint();
    }

    static final String getComboText(JComboBox jComboBox) {
        if (jComboBox.isEditable()) {
            return ((JTextComponent)jComboBox.getEditor().getEditorComponent()).getText();
        }
        return (String)jComboBox.getSelectedItem();
    }

    static final void setComboText(JComboBox jComboBox, String string) {
        if (jComboBox.isEditable()) {
            ((JTextComponent)jComboBox.getEditor().getEditorComponent()).setText(string);
        } else {
            jComboBox.setSelectedItem(string);
        }
    }

    static final void setEnabled(Component component, boolean bl) {
        if (m_disabledBackgroundColor == null) {
            m_disabledBackgroundColor = UIManager.getColor("Panel.background");
        }
        if (m_enabledBackgroundColor == null) {
            m_enabledBackgroundColor = UIManager.getColor("TextField.background");
        }
        component.setEnabled(bl);
        if (component instanceof JComboBox) {
            component = ((JComboBox)component).getEditor().getEditorComponent();
        }
        component.setBackground(bl ? m_enabledBackgroundColor : m_disabledBackgroundColor);
    }

    static final void comboRequestFocus(JComboBox jComboBox) {
        if (jComboBox.isEditable()) {
            jComboBox.getEditor().getEditorComponent().requestFocus();
        } else {
            jComboBox.requestFocus();
        }
    }

    static final PanelManager loadPanel(String string) {
        return ClPanel.loadPanel(string, null, null);
    }

    static final PanelManager loadPanel(String string, DataBean[] dataBeanArray, Container container) {
        PanelManager panelManager = null;
        Window window = null;
        if (container != null) {
            window = container instanceof Window ? (Window)container : SwingUtilities.getWindowAncestor(container);
        }
        try {
            if (window instanceof Dialog) {
                panelManager = new PanelManager(CL_MRI_FILE, string, dataBeanArray);
                final Dialog dialog = (Dialog)window;
                panelManager.setModalRelativeTo(new WindowManager(){

                    public Window getWindow() {
                        return dialog;
                    }

                    public void setModalRelativeTo(WindowManager windowManager) {
                    }

                    public WindowManager getOwnerManager() {
                        return null;
                    }

                    public void addCommitListener(ActionListener actionListener) {
                    }

                    public void addCommitListener(Object object) {
                    }

                    public void addCancelListener(ActionListener actionListener) {
                    }

                    public void addCancelListener(Object object) {
                    }

                    public void dispose() {
                    }

                    public void handleDataException(IllegalUserDataException illegalUserDataException) {
                    }

                    public void setVisible(boolean bl) {
                    }

                    public boolean isVisible() {
                        return dialog.isVisible();
                    }
                });
            } else {
                panelManager = new PanelManager(CL_MRI_FILE, string, dataBeanArray, (Frame)window);
            }
        }
        catch (DisplayManagerException displayManagerException) {
            displayManagerException.displayUserMessage(null);
            return null;
        }
        return panelManager;
    }

    static final String loadString(String string) {
        if (!m_loaded) {
            m_loaded = true;
            m_loader.setResourceName(CL_MRI_FILE);
        }
        return m_loader.getString(string);
    }

    static final String formatString(String string, Object object) {
        return ClPanel.formatString(string, object, null, null, null);
    }

    static final String formatString(String string, Object object, Object object2) {
        return ClPanel.formatString(string, object, object2, null, null);
    }

    static final String formatString(String string, Object object, Object object2, Object object3) {
        return ClPanel.formatString(string, object, object2, object3, null);
    }

    static final String formatString(String string, Object object, Object object2, Object object3, Object object4) {
        String string2 = ClPanel.loadString(string);
        Object[] objectArray = new Object[]{object, object2, object3, object4};
        return MessageFormat.format(string2, objectArray);
    }

    static final GridBagConstraints createGridBagConstraints() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.fill = 0;
        return gridBagConstraints;
    }

    static final void setCursor(JComponent jComponent, boolean bl) {
        Container container;
        if (jComponent != null && (container = jComponent.getTopLevelAncestor()) != null && container instanceof Window) {
            Window window = (Window)container;
            if (bl) {
                window.setCursor(Cursor.getPredefinedCursor(3));
            } else {
                window.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    void InspectPCMLException(PcmlException pcmlException) throws ClCommandException {
        if (pcmlException.getException() instanceof UnknownHostException || pcmlException.getException() instanceof AS400SecurityException || pcmlException.getException() instanceof AS400Exception || pcmlException.getException() instanceof ConnectionDroppedException || pcmlException.getException() instanceof IOException || pcmlException.getException() instanceof InterruptedException || pcmlException.getException() instanceof ServerStartupException) {
            String string = m_system.getSystemName();
            this.error(8, string);
            MessageLog.logError((Object)("CP: Connection exception for system: " + string));
            pcmlException.printStackTrace();
            throw new ClCommandException();
        }
    }

    static final boolean addToLibraryList(String string) {
        try {
            Job job = new Job(m_system, "*", "", "");
            String[] stringArray = job.getUserLibraryList();
            int n = 0;
            while (n < stringArray.length) {
                if (string.equals(stringArray[n])) {
                    return false;
                }
                ++n;
            }
            CommandCall commandCall = new CommandCall(m_system);
            String string2 = "ADDLIBLE LIB(" + string + ")";
            if (!commandCall.run(string2)) {
                MessageLog.logError((Object)"CP: Unable to add library to library list.");
                return false;
            }
        }
        catch (Exception exception) {
            MessageLog.logError((Object)"CP: Unable to add library to library list.");
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    static final void removeFromLibraryList(String string) {
        String string2 = "RMVLIBLE LIB(" + string + ")";
        try {
            CommandCall commandCall = new CommandCall(m_system);
            if (!commandCall.run(string2)) {
                MessageLog.logError((Object)"CP: Unable to remove library from library list.");
            }
        }
        catch (Exception exception) {
            MessageLog.logError((Object)"CP: Unable to remove library from library list.");
            exception.printStackTrace();
        }
    }

    static final Component getMostRecentFocusOwner(Window window) {
        String string = System.getProperty("java.version");
        int n = string.indexOf(".");
        String string2 = string.substring(0, n);
        string = string.substring(n + 1);
        String string3 = string.substring(0, string.indexOf("."));
        if (new Integer(string2) <= 1 && new Integer(string3) < 4) {
            return window.getFocusOwner();
        }
        return window.getMostRecentFocusOwner();
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 1999";
    }

    static {
        m_help = null;
        m_icon = null;
        m_bAllowPrograms = true;
        m_bPromptInteractive = true;
        m_loader = new ResourceLoader();
        m_loaded = false;
        m_disabledBackgroundColor = null;
        m_enabledBackgroundColor = null;
        MAX_DIALOG_SIZE_WIDTH = 0;
        MAX_DIALOG_SIZE_HEIGHT = 0;
    }
}

