/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.util;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.RequestNotSupportedException;
import com.ibm.as400.access.SystemValue;
import com.ibm.as400.ui.framework.java.DisplayManagerException;
import com.ibm.as400.ui.framework.java.MessageLog;
import com.ibm.as400.ui.util.ClAttributeList;
import com.ibm.as400.ui.util.ClButtonGroup;
import com.ibm.as400.ui.util.ClCmd;
import com.ibm.as400.ui.util.ClComboBox;
import com.ibm.as400.ui.util.ClContextMenuManager;
import com.ibm.as400.ui.util.ClElem;
import com.ibm.as400.ui.util.ClElemListPanel;
import com.ibm.as400.ui.util.ClFieldMouseHandler;
import com.ibm.as400.ui.util.ClNode;
import com.ibm.as400.ui.util.ClPQEElementNode;
import com.ibm.as400.ui.util.ClPanel;
import com.ibm.as400.ui.util.ClPanelFocusListener;
import com.ibm.as400.ui.util.ClParm;
import com.ibm.as400.ui.util.ClParmListPanel;
import com.ibm.as400.ui.util.ClParseException;
import com.ibm.as400.ui.util.ClPromptKeyListener;
import com.ibm.as400.ui.util.ClQual;
import com.ibm.as400.ui.util.ClQualListPanel;
import com.ibm.as400.ui.util.ClSyntax;
import com.ibm.as400.ui.util.ClTextArea;
import com.ibm.as400.ui.util.ClTextFieldLimit;
import com.ibm.as400.ui.util.ClValue;
import com.ibm.as400.ui.util.ClValues;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

abstract class ClCommonLayout
extends ClPQEElementNode {
    static final int DEFAULT_WIDTH = 120;
    static final int PASSWORD_LEVEL_0 = 0;
    static final int PASSWORD_LEVEL_1 = 1;
    protected int m_Max;
    protected Vector m_guiControls;
    protected String m_startingValue;
    protected Vector m_labels;
    protected Vector m_parmNames;
    protected ClPanelFocusListener m_focus;
    protected ClPanel m_panel;
    protected boolean m_bVisible;
    protected ClValues m_sngValues;
    protected static ClContextMenuManager m_editMenu;

    public static void cleanup() {
        m_editMenu = null;
    }

    ClCommonLayout() {
    }

    ClCommonLayout(ClAttributeList clAttributeList) {
        super(clAttributeList);
        this.m_guiControls = new Vector(2);
        this.m_labels = new Vector(1);
        this.m_parmNames = new Vector(1);
        this.m_focus = new ClPanelFocusListener();
        this.m_bVisible = false;
        this.m_sngValues = null;
        this.m_Max = 0;
        if (m_editMenu == null) {
            try {
                m_editMenu = new ClContextMenuManager("com.ibm.as400.ui.util.ClMRI", null, "EDIT_MENU", null);
            }
            catch (DisplayManagerException displayManagerException) {
                displayManagerException.displayUserMessage(null);
            }
        }
    }

    void setMax(String string) {
        this.m_Max = new Integer(string);
    }

    void setMax(int n) {
        this.m_Max = n;
    }

    int getMax() {
        return this.m_Max;
    }

    ClValues getSngValues() {
        return this.m_sngValues;
    }

    boolean isVisible() {
        return this.m_bVisible;
    }

    void addLabelElement(JLabel jLabel) {
        this.m_labels.addElement(jLabel);
    }

    int getLongestLabelWidth() {
        int n = 0;
        int n2 = this.m_labels.size();
        Dimension dimension = null;
        int n3 = 0;
        while (n3 < n2) {
            dimension = ((JLabel)this.m_labels.elementAt(n3)).getPreferredSize();
            if (dimension.width > n) {
                n = dimension.width;
            }
            if (this instanceof ClParm && (this.getType() == 18 || this.getType() == 19)) {
                Object e = this.m_guiControls.firstElement();
                int n4 = 0;
                if (e instanceof ClElemListPanel) {
                    n4 = ((ClElemListPanel)e).getLongestLabelWidth();
                } else if (e instanceof ClQualListPanel) {
                    n4 = ((ClQualListPanel)e).getLongestLabelWidth();
                } else {
                    MessageLog.logError((Object)"CP: longestlabelwidth failed: Unknown instance");
                }
                if (n4 > n) {
                    n = n4;
                }
            }
            ++n3;
        }
        return n;
    }

    void setVisible(boolean bl) {
        this.m_bVisible = bl;
        int n = this.m_labels.size();
        int n2 = 0;
        while (n2 < n) {
            ((JLabel)this.m_labels.elementAt(n2)).setVisible(bl);
            ++n2;
        }
        n = this.m_guiControls.size();
        int n3 = 0;
        while (n3 < n) {
            Object e = this.m_guiControls.elementAt(n3);
            if (e instanceof JTextComponent) {
                ((JTextComponent)e).setVisible(bl);
            } else if (e instanceof ClTextArea) {
                ((ClTextArea)e).setVisible(bl);
            } else if (e instanceof ButtonGroup) {
                Enumeration<AbstractButton> enumeration = ((ButtonGroup)e).getElements();
                if (enumeration != null) {
                    while (enumeration.hasMoreElements()) {
                        JRadioButton jRadioButton = (JRadioButton)enumeration.nextElement();
                        jRadioButton.setVisible(bl);
                    }
                }
            } else if (e instanceof JComboBox) {
                ((JComboBox)e).setVisible(bl);
            } else if (e instanceof ClParmListPanel) {
                ((ClParmListPanel)e).setVisible(bl);
            } else if (e instanceof ClQualListPanel) {
                ((ClQualListPanel)e).setVisible(bl);
            } else if (e instanceof ClElemListPanel) {
                ((ClElemListPanel)e).setVisible(bl);
            }
            ++n3;
        }
    }

    void setNamesVisible(boolean bl) {
        int n = this.m_parmNames.size();
        int n2 = 0;
        while (n2 < n) {
            ((JLabel)this.m_parmNames.elementAt(n2)).setVisible(bl && this.m_bVisible);
            ++n2;
        }
        Enumeration enumeration = this.getChildren();
        ClNode clNode = null;
        while (enumeration.hasMoreElements()) {
            clNode = (ClNode)enumeration.nextElement();
            if (clNode instanceof ClQual) {
                ((ClQual)clNode).setNamesVisible(bl);
                continue;
            }
            if (!(clNode instanceof ClElem)) continue;
            ((ClElem)clNode).setNamesVisible(bl);
        }
    }

    void setStartingValue(String string) {
        this.m_startingValue = string;
    }

    String getStartingValue() {
        return this.m_startingValue;
    }

    void layoutPanel(ClPanel clPanel) throws ClParseException {
        this.layoutPanel(clPanel, null);
    }

    void layoutPanel(ClPanel clPanel, ClValues clValues) throws ClParseException {
        this.layoutPanel(clPanel, clValues, 0);
    }

    void layoutPanel(ClPanel clPanel, ClValues clValues, int n) throws ClParseException {
        Enumeration enumeration;
        this.m_guiControls.removeAllElements();
        this.m_panel = clPanel;
        this.m_sngValues = clValues;
        int n2 = this.getType();
        if (this instanceof ClElem && (enumeration = this.getChildren()).hasMoreElements()) {
            while (enumeration.hasMoreElements()) {
                ClNode clNode = (ClNode)enumeration.nextElement();
                if (clNode instanceof ClQual) {
                    n2 = 19;
                    break;
                }
                if (!(clNode instanceof ClElem)) continue;
                n2 = 18;
                break;
            }
        }
        switch (n2) {
            case 1: 
            case 2: 
            case 3: {
                this.displayPrompt(clPanel, this.getPrompt());
                this.displayField(clPanel, n);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                this.displayPrompt(clPanel, this.getPrompt());
                this.displayField(clPanel, n);
                break;
            }
            case 7: {
                this.displayPrompt(clPanel, this.getPrompt());
                this.displayField(clPanel, n);
                break;
            }
            case 8: {
                this.displayPrompt(clPanel, this.getPrompt());
                this.displayField(clPanel, n);
                break;
            }
            case 9: {
                this.displayPrompt(clPanel, this.getPrompt());
                this.displayField(clPanel, n);
                break;
            }
            case 10: {
                this.displayPrompt(clPanel, this.getPrompt());
                this.displayField(clPanel, n);
                break;
            }
            case 11: {
                this.displayPrompt(clPanel, this.getPrompt());
                this.displayField(clPanel, n);
                break;
            }
            case 12: {
                this.displayPrompt(clPanel, this.getPrompt());
                this.displayField(clPanel, n);
                break;
            }
            case 13: {
                this.displayPrompt(clPanel, this.getPrompt());
                this.displayField(clPanel, n);
                break;
            }
            case 14: 
            case 15: 
            case 21: 
            case 22: {
                this.displayPrompt(clPanel, this.getPrompt());
                this.displayField(clPanel, n);
                break;
            }
            case 16: {
                this.displayPrompt(clPanel, this.getPrompt());
                this.displayField(clPanel, n);
                break;
            }
            case 17: {
                this.displayPrompt(clPanel, this.getPrompt());
                this.displayField(clPanel, n);
                break;
            }
            case 18: {
                if (!this.getChildren().hasMoreElements()) break;
                this.displayPrompt(clPanel, this.getPrompt(), true);
                this.displayElems(clPanel, n);
                break;
            }
            case 19: {
                this.displayPrompt(clPanel, this.getPrompt());
                this.displayQualName(clPanel, n);
                break;
            }
            case 20: {
                break;
            }
            default: {
                MessageLog.logError((Object)("CP: Invalid type in common layout " + n2));
            }
        }
    }

    void displayPrompt(ClPanel clPanel, String string) {
        this.displayPrompt(clPanel, string, false);
    }

    void displayPrompt(ClPanel clPanel, String string, boolean bl) {
        Object object;
        GridBagConstraints gridBagConstraints = ClPanel.createGridBagConstraints();
        gridBagConstraints.anchor = 18;
        int n = 7;
        if (this instanceof ClElem) {
            n = 21;
            object = this.getParent();
            while (object instanceof ClElem) {
                n += 21;
                object = ((ClNode)object).getParent();
            }
        }
        gridBagConstraints.insets = new Insets(7 + 3, n, 0, 0);
        object = null;
        object = string != null ? new JLabel(string + ":") : new JLabel(" ");
        ((JComponent)object).setFont(ClPanel.m_scaledFont);
        clPanel.add((Component)object, gridBagConstraints);
        this.m_labels.addElement(object);
        String string2 = " ";
        if (this instanceof ClParm) {
            string2 = ((ClParm)this).getKwd();
        }
        this.addKwdName(clPanel, string2, false);
        if (bl) {
            gridBagConstraints = ClPanel.createGridBagConstraints();
            gridBagConstraints.gridwidth = 0;
            object = new JLabel(" ");
            ((JComponent)object).setFont(ClPanel.m_scaledFont);
            clPanel.add((Component)object, gridBagConstraints);
            this.m_labels.addElement(object);
        }
    }

    void addKwdName(ClPanel clPanel, String string, boolean bl) {
        GridBagConstraints gridBagConstraints = ClPanel.createGridBagConstraints();
        gridBagConstraints.gridwidth = bl ? 0 : 1;
        int n = 7;
        gridBagConstraints.insets = new Insets(7 + 3, n, 0, 7);
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(ClPanel.m_scaledFont);
        jLabel.setVisible(false);
        clPanel.add((Component)jLabel, gridBagConstraints);
        this.m_parmNames.addElement(jLabel);
    }

    JComponent createTextField() throws ClParseException {
        Object object;
        JTextComponent jTextComponent;
        JComponent jComponent;
        int n = this.getLen1();
        int n2 = ClPanel.getColumns(n);
        if (this.getType() == 12) {
            n *= 2;
        }
        if (this.getDspInput().equals("YES") || this.getDspInput().equals("PROMPT")) {
            if (n < 49) {
                jComponent = new JTextField();
                jComponent.setFont(ClPanel.m_scaledFont);
                jTextComponent = (JTextComponent)jComponent;
                object = jComponent.getPreferredSize();
                ((Dimension)object).width = 127;
                jComponent.setPreferredSize((Dimension)object);
            } else {
                int n3 = n / n2 + 1;
                if (n3 > 4) {
                    n3 = 4;
                }
                jComponent = new ClTextArea(n3, n2);
                jTextComponent = ((ClTextArea)jComponent).getTextComponent();
            }
        } else {
            jComponent = new JPasswordField();
            jComponent.setFont(ClPanel.m_scaledFont);
            ((JPasswordField)jComponent).setColumns(n2);
            jTextComponent = (JTextComponent)jComponent;
        }
        if (n > 0) {
            jTextComponent.setDocument(new ClTextFieldLimit(n, this.getAlwVar(), this));
        }
        if (this.m_startingValue == null) {
            jTextComponent.setText(this.getDft());
        } else {
            if (this.m_startingValue.length() > 0 && this.m_startingValue.charAt(0) != '*' && ClSyntax.stripQuotes(this.m_startingValue, false).length() > this.getLen1() && this.getMax() <= 1 && this.getType() != 1 && this.getType() != 12 && this.getType() != 2 && (this.m_startingValue.length() <= 1 || this.m_startingValue.charAt(0) != 'x' && this.m_startingValue.charAt(0) != 'X' || this.m_startingValue.charAt(1) != '\'') && (this.m_startingValue.length() <= 1 || this.m_startingValue.charAt(0) != '$' && this.m_startingValue.charAt(0) != '&')) {
                object = this;
                while (!(object instanceof ClParm)) {
                    object = ((ClNode)object).getParent();
                }
                this.m_panel.displayAS400Message(74, (Object)((ClParm)object).getKwd(), (Object)("'" + this.m_startingValue + "'"), (Object)new Integer(this.getLen1()));
                throw new ClParseException();
            }
            jTextComponent.setText(this.m_startingValue);
        }
        jTextComponent.addFocusListener(this.m_focus);
        if (this.getType() == 9) {
            jTextComponent.addKeyListener(new ClPromptKeyListener());
        }
        this.addListenersToControl(jTextComponent);
        return jComponent;
    }

    void displayNameField(ClPanel clPanel) throws ClParseException {
        this.displayNameField(clPanel, 0);
    }

    void displayNameField(ClPanel clPanel, int n) throws ClParseException {
        JComponent jComponent = this.createTextField();
        if (this.getMax() > 1) {
            this.createListPanel(jComponent);
        } else {
            GridBagConstraints gridBagConstraints = ClPanel.createGridBagConstraints();
            JLabel jLabel = null;
            if (n == 0) {
                n = ClPanel.getGridWidth(ClPanel.getColumns(this.getLen1()));
                jLabel = new JLabel(this.getChoice());
                jLabel.setFont(ClPanel.m_scaledFont);
            }
            gridBagConstraints.gridwidth = n;
            if (ClPanel.getColumns(this.getLen1()) >= 25) {
                gridBagConstraints.fill = 2;
            } else {
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.fill = 0;
            }
            int n2 = 7;
            int n3 = 7;
            if (this instanceof ClQual) {
                n3 = 0;
            } else {
                Dimension dimension = jComponent.getPreferredSize();
                dimension.width = 120;
                jComponent.setPreferredSize(dimension);
            }
            gridBagConstraints.insets = new Insets(n3, n2, 0, 7);
            clPanel.add((Component)jComponent, gridBagConstraints);
            this.m_guiControls.addElement(jComponent);
            if (jLabel != null) {
                gridBagConstraints.insets = new Insets(n3 + 3, 7, 0, 0);
                gridBagConstraints.gridwidth = 0;
                clPanel.add((Component)jLabel, gridBagConstraints);
                this.m_labels.addElement(jLabel);
            }
        }
    }

    void displayField(ClPanel clPanel) throws ClParseException {
        this.displayField(clPanel, 0);
    }

    void displayField(ClPanel clPanel, int n) throws ClParseException {
        ClValues clValues = null;
        ClValues clValues2 = null;
        Enumeration enumeration = this.getChildren();
        if (enumeration.hasMoreElements() || this.m_sngValues != null) {
            ClNode clNode;
            int n2 = 0;
            int n3 = 0;
            if (this.m_sngValues != null) {
                ++n3;
                n2 += this.m_sngValues.getNbrChildren();
            }
            while (enumeration.hasMoreElements()) {
                clNode = (ClNode)enumeration.nextElement();
                if (!(clNode instanceof ClValues)) continue;
                ++n3;
                n2 += clNode.getNbrChildren();
            }
            if (n2 > 0) {
                Object object;
                Object object2;
                Object object3;
                enumeration = this.getChildren();
                ClButtonGroup clButtonGroup = null;
                ClComboBox clComboBox = null;
                int n4 = 0;
                String string = this.getDft();
                if (this.m_startingValue != null) {
                    string = ClSyntax.upperCase(this.getType(), this.m_startingValue);
                }
                boolean bl = this.getRstd() && n2 < 4 && this.getMax() <= 1;
                Vector<String> vector = new Vector<String>(n2);
                while (enumeration.hasMoreElements() || this.m_sngValues != null && n4 == 0) {
                    clNode = this.m_sngValues != null && n4 == 0 ? this.m_sngValues : (ClNode)enumeration.nextElement();
                    if (!(clNode instanceof ClValues)) continue;
                    ++n4;
                    if (bl) {
                        if (n != 0) {
                            n = n3 == n4 && n2 == 1 ? 3 : (n3 == n4 && n2 == 2 ? 2 : 1);
                        }
                        clButtonGroup = ((ClValues)clNode).layoutRadioButtons(clPanel, string, clButtonGroup, this.m_focus, n4 == n3, n);
                        continue;
                    }
                    if (((ClValues)clNode).getNodeType() == 8) {
                        clValues = (ClValues)clNode;
                    }
                    boolean bl2 = false;
                    Vector vector2 = null;
                    if (((ClValues)clNode).getNodeType() == 10) {
                        bl2 = true;
                        vector2 = (Vector)vector.clone();
                        clValues2 = (ClValues)clNode;
                    }
                    object3 = ((ClValues)clNode).getChildren();
                    object2 = new Vector(5);
                    while (object3.hasMoreElements()) {
                        object = (ClNode)object3.nextElement();
                        if (!(object instanceof ClValue)) continue;
                        if (bl2) {
                            if (vector2.contains(((ClValue)object).getVal())) continue;
                            vector.addElement(((ClValue)object).getVal());
                            continue;
                        }
                        vector.addElement(((ClValue)object).getVal());
                    }
                }
                if (clButtonGroup == null) {
                    clComboBox = new ClComboBox((Vector)vector);
                    clComboBox.getEditor().getEditorComponent().setFont(ClPanel.m_scaledFont);
                    clComboBox.setFont(ClPanel.m_scaledFont);
                    clComboBox.setEditable(true);
                    if (this.getLen1() > 0) {
                        Component component = clComboBox.getEditor().getEditorComponent();
                        int n5 = this.getLen1();
                        object = null;
                        if (this.getParent() instanceof ClCmd) {
                            object = (ClCmd)this.getParent();
                            object3 = ((ClCmd)object).getCmdName();
                            object2 = " ";
                            if (this instanceof ClParm) {
                                object2 = ((ClParm)this).getKwd();
                            }
                            AS400 aS400 = ClPanel.m_system;
                            if ((((String)object3).equalsIgnoreCase("CRTUSRPRF") || ((String)object3).equalsIgnoreCase("CHGUSRPRF")) && aS400 != null && ((String)object2).equalsIgnoreCase("PASSWORD")) {
                                SystemValue systemValue = new SystemValue(aS400, "QPWDLVL");
                                Integer n6 = new Integer(-1);
                                try {
                                    n6 = (Integer)systemValue.getValue();
                                }
                                catch (AS400SecurityException aS400SecurityException) {
                                    aS400SecurityException.printStackTrace();
                                }
                                catch (ErrorCompletingRequestException errorCompletingRequestException) {
                                    errorCompletingRequestException.printStackTrace();
                                }
                                catch (InterruptedException interruptedException) {
                                    interruptedException.printStackTrace();
                                }
                                catch (IOException iOException) {
                                    iOException.printStackTrace();
                                }
                                catch (ObjectDoesNotExistException objectDoesNotExistException) {
                                    objectDoesNotExistException.printStackTrace();
                                }
                                catch (RequestNotSupportedException requestNotSupportedException) {
                                    requestNotSupportedException.printStackTrace();
                                }
                                if (n6 == 0 || n6 == 1) {
                                    n5 = 10;
                                }
                            }
                        }
                        if (this.getType() == 12) {
                            n5 *= 2;
                        }
                        ((JTextComponent)component).setDocument(new ClTextFieldLimit(n5, clComboBox, this.getAlwVar(), this));
                    }
                    ClPanel.setComboText(clComboBox, string);
                    clComboBox.getEditor().getEditorComponent().addFocusListener(this.m_focus);
                    if (!(this instanceof ClParm) && !(this instanceof ClElem) || this.getMax() <= 1) {
                        if (this.m_startingValue != null && this.m_startingValue.length() > 0 && this.m_startingValue.charAt(0) != '*' && ClSyntax.stripQuotes(this.m_startingValue, false).length() > this.getLen1() && this.getType() != 1 && this.getType() != 12 && this.getType() != 2 && (this.m_startingValue.length() <= 1 || this.m_startingValue.charAt(0) != 'x' && this.m_startingValue.charAt(0) != 'X' || this.m_startingValue.charAt(1) != '\'') && (this.m_startingValue.length() <= 1 || this.m_startingValue.charAt(0) != '$' && this.m_startingValue.charAt(0) != '&')) {
                            ClNode clNode2 = this;
                            while (!(clNode2 instanceof ClParm)) {
                                clNode2 = clNode2.getParent();
                            }
                            this.m_panel.displayAS400Message(74, (Object)((ClParm)clNode2).getKwd(), (Object)("'" + this.m_startingValue + "'"), (Object)new Integer(this.getLen1()));
                            throw new ClParseException();
                        }
                        this.addComboBox(clPanel, clComboBox, n);
                    }
                } else if (this.getRstd() && this.getMin() == 0 && this.getDft() == null) {
                    clButtonGroup.setExclusive(false);
                }
                ClComboBox clComboBox2 = clComboBox;
                if (clButtonGroup != null) {
                    clComboBox2 = clButtonGroup;
                }
                if (this.getMax() > 1 && (this instanceof ClParm || this instanceof ClElem)) {
                    GridBagConstraints gridBagConstraints = ClPanel.createGridBagConstraints();
                    gridBagConstraints.gridwidth = 0;
                    gridBagConstraints.insets = new Insets(7, 7, 0, 7);
                    object = new ClParmListPanel(clComboBox2, this.getMax(), clValues, clValues2, this);
                    clPanel.add((Component)object, gridBagConstraints);
                    this.m_guiControls.addElement(object);
                } else {
                    this.m_guiControls.addElement(clComboBox2);
                }
                this.addListenersToControl(clComboBox2);
            } else {
                this.displayNameField(clPanel, n);
            }
        } else {
            this.displayNameField(clPanel, n);
        }
    }

    void addComboBox(ClPanel clPanel, JComboBox jComboBox, int n) {
        this.addComboBox(clPanel, jComboBox, n, true);
    }

    void addComboBox(ClPanel clPanel, JComboBox jComboBox, int n, boolean bl) {
        GridBagConstraints gridBagConstraints = ClPanel.createGridBagConstraints();
        JComponent jComponent = null;
        if (n == 0) {
            n = ClPanel.getGridWidth(ClPanel.getColumns(this.getLen1()));
            String string = this.getChoice();
            jComponent = string != null ? new JLabel(string) : new JLabel("");
        }
        if (jComponent != null) {
            jComponent.setFont(ClPanel.m_scaledFont);
        }
        gridBagConstraints.gridwidth = n;
        if (ClPanel.getColumns(this.getLen1()) >= 25) {
            gridBagConstraints.weightx = 100.0;
            gridBagConstraints.fill = 2;
        } else {
            gridBagConstraints.fill = 0;
        }
        int n2 = 7;
        int n3 = 7;
        if (this instanceof ClQual && bl) {
            n3 = 0;
            Dimension dimension = jComboBox.getPreferredSize();
            dimension.width = 120;
            jComboBox.setPreferredSize(dimension);
        } else {
            Dimension dimension = jComboBox.getPreferredSize();
            dimension.width = 120;
            jComboBox.setPreferredSize(dimension);
        }
        gridBagConstraints.insets = new Insets(n3, n2, 0, 7);
        clPanel.add((Component)jComboBox, gridBagConstraints);
        if (jComponent != null) {
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.insets = new Insets(n3 + 3, 7, 0, 0);
            clPanel.add((Component)jComponent, gridBagConstraints);
            this.addLabelElement((JLabel)jComponent);
        }
    }

    void addListenersToControl(Object object) {
        Object object2;
        ClParm clParm = null;
        if (this instanceof ClParm) {
            clParm = (ClParm)this;
        } else {
            object2 = this;
            while (!(object2 instanceof ClParm)) {
                object2 = ((ClNode)object2).getParent();
            }
            clParm = (ClParm)object2;
        }
        if (object instanceof JComboBox) {
            object2 = (JComboBox)object;
            ((JComboBox)object2).addItemListener(clParm);
            Component component = ((JComboBox)object2).getEditor().getEditorComponent();
            component.addFocusListener(clParm);
            component.addKeyListener(clParm);
            component.addMouseListener(new ClFieldMouseHandler(component, m_editMenu));
        } else if (object instanceof ButtonGroup) {
            object2 = ((ButtonGroup)object).getElements();
            JRadioButton jRadioButton = null;
            while (object2.hasMoreElements()) {
                jRadioButton = (JRadioButton)object2.nextElement();
                jRadioButton.addItemListener(clParm);
                jRadioButton.addFocusListener(clParm);
                jRadioButton.addKeyListener(clParm);
            }
        } else if (object instanceof JTextComponent) {
            object2 = (JTextComponent)object;
            ((Component)object2).addFocusListener(clParm);
            ((Component)object2).addKeyListener(clParm);
            ((Component)object2).addMouseListener(new ClFieldMouseHandler((Component)object2, m_editMenu));
        } else if (object instanceof ClTextArea) {
            object2 = ((ClTextArea)object).getTextComponent();
            ((Component)object2).addFocusListener(clParm);
            ((Component)object2).addKeyListener(clParm);
            ((Component)object2).addMouseListener(new ClFieldMouseHandler((JComponent)object, m_editMenu));
        } else {
            MessageLog.logError((Object)("CP: unknown type passed to AddListenersToControl " + object));
        }
    }

    void createListPanel(JComponent jComponent) throws ClParseException {
        GridBagConstraints gridBagConstraints = ClPanel.createGridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(7, 7, 0, 7);
        Enumeration enumeration = this.getChildren();
        ClValues clValues = null;
        ClValues clValues2 = null;
        ClNode clNode = null;
        if (enumeration.hasMoreElements()) {
            while (enumeration.hasMoreElements()) {
                clNode = (ClNode)enumeration.nextElement();
                if (!(clNode instanceof ClValues)) continue;
                if (((ClValues)clNode).getNodeType() == 10) {
                    clValues2 = (ClValues)clNode;
                    continue;
                }
                if (((ClValues)clNode).getNodeType() != 8) continue;
                clValues = (ClValues)clNode;
            }
        }
        ClParmListPanel clParmListPanel = new ClParmListPanel(jComponent, this.getMax(), clValues, clValues2, this);
        this.m_panel.add((Component)clParmListPanel, gridBagConstraints);
        this.m_guiControls.addElement(clParmListPanel);
    }

    void displayQualName(ClPanel clPanel) throws ClParseException {
        this.displayQualName(clPanel, 0);
    }

    void displayQualName(ClPanel clPanel, int n) throws ClParseException {
        ClQualListPanel clQualListPanel = new ClQualListPanel(clPanel, this.getChildren(), this);
        this.m_guiControls.addElement(clQualListPanel);
        Component[] componentArray = clQualListPanel.getComponents();
        if (componentArray.length != 0) {
            GridBagConstraints gridBagConstraints = ClPanel.createGridBagConstraints();
            gridBagConstraints.gridheight = 2;
            JLabel jLabel = new JLabel(" ");
            jLabel.setFont(ClPanel.m_scaledFont);
            clPanel.add((Component)jLabel, gridBagConstraints);
            this.m_labels.addElement(jLabel);
            gridBagConstraints = ClPanel.createGridBagConstraints();
            gridBagConstraints.gridheight = 2;
            jLabel = new JLabel(" ");
            jLabel.setFont(ClPanel.m_scaledFont);
            clPanel.add((Component)jLabel, gridBagConstraints);
            this.m_parmNames.addElement(jLabel);
            gridBagConstraints = ClPanel.createGridBagConstraints();
            GridBagLayout gridBagLayout = (GridBagLayout)clQualListPanel.getLayout();
            int n2 = 0;
            while (n2 < componentArray.length) {
                clPanel.add(componentArray[n2], gridBagLayout.getConstraints(componentArray[n2]));
                ++n2;
            }
        }
    }

    void displayElems(ClPanel clPanel) throws ClParseException {
        this.displayElems(clPanel, 0);
    }

    void displayElems(ClPanel clPanel, int n) throws ClParseException {
        boolean bl = false;
        Enumeration enumeration = this.getChildren();
        if (enumeration.hasMoreElements()) {
            while (enumeration.hasMoreElements()) {
                ClNode clNode = (ClNode)enumeration.nextElement();
                if (!(clNode instanceof ClElem) || ((ClElem)clNode).getMax() <= 1) continue;
                bl = true;
                break;
            }
        }
        boolean bl2 = true;
        if (this instanceof ClElem && n != 0) {
            bl2 = false;
        }
        ClElemListPanel clElemListPanel = new ClElemListPanel(clPanel, this.getChildren(), this, bl, bl2, false);
        this.m_guiControls.addElement(clElemListPanel);
        Component[] componentArray = clElemListPanel.getComponents();
        if (componentArray.length != 0) {
            GridBagConstraints gridBagConstraints = ClPanel.createGridBagConstraints();
            gridBagConstraints.gridheight = 3;
            JLabel jLabel = new JLabel(" ");
            jLabel.setFont(ClPanel.m_scaledFont);
            clPanel.add((Component)jLabel, gridBagConstraints);
            this.m_labels.addElement(jLabel);
            gridBagConstraints = ClPanel.createGridBagConstraints();
            gridBagConstraints.gridheight = 3;
            jLabel = new JLabel(" ");
            jLabel.setFont(ClPanel.m_scaledFont);
            clPanel.add((Component)jLabel, gridBagConstraints);
            this.m_parmNames.addElement(jLabel);
            gridBagConstraints = ClPanel.createGridBagConstraints();
            GridBagLayout gridBagLayout = (GridBagLayout)clElemListPanel.getLayout();
            int n2 = 0;
            while (n2 < componentArray.length) {
                clPanel.add(componentArray[n2], gridBagLayout.getConstraints(componentArray[n2]));
                ++n2;
            }
        }
    }

    ClElemListPanel getElemListPanel() {
        Object var1_1 = null;
        int n = 0;
        while (n < this.m_guiControls.size()) {
            var1_1 = this.m_guiControls.elementAt(n);
            if (var1_1 instanceof ClElemListPanel) {
                return var1_1;
            }
            ++n;
        }
        return null;
    }

    ClQualListPanel getQualListPanel() {
        Object var1_1 = null;
        int n = 0;
        while (n < this.m_guiControls.size()) {
            var1_1 = this.m_guiControls.elementAt(n);
            if (var1_1 instanceof ClQualListPanel) {
                return var1_1;
            }
            ++n;
        }
        return null;
    }

    String getMapToValue(String string) {
        Enumeration enumeration = this.getChildren();
        ClNode clNode = null;
        if (this.m_sngValues != null) {
            string = this.m_sngValues.getMapToValue(string);
        }
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            clNode = (ClNode)enumeration.nextElement();
            if (!(clNode instanceof ClValues)) continue;
            bl = true;
            string = ((ClValues)clNode).getMapToValue(string);
        }
        if (!bl && this instanceof ClParm && this.getType() == 18) {
            enumeration = this.getChildren();
            while (enumeration.hasMoreElements()) {
                clNode = (ClNode)enumeration.nextElement();
                if (!(clNode instanceof ClElem)) continue;
                String string2 = ((ClElem)clNode).getMapToValue(string);
                MessageLog.logError((Object)("CP: mapped: " + string + " to: " + string2));
                return string2;
            }
        }
        return string;
    }

    ClValues getChoicePgmValues() {
        Enumeration enumeration = this.getChildren();
        ClValues clValues = null;
        ClNode clNode = null;
        if (enumeration.hasMoreElements()) {
            while (enumeration.hasMoreElements()) {
                clNode = (ClNode)enumeration.nextElement();
                if (!(clNode instanceof ClValues) || ((ClValues)clNode).getNodeType() != 10) continue;
                clValues = (ClValues)clNode;
            }
        }
        return clValues;
    }

    ClPanel getPanel() {
        return this.m_panel;
    }

    boolean verify() {
        return this.verify(0, false, true);
    }

    boolean verify(int n, boolean bl, boolean bl2) {
        ClCommonLayout clCommonLayout;
        if (!this.m_bVisible && !bl) {
            return true;
        }
        ClPanel clPanel = this.m_panel;
        if (this instanceof ClQual) {
            clCommonLayout = (ClCommonLayout)this.getParent();
            if (this.getPrompt() == null) {
                this.setPrompt(clCommonLayout.getPrompt());
            }
            if (clPanel == null) {
                clPanel = clCommonLayout.getPanel();
            }
        }
        if (this.m_guiControls.size() == 1) {
            clCommonLayout = this.m_guiControls.firstElement();
            if (clCommonLayout instanceof JTextComponent) {
                if (((JTextComponent)((Object)clCommonLayout)).isEnabled()) {
                    return ClSyntax.verifyTextField(clPanel, (JTextComponent)((Object)clCommonLayout), this, n, bl2);
                }
                return true;
            }
            if (clCommonLayout instanceof ClTextArea) {
                if (((ClTextArea)((Object)clCommonLayout)).getTextComponent().isEnabled()) {
                    return ClSyntax.verifyTextField(clPanel, ((ClTextArea)((Object)clCommonLayout)).getTextComponent(), this, n, bl2);
                }
                return true;
            }
            if (clCommonLayout instanceof ButtonGroup) {
                return ClSyntax.verifyRadioButtons(clPanel, (ButtonGroup)((Object)clCommonLayout), this, n, bl2);
            }
            if (clCommonLayout instanceof JComboBox) {
                if (((JComboBox)((Object)clCommonLayout)).isEnabled()) {
                    return ClSyntax.verifyComboBox(clPanel, (JComboBox)((Object)clCommonLayout), this, n, bl2);
                }
                return true;
            }
            if (clCommonLayout instanceof ClParmListPanel) {
                if (((ClParmListPanel)((Object)clCommonLayout)).isEnabled()) {
                    return ((ClParmListPanel)((Object)clCommonLayout)).verify(bl2);
                }
                return true;
            }
            if (clCommonLayout instanceof ClQualListPanel) {
                if (this instanceof ClParm && this.getMin() == 0) {
                    bl2 = false;
                }
                if (((ClQualListPanel)((Object)clCommonLayout)).isEnabled()) {
                    if (!bl2) {
                        return ((ClQualListPanel)((Object)clCommonLayout)).verify(bl2);
                    }
                    return ((ClQualListPanel)((Object)clCommonLayout)).verify(n);
                }
                return true;
            }
            if (clCommonLayout instanceof ClElemListPanel) {
                if (this instanceof ClParm && this.getMin() == 0) {
                    bl2 = false;
                }
                if (((ClElemListPanel)((Object)clCommonLayout)).isEnabled()) {
                    return ((ClElemListPanel)((Object)clCommonLayout)).verify(bl2);
                }
                return true;
            }
        } else {
            MessageLog.logError((Object)("CP: Verify: Invalid amount in common layout " + this.m_guiControls.size()));
        }
        return true;
    }

    boolean assignFocus() {
        if (this.m_guiControls.size() == 0) {
            return false;
        }
        Object var1_1 = null;
        var1_1 = this.m_guiControls.firstElement();
        if (var1_1 != null) {
            if (var1_1 instanceof JComboBox) {
                ClPanel.comboRequestFocus(var1_1);
            } else if (var1_1 instanceof ClTextArea) {
                ((ClTextArea)var1_1).getTextComponent().requestFocus();
            } else if (var1_1 instanceof ButtonGroup) {
                Enumeration<AbstractButton> enumeration = ((ButtonGroup)var1_1).getElements();
                JRadioButton jRadioButton = (JRadioButton)enumeration.nextElement();
                jRadioButton.requestFocus();
            } else if (var1_1 instanceof ClParmListPanel) {
                ((ClParmListPanel)var1_1).assignFocus();
            } else if (var1_1 instanceof ClQualListPanel) {
                ((ClQualListPanel)var1_1).assignFocus();
            } else if (var1_1 instanceof ClElemListPanel) {
                ((ClElemListPanel)var1_1).assignFocus();
            } else {
                ((Component)var1_1).requestFocus();
            }
        }
        return true;
    }

    void addKeyListener(KeyListener keyListener) {
        Object var2_2 = null;
        if (this.m_guiControls.size() > 0) {
            var2_2 = this.m_guiControls.firstElement();
        } else {
            MessageLog.logError((Object)("CP: No controls in: " + this.getPrompt()));
        }
        if (var2_2 != null) {
            if (var2_2 instanceof JComboBox) {
                Component component = ((JComboBox)var2_2).getEditor().getEditorComponent();
                component.addKeyListener(keyListener);
            } else if (var2_2 instanceof ButtonGroup) {
                Enumeration<AbstractButton> enumeration = ((ButtonGroup)var2_2).getElements();
                JRadioButton jRadioButton = null;
                while (enumeration.hasMoreElements()) {
                    jRadioButton = (JRadioButton)enumeration.nextElement();
                    jRadioButton.addKeyListener(keyListener);
                }
            } else if (var2_2 instanceof JTextComponent) {
                ((JTextComponent)var2_2).addKeyListener(keyListener);
            } else if (var2_2 instanceof ClTextArea) {
                ((ClTextArea)var2_2).getTextComponent().addKeyListener(keyListener);
            } else if (var2_2 instanceof ClQualListPanel) {
                ((ClQualListPanel)var2_2).addKeyListener(keyListener);
            } else if (var2_2 instanceof ClElemListPanel) {
                ((ClElemListPanel)var2_2).addKeyListener(keyListener);
            }
        } else {
            MessageLog.logError((Object)"CP: Adding key listener to null component.");
        }
    }

    void addDocumentListener(DocumentListener documentListener) {
        Object var2_2 = null;
        if (this.m_guiControls.size() > 0) {
            var2_2 = this.m_guiControls.firstElement();
        } else {
            MessageLog.logError((Object)("CP: No controls in: " + this.getPrompt()));
        }
        if (var2_2 != null) {
            if (var2_2 instanceof JComboBox) {
                Component component = ((JComboBox)var2_2).getEditor().getEditorComponent();
                ((JTextComponent)component).getDocument().addDocumentListener(documentListener);
            } else if (var2_2 instanceof JTextComponent) {
                ((JTextComponent)var2_2).getDocument().addDocumentListener(documentListener);
            } else if (var2_2 instanceof ClTextArea) {
                ((ClTextArea)var2_2).getTextComponent().getDocument().addDocumentListener(documentListener);
            } else if (var2_2 instanceof ClQualListPanel) {
                ((ClQualListPanel)var2_2).addDocumentListener(documentListener);
            }
        } else {
            MessageLog.logError((Object)"CP: Adding Document listener to null component");
        }
    }

    void addItemListener(ItemListener itemListener) {
        Object var2_2 = null;
        if (this.m_guiControls.size() > 0) {
            var2_2 = this.m_guiControls.firstElement();
        } else {
            MessageLog.logError((Object)("CP: No controls in: " + this.getPrompt()));
        }
        if (var2_2 != null) {
            if (var2_2 instanceof JComboBox) {
                ((JComboBox)var2_2).addItemListener(itemListener);
            } else if (var2_2 instanceof ClQualListPanel) {
                ((ClQualListPanel)var2_2).addItemListener(itemListener);
            } else if (var2_2 instanceof ButtonGroup) {
                Enumeration<AbstractButton> enumeration = ((ButtonGroup)var2_2).getElements();
                JRadioButton jRadioButton = null;
                while (enumeration.hasMoreElements()) {
                    jRadioButton = (JRadioButton)enumeration.nextElement();
                    jRadioButton.addItemListener(itemListener);
                }
            }
        } else {
            MessageLog.logError((Object)"CP: Adding item listener to null component.");
        }
    }

    void refresh() {
        if (this.m_guiControls.size() == 0) {
            return;
        }
        Object e = this.m_guiControls.firstElement();
        if (e != null) {
            if (e instanceof JTextComponent) {
                ((JTextComponent)e).setText(this.getDft());
            } else if (e instanceof ClTextArea) {
                ((ClTextArea)e).getTextComponent().setText(this.getDft());
            } else if (e instanceof JComboBox) {
                ClPanel.setComboText((JComboBox)e, this.getDft());
            } else if (e instanceof ButtonGroup) {
                String string = this.getDft();
                Enumeration<AbstractButton> enumeration = ((ButtonGroup)e).getElements();
                while (enumeration.hasMoreElements()) {
                    JRadioButton jRadioButton = (JRadioButton)enumeration.nextElement();
                    if (!jRadioButton.getActionCommand().equals(string)) continue;
                    ((ButtonGroup)e).setSelected(jRadioButton.getModel(), true);
                    jRadioButton.setSelected(true);
                    return;
                }
                if (string == null) {
                    ((ClButtonGroup)e).deselectButtons();
                }
            } else if (e instanceof ClParmListPanel) {
                ((ClParmListPanel)e).refresh();
            } else if (e instanceof ClQualListPanel) {
                ((ClQualListPanel)e).refresh();
            } else if (e instanceof ClElemListPanel) {
                ((ClElemListPanel)e).refresh();
            } else {
                MessageLog.logError((Object)("CP: Unknown component type in refresh " + e));
            }
        }
    }

    void updateStartingValue(String string) throws ClParseException {
        if (this.m_guiControls.size() == 1) {
            Object e = this.m_guiControls.firstElement();
            if (e instanceof JTextComponent) {
                ((JTextComponent)e).setText(string);
            } else if (e instanceof ClTextArea) {
                ((ClTextArea)e).getTextComponent().setText(string);
            } else if (e instanceof ButtonGroup) {
                Enumeration<AbstractButton> enumeration = ((ButtonGroup)e).getElements();
                while (enumeration.hasMoreElements()) {
                    JRadioButton jRadioButton = (JRadioButton)enumeration.nextElement();
                    if (!jRadioButton.getActionCommand().equals(string)) continue;
                    ((ButtonGroup)e).setSelected(jRadioButton.getModel(), true);
                    jRadioButton.setSelected(true);
                    return;
                }
                if (string == null) {
                    ((ClButtonGroup)e).deselectButtons();
                }
            } else if (e instanceof JComboBox) {
                ClPanel.setComboText((JComboBox)e, string);
            } else if (e instanceof ClParmListPanel) {
                ((ClParmListPanel)e).setStartingValue(string);
            } else if (e instanceof ClQualListPanel) {
                ((ClQualListPanel)e).setStartingValues(string);
            } else if (e instanceof ClElemListPanel) {
                if (this.getMax() > 1) {
                    ((ClElemListPanel)e).setStartingListValues(string);
                } else {
                    ((ClElemListPanel)e).setStartingValue(string);
                }
            }
        }
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 1999";
    }
}

