/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.util;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.data.PcmlException;
import com.ibm.as400.data.ProgramCallDocument;
import com.ibm.as400.ui.framework.java.MessageLog;
import com.ibm.as400.ui.framework.java.PanelManager;
import com.ibm.as400.ui.util.ClCommandException;
import com.ibm.as400.ui.util.ClPanel;
import com.ibm.as400.ui.util.MessageViewer;
import java.awt.Container;

class ClChangeExit {
    private int m_ccsid;
    private String m_command;
    private ClPanel m_panel;

    ClChangeExit() {
        this.m_command = "";
        this.m_ccsid = 0;
    }

    ClChangeExit(String string, ClPanel clPanel) {
        this.m_command = string;
        this.m_panel = clPanel;
    }

    void callProgram() {
        AS400 aS400 = ClPanel.m_system;
        boolean bl = false;
        int[] nArray = new int[1];
        byte[] byArray = new byte[4];
        try {
            MessageLog.logError((Object)"CP: Beginning PCML Call..");
            MessageLog.logError((Object)"CP:    Constructing ProgramCallDocument for QCAPCMD API...");
            ProgramCallDocument programCallDocument = new ProgramCallDocument(aS400, "com.ibm.as400.ui.util.qcapcmd");
            programCallDocument.setValue("qcapcmd.sourceCommand", (Object)this.m_command);
            programCallDocument.setValue("qcapcmd.length", (Object)new Integer(this.m_command.length()));
            MessageLog.logError((Object)"CP:    Calling QCAPCMD API.");
            bl = programCallDocument.callProgram("qcapcmd");
            if (!bl) {
                AS400Message[] aS400MessageArray = programCallDocument.getMessageList("qcapcmd");
                PanelManager panelManager = null;
                try {
                    panelManager = new PanelManager("com.ibm.as400.ui.util.ClMRI", "ADVANCED_BUTTON_PANEL", null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String string = ClPanel.loadString("IDS_MESSAGE_ERROR");
                MessageViewer messageViewer = new MessageViewer(string, panelManager);
                messageViewer.setSystem(ClPanel.m_system);
                messageViewer.addMessages(aS400MessageArray);
                messageViewer.setVisible(true);
                int n = 0;
                while (n < aS400MessageArray.length) {
                    String string2 = aS400MessageArray[n].getID();
                    String string3 = aS400MessageArray[n].getText();
                    MessageLog.logError((Object)("CP:    " + string2 + " - " + string3));
                    ++n;
                }
                MessageLog.logError((Object)"CP: ** Call to QCAPCMD failed. See messages above **");
                return;
            }
            int n = (Integer)programCallDocument.getValue("qcapcmd.plength", new int[]{0});
            int n2 = (Integer)programCallDocument.getValue("qcapcmd.clength", new int[]{0});
            MessageLog.logError((Object)("CP: Buffer size    : " + n));
            MessageLog.logError((Object)("CP: Bytes available: " + n2));
            if (n < n2) {
                programCallDocument.setIntValue("qcapcmd.plength", n2 + 16);
                MessageLog.logError((Object)"CP:    Calling QCDRCMDD API Second Time.");
                bl = programCallDocument.callProgram("qcapcmd");
                if (!bl) {
                    AS400Message[] aS400MessageArray = programCallDocument.getMessageList("qcapcmd");
                    PanelManager panelManager = null;
                    try {
                        panelManager = new PanelManager("com.ibm.as400.ui.util.ClMRI", "ADVANCED_BUTTON_PANEL", null, (Container)this.m_panel);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    String string = ClPanel.loadString("IDS_MESSAGE_ERROR");
                    MessageViewer messageViewer = new MessageViewer(string, panelManager);
                    messageViewer.setSystem(ClPanel.m_system);
                    messageViewer.addMessages(aS400MessageArray);
                    messageViewer.setVisible(true);
                    int n3 = 0;
                    while (n3 < aS400MessageArray.length) {
                        String string4 = aS400MessageArray[n3].getID();
                        String string5 = aS400MessageArray[n3].getText();
                        MessageLog.logError((Object)("CP:    " + string4 + " - " + string5));
                        ++n3;
                    }
                    MessageLog.logError((Object)"CP: ** Call to QCDRCMDD failed. See messages above **");
                    return;
                }
            }
            if (n2 > 0) {
                this.m_command = (String)programCallDocument.getValue("qcapcmd.commandString");
                MessageLog.logError((Object)("CP: change exit string: " + this.m_command));
            }
        }
        catch (PcmlException pcmlException) {
            try {
                this.m_panel.InspectPCMLException(pcmlException);
            }
            catch (ClCommandException clCommandException) {
                return;
            }
            MessageLog.logError((Object)("CP: " + pcmlException.getLocalizedMessage()));
            pcmlException.printStackTrace();
            MessageLog.logError((Object)"CP: *** Call to QPTRTVPO failed. ***");
            return;
        }
    }

    String getCommand() {
        return this.m_command;
    }

    void setCommand(String string) {
        this.m_command = string;
    }

    int getCCSID() {
        return this.m_ccsid;
    }

    void setCCSID(int n) {
        this.m_ccsid = n;
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 1999";
    }
}

