/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.util;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.ui.framework.java.IllegalUserDataException;
import com.ibm.as400.ui.framework.java.MessageLog;
import com.ibm.as400.ui.util.AS400Formatter;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;

public class AS400MessageIdFormatter
extends AS400Formatter {
    static final int EBCDIC_F = -58;
    static final int EBCDIC_f = -122;
    static final int EBCDIC_f_KAT = 103;
    private int m_stringLength = 7;

    public AS400MessageIdFormatter(AS400 aS400) {
        super(aS400);
    }

    public Object parse(String string) throws IllegalUserDataException {
        string = string.trim();
        String string2 = AS400Formatter.m_loader.getString("badAS400MessageId");
        Object[] objectArray = new Object[]{string};
        String string3 = MessageFormat.format(string2, objectArray);
        if (string.length() == 0 || string.length() > this.m_stringLength) {
            throw new IllegalUserDataException(string3);
        }
        byte[] byArray = null;
        try {
            CharConverter charConverter = new CharConverter(this.m_iCCSID, this.m_system);
            byArray = charConverter.stringToByteArray(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            MessageLog.logError((Object)("Converting " + string + " threw an UnsupportedEncodingException: " + unsupportedEncodingException));
            throw new IllegalUserDataException(string3);
        }
        if (string.length() < this.m_stringLength) {
            if (this.m_iWildCardMode != 2) {
                throw new IllegalUserDataException(string3);
            }
            if (!this.containsAsterisk(byArray)) {
                throw new IllegalUserDataException(string3);
            }
        }
        if (!this.isAllowedWildCard(byArray[0], 1 == byArray.length) && !this.isValidEbcdicAlpha(byArray[0], this.m_iCCSID)) {
            throw new IllegalUserDataException(string3);
        }
        int n = 1;
        while (n < byArray.length) {
            if (n < 3 ? !this.isAllowedWildCard(byArray[n], n == byArray.length - 1) && !this.isValidEbcdicAlpha(byArray[n], this.m_iCCSID) && (byArray[n] < -16 || byArray[n] > -7) : !this.isAllowedWildCard(byArray[n], n == byArray.length - 1) && !this.isValidHexCharacter(byArray[n], this.m_iCCSID) && (byArray[n] < -16 || byArray[n] > -7)) {
                throw new IllegalUserDataException(string3);
            }
            ++n;
        }
        return string;
    }

    private boolean containsAsterisk(byte[] byArray) {
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] == 92) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean isValidHexCharacter(byte by, int n) {
        boolean bl = false;
        if (n == 5026 || n == 930 || n == 29) {
            if (by >= -63 && by <= -58 || by >= 98 && by <= 103) {
                bl = true;
            }
        } else if (by >= -63 && by <= -58 || by >= -127 && by <= -122) {
            bl = true;
        }
        return bl;
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 1999";
    }
}

