/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.util;

import com.ibm.as400.access.AS400;
import com.ibm.as400.ui.framework.java.DataFormatter;
import com.ibm.as400.ui.util.ResourceLoader;

public abstract class AS400Formatter
extends DataFormatter {
    static ResourceLoader m_loader = new ResourceLoader();
    public static final int IBM_OBJECT_NAME_MAX_LENGTH = 10;
    public static final int STANDARD_OBJECT_NAME_MAX_LENGTH = 256;
    public static final int NO_WILD_CARDS = 0;
    public static final int ALLOW_TRAILING_WILD_CARD = 1;
    public static final int ALLOW_EMBEDDED_WILD_CARDS = 2;
    int m_iWildCardMode = 0;
    AS400 m_system = null;
    int m_iCCSID = 37;
    static final int EBCDIC_A = -63;
    static final int EBCDIC_I = -55;
    static final int EBCDIC_J = -47;
    static final int EBCDIC_R = -39;
    static final int EBCDIC_S = -30;
    static final int EBCDIC_Z = -23;
    static final int EBCDIC_a = -127;
    static final int EBCDIC_i = -119;
    static final int EBCDIC_j = -111;
    static final int EBCDIC_r = -103;
    static final int EBCDIC_s = -94;
    static final int EBCDIC_z = -87;
    static final int EBCDIC_a_KAT = 98;
    static final int EBCDIC_h_KAT = 105;
    static final int EBCDIC_i_KAT = 113;
    static final int EBCDIC_p_KAT = 120;
    static final int EBCDIC_q_KAT = -117;
    static final int EBCDIC_r_KAT = -101;
    static final int EBCDIC_s_KAT = -85;
    static final int EBCDIC_t_KAT = -77;
    static final int EBCDIC_z_KAT = -71;
    static final int EBCDIC_0 = -16;
    static final int EBCDIC_9 = -7;
    static final int EBCDIC_ATSIGN = 124;
    static final int EBCDIC_NUMBERSIGN = 123;
    static final int EBCDIC_DOLLARSIGN = 91;
    static final int EBCDIC_UNDERSCORE = 109;
    static final int EBCDIC_BLANK = 64;
    static final int EBCDIC_ASTERISK = 92;
    static final int EBCDIC_PERIOD = 75;
    static final int EBCDIC_QUESTIONMARK = 111;
    static final int EBCDIC_SQUOTE = 125;
    static final int EBCDIC_DQUOTE = 127;
    static final int EBCDIC_X00 = 0;
    static final int EBCDIC_X3f = 63;
    static final int EBCDIC_Xff = -1;

    public AS400Formatter(AS400 aS400) {
        this.m_system = aS400;
        if (aS400 != null) {
            this.m_iCCSID = aS400.getCcsid();
        }
    }

    protected boolean isValidEbcdicAlpha(byte by, int n) {
        boolean bl = false;
        if (n == 5026 || n == 930 || n == 29) {
            if (by >= -63 && by <= -55 || by >= -47 && by <= -39 || by >= -30 && by <= -23 || by >= 98 && by <= 105 || by >= 113 && by <= 120 || by == -117 || by == -101 || by == -85 || by >= -77 && by <= -71) {
                bl = true;
            }
        } else if (by >= -63 && by <= -55 || by >= -47 && by <= -39 || by >= -30 && by <= -23 || by >= -127 && by <= -119 || by >= -111 && by <= -103 || by >= -94 && by <= -87) {
            bl = true;
        }
        return bl;
    }

    public int getCCSID() {
        return this.m_iCCSID;
    }

    public void setCCSID(int n) {
        this.m_iCCSID = n;
    }

    public void setWildCardMode(int n) throws IllegalArgumentException {
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException(m_loader.getString("illegalWildCardMode"));
        }
        this.m_iWildCardMode = n;
    }

    public int getWildCardMode() {
        return this.m_iWildCardMode;
    }

    protected boolean isAllowedWildCard(byte by, boolean bl) {
        boolean bl2 = false;
        if (bl && by == 92 && this.m_iWildCardMode != 0) {
            bl2 = true;
        } else if (by == 92 && this.m_iWildCardMode == 2) {
            bl2 = true;
        }
        return bl2;
    }

    void setSystem(AS400 aS400) {
        this.m_system = aS400;
        if (aS400 != null) {
            this.m_iCCSID = aS400.getCcsid();
        }
    }

    AS400 getSystem() {
        return this.m_system;
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 1999";
    }

    static {
        m_loader.setResourceName("com.ibm.as400.ui.util.UTMRI");
    }
}

