/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.unix.packet;

import com.ibm.iseries.debug.DebugConstants;
import com.ibm.iseries.debug.ISeriesMessage;
import com.ibm.iseries.debug.PgmDescriptor;
import com.ibm.iseries.debug.event.PgmEvent;
import com.ibm.iseries.debug.manager.PgmManager;
import com.ibm.iseries.debug.util.CommLink;
import com.ibm.iseries.unix.packet.UnixPacket;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;

public class UnixUpdatePgmPacket
extends UnixPacket
implements DebugConstants {
    private ArrayList m_descriptors;
    private ISeriesMessage m_msgObj;

    public UnixUpdatePgmPacket() {
        super(3008);
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_descriptors.clear();
        this.m_descriptors = null;
        this.m_msgObj = null;
    }

    public void read(CommLink commLink, int n) throws IOException {
        int n2 = commLink.readInt();
        this.m_descriptors = new ArrayList(n2);
        int n3 = 0;
        while (n3 < n2) {
            PgmDescriptor pgmDescriptor = new PgmDescriptor();
            pgmDescriptor.read(commLink);
            this.m_descriptors.add(pgmDescriptor);
            ++n3;
        }
        Collections.sort(this.m_descriptors);
        int n4 = commLink.readInt();
        if (n4 == 1) {
            this.m_msgObj = new ISeriesMessage();
            this.m_msgObj.read(commLink);
        }
    }

    public void run() {
        if (this.m_msgObj == null) {
            PgmDescriptor[] pgmDescriptorArray = new PgmDescriptor[this.m_descriptors.size()];
            int n = 0;
            while (n < pgmDescriptorArray.length) {
                pgmDescriptorArray[n] = (PgmDescriptor)this.m_descriptors.get(n);
                ++n;
            }
            PgmEvent pgmEvent = new PgmEvent(this, 1, pgmDescriptorArray, 0);
            PgmManager pgmManager = (PgmManager)this.m_ctxt.getManager("pgmmgr");
            pgmManager.fireProgramUpdatedEvent(pgmEvent);
            pgmEvent.cleanUp();
        } else {
            this.displayMessage(this.m_msgObj);
        }
        this.cleanUp();
    }
}

