/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.unix.packet;

import com.ibm.iseries.debug.DebugConstants;
import com.ibm.iseries.debug.util.CommLink;
import com.ibm.iseries.unix.packet.UnixPacket;
import java.io.IOException;

public class UnixResetPacket
extends UnixPacket
implements DebugConstants {
    private static final int PGM_EXEC = 1;
    private static final int PGM_FORK = 2;
    private static final int PGM_RESTART = 3;
    private static final int SYNC_DELAYED_ATTACH = 4;
    private int m_reason;

    public UnixResetPacket() {
        super(3004);
    }

    public void read(CommLink commLink, int n) throws IOException {
        this.m_reason = commLink.readInt();
    }

    public void run() {
        switch (this.m_reason) {
            case 1: {
                this.m_ctxt.clear(0);
                if (!this.m_ctxt.hasPartnerContext()) break;
                this.m_ctxt.bringToFront();
                break;
            }
            case 2: {
                this.m_ctxt.clear(0);
                if (!this.m_ctxt.hasPartnerContext() || !this.m_ctxt.isMasterContext()) break;
                this.m_ctxt.removePartnerContext();
                break;
            }
            case 3: {
                this.m_ctxt.clear(8);
                if (!this.m_ctxt.hasPartnerContext() || !this.m_ctxt.isMasterContext()) break;
                this.m_ctxt.removePartnerContext();
                break;
            }
            case 4: {
                if (!this.m_ctxt.hasPartnerContext() || !this.m_ctxt.isSlaveContext()) break;
                this.m_ctxt.allowRunAction(false);
                this.m_ctxt.getPartnerContext().allowRunAction(true);
                this.m_ctxt.getPartnerContext().retractClock();
            }
        }
    }
}

