/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.unix.dialog;

import com.ibm.iseries.debug.PgmDescriptor;
import com.ibm.iseries.debug.dialog.PickFromListDialog;
import com.ibm.iseries.debug.dialog.TokenEditorDialog;
import com.ibm.iseries.debug.manager.SettingsManager;
import com.ibm.iseries.debug.util.DebugWindow;
import com.ibm.iseries.debug.util.Dialog;
import com.ibm.iseries.debug.util.DialogTabPanel;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.Settings;
import com.ibm.iseries.debug.util.Util;
import com.ibm.iseries.unix.dialog.UnixBrowseProcessDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.Serializable;
import java.util.ArrayList;
import javax.accessibility.Accessible;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class UnixStartDebugGeneralPage
extends DialogTabPanel
implements ActionListener,
FocusListener {
    private static final String PGM = "pgm";
    private static final String PARMS = "parms";
    private static final String SUBMIT = "submit";
    private static final String SPECIFY = "specify";
    private static final String LIBPATH = "libpath";
    private static final String ENVVARS = "envvars";
    private static final String CMD = "cmd";
    private static final String PID = "pid";
    private static final String RECENT = "recent";
    private static final String BROWSE = "browse";
    private static final String EDIT_PARMS = "editparms";
    private static final String EDIT_LIBPATH = "editlib";
    private static final String EDIT_ENVVAR = "editenv";
    private static final String USER_KEY_FLAG = "*";
    private static final int TEXT_FIELD_WIDTH = 25;
    private DebugWindow m_wnd;
    private JTabbedPane m_parent;
    private SettingsManager m_settingsMgr;
    private Settings m_userCfg;
    private Settings m_userAliases;
    private JPanel m_panel;
    private JPanel m_boxPanel;
    private JPanel m_infoPanel;
    private JPanel m_methodPanel;
    private JPanel m_pgmPanel;
    private JPanel m_pidPanel;
    private JLabel m_pgmPathLabel;
    private JLabel m_pgmParmsLabel;
    private JLabel m_libPathLabel;
    private JLabel m_envVarsLabel;
    private JLabel m_cmdLabel;
    private JLabel m_pidLabel;
    private JRadioButton m_submitCtrl;
    private JRadioButton m_specifyCtrl;
    private JTextField m_pgmPathCtrl;
    private JTextField m_pgmParmsCtrl;
    private JTextField m_libPathCtrl;
    private JTextField m_envVarsCtrl;
    private JTextField m_cmdCtrl;
    private JTextField m_pidCtrl;
    private JButton m_recentButton;
    private JButton m_browseButton;
    private JButton m_editParmsButton;
    private JButton m_editLibPathButton;
    private JButton m_editEnvButton;
    private String m_pgmPath;
    private String m_pgmParms;
    private String m_libPath;
    private String m_envVars;
    private String m_cmd;
    private String m_pid;
    private boolean m_submitJob;
    private String m_user;

    public UnixStartDebugGeneralPage(DebugWindow debugWindow, JTabbedPane jTabbedPane, SettingsManager settingsManager, String string, String string2, String string3) {
        super(MRI.get("DBG_GENERAL"), 0);
        this.addTopComponents(debugWindow, jTabbedPane, settingsManager, string, string2, string3);
    }

    public UnixStartDebugGeneralPage(DebugWindow debugWindow, JTabbedPane jTabbedPane, SettingsManager settingsManager, String string, String string2) {
        super(MRI.get("DBG_GENERAL"), 0);
        String string3 = "";
        this.addTopComponents(debugWindow, jTabbedPane, settingsManager, string, string2, string3);
    }

    public void addTopComponents(DebugWindow debugWindow, JTabbedPane jTabbedPane, SettingsManager settingsManager, String string, String string2, String string3) {
        this.m_wnd = debugWindow;
        this.m_parent = jTabbedPane;
        this.m_settingsMgr = settingsManager;
        this.m_userCfg = this.m_settingsMgr.getUserConfig();
        this.m_userAliases = this.m_settingsMgr.getUserAliases();
        if (string3.length() > 0) {
            this.m_pid = string3;
            this.m_submitJob = false;
            this.m_pgmPath = "";
            this.m_pgmParms = "";
            this.m_libPath = "";
            this.m_envVars = "";
            this.m_cmd = "";
        } else {
            this.m_pid = this.m_userCfg.getString("strdbgPID", "");
            this.m_submitJob = this.m_userCfg.getBool("strdbgSubmit", true);
            this.m_pgmPath = this.m_userCfg.getString("strdbgPgmPath", "");
            this.m_pgmParms = this.m_userCfg.getString("strdbgPgmParms", "");
            this.m_libPath = this.m_userCfg.getString("strdbgLibPath", "");
            this.m_envVars = this.m_userCfg.getString("strdbgEnvVars", "");
            this.m_cmd = this.m_userCfg.getString("strdbgCmd", "");
        }
        this.m_user = string2;
        this.m_panel = new JPanel(new BorderLayout());
        this.m_boxPanel = new JPanel();
        this.m_infoPanel = new JPanel(new BorderLayout());
        this.m_methodPanel = new JPanel(new GridLayout(0, 1));
        this.m_pgmPanel = new JPanel(new BorderLayout());
        this.m_pidPanel = new JPanel(new BorderLayout());
        this.addComponents(string, string2);
        Dimension dimension = new Dimension(0, 10);
        this.m_boxPanel.setLayout(new BoxLayout(this.m_boxPanel, 1));
        this.m_boxPanel.add(this.m_infoPanel);
        this.m_boxPanel.add(Box.createRigidArea(dimension));
        this.m_boxPanel.add(this.m_methodPanel);
        this.m_boxPanel.add(Box.createRigidArea(dimension));
        this.m_boxPanel.add(this.m_pgmPanel);
        this.m_boxPanel.add(Box.createRigidArea(dimension));
        this.m_boxPanel.add(this.m_pidPanel);
        this.m_boxPanel.add(Box.createRigidArea(dimension));
        this.m_boxPanel.add(Box.createVerticalGlue());
        this.m_boxPanel.setBorder(this.getEmptyBorder(5, 5, 5, 5));
        this.m_panel.add((Component)this.m_boxPanel, "North");
    }

    public void setDefaultFocus() {
        if (this.m_submitJob) {
            this.m_pgmPathCtrl.requestFocus();
            this.m_pgmPathCtrl.selectAll();
        } else {
            this.m_pidCtrl.requestFocus();
            this.m_pidCtrl.selectAll();
        }
    }

    public String getPgmPath() {
        return this.m_submitJob ? this.m_pgmPath : "";
    }

    public String getPgmParms() {
        return this.m_submitJob ? this.m_pgmParms : "";
    }

    public String getLibPath() {
        return this.m_libPath;
    }

    public String getEnvVars() {
        return this.m_envVars;
    }

    public String getCommand() {
        return this.m_submitJob ? this.m_cmd : "";
    }

    public String getPid() {
        return this.m_pid;
    }

    public boolean getSubmit() {
        return this.m_submitJob;
    }

    private void addComponents(String string, String string2) {
        Dimension dimension;
        Serializable serializable;
        ArrayList arrayList = new ArrayList();
        this.createInfoPanel(string, string2, arrayList);
        this.createMethodPanel(arrayList);
        this.createPgmPanel(arrayList);
        this.createPidPanel(arrayList);
        int n = arrayList.size();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            JLabel jLabel = (JLabel)arrayList.get(n3);
            serializable = jLabel.getPreferredSize();
            if (((Dimension)serializable).width > n2) {
                n2 = ((Dimension)serializable).width;
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < n) {
            serializable = (JLabel)arrayList.get(n4);
            dimension = ((JComponent)serializable).getPreferredSize();
            dimension.width = n2;
            ((JComponent)serializable).setPreferredSize(dimension);
            ++n4;
        }
        serializable = this.m_pgmPathCtrl.getPreferredSize();
        dimension = this.m_recentButton.getPreferredSize();
        Dimension dimension2 = this.m_browseButton.getPreferredSize();
        Dimension dimension3 = this.m_editParmsButton.getPreferredSize();
        if (dimension.width < dimension2.width) {
            dimension.width = dimension2.width;
        }
        if (dimension.width < dimension3.width) {
            dimension.width = dimension3.width;
        }
        if (dimension.height - ((Dimension)serializable).height < 10) {
            dimension.height = ((Dimension)serializable).height;
            dimension2.height = ((Dimension)serializable).height;
            dimension3.height = ((Dimension)serializable).height;
        }
        this.m_recentButton.setPreferredSize(dimension);
        this.m_editLibPathButton.setPreferredSize(dimension);
        this.m_editEnvButton.setPreferredSize(dimension);
        this.m_editParmsButton.setPreferredSize(dimension);
        this.m_browseButton.setPreferredSize(dimension);
        this.enablePidControls(!this.m_submitJob);
        this.enablePgmControls(this.m_submitJob);
    }

    private void createInfoPanel(String string, String string2, ArrayList arrayList) {
        JPanel jPanel = new JPanel(new GridLayout(0, 1, 0, 3));
        JPanel jPanel2 = new JPanel(new GridLayout(0, 1, 0, 3));
        JLabel jLabel = Util.getAccessibleLabel(MRI.get("DBG_SYSTEM_LABEL"));
        JLabel jLabel2 = Util.getAccessibleLabel(MRI.get("DBG_USER_LABEL"));
        JLabel jLabel3 = Util.getAccessibleLabel(Util.firstUpper(string));
        JLabel jLabel4 = Util.getAccessibleLabel(Util.firstUpper(string2));
        jPanel.setBorder(this.getEmptyBorder(5, 5, 5, 10));
        jPanel.add(jLabel);
        jPanel.add(jLabel2);
        arrayList.add(jLabel);
        arrayList.add(jLabel2);
        jPanel2.setBorder(this.getEmptyBorder(5, 10, 5, 10));
        jPanel2.add(jLabel3);
        jPanel2.add(jLabel4);
        Util.setAccessible((Accessible)jLabel3, jLabel);
        Util.setAccessible((Accessible)jLabel4, jLabel2);
        Util.setOrientation(jLabel3, jLabel);
        Util.setOrientation(jLabel4, jLabel2);
        this.m_infoPanel.add((Component)jPanel, this.m_isLtoR ? "West" : "East");
        this.m_infoPanel.add((Component)jPanel2, "Center");
    }

    private void createMethodPanel(ArrayList arrayList) {
        String string = MRI.get("DBG_SUBMIT_AND_DEBUG_PROGRAM");
        String string2 = MRI.get("DBG_DEBUG_EXISTING_PROCESS");
        this.m_submitCtrl = new JRadioButton(string);
        this.m_submitCtrl.setSelected(this.m_submitJob);
        this.m_submitCtrl.setActionCommand(SUBMIT);
        this.m_submitCtrl.addActionListener(this);
        this.m_submitCtrl.setHorizontalAlignment(this.m_isLtoR ? 2 : 4);
        this.m_specifyCtrl = new JRadioButton(string2);
        this.m_specifyCtrl.setSelected(!this.m_submitJob);
        this.m_specifyCtrl.setActionCommand(SPECIFY);
        this.m_specifyCtrl.addActionListener(this);
        this.m_specifyCtrl.setHorizontalAlignment(this.m_isLtoR ? 2 : 4);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_submitCtrl);
        buttonGroup.add(this.m_specifyCtrl);
        Util.setAccessible((Accessible)this.m_submitCtrl, string);
        Util.setAccessible((Accessible)this.m_specifyCtrl, string2);
        Util.setOrientation(this.m_submitCtrl);
        Util.setOrientation(this.m_specifyCtrl);
        this.m_methodPanel.setBorder(this.getTitledBorder(MRI.get("DBG_SELECT_METHOD")));
        this.m_methodPanel.add(this.m_submitCtrl);
        this.m_methodPanel.add(this.m_specifyCtrl);
    }

    private void createPgmPanel(ArrayList arrayList) {
        JPanel jPanel = new JPanel(new GridLayout(0, 1, 0, 3));
        JPanel jPanel2 = new JPanel(new GridLayout(0, 1, 0, 3));
        JPanel jPanel3 = new JPanel(new GridLayout(0, 1, 0, 3));
        this.m_pgmPathLabel = Util.getAccessibleLabel(MRI.get("DBG_PROGRAM_LABEL"));
        this.m_pgmParmsLabel = Util.getAccessibleLabel(MRI.get("DBG_PARAMETERS_LABEL"));
        this.m_libPathLabel = Util.getAccessibleLabel(MRI.get("DBG_LIBPATH_LABEL"));
        this.m_envVarsLabel = Util.getAccessibleLabel(MRI.get("DBG_ENVIRONMENT_VARIABLES_LABEL"));
        this.m_cmdLabel = Util.getAccessibleLabel(MRI.get("DBG_INIT_CMD_LABEL"));
        jPanel.setBorder(this.getEmptyBorder(5, 5, 10, 10));
        jPanel.add(this.m_pgmPathLabel);
        jPanel.add(this.m_pgmParmsLabel);
        jPanel.add(this.m_libPathLabel);
        jPanel.add(this.m_envVarsLabel);
        jPanel.add(this.m_cmdLabel);
        arrayList.add(this.m_pgmPathLabel);
        arrayList.add(this.m_pgmParmsLabel);
        arrayList.add(this.m_libPathLabel);
        arrayList.add(this.m_envVarsLabel);
        arrayList.add(this.m_cmdLabel);
        this.m_pgmPathCtrl = new JTextField(this.m_pgmPath, 25);
        this.m_pgmPathCtrl.setActionCommand(PGM);
        this.m_pgmPathCtrl.addActionListener(this);
        this.m_pgmPathCtrl.addFocusListener(this);
        this.m_pgmParmsCtrl = new JTextField(this.m_pgmParms, 25);
        this.m_pgmParmsCtrl.setActionCommand(PARMS);
        this.m_pgmParmsCtrl.addActionListener(this);
        this.m_pgmParmsCtrl.addFocusListener(this);
        this.m_libPathCtrl = new JTextField(this.m_libPath, 25);
        this.m_libPathCtrl.setActionCommand(LIBPATH);
        this.m_libPathCtrl.addActionListener(this);
        this.m_libPathCtrl.addFocusListener(this);
        this.m_envVarsCtrl = new JTextField(this.m_envVars, 25);
        this.m_envVarsCtrl.setActionCommand(ENVVARS);
        this.m_envVarsCtrl.addActionListener(this);
        this.m_envVarsCtrl.addFocusListener(this);
        this.m_cmdCtrl = new JTextField(this.m_cmd, 25);
        this.m_cmdCtrl.setActionCommand(CMD);
        this.m_cmdCtrl.addActionListener(this);
        this.m_cmdCtrl.addFocusListener(this);
        jPanel2.setBorder(this.getEmptyBorder(5, 5, 10, 10));
        jPanel2.add(this.m_pgmPathCtrl);
        jPanel2.add(this.m_pgmParmsCtrl);
        jPanel2.add(this.m_libPathCtrl);
        jPanel2.add(this.m_envVarsCtrl);
        jPanel2.add(this.m_cmdCtrl);
        Insets insets = new Insets(0, 2, 0, 2);
        String string = MRI.get("DBG_RECENT_WITH_ELLIPSIS");
        this.m_recentButton = new JButton(string);
        this.m_recentButton.setActionCommand(RECENT);
        this.m_recentButton.addActionListener(this);
        this.m_recentButton.setMargin(insets);
        if (this.m_settingsMgr.getRecentPgms().size() == 0) {
            this.m_recentButton.setEnabled(false);
        }
        String string2 = MRI.get("DBG_EDIT_WITH_ELLIPSIS");
        this.m_editParmsButton = new JButton(string2);
        this.m_editParmsButton.setActionCommand(EDIT_PARMS);
        this.m_editParmsButton.addActionListener(this);
        this.m_editParmsButton.setMargin(insets);
        this.m_editLibPathButton = new JButton(string2);
        this.m_editLibPathButton.setActionCommand(EDIT_LIBPATH);
        this.m_editLibPathButton.addActionListener(this);
        this.m_editLibPathButton.setMargin(insets);
        this.m_editEnvButton = new JButton(string2);
        this.m_editEnvButton.setActionCommand(EDIT_ENVVAR);
        this.m_editEnvButton.addActionListener(this);
        this.m_editEnvButton.setMargin(insets);
        jPanel3.setBorder(this.getEmptyBorder(5, 0, 10, 10));
        jPanel3.add(this.m_recentButton);
        jPanel3.add(this.m_editParmsButton);
        jPanel3.add(this.m_editLibPathButton);
        jPanel3.add(this.m_editEnvButton);
        jPanel3.add(new JLabel(" "));
        this.m_pgmPanel.setBorder(this.getTitledBorder(MRI.get("DBG_PROGRAM_TO_DEBUG")));
        this.m_pgmPanel.add((Component)jPanel, this.m_isLtoR ? "West" : "East");
        this.m_pgmPanel.add((Component)jPanel2, "Center");
        this.m_pgmPanel.add((Component)jPanel3, this.m_isLtoR ? "East" : "West");
        Util.setAccessible((Accessible)this.m_pgmPathCtrl, this.m_pgmPathLabel);
        Util.setAccessible((Accessible)this.m_pgmParmsCtrl, this.m_pgmParmsLabel);
        Util.setAccessible((Accessible)this.m_libPathCtrl, this.m_libPathLabel);
        Util.setAccessible((Accessible)this.m_envVarsCtrl, this.m_envVarsLabel);
        Util.setAccessible((Accessible)this.m_cmdCtrl, this.m_cmdLabel);
        Util.setAccessible((Accessible)this.m_recentButton, string);
        Util.setAccessible((Accessible)this.m_editParmsButton, string2);
        Util.setAccessible((Accessible)this.m_editEnvButton, string2);
        Util.setOrientation(this.m_pgmPathCtrl, this.m_pgmPathLabel);
        Util.setOrientation(this.m_pgmParmsCtrl, this.m_pgmParmsLabel);
        Util.setOrientation(this.m_libPathCtrl, this.m_libPathLabel);
        Util.setOrientation(this.m_envVarsCtrl, this.m_envVarsLabel);
        Util.setOrientation(this.m_cmdCtrl, this.m_cmdLabel);
        Util.setOrientation(this.m_recentButton);
        Util.setOrientation(this.m_editParmsButton);
        Util.setOrientation(this.m_editEnvButton);
    }

    private void createPidPanel(ArrayList arrayList) {
        JPanel jPanel = new JPanel(new GridLayout(0, 1, 0, 3));
        JPanel jPanel2 = new JPanel(new GridLayout(0, 1, 0, 3));
        JPanel jPanel3 = new JPanel(new GridLayout(0, 1, 0, 3));
        this.m_pidLabel = Util.getAccessibleLabel(MRI.get("DBG_PROCESS_ID_LABEL"));
        jPanel.setBorder(this.getEmptyBorder(5, 5, 10, 10));
        jPanel.add(this.m_pidLabel);
        arrayList.add(this.m_pidLabel);
        this.m_pidCtrl = new JTextField(this.m_pid, 25);
        this.m_pidCtrl.setActionCommand(PID);
        this.m_pidCtrl.addActionListener(this);
        jPanel2.setBorder(this.getEmptyBorder(5, 5, 10, 10));
        jPanel2.add(this.m_pidCtrl);
        String string = MRI.get("DBG_BROWSE_WITH_ELLIPSIS");
        this.m_browseButton = new JButton(string);
        this.m_browseButton.setActionCommand(BROWSE);
        this.m_browseButton.addActionListener(this);
        this.m_browseButton.setMargin(new Insets(0, 0, 0, 0));
        jPanel3.setBorder(this.getEmptyBorder(5, 0, 10, 10));
        jPanel3.add(this.m_browseButton);
        Util.setAccessible((Accessible)this.m_pidCtrl, this.m_pidLabel);
        Util.setAccessible((Accessible)this.m_browseButton, string);
        Util.setOrientation(this.m_pidCtrl, this.m_pidLabel);
        Util.setOrientation(this.m_browseButton);
        this.m_pidPanel.setBorder(this.getTitledBorder(MRI.get("DBG_PROCESS_TO_DEBUG")));
        this.m_pidPanel.add((Component)jPanel, this.m_isLtoR ? "West" : "East");
        this.m_pidPanel.add((Component)jPanel2, "Center");
        this.m_pidPanel.add((Component)jPanel3, this.m_isLtoR ? "East" : "West");
    }

    private void enablePidControls(boolean bl) {
        this.m_pidLabel.setEnabled(bl);
        this.m_pidCtrl.setEnabled(bl);
        this.m_pidCtrl.setOpaque(bl);
        this.m_browseButton.setEnabled(bl);
    }

    private void enablePgmControls(boolean bl) {
        this.m_pgmPathLabel.setEnabled(bl);
        this.m_pgmPathCtrl.setEnabled(bl);
        this.m_pgmPathCtrl.setOpaque(bl);
        this.m_pgmParmsLabel.setEnabled(bl);
        this.m_pgmParmsCtrl.setEnabled(bl);
        this.m_pgmParmsCtrl.setOpaque(bl);
        this.m_libPathLabel.setEnabled(bl);
        this.m_libPathCtrl.setEnabled(bl);
        this.m_libPathCtrl.setOpaque(bl);
        this.m_envVarsLabel.setEnabled(bl);
        this.m_envVarsCtrl.setEnabled(bl);
        this.m_envVarsCtrl.setOpaque(bl);
        this.m_cmdLabel.setEnabled(bl);
        this.m_cmdCtrl.setEnabled(bl);
        this.m_cmdCtrl.setOpaque(bl);
        this.m_recentButton.setEnabled(bl);
        this.m_editParmsButton.setEnabled(bl);
        this.m_editEnvButton.setEnabled(bl);
    }

    private void doRecent() {
        Object object;
        ArrayList arrayList = this.m_settingsMgr.getRecentPgms();
        int n = arrayList.size();
        if (n == 0) {
            this.m_recentButton.setEnabled(false);
            return;
        }
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            object = (PgmDescriptor)arrayList.get(n2);
            stringArray[n2] = ((PgmDescriptor)object).getPgmPath();
            ++n2;
        }
        object = new PickFromListDialog(this.getDialog(), MRI.get("DBG_RECENT_PGM_DIALOG_TITLE"), MRI.get("DBG_SELECT_PGM_LABEL"), MRI.get("DBG_OK"), null, stringArray, 0);
        ((PickFromListDialog)object).setSingleSelect();
        ((Dialog)object).display();
        if (!((Dialog)object).wasCanceled()) {
            int n3 = ((PickFromListDialog)object).getSelectedIndex();
            PgmDescriptor pgmDescriptor = (PgmDescriptor)arrayList.get(n3);
            this.m_pgmPathCtrl.setText(pgmDescriptor.getPgmPath());
            this.m_pgmParmsCtrl.setText(pgmDescriptor.getPgmParms());
        }
    }

    private void doEditParms() {
        String string = this.m_pgmParmsCtrl.getText().trim();
        String string2 = " '";
        char c = ' ';
        String string3 = MRI.get("DBG_PARAMETERS_LABEL");
        TokenEditorDialog tokenEditorDialog = new TokenEditorDialog(this.getDialog(), MRI.get("DBG_EDIT_PARMS_DIALOG_TITLE"), string3, MRI.get("DBG_ENTER_PARM_LABEL"), string, string2, c);
        tokenEditorDialog.display();
        if (!tokenEditorDialog.wasCanceled()) {
            this.m_pgmParms = tokenEditorDialog.getTokenString();
            this.m_pgmParmsCtrl.setText(this.m_pgmParms);
        }
    }

    private void doEditLibPath() {
        String string = this.m_libPathCtrl.getText().trim();
        String string2 = ":";
        char c = ':';
        String string3 = MRI.get("DBG_LIBPATH_LABEL");
        TokenEditorDialog tokenEditorDialog = new TokenEditorDialog(this.getDialog(), MRI.get("DBG_EDIT_PATH_DIALOG_TITLE"), string3, MRI.get("DBG_ENTER_NEW_PATH_LABEL"), string, string2, c);
        tokenEditorDialog.display();
        if (!tokenEditorDialog.wasCanceled()) {
            this.m_libPath = tokenEditorDialog.getTokenString();
            this.m_libPathCtrl.setText(this.m_libPath);
        }
    }

    private void doEditEnvVars() {
        String string = this.m_envVarsCtrl.getText().trim();
        String string2 = " ";
        char c = ' ';
        String string3 = MRI.get("DBG_ENVIRONMENT_VARIABLES_LABEL");
        TokenEditorDialog tokenEditorDialog = new TokenEditorDialog(this.getDialog(), MRI.get("DBG_EDIT_ENVVAR_DIALOG_TITLE"), string3, MRI.get("DBG_ENTER_ENVVAR_LABEL"), string, string2, c);
        tokenEditorDialog.display();
        if (!tokenEditorDialog.wasCanceled()) {
            this.m_envVars = tokenEditorDialog.getTokenString();
            this.m_envVarsCtrl.setText(this.m_envVars);
        }
    }

    private void doBrowse() {
        this.postClock();
        UnixBrowseProcessDialog unixBrowseProcessDialog = new UnixBrowseProcessDialog(this.m_wnd, this.getDialog(), this.m_settingsMgr, this.m_user);
        unixBrowseProcessDialog.display(this.m_wnd);
        if (!unixBrowseProcessDialog.wasCanceled()) {
            this.m_pidCtrl.setText(unixBrowseProcessDialog.getPID());
        }
        this.retractClock();
    }

    public JComponent getComponent() {
        return this.m_panel;
    }

    public void cleanUp() {
        this.m_settingsMgr = null;
        this.m_userCfg = null;
        this.m_panel = null;
        this.m_boxPanel = null;
        this.m_infoPanel = null;
        this.m_methodPanel = null;
        this.m_pgmPanel = null;
        this.m_pidPanel = null;
        this.m_pgmPathLabel = null;
        this.m_pgmParmsLabel = null;
        this.m_libPathLabel = null;
        this.m_envVarsLabel = null;
        this.m_cmdLabel = null;
        this.m_pidLabel = null;
        this.m_submitCtrl = null;
        this.m_specifyCtrl = null;
        this.m_pgmPathCtrl = null;
        this.m_pgmParmsCtrl = null;
        this.m_libPathCtrl = null;
        this.m_envVarsCtrl = null;
        this.m_cmdCtrl = null;
        this.m_pidCtrl = null;
        this.m_recentButton = null;
        this.m_browseButton = null;
        this.m_editParmsButton = null;
        this.m_editLibPathButton = null;
        this.m_editEnvButton = null;
    }

    public boolean doOk() {
        String string = this.m_pgmPathCtrl.getText().trim();
        String string2 = this.m_pgmParmsCtrl.getText().trim();
        String string3 = string2.startsWith(USER_KEY_FLAG) ? this.m_userAliases.getString(string2.substring(1), string2) : string2;
        string2 = this.m_libPathCtrl.getText().trim();
        String string4 = string2.startsWith(USER_KEY_FLAG) ? this.m_userAliases.getString(string2.substring(1), string2) : string2;
        string2 = this.m_envVarsCtrl.getText().trim();
        String string5 = string2.startsWith(USER_KEY_FLAG) ? this.m_userAliases.getString(string2.substring(1), string2) : string2;
        string2 = this.m_cmdCtrl.getText().trim();
        String string6 = string2.startsWith(USER_KEY_FLAG) ? this.m_userAliases.getString(string2.substring(1), string2) : string2;
        String string7 = this.m_pidCtrl.getText().trim();
        boolean bl = this.m_submitCtrl.isSelected();
        boolean bl2 = false;
        if (bl) {
            if (string.length() > 0) {
                this.m_pid = "";
                bl2 = true;
            }
        } else if (string7.length() > 0) {
            this.m_pid = string7;
            bl2 = true;
        }
        if (bl2) {
            this.m_pgmPath = string;
            this.m_pgmParms = string3;
            this.m_libPath = string4;
            this.m_envVars = string5;
            this.m_cmd = string6;
            this.m_submitJob = bl;
            this.m_userCfg.setString("strdbgPgmPath", this.m_pgmPath);
            this.m_userCfg.setString("strdbgPgmParms", this.m_pgmParms);
            this.m_userCfg.setString("strdbgLibPath", this.m_libPath);
            this.m_userCfg.setString("strdbgEnvVars", this.m_envVars);
            this.m_userCfg.setString("strdbgCmd", this.m_cmd);
            this.m_userCfg.setString("strdbgPID", this.m_pid);
            this.m_userCfg.setBool("strdbgSubmit", this.m_submitJob);
        } else if (bl) {
            this.m_parent.setSelectedComponent(this.getComponent());
            this.m_pgmPathCtrl.requestFocus();
            this.getDialog().getToolkit().beep();
        } else {
            this.m_parent.setSelectedComponent(this.getComponent());
            this.m_pidCtrl.requestFocus();
            this.getDialog().getToolkit().beep();
        }
        return bl2;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(PGM) || string.equals(PARMS) || string.equals(LIBPATH) || string.equals(ENVVARS) || string.equals(CMD) || string.equals(PID)) {
            this.getDialog().doOk();
        } else if (string.equals(SUBMIT)) {
            this.m_submitJob = true;
            this.enablePidControls(!this.m_submitJob);
            this.enablePgmControls(this.m_submitJob);
        } else if (string.equals(SPECIFY)) {
            this.m_submitJob = false;
            this.enablePidControls(!this.m_submitJob);
            this.enablePgmControls(this.m_submitJob);
        } else if (string.equals(RECENT)) {
            this.doRecent();
        } else if (string.equals(BROWSE)) {
            this.doBrowse();
        } else if (string.equals(EDIT_PARMS)) {
            this.doEditParms();
        } else if (string.equals(EDIT_LIBPATH)) {
            this.doEditLibPath();
        } else if (string.equals(EDIT_ENVVAR)) {
            this.doEditEnvVars();
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        Component component;
        String string;
        if (!focusEvent.isTemporary() && (string = ((JTextField)(component = focusEvent.getComponent())).getText().trim()).startsWith(USER_KEY_FLAG)) {
            ((JTextField)component).setText(this.m_userAliases.getString(string.substring(1), string));
        }
    }
}

