/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.unix.dialog;

import com.ibm.iseries.debug.memory.MemoryAddrControl;
import com.ibm.iseries.debug.memory.MemoryAddrEditListener;
import com.ibm.iseries.debug.memory.MemoryAddress;
import com.ibm.iseries.debug.util.DebugContext;
import com.ibm.iseries.debug.util.Dialog;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class UnixAddressDialog
extends Dialog
implements MemoryAddrEditListener {
    private JPanel m_panel;
    private JPanel m_basePanel;
    private MemoryAddrControl m_addrCtrl;
    private MemoryAddress m_lowBound;
    private MemoryAddress m_hiBound;
    private MemoryAddress m_addr;

    public UnixAddressDialog(DebugContext debugContext, String string, String string2) {
        this(debugContext, string, string2, null, null);
    }

    public UnixAddressDialog(DebugContext debugContext, String string, String string2, MemoryAddress memoryAddress, MemoryAddress memoryAddress2) {
        super(debugContext.getJFrame(), string, true, "");
        this.m_lowBound = memoryAddress;
        this.m_hiBound = memoryAddress2;
        this.m_panel = new JPanel(new BorderLayout());
        this.m_panel.setBorder(this.getEmptyBorder(15, 15, 15, 15));
        this.listenForEscape(this.m_panel);
        this.m_basePanel = new JPanel(null);
        this.m_basePanel.setLayout(new BoxLayout(this.m_basePanel, 1));
        JLabel jLabel = Util.getAccessibleLabel(string2);
        jLabel.setAlignmentX(MRI.isLtoR() ? 0.0f : 1.0f);
        Util.setOrientation(jLabel);
        this.m_addrCtrl = this.m_lowBound != null ? new MemoryAddrControl(this.m_lowBound, debugContext.getAddrOffsetSizeInBits()) : new MemoryAddrControl(debugContext.getAddrSizeInBits(), debugContext.getAddrOffsetSizeInBits());
        this.m_addrCtrl.appendAddress(this.m_hiBound);
        this.m_addrCtrl.setAlignmentX(MRI.isLtoR() ? 0.0f : 1.0f);
        Dimension dimension = this.m_addrCtrl.getPreferredSize();
        this.m_addrCtrl.setMaximumSize(dimension);
        this.m_addrCtrl.setEditListener(this);
        this.m_addrCtrl.enableCancel(false);
        this.m_basePanel.add(jLabel);
        this.m_basePanel.add(Box.createRigidArea(new Dimension(10, 3)));
        this.m_basePanel.add(this.m_addrCtrl);
        this.m_basePanel.add(Box.createVerticalGlue());
        this.m_panel.add((Component)this.m_basePanel, "North");
        this.m_panel.add((Component)this.defaultButtons(MRI.get("DBG_OK"), true, false), "South");
        this.setContentPane(this.m_panel);
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_addrCtrl.cleanUp();
        this.m_panel = null;
        this.m_basePanel = null;
        this.m_addrCtrl = null;
    }

    public MemoryAddress getAddress() {
        return this.m_addr;
    }

    public void doOk() {
        int n;
        if (this.m_addrCtrl.isEditing()) {
            this.m_addrCtrl.acceptEdit();
        }
        this.m_addr = this.m_addrCtrl.getAddress();
        if (this.m_lowBound != null && (n = this.m_addr.compareTo(this.m_lowBound)) < 0) {
            this.getToolkit().beep();
            return;
        }
        if (this.m_hiBound != null && (n = this.m_addr.compareTo(this.m_hiBound)) > 0) {
            this.getToolkit().beep();
            return;
        }
        this.setCanceled(false);
        this.dispose();
    }

    public void addressEditInitiated(MemoryAddrControl memoryAddrControl) {
    }

    public void addressEditCommitted(MemoryAddrControl memoryAddrControl) {
        if (memoryAddrControl.enterWasPressed()) {
            this.doOk();
        }
    }

    public void addressEditAborted(MemoryAddrControl memoryAddrControl) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        String string = actionEvent.getActionCommand();
        if (string.equals("doit")) {
            this.doOk();
        }
    }
}

