/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.unix;

import com.ibm.iseries.debug.util.CommLink;
import com.ibm.iseries.debug.util.RequestPacketElement;
import com.ibm.iseries.debug.util.Util;
import java.io.IOException;

public class UnixProcessDescriptor
implements RequestPacketElement,
Comparable {
    public static final int SORT_USER = 0;
    public static final int SORT_PID = 1;
    public static final int SORT_PPID = 2;
    public static final int SORT_CMD = 3;
    private static int s_sortMode = 0;
    private String m_user;
    private String m_pid;
    private String m_ppid;
    private String m_cmd;

    public static int getSortMode() {
        return s_sortMode;
    }

    public static void setSortMode(int n) {
        s_sortMode = n;
    }

    public String getUser() {
        return this.m_user;
    }

    public String getPID() {
        return this.m_pid;
    }

    public String getPPID() {
        return this.m_ppid;
    }

    public String getCmd() {
        return this.m_cmd;
    }

    public void read(CommLink commLink) throws IOException {
        this.m_user = commLink.readString();
        this.m_pid = commLink.readString();
        this.m_ppid = commLink.readString();
        this.m_cmd = commLink.readString();
        this.m_user = Util.firstUpper(this.m_user);
    }

    public int writeSize(CommLink commLink) {
        int n = 0;
        n += commLink.writeSize(this.m_user);
        n += commLink.writeSize(this.m_pid);
        n += commLink.writeSize(this.m_ppid);
        return n += commLink.writeSize(this.m_cmd);
    }

    public void write(CommLink commLink) throws IOException {
        commLink.writeString(this.m_user);
        commLink.writeString(this.m_pid);
        commLink.writeString(this.m_ppid);
        commLink.writeSize(this.m_cmd);
    }

    public int compareAsInt(String string, String string2) {
        int n;
        int n2 = Integer.parseInt(string);
        if (n2 < (n = Integer.parseInt(string2))) {
            return -1;
        }
        if (n2 > n) {
            return 1;
        }
        return 0;
    }

    public int compareTo(Object object) {
        if (object instanceof UnixProcessDescriptor) {
            UnixProcessDescriptor unixProcessDescriptor = (UnixProcessDescriptor)object;
            switch (s_sortMode) {
                case 0: {
                    if (!this.m_user.equals(unixProcessDescriptor.m_user)) {
                        return this.m_user.compareTo(unixProcessDescriptor.m_user);
                    }
                    return this.compareAsInt(this.m_pid, unixProcessDescriptor.m_pid);
                }
                case 1: {
                    return this.compareAsInt(this.m_pid, unixProcessDescriptor.m_pid);
                }
                case 2: {
                    int n = this.compareAsInt(this.m_ppid, unixProcessDescriptor.m_ppid);
                    if (n == 0) {
                        if (!this.m_user.equals(unixProcessDescriptor.m_user)) {
                            return this.m_user.compareTo(unixProcessDescriptor.m_user);
                        }
                        this.compareAsInt(this.m_pid, unixProcessDescriptor.m_pid);
                    }
                    return n;
                }
                case 3: {
                    if (!this.m_cmd.equals(unixProcessDescriptor.m_cmd)) {
                        return this.m_cmd.compareTo(unixProcessDescriptor.m_cmd);
                    }
                    if (!this.m_user.equals(unixProcessDescriptor.m_user)) {
                        return this.m_user.compareTo(unixProcessDescriptor.m_user);
                    }
                    return this.compareAsInt(this.m_pid, unixProcessDescriptor.m_pid);
                }
            }
        }
        return this.toString().compareTo(object.toString());
    }
}

