/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debugmanager.packet;

import com.ibm.iseries.debug.IleDebugContext;
import com.ibm.iseries.debug.util.CommLink;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.Util;
import com.ibm.iseries.debugmanager.DebugManager;
import com.ibm.iseries.debugmanager.packet.DebugManagerPacket;
import com.ibm.iseries.pase.PaseDebugContext;
import java.io.IOException;
import java.text.MessageFormat;

public class GraphicalDebugPacket
extends DebugManagerPacket {
    private String m_user = "";
    private String m_jobId = "";
    private String m_system = "";

    public GraphicalDebugPacket() {
        super(1001);
    }

    public void read(CommLink commLink, int n) throws IOException {
        this.m_user = commLink.readString();
        this.m_jobId = commLink.readString();
        this.m_system = commLink.getSystem();
        if (this.m_jobId.indexOf(47) >= 0) {
            this.m_jobId = Util.firstUpperJobId(this.m_jobId);
        }
    }

    public void run() {
        DebugManager.instance().postClock();
        if (this.m_jobId.indexOf(47) >= 0) {
            Object[] objectArray = new Object[]{this.m_jobId};
            String string = MessageFormat.format(MRI.get("DBGMGR_START_DEBUG_ISSUED_FMT"), objectArray);
            DebugManager.instance().logMsg(string);
            DebugManager.instance().logMsg(MRI.get("DBGMGR_STARTING_DEBUGGER"));
            String[] stringArray = new String[]{"-s", this.m_system, "-u", this.m_user, "-j", this.m_jobId, "-p", "        "};
            IleDebugContext ileDebugContext = IleDebugContext.createIleDebugger(stringArray);
            ileDebugContext.bringToFront();
        } else {
            DebugManager.instance().logMsg(MRI.get("DBGMGR_STARTING_DEBUGGER"));
            String[] stringArray = new String[]{"-system", this.m_system, "-user", this.m_user, "-pid", this.m_jobId, "-reatt", "    "};
            PaseDebugContext paseDebugContext = PaseDebugContext.createPaseDebugger(stringArray);
            paseDebugContext.bringToFront();
        }
        DebugManager.instance().retractClock();
    }
}

