/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debugmanager.action;

import com.ibm.iseries.debug.DebugConstants;
import com.ibm.iseries.debug.IleDebugContext;
import com.ibm.iseries.debug.PgmDescriptor;
import com.ibm.iseries.debug.dialog.PickFromListDialog;
import com.ibm.iseries.debug.dialog.StartDebugDialog;
import com.ibm.iseries.debug.util.Action;
import com.ibm.iseries.debug.util.DebugWindow;
import com.ibm.iseries.debug.util.Dialog;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.Settings;
import com.ibm.iseries.debugmanager.DebugManager;
import javax.swing.SwingUtilities;

public class DebugManagerStartDebugAction
extends Action
implements DebugConstants {
    public static final String KEY = "strdbg2";
    public static final String GIF = "/com/ibm/iseries/debug/dbg031.gif";

    public DebugManagerStartDebugAction() {
        super(KEY, MRI.get("DBGMGR_START_DEBUG_MENU"), MRI.getIcon(0, GIF), 115, 0, false);
    }

    public void run() {
        Object object;
        DebugManager debugManager = DebugManager.instance();
        String string = debugManager.getActionGroup().m_system;
        String[] stringArray = debugManager.getActionGroup().m_users;
        if (string == null || stringArray == null) {
            return;
        }
        String string2 = "";
        if (stringArray.length > 1) {
            object = new PickFromListDialog(debugManager, MRI.get("DBGMGR_SELECT_USER_DIALOG_TITLE"), MRI.get("DBGMGR_SELECT_USER_LABEL"), MRI.get("DBG_OK"), null, stringArray, 0);
            ((PickFromListDialog)object).setSingleSelect();
            ((Dialog)object).display(debugManager);
            if (((Dialog)object).wasCanceled()) {
                return;
            }
            string2 = stringArray[((PickFromListDialog)object).getSelectedIndex()];
            debugManager.getActionGroup().setUser(string2);
        } else if (stringArray.length > 0) {
            string2 = stringArray[0];
        }
        object = debugManager.getUserConfig();
        int n = ((Settings)object).getInt("strdbgPgmType", 0);
        StartDebugDialog startDebugDialog = new StartDebugDialog((DebugWindow)debugManager, debugManager.getSettingsManager(), n, string, string2, "dbgstrdbg");
        startDebugDialog.display(debugManager);
        if (!startDebugDialog.wasCanceled()) {
            debugManager.refresh();
            debugManager.postClock();
            debugManager.logMsg(MRI.get("DBGMGR_STARTING_DEBUGGER"));
            SwingUtilities.invokeLater(new DebuggerInvoker(startDebugDialog, string, string2));
        }
    }

    private class DebuggerInvoker
    implements Runnable {
        private StartDebugDialog m_dialog = null;
        private String m_system = null;
        private String m_user = null;

        public DebuggerInvoker(StartDebugDialog startDebugDialog, String string, String string2) {
            this.m_dialog = startDebugDialog;
            this.m_system = string;
            this.m_user = string2;
        }

        public void run() {
            String string = this.m_dialog.getPgmLibrary();
            String string2 = this.m_dialog.getPgmName();
            int n = this.m_dialog.getPgmType();
            String string3 = this.m_dialog.getPgmParms();
            String string4 = this.m_dialog.getCommand();
            String string5 = this.m_dialog.getJobId();
            String string6 = this.m_dialog.getClassPath();
            String string7 = this.m_dialog.getHostSourcePath();
            String string8 = this.m_dialog.getClientSourcePath();
            int n2 = 4;
            String string9 = "";
            if (string.length() > 0 || string2.length() > 0) {
                string9 = PgmDescriptor.getPgmPath(string, string2, n);
            }
            if (string5.length() > 0) {
                n2 += 2;
            }
            if (string9.length() > 0) {
                n2 += 2;
            }
            if (string4.length() > 0) {
                n2 += 2;
            }
            if (string6.length() > 0) {
                n2 += 2;
            }
            if (string7.length() > 0) {
                n2 += 2;
            }
            if (string8.length() > 0) {
                n2 += 2;
            }
            if (string3.length() > 0) {
                n2 += 2;
            }
            String[] stringArray = new String[n2];
            int n3 = 0;
            stringArray[n3++] = "-s";
            stringArray[n3++] = this.m_system;
            stringArray[n3++] = "-u";
            stringArray[n3++] = this.m_user;
            if (string5.length() > 0) {
                stringArray[n3++] = "-j";
                stringArray[n3++] = string5;
            }
            if (string9.length() > 0) {
                stringArray[n3++] = "-p";
                stringArray[n3++] = string9;
            }
            if (string4.length() > 0) {
                stringArray[n3++] = "-command";
                stringArray[n3++] = string4;
            }
            if (string6.length() > 0) {
                stringArray[n3++] = "-c";
                stringArray[n3++] = string6;
            }
            if (string7.length() > 0) {
                stringArray[n3++] = "-sourcepath";
                stringArray[n3++] = string7;
            }
            if (string8.length() > 0) {
                stringArray[n3++] = "-clientsourcepath";
                stringArray[n3++] = string8;
            }
            if (string3.length() > 0) {
                stringArray[n3++] = "-parms";
                stringArray[n3++] = string3;
            }
            IleDebugContext.createIleDebugger(stringArray);
            DebugManager.instance().retractClock();
        }
    }
}

