/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.util;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.plaf.ColorUIResource;

public class Settings {
    protected String m_comment = "";
    protected Properties m_prop = null;
    protected File m_file = null;

    public Settings(InputStream inputStream) throws IOException {
        this.m_prop = new Properties();
        this.m_prop.load(inputStream);
    }

    public Settings(String string, String string2) {
        this.m_comment = string2;
        this.m_prop = new Properties();
        this.m_file = new File(System.getProperty("user.home"), string);
    }

    public Settings(String string, String string2, String string3) {
        this.m_comment = string3;
        this.m_prop = new Properties();
        this.m_file = new File(string, string2);
    }

    public boolean load() {
        boolean bl = false;
        try {
            if (this.m_file.exists() && this.m_file.canRead()) {
                FileInputStream fileInputStream = new FileInputStream(this.m_file);
                this.m_prop.load(fileInputStream);
                fileInputStream.close();
                bl = true;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return bl;
    }

    public boolean commit() {
        boolean bl = false;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.m_file);
            this.m_prop.store(fileOutputStream, this.m_comment);
            fileOutputStream.close();
            bl = true;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return bl;
    }

    public boolean contains(String string) {
        return ((Hashtable)this.m_prop).containsKey(string);
    }

    public void remove(String string) {
        ((Hashtable)this.m_prop).remove(string);
    }

    public boolean getBool(String string, boolean bl) {
        String string2 = this.m_prop.getProperty(string);
        if (string2 == null) {
            return bl;
        }
        Boolean bl2 = Boolean.valueOf(string2);
        return bl2;
    }

    public double getDouble(String string, double d) {
        String string2 = this.m_prop.getProperty(string);
        if (string2 == null) {
            return d;
        }
        Double d2 = Double.valueOf(string2);
        return d2;
    }

    public int getInt(String string, int n) {
        String string2 = this.m_prop.getProperty(string);
        if (string2 == null) {
            return n;
        }
        Integer n2 = Integer.valueOf(string2);
        return n2;
    }

    public String getString(String string, String string2) {
        String string3 = this.m_prop.getProperty(string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    public ColorUIResource getColor(String string, Color color) {
        String string2 = this.m_prop.getProperty(string);
        if (string2 == null) {
            return new ColorUIResource(color);
        }
        ColorUIResource colorUIResource = null;
        try {
            colorUIResource = new ColorUIResource(Color.decode(string2));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            colorUIResource = new ColorUIResource(color);
        }
        return colorUIResource;
    }

    public void setBool(String string, boolean bl) {
        Boolean bl2 = new Boolean(bl);
        String string2 = bl2.toString();
        ((Hashtable)this.m_prop).put(string, string2);
    }

    public void setDouble(String string, double d) {
        Double d2 = new Double(d);
        String string2 = d2.toString();
        ((Hashtable)this.m_prop).put(string, string2);
    }

    public void setInt(String string, int n) {
        Integer n2 = new Integer(n);
        String string2 = n2.toString();
        ((Hashtable)this.m_prop).put(string, string2);
    }

    public void setString(String string, String string2) {
        ((Hashtable)this.m_prop).put(string, string2);
    }

    public void setColor(String string, Color color) {
        String string2 = Integer.toHexString(color.getRed());
        String string3 = Integer.toHexString(color.getGreen());
        String string4 = Integer.toHexString(color.getBlue());
        StringBuffer stringBuffer = new StringBuffer(20);
        stringBuffer.append('#');
        if (string2.length() == 1) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string2);
        if (string3.length() == 1) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string3);
        if (string4.length() == 1) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string4);
        ((Hashtable)this.m_prop).put(string, stringBuffer.toString());
    }
}

