/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.util;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.iseries.debug.dialog.SignonDialog;
import com.ibm.iseries.debug.util.CommLink;
import com.ibm.iseries.debug.util.DebugFile;
import com.ibm.iseries.debug.util.DebugWindow;
import com.ibm.iseries.debug.util.Dialog;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.Util;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;

public class PasswordSecurity {
    public static final int DES = 0;
    public static final int SHAW1 = 1;
    private static final int SIGNON_VALID = 0;
    private static final int SIGNON_INVALID = 1;
    private static final int SIGNON_CANCELED = 2;
    private static final int SIGNON_COMM_ERROR = 3;
    private static final String PW_CACHE = ".idbgcache";
    private static final int ONE_DAY = 86400000;
    private static final int DEFAULT_DAYS = 5;
    private static final double VERSION = 5.40001;
    private static PasswordSecurity s_instance = null;
    private File m_file = new File(System.getProperty("user.home"), ".idbgcache");
    private HashMap m_systems = new HashMap();
    private String m_thisSystem = "";
    private String m_thisUser = "";
    private boolean m_rememberPassword = true;
    private int m_rememberDays = 5;
    private static final int[] EPERM = new int[]{32, 1, 2, 3, 4, 5, 4, 5, 6, 7, 8, 9, 8, 9, 10, 11, 12, 13, 12, 13, 14, 15, 16, 17, 16, 17, 18, 19, 20, 21, 20, 21, 22, 23, 24, 25, 24, 25, 26, 27, 28, 29, 28, 29, 30, 31, 32, 1};
    private static final int[] INITPERM = new int[]{58, 50, 42, 34, 26, 18, 10, 2, 60, 52, 44, 36, 28, 20, 12, 4, 62, 54, 46, 38, 30, 22, 14, 6, 64, 56, 48, 40, 32, 24, 16, 8, 57, 49, 41, 33, 25, 17, 9, 1, 59, 51, 43, 35, 27, 19, 11, 3, 61, 53, 45, 37, 29, 21, 13, 5, 63, 55, 47, 39, 31, 23, 15, 7};
    private static final int[] OUTPERM = new int[]{40, 8, 48, 16, 56, 24, 64, 32, 39, 7, 47, 15, 55, 23, 63, 31, 38, 6, 46, 14, 54, 22, 62, 30, 37, 5, 45, 13, 53, 21, 61, 29, 36, 4, 44, 12, 52, 20, 60, 28, 35, 3, 43, 11, 51, 19, 59, 27, 34, 2, 42, 10, 50, 18, 58, 26, 33, 1, 41, 9, 49, 17, 57, 25};
    private static final int[] PPERM = new int[]{16, 7, 20, 21, 29, 12, 28, 17, 1, 15, 23, 26, 5, 18, 31, 10, 2, 8, 24, 14, 32, 27, 3, 9, 19, 13, 30, 6, 22, 11, 4, 25};
    private static final int[] PC1 = new int[]{57, 49, 41, 33, 25, 17, 9, 1, 58, 50, 42, 34, 26, 18, 10, 2, 59, 51, 43, 35, 27, 19, 11, 3, 60, 52, 44, 36, 63, 55, 47, 39, 31, 23, 15, 7, 62, 54, 46, 38, 30, 22, 14, 6, 61, 53, 45, 37, 29, 21, 13, 5, 28, 20, 12, 4};
    private static final int[] PC2 = new int[]{14, 17, 11, 24, 1, 5, 3, 28, 15, 6, 21, 10, 23, 19, 12, 4, 26, 8, 16, 7, 27, 20, 13, 2, 41, 52, 31, 37, 47, 55, 30, 40, 51, 45, 33, 48, 44, 49, 39, 56, 34, 53, 46, 42, 50, 36, 29, 32};
    private static final int[] S1 = new int[]{14, 4, 13, 1, 2, 15, 11, 8, 3, 10, 6, 12, 5, 9, 0, 7, 0, 15, 7, 4, 14, 2, 13, 1, 10, 6, 12, 11, 9, 5, 3, 8, 4, 1, 14, 8, 13, 6, 2, 11, 15, 12, 9, 7, 3, 10, 5, 0, 15, 12, 8, 2, 4, 9, 1, 7, 5, 11, 3, 14, 10, 0, 6, 13};
    private static final int[] S2 = new int[]{15, 1, 8, 14, 6, 11, 3, 4, 9, 7, 2, 13, 12, 0, 5, 10, 3, 13, 4, 7, 15, 2, 8, 14, 12, 0, 1, 10, 6, 9, 11, 5, 0, 14, 7, 11, 10, 4, 13, 1, 5, 8, 12, 6, 9, 3, 2, 15, 13, 8, 10, 1, 3, 15, 4, 2, 11, 6, 7, 12, 0, 5, 14, 9};
    private static final int[] S3 = new int[]{10, 0, 9, 14, 6, 3, 15, 5, 1, 13, 12, 7, 11, 4, 2, 8, 13, 7, 0, 9, 3, 4, 6, 10, 2, 8, 5, 14, 12, 11, 15, 1, 13, 6, 4, 9, 8, 15, 3, 0, 11, 1, 2, 12, 5, 10, 14, 7, 1, 10, 13, 0, 6, 9, 8, 7, 4, 15, 14, 3, 11, 5, 2, 12};
    private static final int[] S4 = new int[]{7, 13, 14, 3, 0, 6, 9, 10, 1, 2, 8, 5, 11, 12, 4, 15, 13, 8, 11, 5, 6, 15, 0, 3, 4, 7, 2, 12, 1, 10, 14, 9, 10, 6, 9, 0, 12, 11, 7, 13, 15, 1, 3, 14, 5, 2, 8, 4, 3, 15, 0, 6, 10, 1, 13, 8, 9, 4, 5, 11, 12, 7, 2, 14};
    private static final int[] S5 = new int[]{2, 12, 4, 1, 7, 10, 11, 6, 8, 5, 3, 15, 13, 0, 14, 9, 14, 11, 2, 12, 4, 7, 13, 1, 5, 0, 15, 10, 3, 9, 8, 6, 4, 2, 1, 11, 10, 13, 7, 8, 15, 9, 12, 5, 6, 3, 0, 14, 11, 8, 12, 7, 1, 14, 2, 13, 6, 15, 0, 9, 10, 4, 5, 3};
    private static final int[] S6 = new int[]{12, 1, 10, 15, 9, 2, 6, 8, 0, 13, 3, 4, 14, 7, 5, 11, 10, 15, 4, 2, 7, 12, 9, 5, 6, 1, 13, 14, 0, 11, 3, 8, 9, 14, 15, 5, 2, 8, 12, 3, 7, 0, 4, 10, 1, 13, 11, 6, 4, 3, 2, 12, 9, 5, 15, 10, 11, 14, 1, 7, 6, 0, 8, 13};
    private static final int[] S7 = new int[]{4, 11, 2, 14, 15, 0, 8, 13, 3, 12, 9, 7, 5, 10, 6, 1, 13, 0, 11, 7, 4, 9, 1, 10, 14, 3, 5, 12, 2, 15, 8, 6, 1, 4, 11, 13, 12, 3, 7, 14, 10, 15, 6, 8, 0, 5, 9, 2, 6, 11, 13, 8, 1, 4, 10, 7, 9, 5, 0, 15, 14, 2, 3, 12};
    private static final int[] S8 = new int[]{13, 2, 8, 4, 6, 15, 11, 1, 10, 9, 3, 14, 5, 0, 12, 7, 1, 15, 13, 8, 10, 3, 7, 4, 12, 5, 6, 11, 0, 14, 9, 2, 7, 11, 4, 1, 9, 12, 14, 2, 0, 6, 10, 13, 15, 3, 5, 8, 2, 1, 14, 7, 4, 10, 8, 13, 15, 12, 9, 0, 3, 5, 6, 11};
    static /* synthetic */ Class class$com$ibm$iseries$debug$util$PasswordSecurity;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PasswordSecurity instance() {
        if (s_instance == null) {
            Class clazz = class$com$ibm$iseries$debug$util$PasswordSecurity == null ? (class$com$ibm$iseries$debug$util$PasswordSecurity = PasswordSecurity.class$("com.ibm.iseries.debug.util.PasswordSecurity")) : class$com$ibm$iseries$debug$util$PasswordSecurity;
            synchronized (clazz) {
                if (s_instance == null) {
                    s_instance = new PasswordSecurity();
                }
            }
        }
        return s_instance;
    }

    private PasswordSecurity() {
        try {
            this.m_thisSystem = InetAddress.getLocalHost().getHostName();
            this.m_thisUser = System.getProperty("user.name");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.m_thisSystem = "";
            this.m_thisUser = "";
        }
        this.load();
    }

    public boolean rememberPassword() {
        return this.m_rememberPassword;
    }

    public int rememberPasswordDays() {
        return this.m_rememberDays;
    }

    public void remember(String string, String string2, String string3, boolean bl, int n) {
        this.m_rememberPassword = bl;
        this.m_rememberDays = n;
        this.put(string, string2, string3, this.m_rememberPassword, this.m_rememberDays);
    }

    private boolean load() {
        boolean bl = false;
        this.m_systems.clear();
        try {
            if (this.m_file.exists() && this.m_file.canRead()) {
                DebugFile debugFile = new DebugFile(this.m_file);
                Date date = new Date();
                long l = date.getTime();
                int n = debugFile.readInt();
                this.m_rememberPassword = debugFile.readBoolean();
                this.m_rememberDays = debugFile.readInt();
                int n2 = 0;
                while (n2 < n) {
                    String string = debugFile.readString();
                    HashMap<String, PasswordRec> hashMap = new HashMap<String, PasswordRec>();
                    this.m_systems.put(string, hashMap);
                    int n3 = debugFile.readInt();
                    int n4 = 0;
                    while (n4 < n3) {
                        String string2 = debugFile.readString();
                        byte[] byArray = debugFile.readBytes();
                        byte[] byArray2 = debugFile.readBytes();
                        long l2 = debugFile.readLong();
                        if (l < l2) {
                            PasswordRec passwordRec = new PasswordRec(string2, byArray, byArray2, l2);
                            hashMap.put(string2, passwordRec);
                        }
                        ++n4;
                    }
                    ++n2;
                }
                debugFile.close();
                bl = true;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return bl;
    }

    private boolean save() {
        boolean bl = false;
        try {
            DebugFile debugFile = new DebugFile(this.m_file, 5.40001);
            int n = this.m_systems.size();
            debugFile.writeInt(n);
            debugFile.writeBoolean(this.m_rememberPassword);
            debugFile.writeInt(this.m_rememberDays);
            if (n > 0) {
                Iterator iterator = this.m_systems.keySet().iterator();
                while (iterator.hasNext()) {
                    Object object;
                    String string = (String)iterator.next();
                    HashMap hashMap = (HashMap)this.m_systems.get(string);
                    debugFile.writeString(string);
                    int n2 = 0;
                    Iterator iterator2 = hashMap.values().iterator();
                    while (iterator2.hasNext()) {
                        object = (PasswordRec)iterator2.next();
                        if (!((PasswordRec)object).m_remember) continue;
                        ++n2;
                    }
                    debugFile.writeInt(n2);
                    if (n2 <= 0) continue;
                    object = hashMap.values().iterator();
                    while (object.hasNext()) {
                        PasswordRec passwordRec = (PasswordRec)object.next();
                        if (!passwordRec.m_remember) continue;
                        debugFile.writeString(passwordRec.m_user);
                        byte[] byArray = PasswordSecurity.charArrayToByteArray(passwordRec.m_pw);
                        byte[] byArray2 = PasswordSecurity.charArrayToByteArray(passwordRec.m_mask);
                        debugFile.writeBytes(byArray);
                        debugFile.writeBytes(byArray2);
                        debugFile.writeLong(passwordRec.m_expiration);
                    }
                }
            }
            debugFile.close();
            bl = true;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return bl;
    }

    private void put(String string, String string2, String string3, boolean bl, int n) {
        PasswordRec passwordRec;
        string = Util.upper(string);
        string2 = Util.upper(string2);
        HashMap<String, PasswordRec> hashMap = (HashMap<String, PasswordRec>)this.m_systems.get(string);
        if (hashMap == null) {
            hashMap = new HashMap<String, PasswordRec>();
            this.m_systems.put(string, hashMap);
        }
        if ((passwordRec = (PasswordRec)hashMap.get(string2)) == null) {
            passwordRec = new PasswordRec(string2, string3, bl, n);
            hashMap.put(string2, passwordRec);
        } else {
            passwordRec.update(string3, bl, n);
        }
        this.save();
    }

    private PasswordRec get(String string, String string2) {
        PasswordRec passwordRec = null;
        if (string.length() > 0 && string2.length() > 0) {
            string = Util.upper(string);
            string2 = Util.upper(string2);
            HashMap hashMap = (HashMap)this.m_systems.get(string);
            if (hashMap == null) {
                string = Util.getSystemShortName(string);
                hashMap = (HashMap)this.m_systems.get(string);
            }
            if (hashMap != null) {
                passwordRec = (PasswordRec)hashMap.get(string2);
            }
        }
        return passwordRec;
    }

    private int validate(String string, String string2, String string3) {
        AS400 aS400 = new AS400(string, string2, string3);
        int n = 3;
        try {
            n = aS400.validateSignon() ? 0 : 1;
        }
        catch (AS400SecurityException aS400SecurityException) {
            n = 1;
        }
        catch (ExtendedIllegalArgumentException extendedIllegalArgumentException) {
            n = 1;
        }
        catch (IOException iOException) {
            n = 3;
        }
        catch (Throwable throwable) {
            n = 3;
        }
        aS400.disconnectAllServices();
        return n;
    }

    AS400 prepareAS400(String string, String string2) {
        AS400 aS400 = null;
        PasswordRec passwordRec = this.get(string, string2);
        if (passwordRec != null) {
            aS400 = new AS400(string, string2, passwordRec.decode());
        }
        return aS400;
    }

    int prepareSignon(DebugWindow debugWindow, CommLink commLink) {
        String string = commLink.getSystem();
        String string2 = commLink.getUser();
        String string3 = "";
        PasswordRec passwordRec = this.get(string, string2);
        if (passwordRec != null) {
            int n = this.validate(string, string2, passwordRec.decode());
            if (commLink.isCanceled()) {
                return 2;
            }
            switch (n) {
                case 0: {
                    return 0;
                }
                case 1: {
                    break;
                }
                case 3: {
                    return 3;
                }
            }
        }
        if (string.length() == 0 && (string = debugWindow.getUserConfig().getString("system", "")).length() > 0 && (passwordRec = this.get(string, string2)) != null) {
            string3 = passwordRec.decode();
        }
        SignonDialog signonDialog = new SignonDialog(debugWindow.getJFrame(), MRI.get("DBG_SIGNON_DIALOG_TITLE"), "signon", string, string2, string3);
        signonDialog.display(debugWindow);
        if (!signonDialog.wasCanceled()) {
            commLink.setSystem(signonDialog.getSystem());
            commLink.setUser(signonDialog.getUser());
            debugWindow.getUserConfig().setString("system", signonDialog.getSystem());
            return 0;
        }
        return 2;
    }

    boolean signon(DebugWindow debugWindow, CommLink commLink) throws IOException {
        Object object;
        PasswordRec passwordRec = this.get(commLink.getSystem(), commLink.getUser());
        if (passwordRec == null) {
            object = new SignonDialog(debugWindow.getJFrame(), MRI.get("DBG_SIGNON_DIALOG_TITLE"), "signon", commLink.getSystem(), commLink.getUser(), "");
            ((Dialog)object).display(debugWindow);
            if (!((Dialog)object).wasCanceled()) {
                passwordRec = this.get(((SignonDialog)object).getSystem(), ((SignonDialog)object).getUser());
                commLink.setSystem(((SignonDialog)object).getSystem());
                commLink.setUser(((SignonDialog)object).getUser());
            } else {
                return false;
            }
        }
        object = this.getPassword(commLink.getPasswordType(), passwordRec.m_user, passwordRec.decode(), commLink.getClientSeed(), commLink.getServerSeed());
        int n = commLink.writeSize(passwordRec.m_user) + 4 + commLink.writeSize((byte[])object);
        commLink.writeInt(n);
        commLink.writeString(passwordRec.m_user);
        commLink.writeInt(commLink.getPasswordType());
        commLink.writeBytes((byte[])object);
        commLink.flush();
        int n2 = commLink.readInt();
        return n2 == 0;
    }

    private byte[] getPassword(int n, String string, String string2, byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = null;
        byte[] byArray4 = PasswordSecurity.stringToByteArray(Util.upper(string));
        if (byArray4 == null) {
            return null;
        }
        if (n == 0) {
            byte[] byArray5 = PasswordSecurity.stringToByteArray(string2.toUpperCase());
            if (byArray5 == null) {
                return null;
            }
            byArray3 = PasswordSecurity.encryptPassword(byArray4, byArray5, byArray, byArray2);
        } else {
            char[] cArray = string2.toCharArray();
            byArray3 = PasswordSecurity.genNewPwd(cArray, byArray, byArray2, byArray4);
        }
        return byArray3;
    }

    private static byte[] genNewPwd(char[] cArray, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        byte[] byArray4 = PasswordSecurity.charArrayToByteArray(PasswordSecurity.SignOnByteArrayToCharArray(byArray3));
        int n = cArray.length - 1;
        while (cArray[n] == '\u0000' || cArray[n] == ' ' || cArray[n] == '\u3000') {
            --n;
        }
        char[] cArray2 = new char[n + 1];
        System.arraycopy(cArray, 0, cArray2, 0, cArray2.length);
        byte[] byArray5 = PasswordSecurity.charArrayToByteArray(cArray2);
        byte[] byArray6 = new byte[]{0, 0, 0, 0, 0, 0, 0, 1};
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            messageDigest.update(byArray4);
            messageDigest.update(byArray5);
            byte[] byArray7 = messageDigest.digest();
            messageDigest.update(byArray7);
            messageDigest.update(byArray2);
            messageDigest.update(byArray);
            messageDigest.update(byArray4);
            messageDigest.update(byArray6);
            return messageDigest.digest();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    private static byte[] encryptPassword(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        byte[] byArray5 = new byte[]{0, 0, 0, 0, 0, 0, 0, 1};
        byte[] byArray6 = new byte[8];
        byte[] byArray7 = PasswordSecurity.generateToken(byArray, byArray2);
        byte[] byArray8 = PasswordSecurity.generatePasswordSubstitute(byArray, byArray7, byArray6, byArray5, byArray3, byArray4);
        return byArray8;
    }

    private static byte[] generatePasswordSubstitute(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, byte[] byArray6) {
        byte[] byArray7 = new byte[8];
        byte[] byArray8 = new byte[8];
        byte[] byArray9 = new byte[8];
        PasswordSecurity.addArray(byArray4, byArray6, byArray7, 8);
        byArray9 = PasswordSecurity.enc_des(byArray2, byArray7);
        PasswordSecurity.xORArray(byArray9, byArray5, byArray8);
        byArray9 = PasswordSecurity.enc_des(byArray2, byArray8);
        System.arraycopy(byArray9, 0, byArray3, 0, 8);
        PasswordSecurity.xORArray(byArray, byArray7, byArray8);
        PasswordSecurity.xORArray(byArray8, byArray9, byArray8);
        byArray9 = PasswordSecurity.enc_des(byArray2, byArray8);
        int n = 0;
        while (n < 8) {
            byArray8[n] = 64;
            ++n;
        }
        byArray8[0] = byArray[8];
        byArray8[1] = byArray[9];
        PasswordSecurity.xORArray(byArray7, byArray8, byArray8);
        PasswordSecurity.xORArray(byArray8, byArray9, byArray8);
        byArray9 = PasswordSecurity.enc_des(byArray2, byArray8);
        PasswordSecurity.xORArray(byArray4, byArray9, byArray8);
        return PasswordSecurity.enc_des(byArray2, byArray8);
    }

    private static byte[] generateToken(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[8];
        byte[] byArray4 = new byte[10];
        byte[] byArray5 = new byte[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
        byte[] byArray6 = new byte[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
        System.arraycopy(byArray, 0, byArray4, 0, 10);
        int n = PasswordSecurity.ebcdicStrLen(byArray, 10);
        if (n > 8) {
            byArray4[0] = (byte)(byArray4[0] ^ byArray4[8] & 0xC0);
            byArray4[1] = (byte)(byArray4[1] ^ (byArray4[8] & 0x30) << 2);
            byArray4[2] = (byte)(byArray4[2] ^ (byArray4[8] & 0xC) << 4);
            byArray4[3] = (byte)(byArray4[3] ^ (byArray4[8] & 3) << 6);
            byArray4[4] = (byte)(byArray4[4] ^ byArray4[9] & 0xC0);
            byArray4[5] = (byte)(byArray4[5] ^ (byArray4[9] & 0x30) << 2);
            byArray4[6] = (byte)(byArray4[6] ^ (byArray4[9] & 0xC) << 4);
            byArray4[7] = (byte)(byArray4[7] ^ (byArray4[9] & 3) << 6);
        }
        if ((n = PasswordSecurity.ebcdicStrLen(byArray2, 10)) > 8) {
            System.arraycopy(byArray2, 0, byArray5, 0, 8);
            System.arraycopy(byArray2, 8, byArray6, 0, n - 8);
            PasswordSecurity.xorWith0x55andLshift(byArray5);
            byArray5 = PasswordSecurity.enc_des(byArray5, byArray4);
            PasswordSecurity.xorWith0x55andLshift(byArray6);
            byArray6 = PasswordSecurity.enc_des(byArray6, byArray4);
            PasswordSecurity.xORArray(byArray5, byArray6, byArray3);
        } else {
            System.arraycopy(byArray2, 0, byArray5, 0, n);
            PasswordSecurity.xorWith0x55andLshift(byArray5);
            byArray3 = PasswordSecurity.enc_des(byArray5, byArray4);
        }
        return byArray3;
    }

    private static void addArray(byte[] byArray, byte[] byArray2, byte[] byArray3, int n) {
        int n2 = 0;
        int n3 = n - 1;
        while (n3 >= 0) {
            int n4 = (byArray[n3] & 0xFF) + (byArray2[n3] & 0xFF) + n2;
            n2 = n4 >>> 8;
            byArray3[n3] = (byte)n4;
            --n3;
        }
    }

    private static int ebcdicStrLen(byte[] byArray, int n) {
        int n2 = 0;
        while (n2 < n && byArray[n2] != 64 && byArray[n2] != 0) {
            ++n2;
        }
        return n2;
    }

    private static void incrementString(byte[] byArray) {
        byte[] byArray2 = new byte[]{0, 0, 0, 0, 0, 0, 0, 1};
        PasswordSecurity.addArray(byArray, byArray2, byArray, 8);
    }

    private static void xORArray(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        int n = 0;
        while (n < 8) {
            byArray3[n] = (byte)(byArray[n] ^ byArray2[n]);
            ++n;
        }
    }

    private static void xorWith0x55andLshift(byte[] byArray) {
        byArray[0] = (byte)(byArray[0] ^ 0x55);
        byArray[1] = (byte)(byArray[1] ^ 0x55);
        byArray[2] = (byte)(byArray[2] ^ 0x55);
        byArray[3] = (byte)(byArray[3] ^ 0x55);
        byArray[4] = (byte)(byArray[4] ^ 0x55);
        byArray[5] = (byte)(byArray[5] ^ 0x55);
        byArray[6] = (byte)(byArray[6] ^ 0x55);
        byArray[7] = (byte)(byArray[7] ^ 0x55);
        byArray[0] = (byte)(byArray[0] << 1 | (byArray[1] & 0x80) >>> 7);
        byArray[1] = (byte)(byArray[1] << 1 | (byArray[2] & 0x80) >>> 7);
        byArray[2] = (byte)(byArray[2] << 1 | (byArray[3] & 0x80) >>> 7);
        byArray[3] = (byte)(byArray[3] << 1 | (byArray[4] & 0x80) >>> 7);
        byArray[4] = (byte)(byArray[4] << 1 | (byArray[5] & 0x80) >>> 7);
        byArray[5] = (byte)(byArray[5] << 1 | (byArray[6] & 0x80) >>> 7);
        byArray[6] = (byte)(byArray[6] << 1 | (byArray[7] & 0x80) >>> 7);
        byArray[7] = (byte)(byArray[7] << 1);
    }

    private static byte[] enc_des(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[65];
        byte[] byArray4 = new byte[65];
        int n = 0;
        while (n < 8) {
            byArray3[8 * n + 1] = (byte)((byArray2[n] & 0x80) == 0 ? 48 : 49);
            byArray3[8 * n + 2] = (byte)((byArray2[n] & 0x40) == 0 ? 48 : 49);
            byArray3[8 * n + 3] = (byte)((byArray2[n] & 0x20) == 0 ? 48 : 49);
            byArray3[8 * n + 4] = (byte)((byArray2[n] & 0x10) == 0 ? 48 : 49);
            byArray3[8 * n + 5] = (byte)((byArray2[n] & 8) == 0 ? 48 : 49);
            byArray3[8 * n + 6] = (byte)((byArray2[n] & 4) == 0 ? 48 : 49);
            byArray3[8 * n + 7] = (byte)((byArray2[n] & 2) == 0 ? 48 : 49);
            byArray3[8 * n + 8] = (byte)((byArray2[n] & 1) == 0 ? 48 : 49);
            ++n;
        }
        int n2 = 0;
        while (n2 < 8) {
            byArray4[8 * n2 + 1] = (byte)((byArray[n2] & 0x80) == 0 ? 48 : 49);
            byArray4[8 * n2 + 2] = (byte)((byArray[n2] & 0x40) == 0 ? 48 : 49);
            byArray4[8 * n2 + 3] = (byte)((byArray[n2] & 0x20) == 0 ? 48 : 49);
            byArray4[8 * n2 + 4] = (byte)((byArray[n2] & 0x10) == 0 ? 48 : 49);
            byArray4[8 * n2 + 5] = (byte)((byArray[n2] & 8) == 0 ? 48 : 49);
            byArray4[8 * n2 + 6] = (byte)((byArray[n2] & 4) == 0 ? 48 : 49);
            byArray4[8 * n2 + 7] = (byte)((byArray[n2] & 2) == 0 ? 48 : 49);
            byArray4[8 * n2 + 8] = (byte)((byArray[n2] & 1) == 0 ? 48 : 49);
            ++n2;
        }
        byte[] byArray5 = new byte[65];
        byte[] byArray6 = new byte[58];
        int n3 = 1;
        while (n3 <= 56) {
            byArray6[n3] = byArray4[PC1[n3 - 1]];
            ++n3;
        }
        PasswordSecurity.lshift1(byArray6);
        byte[] byArray7 = new byte[49];
        int n4 = 1;
        while (n4 <= 48) {
            byArray7[n4] = byArray6[PC2[n4 - 1]];
            ++n4;
        }
        byte[] byArray8 = new byte[49];
        PasswordSecurity.lshift1(byArray6);
        int n5 = 1;
        while (n5 <= 48) {
            byArray8[n5] = byArray6[PC2[n5 - 1]];
            ++n5;
        }
        byte[] byArray9 = new byte[49];
        PasswordSecurity.lshift2(byArray6);
        int n6 = 1;
        while (n6 <= 48) {
            byArray9[n6] = byArray6[PC2[n6 - 1]];
            ++n6;
        }
        byte[] byArray10 = new byte[49];
        PasswordSecurity.lshift2(byArray6);
        int n7 = 1;
        while (n7 <= 48) {
            byArray10[n7] = byArray6[PC2[n7 - 1]];
            ++n7;
        }
        byte[] byArray11 = new byte[49];
        PasswordSecurity.lshift2(byArray6);
        int n8 = 1;
        while (n8 <= 48) {
            byArray11[n8] = byArray6[PC2[n8 - 1]];
            ++n8;
        }
        byte[] byArray12 = new byte[49];
        PasswordSecurity.lshift2(byArray6);
        int n9 = 1;
        while (n9 <= 48) {
            byArray12[n9] = byArray6[PC2[n9 - 1]];
            ++n9;
        }
        byte[] byArray13 = new byte[49];
        PasswordSecurity.lshift2(byArray6);
        int n10 = 1;
        while (n10 <= 48) {
            byArray13[n10] = byArray6[PC2[n10 - 1]];
            ++n10;
        }
        byte[] byArray14 = new byte[49];
        PasswordSecurity.lshift2(byArray6);
        int n11 = 1;
        while (n11 <= 48) {
            byArray14[n11] = byArray6[PC2[n11 - 1]];
            ++n11;
        }
        byte[] byArray15 = new byte[49];
        PasswordSecurity.lshift1(byArray6);
        int n12 = 1;
        while (n12 <= 48) {
            byArray15[n12] = byArray6[PC2[n12 - 1]];
            ++n12;
        }
        byte[] byArray16 = new byte[49];
        PasswordSecurity.lshift2(byArray6);
        int n13 = 1;
        while (n13 <= 48) {
            byArray16[n13] = byArray6[PC2[n13 - 1]];
            ++n13;
        }
        byte[] byArray17 = new byte[49];
        PasswordSecurity.lshift2(byArray6);
        int n14 = 1;
        while (n14 <= 48) {
            byArray17[n14] = byArray6[PC2[n14 - 1]];
            ++n14;
        }
        byte[] byArray18 = new byte[49];
        PasswordSecurity.lshift2(byArray6);
        int n15 = 1;
        while (n15 <= 48) {
            byArray18[n15] = byArray6[PC2[n15 - 1]];
            ++n15;
        }
        byte[] byArray19 = new byte[49];
        PasswordSecurity.lshift2(byArray6);
        int n16 = 1;
        while (n16 <= 48) {
            byArray19[n16] = byArray6[PC2[n16 - 1]];
            ++n16;
        }
        byte[] byArray20 = new byte[49];
        PasswordSecurity.lshift2(byArray6);
        int n17 = 1;
        while (n17 <= 48) {
            byArray20[n17] = byArray6[PC2[n17 - 1]];
            ++n17;
        }
        byte[] byArray21 = new byte[49];
        PasswordSecurity.lshift2(byArray6);
        int n18 = 1;
        while (n18 <= 48) {
            byArray21[n18] = byArray6[PC2[n18 - 1]];
            ++n18;
        }
        byte[] byArray22 = new byte[49];
        PasswordSecurity.lshift1(byArray6);
        int n19 = 1;
        while (n19 <= 48) {
            byArray22[n19] = byArray6[PC2[n19 - 1]];
            ++n19;
        }
        byte[] byArray23 = new byte[33];
        byte[] byArray24 = new byte[33];
        int n20 = 1;
        while (n20 <= 32) {
            byArray23[n20] = byArray3[INITPERM[n20 - 1]];
            byArray24[n20] = byArray3[INITPERM[n20 + 31]];
            ++n20;
        }
        PasswordSecurity.cipher(byArray7, byArray23, byArray24);
        PasswordSecurity.cipher(byArray8, byArray23, byArray24);
        PasswordSecurity.cipher(byArray9, byArray23, byArray24);
        PasswordSecurity.cipher(byArray10, byArray23, byArray24);
        PasswordSecurity.cipher(byArray11, byArray23, byArray24);
        PasswordSecurity.cipher(byArray12, byArray23, byArray24);
        PasswordSecurity.cipher(byArray13, byArray23, byArray24);
        PasswordSecurity.cipher(byArray14, byArray23, byArray24);
        PasswordSecurity.cipher(byArray15, byArray23, byArray24);
        PasswordSecurity.cipher(byArray16, byArray23, byArray24);
        PasswordSecurity.cipher(byArray17, byArray23, byArray24);
        PasswordSecurity.cipher(byArray18, byArray23, byArray24);
        PasswordSecurity.cipher(byArray19, byArray23, byArray24);
        PasswordSecurity.cipher(byArray20, byArray23, byArray24);
        PasswordSecurity.cipher(byArray21, byArray23, byArray24);
        PasswordSecurity.cipher(byArray22, byArray23, byArray24);
        System.arraycopy(byArray24, 1, byArray5, 1, 32);
        System.arraycopy(byArray23, 1, byArray5, 33, 32);
        byte[] byArray25 = new byte[65];
        int n21 = 1;
        while (n21 <= 64) {
            byArray25[n21] = byArray5[OUTPERM[n21 - 1]];
            ++n21;
        }
        byte[] byArray26 = new byte[8];
        int n22 = 0;
        while (n22 < 8) {
            if (byArray25[8 * n22 + 1] == 49) {
                int n23 = n22;
                byArray26[n23] = (byte)(byArray26[n23] | 0x80);
            }
            if (byArray25[8 * n22 + 2] == 49) {
                int n24 = n22;
                byArray26[n24] = (byte)(byArray26[n24] | 0x40);
            }
            if (byArray25[8 * n22 + 3] == 49) {
                int n25 = n22;
                byArray26[n25] = (byte)(byArray26[n25] | 0x20);
            }
            if (byArray25[8 * n22 + 4] == 49) {
                int n26 = n22;
                byArray26[n26] = (byte)(byArray26[n26] | 0x10);
            }
            if (byArray25[8 * n22 + 5] == 49) {
                int n27 = n22;
                byArray26[n27] = (byte)(byArray26[n27] | 8);
            }
            if (byArray25[8 * n22 + 6] == 49) {
                int n28 = n22;
                byArray26[n28] = (byte)(byArray26[n28] | 4);
            }
            if (byArray25[8 * n22 + 7] == 49) {
                int n29 = n22;
                byArray26[n29] = (byte)(byArray26[n29] | 2);
            }
            if (byArray25[8 * n22 + 8] == 49) {
                int n30 = n22;
                byArray26[n30] = (byte)(byArray26[n30] | 1);
            }
            ++n22;
        }
        return byArray26;
    }

    private static void cipher(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        byte[] byArray4 = new byte[49];
        byte[] byArray5 = new byte[49];
        byte[] byArray6 = new byte[33];
        byte[] byArray7 = new byte[33];
        int[] nArray = new int[9];
        int[] nArray2 = new int[9];
        int n = 1;
        while (n <= 48) {
            byArray4[n] = byArray3[EPERM[n - 1]];
            ++n;
        }
        int n2 = 1;
        while (n2 <= 48) {
            byArray5[n2] = byArray4[n2] != byArray[n2] ? 49 : 48;
            ++n2;
        }
        nArray[1] = (byArray5[1] == 49 ? 32 : 0) | (byArray5[6] == 49 ? 16 : 0) | (byArray5[2] == 49 ? 8 : 0) | (byArray5[3] == 49 ? 4 : 0) | (byArray5[4] == 49 ? 2 : 0) | (byArray5[5] == 49 ? 1 : 0);
        nArray[2] = (byArray5[7] == 49 ? 32 : 0) | (byArray5[12] == 49 ? 16 : 0) | (byArray5[8] == 49 ? 8 : 0) | (byArray5[9] == 49 ? 4 : 0) | (byArray5[10] == 49 ? 2 : 0) | (byArray5[11] == 49 ? 1 : 0);
        nArray[3] = (byArray5[13] == 49 ? 32 : 0) | (byArray5[18] == 49 ? 16 : 0) | (byArray5[14] == 49 ? 8 : 0) | (byArray5[15] == 49 ? 4 : 0) | (byArray5[16] == 49 ? 2 : 0) | (byArray5[17] == 49 ? 1 : 0);
        nArray[4] = (byArray5[19] == 49 ? 32 : 0) | (byArray5[24] == 49 ? 16 : 0) | (byArray5[20] == 49 ? 8 : 0) | (byArray5[21] == 49 ? 4 : 0) | (byArray5[22] == 49 ? 2 : 0) | (byArray5[23] == 49 ? 1 : 0);
        nArray[5] = (byArray5[25] == 49 ? 32 : 0) | (byArray5[30] == 49 ? 16 : 0) | (byArray5[26] == 49 ? 8 : 0) | (byArray5[27] == 49 ? 4 : 0) | (byArray5[28] == 49 ? 2 : 0) | (byArray5[29] == 49 ? 1 : 0);
        nArray[6] = (byArray5[31] == 49 ? 32 : 0) | (byArray5[36] == 49 ? 16 : 0) | (byArray5[32] == 49 ? 8 : 0) | (byArray5[33] == 49 ? 4 : 0) | (byArray5[34] == 49 ? 2 : 0) | (byArray5[35] == 49 ? 1 : 0);
        nArray[7] = (byArray5[37] == 49 ? 32 : 0) | (byArray5[42] == 49 ? 16 : 0) | (byArray5[38] == 49 ? 8 : 0) | (byArray5[39] == 49 ? 4 : 0) | (byArray5[40] == 49 ? 2 : 0) | (byArray5[41] == 49 ? 1 : 0);
        nArray[8] = (byArray5[43] == 49 ? 32 : 0) | (byArray5[48] == 49 ? 16 : 0) | (byArray5[44] == 49 ? 8 : 0) | (byArray5[45] == 49 ? 4 : 0) | (byArray5[46] == 49 ? 2 : 0) | (byArray5[47] == 49 ? 1 : 0);
        nArray2[1] = S1[nArray[1]];
        nArray2[2] = S2[nArray[2]];
        nArray2[3] = S3[nArray[3]];
        nArray2[4] = S4[nArray[4]];
        nArray2[5] = S5[nArray[5]];
        nArray2[6] = S6[nArray[6]];
        nArray2[7] = S7[nArray[7]];
        nArray2[8] = S8[nArray[8]];
        PasswordSecurity.dectobin(nArray2[1], byArray6, 1);
        PasswordSecurity.dectobin(nArray2[2], byArray6, 5);
        PasswordSecurity.dectobin(nArray2[3], byArray6, 9);
        PasswordSecurity.dectobin(nArray2[4], byArray6, 13);
        PasswordSecurity.dectobin(nArray2[5], byArray6, 17);
        PasswordSecurity.dectobin(nArray2[6], byArray6, 21);
        PasswordSecurity.dectobin(nArray2[7], byArray6, 25);
        PasswordSecurity.dectobin(nArray2[8], byArray6, 29);
        int n3 = 1;
        while (n3 <= 32) {
            byArray7[n3] = byArray6[PPERM[n3 - 1]];
            ++n3;
        }
        byte[] byArray8 = new byte[33];
        System.arraycopy(byArray3, 1, byArray8, 1, 32);
        int n4 = 1;
        while (n4 <= 32) {
            byArray3[n4] = byArray2[n4] == byArray7[n4] ? 48 : 49;
            ++n4;
        }
        System.arraycopy(byArray8, 1, byArray2, 1, 32);
    }

    private static void dectobin(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)((n & 8) != 0 ? 49 : 48);
        byArray[n2 + 1] = (byte)((n & 4) != 0 ? 49 : 48);
        byArray[n2 + 2] = (byte)((n & 2) != 0 ? 49 : 48);
        byArray[n2 + 3] = (byte)((n & 1) != 0 ? 49 : 48);
    }

    private static void lshift1(byte[] byArray) {
        byte[] byArray2 = new byte[]{byArray[1], byArray[29]};
        System.arraycopy(byArray, 2, byArray, 1, 27);
        System.arraycopy(byArray, 30, byArray, 29, 27);
        byArray[28] = byArray2[0];
        byArray[56] = byArray2[1];
    }

    private static void lshift2(byte[] byArray) {
        byte[] byArray2 = new byte[]{byArray[1], byArray[2], byArray[29], byArray[30]};
        System.arraycopy(byArray, 3, byArray, 1, 27);
        System.arraycopy(byArray, 31, byArray, 29, 27);
        byArray[27] = byArray2[0];
        byArray[28] = byArray2[1];
        byArray[55] = byArray2[2];
        byArray[56] = byArray2[3];
    }

    private static byte[] charArrayToByteArray(char[] cArray) {
        if (cArray == null) {
            return null;
        }
        byte[] byArray = new byte[cArray.length * 2];
        int n = 0;
        int n2 = 0;
        while (n < cArray.length) {
            byArray[n2++] = (byte)(cArray[n] >> 8);
            byArray[n2++] = (byte)cArray[n++];
        }
        return byArray;
    }

    private static char[] byteArrayToCharArray(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        char[] cArray = new char[byArray.length / 2];
        int n = 0;
        int n2 = 0;
        while (n < byArray.length) {
            cArray[n2++] = (char)(((byArray[n++] & 0xFF) << 8) + (byArray[n++] & 0xFF));
        }
        return cArray;
    }

    private static String SignOnByteArrayToString(byte[] byArray) {
        return new String(PasswordSecurity.SignOnByteArrayToCharArray(byArray)).trim();
    }

    private static char[] SignOnByteArrayToCharArray(byte[] byArray) {
        char[] cArray = new char[10];
        int n = 0;
        while (n < 10) {
            switch (byArray[n] & 0xFF) {
                case 64: {
                    cArray[n] = 32;
                    break;
                }
                case 91: {
                    cArray[n] = 36;
                    break;
                }
                case 109: {
                    cArray[n] = 95;
                    break;
                }
                case 123: {
                    cArray[n] = 35;
                    break;
                }
                case 124: {
                    cArray[n] = 64;
                    break;
                }
                case 193: {
                    cArray[n] = 65;
                    break;
                }
                case 194: {
                    cArray[n] = 66;
                    break;
                }
                case 195: {
                    cArray[n] = 67;
                    break;
                }
                case 196: {
                    cArray[n] = 68;
                    break;
                }
                case 197: {
                    cArray[n] = 69;
                    break;
                }
                case 198: {
                    cArray[n] = 70;
                    break;
                }
                case 199: {
                    cArray[n] = 71;
                    break;
                }
                case 200: {
                    cArray[n] = 72;
                    break;
                }
                case 201: {
                    cArray[n] = 73;
                    break;
                }
                case 209: {
                    cArray[n] = 74;
                    break;
                }
                case 210: {
                    cArray[n] = 75;
                    break;
                }
                case 211: {
                    cArray[n] = 76;
                    break;
                }
                case 212: {
                    cArray[n] = 77;
                    break;
                }
                case 213: {
                    cArray[n] = 78;
                    break;
                }
                case 214: {
                    cArray[n] = 79;
                    break;
                }
                case 215: {
                    cArray[n] = 80;
                    break;
                }
                case 216: {
                    cArray[n] = 81;
                    break;
                }
                case 217: {
                    cArray[n] = 82;
                    break;
                }
                case 226: {
                    cArray[n] = 83;
                    break;
                }
                case 227: {
                    cArray[n] = 84;
                    break;
                }
                case 228: {
                    cArray[n] = 85;
                    break;
                }
                case 229: {
                    cArray[n] = 86;
                    break;
                }
                case 230: {
                    cArray[n] = 87;
                    break;
                }
                case 231: {
                    cArray[n] = 88;
                    break;
                }
                case 232: {
                    cArray[n] = 89;
                    break;
                }
                case 233: {
                    cArray[n] = 90;
                    break;
                }
                case 240: {
                    cArray[n] = 48;
                    break;
                }
                case 241: {
                    cArray[n] = 49;
                    break;
                }
                case 242: {
                    cArray[n] = 50;
                    break;
                }
                case 243: {
                    cArray[n] = 51;
                    break;
                }
                case 244: {
                    cArray[n] = 52;
                    break;
                }
                case 245: {
                    cArray[n] = 53;
                    break;
                }
                case 246: {
                    cArray[n] = 54;
                    break;
                }
                case 247: {
                    cArray[n] = 55;
                    break;
                }
                case 248: {
                    cArray[n] = 56;
                    break;
                }
                case 249: {
                    cArray[n] = 57;
                    break;
                }
                default: {
                    return null;
                }
            }
            ++n;
        }
        return cArray;
    }

    private static byte[] stringToByteArray(String string) {
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
        int n = 0;
        while (n < cArray.length) {
            switch (cArray[n]) {
                case '#': {
                    byArray[n] = 123;
                    break;
                }
                case '$': {
                    byArray[n] = 91;
                    break;
                }
                case '0': {
                    byArray[n] = -16;
                    break;
                }
                case '1': {
                    byArray[n] = -15;
                    break;
                }
                case '2': {
                    byArray[n] = -14;
                    break;
                }
                case '3': {
                    byArray[n] = -13;
                    break;
                }
                case '4': {
                    byArray[n] = -12;
                    break;
                }
                case '5': {
                    byArray[n] = -11;
                    break;
                }
                case '6': {
                    byArray[n] = -10;
                    break;
                }
                case '7': {
                    byArray[n] = -9;
                    break;
                }
                case '8': {
                    byArray[n] = -8;
                    break;
                }
                case '9': {
                    byArray[n] = -7;
                    break;
                }
                case '@': {
                    byArray[n] = 124;
                    break;
                }
                case 'A': {
                    byArray[n] = -63;
                    break;
                }
                case 'B': {
                    byArray[n] = -62;
                    break;
                }
                case 'C': {
                    byArray[n] = -61;
                    break;
                }
                case 'D': {
                    byArray[n] = -60;
                    break;
                }
                case 'E': {
                    byArray[n] = -59;
                    break;
                }
                case 'F': {
                    byArray[n] = -58;
                    break;
                }
                case 'G': {
                    byArray[n] = -57;
                    break;
                }
                case 'H': {
                    byArray[n] = -56;
                    break;
                }
                case 'I': {
                    byArray[n] = -55;
                    break;
                }
                case 'J': {
                    byArray[n] = -47;
                    break;
                }
                case 'K': {
                    byArray[n] = -46;
                    break;
                }
                case 'L': {
                    byArray[n] = -45;
                    break;
                }
                case 'M': {
                    byArray[n] = -44;
                    break;
                }
                case 'N': {
                    byArray[n] = -43;
                    break;
                }
                case 'O': {
                    byArray[n] = -42;
                    break;
                }
                case 'P': {
                    byArray[n] = -41;
                    break;
                }
                case 'Q': {
                    byArray[n] = -40;
                    break;
                }
                case 'R': {
                    byArray[n] = -39;
                    break;
                }
                case 'S': {
                    byArray[n] = -30;
                    break;
                }
                case 'T': {
                    byArray[n] = -29;
                    break;
                }
                case 'U': {
                    byArray[n] = -28;
                    break;
                }
                case 'V': {
                    byArray[n] = -27;
                    break;
                }
                case 'W': {
                    byArray[n] = -26;
                    break;
                }
                case 'X': {
                    byArray[n] = -25;
                    break;
                }
                case 'Y': {
                    byArray[n] = -24;
                    break;
                }
                case 'Z': {
                    byArray[n] = -23;
                    break;
                }
                case '_': {
                    byArray[n] = 109;
                    break;
                }
                default: {
                    return null;
                }
            }
            ++n;
        }
        return byArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class PasswordRec {
        String m_user;
        boolean m_remember;
        long m_expiration;
        char[] m_pw;
        char[] m_mask;
        char[] m_adder;

        PasswordRec(String string, String string2, boolean bl, int n) {
            this.m_user = string;
            this.m_remember = bl;
            Date date = new Date();
            this.m_expiration = date.getTime() + (long)(86400000 * n);
            this.genMask(null);
            this.encode(string2);
        }

        PasswordRec(String string, byte[] byArray, byte[] byArray2, long l) {
            this.m_user = string;
            this.m_remember = true;
            this.m_expiration = l;
            this.m_pw = PasswordSecurity.byteArrayToCharArray(byArray);
            this.genMask(byArray2);
        }

        void update(String string, boolean bl, int n) {
            int n2 = 0;
            while (n2 < this.m_pw.length) {
                this.m_pw[n2] = '\u0000';
                ++n2;
            }
            this.m_remember = bl;
            Date date = new Date();
            this.m_expiration = date.getTime() + (long)(86400000 * n);
            this.encode(string);
        }

        void encode(String string) {
            char[] cArray = new char[string.length()];
            string.getChars(0, string.length(), cArray, 0);
            this.m_pw = new char[cArray.length];
            int n = 0;
            while (n < cArray.length) {
                this.m_pw[n] = (char)(cArray[n] + this.m_adder[n % 9]);
                ++n;
            }
            int n2 = 0;
            while (n2 < cArray.length) {
                this.m_pw[n2] = (char)(this.m_pw[n2] ^ this.m_mask[n2 % 7]);
                ++n2;
            }
        }

        String decode() {
            char[] cArray = new char[this.m_pw.length];
            int n = 0;
            while (n < this.m_pw.length) {
                cArray[n] = (char)(this.m_mask[n % 7] ^ this.m_pw[n]);
                ++n;
            }
            int n2 = 0;
            while (n2 < this.m_pw.length) {
                cArray[n2] = (char)(cArray[n2] - this.m_adder[n2 % 9]);
                ++n2;
            }
            return new String(cArray);
        }

        void genMask(byte[] byArray) {
            byte[] byArray2 = new byte[18];
            if (byArray == null) {
                byArray = new byte[14];
                Random random = new Random();
                random.nextBytes(byArray);
            }
            int n = 0;
            while (n < byArray2.length) {
                byArray2[n] = n < byArray.length ? byArray[byArray.length - n - 1] : byArray2[n - byArray.length];
                ++n;
            }
            byte[] byArray3 = PasswordSecurity.this.m_thisUser.getBytes();
            int n2 = byArray3.length - 1;
            int n3 = 0;
            while (n3 < byArray2.length) {
                byArray2[n3] = (byte)(byArray2[n3] + byArray3[n2]);
                if (--n2 < 0) {
                    n2 = byArray3.length - 1;
                }
                ++n3;
            }
            byte[] byArray4 = PasswordSecurity.this.m_thisSystem.getBytes();
            int n4 = 0;
            int n5 = 0;
            while (n5 < byArray2.length) {
                byArray2[n5] = (byte)(byArray2[n5] ^ byArray4[n4]);
                if (++n4 == byArray4.length) {
                    n4 = 0;
                }
                ++n5;
            }
            this.m_adder = PasswordSecurity.byteArrayToCharArray(byArray2);
            this.m_mask = PasswordSecurity.byteArrayToCharArray(byArray);
        }
    }
}

