/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.util;

import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class DebugComboBox
extends JComboBox
implements KeyListener,
ItemListener {
    protected boolean m_ignore;
    protected int m_maxHistory;
    protected boolean m_enterPressed;
    protected boolean m_autoInsert;
    protected boolean m_autoDelete;
    protected JTextField m_editor;

    public DebugComboBox(int n) {
        this.m_maxHistory = n;
        this.m_autoInsert = true;
        this.setEditable(true);
        this.setMaximumRowCount(this.m_maxHistory > 20 ? 20 : this.m_maxHistory);
        this.addItemListener(this);
    }

    public void clear() {
        this.removeItemListener(this);
        super.removeAllItems();
        this.addItemListener(this);
    }

    public void setAutoInsert(boolean bl) {
        this.m_autoInsert = bl;
    }

    public void setAutoDelete(boolean bl) {
        this.m_autoDelete = bl;
    }

    public int getActualItemCount() {
        String string;
        int n = super.getItemCount();
        if (n == 1 && ((string = (String)this.getSelectedItem()) == null || string.trim().length() == 0)) {
            n = 0;
        }
        return n;
    }

    public String getItem() {
        String string = (String)this.getSelectedItem();
        if (string == null) {
            return "";
        }
        return string.trim();
    }

    public void setItem(String string) {
        this.removeItemListener(this);
        super.setSelectedItem(string);
        this.addItemListener(this);
    }

    public void insertItem(String string, boolean bl) {
        this.removeItemListener(this);
        super.removeItem(string);
        super.insertItemAt(string, 0);
        if (bl) {
            this.addItemListener(this);
            super.setSelectedIndex(0);
        } else {
            super.setSelectedIndex(0);
            this.addItemListener(this);
        }
    }

    public void addItem(String string) {
        this.removeItemListener(this);
        super.addItem(string);
        this.addItemListener(this);
    }

    public void removeItem(String string) {
        this.removeItemListener(this);
        super.removeItem(string);
        this.addItemListener(this);
    }

    public void replaceItem(String string, String string2) {
        this.removeItemListener(this);
        super.removeItem(string);
        super.insertItemAt(string2, 0);
        super.setSelectedIndex(0);
        this.addItemListener(this);
    }

    public String[] getItems() {
        String[] stringArray = new String[this.getItemCount()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = (String)this.getItemAt(n);
            ++n;
        }
        return stringArray;
    }

    public void setItems(String[] stringArray) {
        if (stringArray.length > 0) {
            this.removeItemListener(this);
            int n = 0;
            while (n < stringArray.length) {
                super.addItem(stringArray[n]);
                ++n;
            }
            super.setSelectedIndex(0);
            this.addItemListener(this);
        } else {
            this.clear();
        }
    }

    public void addItems(String[] stringArray) {
        this.removeItemListener(this);
        if (stringArray.length > 0) {
            int n = 0;
            while (n < stringArray.length) {
                super.addItem(stringArray[n]);
                ++n;
            }
            super.setSelectedIndex(this.getItemCount() - 1);
        }
        this.addItemListener(this);
    }

    public void forceEvent() {
        if (this.getItemCount() > 0) {
            this.itemSelected(this.getItem());
        }
    }

    protected void itemSelected(String string) {
    }

    protected boolean enterPressed() {
        return this.m_enterPressed;
    }

    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 38: 
            case 40: 
            case 224: 
            case 225: {
                if (!this.isPopupVisible()) break;
                this.m_ignore = true;
                break;
            }
            case 10: {
                this.m_enterPressed = true;
                ItemEvent itemEvent = new ItemEvent(this, 701, this.getEditor().getItem(), 1);
                this.itemStateChanged(itemEvent);
                break;
            }
            case 127: {
                String string;
                if (keyEvent.getModifiers() != 2 || !this.m_autoDelete || (string = this.getItem()).length() <= 0) break;
                this.removeItem(string);
            }
        }
        this.m_enterPressed = false;
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            String string;
            if (!this.m_ignore && (string = ((String)itemEvent.getItem()).trim()).length() > 0) {
                this.removeItemListener(this);
                if (this.m_autoInsert) {
                    super.removeItem(string);
                    super.insertItemAt(string, 0);
                    super.setSelectedItem(string);
                    if (this.getItemCount() > this.m_maxHistory) {
                        super.removeItemAt(this.getItemCount() - 1);
                    }
                }
                this.itemSelected(string);
                this.addItemListener(this);
            }
            this.m_ignore = false;
        }
    }

    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        boolean bl2 = super.processKeyBinding(keyStroke, keyEvent, n, bl);
        return bl2 || bl && Character.isLetterOrDigit(keyEvent.getKeyChar());
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        Dimension dimension2 = super.getMinimumSize();
        if (dimension.width < dimension2.width) {
            return dimension2;
        }
        return dimension;
    }

    public void updateUI() {
        super.updateUI();
        this.m_editor = (JTextField)this.getEditor().getEditorComponent();
        this.m_editor.addKeyListener(this);
    }
}

