/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.util;

import com.ibm.iseries.debug.util.Action;
import com.ibm.iseries.debug.util.ActionGroup;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.Util;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.accessibility.Accessible;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;

public abstract class ContextMenu
extends JPopupMenu
implements PropertyChangeListener {
    public ContextMenu() {
        Util.setOrientation(this);
    }

    public ContextMenu(String string) {
        super(string);
    }

    public abstract void init(ActionGroup var1);

    public void cleanUp() {
    }

    public void show(Component component, int n, int n2) {
        Dimension dimension = this.getToolkit().getScreenSize();
        Dimension dimension2 = this.getPreferredSize();
        Point point = new Point(n, n2);
        SwingUtilities.convertPointToScreen(point, component);
        if (point.y + dimension2.height > dimension.height) {
            n2 = point.y - dimension2.height >= 0 ? (n2 -= dimension2.height) : (n2 -= dimension2.height / 2);
        }
        super.show(component, n, n2);
    }

    public boolean removeMenuItem(ActionGroup actionGroup, String string) {
        Action action = (Action)actionGroup.get(string);
        int n = this.getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            JMenuItem jMenuItem;
            Component component = this.getComponent(n2);
            if (component instanceof JMenuItem && (jMenuItem = (JMenuItem)component).getText().equals(action.getName())) {
                this.remove(n2);
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean swapMenuItem(ActionGroup actionGroup, String string, String string2) {
        Action action = (Action)actionGroup.get(string);
        Action action2 = (Action)actionGroup.get(string2);
        if (action2 == null) {
            return false;
        }
        int n = this.getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            JMenuItem jMenuItem;
            Component component = this.getComponent(n2);
            if (component instanceof JMenuItem && (jMenuItem = (JMenuItem)component).getText().equals(action.getName())) {
                this.remove(n2);
                jMenuItem = new JMenuItem(action2);
                this.adjustMenuItem(action2, jMenuItem, action2.getName());
                this.insert(jMenuItem, n2);
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected JMenuItem addAction(ActionGroup actionGroup, String string) {
        JMenuItem jMenuItem = null;
        Action action = (Action)actionGroup.get(string);
        if (action != null) {
            jMenuItem = this.add(action);
            this.adjustMenuItem(action, jMenuItem, action.getName());
        }
        return jMenuItem;
    }

    protected JCheckBoxMenuItem addCheckAction(ActionGroup actionGroup, String string, boolean bl) {
        JCheckBoxMenuItem jCheckBoxMenuItem = null;
        Action action = (Action)actionGroup.get(string);
        if (action != null) {
            action.addPropertyChangeListener(this);
            jCheckBoxMenuItem = new JCheckBoxMenuItem(action);
            jCheckBoxMenuItem.setSelected(bl);
            this.add(jCheckBoxMenuItem);
            this.adjustMenuItem(action, jCheckBoxMenuItem, action.getName());
        }
        return jCheckBoxMenuItem;
    }

    protected JRadioButtonMenuItem addRadioAction(ActionGroup actionGroup, String string, boolean bl) {
        JRadioButtonMenuItem jRadioButtonMenuItem = null;
        Action action = (Action)actionGroup.get(string);
        if (action != null) {
            action.addPropertyChangeListener(this);
            jRadioButtonMenuItem = new JRadioButtonMenuItem(action);
            jRadioButtonMenuItem.setSelected(bl);
            this.add(jRadioButtonMenuItem);
            this.adjustMenuItem(action, jRadioButtonMenuItem, action.getName());
        }
        return jRadioButtonMenuItem;
    }

    protected void adjustMenuItem(Action action, JMenuItem jMenuItem, String string) {
        jMenuItem.setHorizontalTextPosition(MRI.isLtoR() ? 4 : 2);
        Util.setAccessible((Accessible)jMenuItem, string);
        Util.setOrientation(jMenuItem);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }
}

