/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.util;

import com.ibm.iseries.debug.util.CommLinkEvent;
import com.ibm.iseries.debug.util.CommLinkListener;
import com.ibm.iseries.debug.util.DebugWindow;
import com.ibm.iseries.debug.util.Packet;
import com.ibm.iseries.debug.util.PacketInflater;
import com.ibm.iseries.debug.util.PasswordSecurity;
import com.ibm.iseries.debug.util.PortMap;
import com.ibm.iseries.debug.util.Request;
import com.ibm.iseries.debug.util.Util;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Random;
import java.util.Vector;

public class CommLink {
    public static final double DATA_VERSION = 5.40001;
    public static final int FAILED = -1;
    public static final int CONNECTING = 1;
    public static final int CONNECTED = 2;
    public static final int CLOSING = 3;
    public static final int CLOSED = 0;
    public static final int DROPPED = 4;
    public static final int ACCEPTING = 5;
    public static final int ACCEPTED = 6;
    public static final int CANCELED = 7;
    public static final int PORT_NOT_MAPPED = 8;
    public static final int DEBUG_PACKET = 9;
    public static final int DOUBLE_SIZE = 8;
    public static final int FLOAT_SIZE = 4;
    public static final int LONG_SIZE = 4;
    public static final int INT_SIZE = 4;
    public static final int SHORT_SIZE = 2;
    public static final int BYTE_SIZE = 1;
    public static final int SIGNON_VALID = 0;
    public static final int SIGNON_INVALID = 1;
    public static final int SIGNON_CANCELED = 2;
    public static final int SIGNON_COMM_ERROR = 3;
    protected static double s_dataVersion = 5.40001;
    protected DebugWindow m_dbgWnd = null;
    protected double m_dataVersion = 5.40001;
    protected String m_user = "";
    protected String m_system = "";
    protected String m_ip = "";
    protected int m_port = -1;
    protected String m_portService = "";
    protected byte[] m_clientSeed = new byte[8];
    protected byte[] m_serverSeed = new byte[8];
    protected int m_pwType = 0;
    protected ServerSocket m_serverSocket = null;
    protected Socket m_socket = null;
    protected DataInputStream m_in = null;
    protected DataOutputStream m_out = null;
    protected CommLinkThread m_thread = null;
    protected Vector m_listeners = new Vector();
    protected int m_status = 0;
    protected PacketInflater m_inflater = null;

    public CommLink(DebugWindow debugWindow, String string, int n, PacketInflater packetInflater) throws IOException {
        this.m_dbgWnd = debugWindow;
        this.m_inflater = packetInflater;
        this.m_user = Util.upper(string);
        this.m_serverSocket = new ServerSocket(n);
        this.m_port = this.m_serverSocket.getLocalPort();
    }

    public CommLink(DebugWindow debugWindow, String string, String string2, int n, String string3, PacketInflater packetInflater) throws UnknownHostException {
        this.m_dbgWnd = debugWindow;
        this.m_inflater = packetInflater;
        this.m_system = Util.upper(string);
        this.m_user = Util.upper(string2);
        this.m_ip = InetAddress.getByName(string).getHostAddress();
        this.m_port = n;
        this.m_portService = string3;
    }

    public void cleanUp() {
        this.m_listeners.clear();
        this.m_dbgWnd = null;
        this.m_user = null;
        this.m_system = null;
        this.m_ip = null;
        this.m_portService = null;
        this.m_clientSeed = null;
        this.m_serverSeed = null;
        this.m_serverSocket = null;
        this.m_socket = null;
        this.m_in = null;
        this.m_out = null;
        this.m_thread = null;
        this.m_listeners = null;
        this.m_inflater = null;
    }

    public double getSystemVersion() {
        return this.m_dataVersion;
    }

    public String getSystem() {
        return this.m_system;
    }

    public void setSystem(String string) {
        this.m_system = Util.upper(string);
    }

    public String getIp() {
        return this.m_ip;
    }

    public int getPort() {
        return this.m_port;
    }

    public void setPort(int n) {
        this.m_port = n;
    }

    public String getUser() {
        return this.m_user;
    }

    public void setUser(String string) {
        this.m_user = Util.upper(string);
    }

    public byte[] getClientSeed() {
        return this.m_clientSeed;
    }

    public byte[] getServerSeed() {
        return this.m_serverSeed;
    }

    public int getPasswordType() {
        return this.m_pwType;
    }

    public void setPacketInflater(PacketInflater packetInflater) {
        this.m_inflater = packetInflater;
    }

    public void addListener(CommLinkListener commLinkListener) {
        this.m_listeners.addElement(commLinkListener);
    }

    public boolean removeListener(CommLinkListener commLinkListener) {
        boolean bl = false;
        int n = this.m_listeners.size();
        int n2 = 0;
        while (n2 < n) {
            CommLinkListener commLinkListener2 = (CommLinkListener)this.m_listeners.elementAt(n2);
            if (commLinkListener2 == commLinkListener) {
                this.m_listeners.removeElementAt(n2);
                bl = true;
                break;
            }
            ++n2;
        }
        return bl;
    }

    protected void fireCommLinkEvent(CommLinkEvent commLinkEvent) {
        if (this.m_listeners == null) {
            return;
        }
        int n = this.m_listeners.size();
        int n2 = 0;
        while (n2 < n) {
            CommLinkListener commLinkListener = (CommLinkListener)this.m_listeners.elementAt(n2);
            if (commLinkEvent.getType() == 9) {
                commLinkListener.commLinkPacket(commLinkEvent);
            } else {
                commLinkListener.commLinkStatusChanged(commLinkEvent);
            }
            ++n2;
        }
    }

    public int getStatus() {
        return this.m_status;
    }

    public boolean isConnected() {
        return this.m_socket != null && this.m_status == 2;
    }

    public boolean isConnecting() {
        return this.m_socket != null && this.m_status == 1;
    }

    public boolean isFailed() {
        return this.m_socket == null || this.m_status == -1 || this.m_status == 4;
    }

    public boolean isCanceled() {
        return this.m_status == 7;
    }

    public boolean isListening() {
        return this.m_thread != null;
    }

    public boolean connect(boolean bl) {
        this.m_status = 1;
        this.fireCommLinkEvent(new CommLinkEvent(this, 1));
        int n = this.requireSignon() ? this.prepareSignon() : 0;
        switch (n) {
            case 0: {
                try {
                    if (this.m_port == -1) {
                        this.m_port = PortMap.getPort(this.m_dbgWnd.getJFrame(), this.m_system, this.m_portService);
                        if (this.m_port == -1) {
                            this.m_status = 8;
                            this.fireCommLinkEvent(new CommLinkEvent(this, 8));
                            return false;
                        }
                    }
                    this.m_socket = new Socket(this.m_system, this.m_port);
                    this.m_in = new DataInputStream(new BufferedInputStream(this.m_socket.getInputStream()));
                    this.m_out = new DataOutputStream(new BufferedOutputStream(this.m_socket.getOutputStream(), 2048));
                    this.writeConnectHeader();
                    this.readConnectHeader();
                    if (this.requireSignon()) {
                        this.signon();
                    }
                    this.m_status = 2;
                    this.fireCommLinkEvent(new CommLinkEvent(this, 2));
                    if (!bl) break;
                    this.listen();
                }
                catch (Throwable throwable) {
                    this.m_status = -1;
                    this.fireCommLinkEvent(new CommLinkEvent(this, -1));
                    this.m_socket = null;
                    throwable.printStackTrace();
                }
                break;
            }
            case 1: 
            case 3: {
                this.m_status = -1;
                this.fireCommLinkEvent(new CommLinkEvent(this, -1));
                break;
            }
            case 2: {
                this.m_status = 7;
                this.fireCommLinkEvent(new CommLinkEvent(this, 7));
            }
        }
        return this.m_status == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean accept(boolean bl) {
        boolean bl2 = true;
        try {
            block5: {
                try {
                    this.m_status = 5;
                    this.fireCommLinkEvent(new CommLinkEvent(this, 5));
                    this.m_socket = this.m_serverSocket.accept();
                    this.m_in = new DataInputStream(new BufferedInputStream(this.m_socket.getInputStream()));
                    this.m_out = new DataOutputStream(new BufferedOutputStream(this.m_socket.getOutputStream(), 2048));
                    this.readConnectHeader();
                    this.writeConnectHeader();
                    if (this.requireSignon()) {
                        this.signon();
                    }
                    this.m_status = 2;
                    this.fireCommLinkEvent(new CommLinkEvent(this, 6));
                    this.m_serverSocket.close();
                    if (!bl) break block5;
                    this.listen();
                }
                catch (Throwable throwable) {
                    this.m_status = -1;
                    this.fireCommLinkEvent(new CommLinkEvent(this, -1));
                    bl2 = false;
                    Object var5_4 = null;
                    this.m_serverSocket = null;
                }
            }
            Object var5_3 = null;
            this.m_serverSocket = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.m_serverSocket = null;
            throw throwable;
        }
        return bl2;
    }

    public boolean relay(boolean bl) {
        boolean bl2 = true;
        try {
            if (this.m_thread != null) {
                this.m_thread.halt();
                this.m_thread = null;
            }
            this.m_status = 5;
            this.fireCommLinkEvent(new CommLinkEvent(this, 5));
            this.readConnectHeader();
            this.writeConnectHeader();
            if (this.requireSignon()) {
                this.signon();
            }
            this.m_status = 2;
            this.fireCommLinkEvent(new CommLinkEvent(this, 6));
            if (bl) {
                this.listen();
            }
        }
        catch (Throwable throwable) {
            this.m_status = -1;
            this.fireCommLinkEvent(new CommLinkEvent(this, -1));
            bl2 = false;
        }
        return bl2;
    }

    public void listen() {
        if (this.m_thread == null) {
            this.m_thread = new CommLinkThread();
            this.m_thread.setDaemon(true);
            this.m_thread.start();
        }
    }

    public void close() {
        if (this.m_thread != null) {
            this.m_status = 3;
            this.fireCommLinkEvent(new CommLinkEvent(this, 3));
            this.m_thread.halt();
            this.m_thread = null;
        } else if (this.m_status == 1) {
            this.m_status = 7;
            this.fireCommLinkEvent(new CommLinkEvent(this, 7));
        } else {
            this.m_status = 0;
            this.fireCommLinkEvent(new CommLinkEvent(this, 0));
        }
        this.cleanUpSockets();
    }

    protected boolean requireSignon() {
        return true;
    }

    protected int prepareSignon() {
        return PasswordSecurity.instance().prepareSignon(this.m_dbgWnd, this);
    }

    protected void signon() throws IOException {
        PasswordSecurity.instance().signon(this.m_dbgWnd, this);
    }

    protected void readConnectHeader() throws IOException {
        this.m_dataVersion = this.readDouble();
        String string = this.readString();
        if (this.m_system == null || this.m_system.length() == 0) {
            this.m_system = Util.upper(string);
        }
        this.m_ip = this.readString();
        this.m_pwType = this.readInt();
        this.readBytes(this.m_serverSeed);
    }

    protected void writeConnectHeader() throws IOException {
        InetAddress inetAddress = InetAddress.getLocalHost();
        String string = inetAddress.getHostName();
        String string2 = inetAddress.getHostAddress();
        this.writeDouble(s_dataVersion);
        int n = this.writeSize(string) + this.writeSize(string2) + this.writeSize(this.m_clientSeed);
        this.writeInt(n);
        this.writeString(string);
        this.writeString(string2);
        Random random = new Random();
        random.nextBytes(this.m_clientSeed);
        this.writeBytes(this.m_clientSeed);
        this.flush();
    }

    public boolean sendRequest(Request request) throws IOException {
        this.writeInt(request.getType());
        this.writeInt(request.writeSize(this));
        request.write(this);
        this.flush();
        return true;
    }

    public Packet sendRequestAndWait(Request request, int n) throws IOException {
        return null;
    }

    public double readDouble() throws IOException {
        return this.m_in.readDouble();
    }

    public float readFloat() throws IOException {
        return this.m_in.readFloat();
    }

    public long readLong() throws IOException {
        return this.m_in.readLong();
    }

    public int readInt() throws IOException {
        return this.m_in.readInt();
    }

    public short readShort() throws IOException {
        return this.m_in.readShort();
    }

    public byte readByte() throws IOException {
        return this.m_in.readByte();
    }

    public byte[] readBytes() throws IOException {
        int n = this.m_in.readInt();
        byte[] byArray = new byte[n];
        if (n > 0) {
            int n2 = 0;
            int n3 = 0;
            while (n2 < n) {
                int n4 = this.m_in.read(byArray, n3, n - n2);
                n2 += n4;
                n3 += n4;
            }
        }
        return byArray;
    }

    public void readBytes(byte[] byArray) throws IOException {
        int n = this.m_in.readInt();
        if (n == byArray.length) {
            int n2 = 0;
            int n3 = 0;
            while (n2 < n) {
                int n4 = this.m_in.read(byArray, n3, n - n2);
                n2 += n4;
                n3 += n4;
            }
        }
    }

    public void readRawBytes(byte[] byArray) throws IOException {
        int n = byArray.length;
        if (n > 0) {
            int n2 = 0;
            int n3 = 0;
            while (n2 < n) {
                int n4 = this.m_in.read(byArray, n3, n - n2);
                n2 += n4;
                n3 += n4;
            }
        }
    }

    public void readRawBytes(byte[] byArray, int n) throws IOException {
        if (n > 0) {
            int n2 = 0;
            int n3 = 0;
            while (n2 < n) {
                int n4 = this.m_in.read(byArray, n3, n - n2);
                n2 += n4;
                n3 += n4;
            }
        }
    }

    public String readString() throws IOException {
        String string = new String(this.byteArrayToCharArray(this.readBytes()));
        return string;
    }

    public String readAsciiString() throws IOException {
        byte[] byArray = this.readBytes();
        String string = new String(byArray);
        return string;
    }

    public void writeDouble(double d) throws IOException {
        this.m_out.writeDouble(d);
    }

    public void writeFloat(float f) throws IOException {
        this.m_out.writeFloat(f);
    }

    public void writeLong(long l) throws IOException {
        this.m_out.writeLong(l);
    }

    public void writeInt(int n) throws IOException {
        this.m_out.writeInt(n);
    }

    public void writeShort(short s) throws IOException {
        this.m_out.writeShort(s);
    }

    public void writeByte(byte by) throws IOException {
        this.m_out.writeByte(by);
    }

    public void writeBytes(byte[] byArray) throws IOException {
        this.m_out.writeInt(byArray.length);
        this.m_out.write(byArray, 0, byArray.length);
    }

    public void writeRawBytes(byte[] byArray) throws IOException {
        if (byArray.length > 0) {
            this.m_out.write(byArray, 0, byArray.length);
        }
    }

    public void writeRawBytes(byte[] byArray, int n) throws IOException {
        if (n > 0) {
            this.m_out.write(byArray, 0, n);
        }
    }

    public void writeString(String string) throws IOException {
        int n = string.length();
        this.m_out.writeInt(n * 2);
        if (n > 0) {
            this.m_out.writeChars(string);
        }
    }

    public void writeAsciiString(String string) throws IOException {
        byte[] byArray = string.getBytes();
        this.m_out.writeInt(byArray.length);
        if (byArray.length > 0) {
            this.m_out.write(byArray, 0, byArray.length);
        }
    }

    public int writeSize(String string) {
        return 4 + string.length() * 2;
    }

    public int writeAsciiSize(String string) {
        return 4 + string.length();
    }

    public int writeSize(byte[] byArray) {
        return 4 + byArray.length;
    }

    public void flush() throws IOException {
        this.m_out.flush();
    }

    public byte[] charArrayToByteArray(char[] cArray) {
        if (cArray == null) {
            return null;
        }
        byte[] byArray = new byte[cArray.length * 2];
        int n = 0;
        int n2 = 0;
        while (n < cArray.length) {
            byArray[n2++] = (byte)(cArray[n] >> 8);
            byArray[n2++] = (byte)cArray[n++];
        }
        return byArray;
    }

    public char[] byteArrayToCharArray(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        char[] cArray = new char[byArray.length / 2];
        int n = 0;
        int n2 = 0;
        while (n < byArray.length) {
            switch (byArray[n + 1]) {
                case -35: {
                    if (byArray[n] == 0) {
                        cArray[n2++] = 91;
                        n += 2;
                        break;
                    }
                    cArray[n2++] = (char)(((byArray[n++] & 0xFF) << 8) + (byArray[n++] & 0xFF));
                    break;
                }
                case -88: {
                    if (byArray[n] == 0) {
                        cArray[n2++] = 93;
                        n += 2;
                        break;
                    }
                    cArray[n2++] = (char)(((byArray[n++] & 0xFF) << 8) + (byArray[n++] & 0xFF));
                    break;
                }
                default: {
                    cArray[n2++] = (char)(((byArray[n++] & 0xFF) << 8) + (byArray[n++] & 0xFF));
                }
            }
        }
        return cArray;
    }

    protected void cleanUpSockets() {
        try {
            if (this.m_serverSocket != null) {
                this.m_serverSocket.close();
                this.m_serverSocket = null;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        try {
            if (this.m_socket != null) {
                this.m_socket.close();
                this.m_socket = null;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected class CommLinkThread
    extends Thread {
        private boolean m_halt = false;

        protected CommLinkThread() {
        }

        public void halt() {
            this.m_halt = true;
        }

        public void run() {
            boolean bl = false;
            while (!this.m_halt && !bl) {
                try {
                    Object object;
                    int n = CommLink.this.readInt();
                    int n2 = CommLink.this.readInt();
                    if (CommLink.this.m_inflater != null) {
                        object = CommLink.this.m_inflater.inflatePacket(CommLink.this, n, n2);
                        if (object == null) continue;
                        CommLink.this.fireCommLinkEvent(new CommLinkEvent(CommLink.this, 9, (Packet)object));
                        continue;
                    }
                    System.out.println("CommLinkThread.run()  no inflater registered; disregarding packet type=" + n);
                    object = new byte[n2];
                    CommLink.this.m_in.read((byte[])object);
                }
                catch (Throwable throwable) {
                    if (this.m_halt) continue;
                    bl = true;
                }
            }
            if (bl) {
                if (CommLink.this.m_status != 3) {
                    CommLink.this.cleanUpSockets();
                    CommLink.this.m_status = 4;
                    CommLink.this.fireCommLinkEvent(new CommLinkEvent(CommLink.this, 4));
                } else {
                    CommLink.this.m_status = 0;
                    CommLink.this.fireCommLinkEvent(new CommLinkEvent(CommLink.this, 0));
                }
            } else {
                CommLink.this.m_status = 0;
                CommLink.this.fireCommLinkEvent(new CommLinkEvent(CommLink.this, 0));
            }
            CommLink.this.m_thread = null;
        }
    }
}

