/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.request;

import com.ibm.iseries.debug.request.DebuggerRequest;
import com.ibm.iseries.debug.util.CommLink;
import com.ibm.iseries.debug.util.Util;
import java.io.IOException;

public class StartDebugServerRequest
extends DebuggerRequest {
    private static final String UPPER_SLASH_QSYS_LIB_SLASH = "/QSYS.LIB/";
    private String m_pgmPath;
    private String m_pgmParms;
    private String m_cmd;
    private String m_jobId;
    private String m_user;
    private String m_jvmVersion;
    private String m_classPath;
    private String m_sourcePath;
    private int m_options;

    public StartDebugServerRequest(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, int n) {
        super(500);
        if (string.length() == 0 || string4.length() == 0) {
            this.m_user = string5;
            this.m_pgmPath = "";
            this.m_pgmParms = "";
            this.m_cmd = "";
            this.m_jobId = "";
            this.m_jvmVersion = "";
            this.m_classPath = "";
            this.m_sourcePath = "";
            this.m_options = n;
        } else {
            this.m_user = string5;
            this.m_pgmPath = string;
            this.m_pgmParms = this.quoteIt(string2.trim());
            this.m_cmd = this.quoteIt(string3.trim());
            this.m_jobId = string4;
            this.m_jvmVersion = string6.trim();
            this.m_classPath = string7.trim();
            this.m_sourcePath = string8.trim();
            this.m_options = n;
        }
    }

    public int writeSize(CommLink commLink) {
        int n = 0;
        n += commLink.writeSize(this.m_pgmPath);
        n += commLink.writeSize(this.m_pgmParms);
        n += commLink.writeSize(this.m_jobId);
        n += commLink.writeSize(this.m_user);
        n += commLink.writeSize(this.m_jvmVersion);
        n += commLink.writeSize(this.m_classPath);
        n += commLink.writeSize(this.m_sourcePath);
        if (this.m_ctxt != null) {
            double d = commLink.getSystemVersion();
            if (this.m_ctxt.isSupported(3, d)) {
                n += commLink.writeSize(this.m_cmd);
            }
            if (this.m_ctxt.isSupported(4, d)) {
                n += 4;
            }
        }
        return n;
    }

    public void write(CommLink commLink) throws IOException {
        String string = Util.upper(this.m_pgmPath);
        if (string.startsWith(UPPER_SLASH_QSYS_LIB_SLASH)) {
            commLink.writeString(string);
        } else {
            commLink.writeString(this.m_pgmPath);
        }
        commLink.writeString(this.m_pgmParms);
        commLink.writeString(Util.upper(this.m_jobId));
        commLink.writeString(Util.upper(this.m_user));
        commLink.writeString(this.m_jvmVersion);
        commLink.writeString(this.m_classPath);
        commLink.writeString(this.m_sourcePath);
        if (this.m_ctxt != null) {
            double d = commLink.getSystemVersion();
            if (this.m_ctxt.isSupported(3, d)) {
                commLink.writeString(this.m_cmd);
            }
            if (this.m_ctxt.isSupported(4, d)) {
                commLink.writeInt(this.m_options);
            }
        }
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_pgmPath = null;
        this.m_pgmParms = null;
        this.m_jobId = null;
        this.m_user = null;
        this.m_jvmVersion = null;
        this.m_classPath = null;
        this.m_sourcePath = null;
    }

    private String quoteIt(String string) {
        if (string.length() > 0 && string.indexOf(39) >= 0) {
            StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
            int n = string.length();
            int n2 = 0;
            while (n2 < n) {
                char c = string.charAt(n2);
                stringBuffer.append(c);
                if (c == '\'') {
                    stringBuffer.append(c);
                    stringBuffer.append(c);
                    stringBuffer.append(c);
                }
                ++n2;
            }
            string = stringBuffer.toString();
        }
        return string;
    }
}

