/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.request;

import com.ibm.iseries.debug.BreakpointDescriptor;
import com.ibm.iseries.debug.request.DebuggerRequest;
import com.ibm.iseries.debug.util.CommLink;
import java.io.IOException;
import java.util.ArrayList;

public class LnBrkRequest
extends DebuggerRequest {
    public static final int ADD = 1;
    public static final int REMOVE = 2;
    public static final int ENABLE = 3;
    public static final int DISABLE = 4;
    private int m_action;
    private ArrayList m_descriptors;

    public LnBrkRequest(int n, BreakpointDescriptor breakpointDescriptor) {
        super(506);
        this.m_action = n;
        this.m_descriptors = new ArrayList(1);
        this.m_descriptors.add(breakpointDescriptor);
    }

    public LnBrkRequest(int n, ArrayList arrayList) {
        super(506);
        this.m_action = n;
        this.m_descriptors = arrayList != null ? (ArrayList)arrayList.clone() : null;
    }

    public void write(CommLink commLink) throws IOException {
        commLink.writeInt(this.m_action);
        int n = this.m_descriptors.size();
        commLink.writeInt(n);
        int n2 = 0;
        while (n2 < n) {
            BreakpointDescriptor breakpointDescriptor = (BreakpointDescriptor)this.m_descriptors.get(n2);
            breakpointDescriptor.write(commLink);
            ++n2;
        }
    }

    public int writeSize(CommLink commLink) {
        int n = 8;
        int n2 = this.m_descriptors.size();
        int n3 = 0;
        while (n3 < n2) {
            BreakpointDescriptor breakpointDescriptor = (BreakpointDescriptor)this.m_descriptors.get(n3);
            n += breakpointDescriptor.writeSize(commLink);
            ++n3;
        }
        return n;
    }

    public void cleanUp() {
        super.cleanUp();
        if (this.m_descriptors != null) {
            this.m_descriptors.clear();
            this.m_descriptors = null;
        }
    }
}

