/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.panel;

import com.ibm.iseries.debug.BreakpointIcon;
import com.ibm.iseries.debug.ThreadDescriptor;
import com.ibm.iseries.debug.event.ContextEvent;
import com.ibm.iseries.debug.event.LAFEvent;
import com.ibm.iseries.debug.event.SettingsEvent;
import com.ibm.iseries.debug.listener.ContextListener;
import com.ibm.iseries.debug.listener.LAFListener;
import com.ibm.iseries.debug.listener.SettingsListener;
import com.ibm.iseries.debug.request.ModifyThreadRequest;
import com.ibm.iseries.debug.request.ThreadsRequest;
import com.ibm.iseries.debug.util.Action;
import com.ibm.iseries.debug.util.ContextMenu;
import com.ibm.iseries.debug.util.DebugContext;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.Settings;
import com.ibm.iseries.debug.util.TabPanel;
import com.ibm.iseries.debug.util.TabbedPane;
import com.ibm.iseries.debug.util.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import javax.accessibility.Accessible;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class ThreadsPanel
extends TabPanel
implements ContextListener,
SettingsListener,
LAFListener,
MouseListener,
ListSelectionListener,
ClipboardOwner {
    public static final String KEY = "threads";
    protected static final String GIF = "/com/ibm/iseries/debug/dbg022.gif";
    protected static final String EMPTY_GIF = "/com/ibm/iseries/debug/dbg072.gif";
    protected static final String CHECKONLY_GIF = "/com/ibm/iseries/debug/dbg071.gif";
    protected static final String GRAYNOCHECK_GIF = "/com/ibm/iseries/debug/dbg069.gif";
    protected static final String GRAYCHECK_GIF = "/com/ibm/iseries/debug/dbg070.gif";
    protected static final int COL_COUNT = 9;
    protected static final int ENABLED_COL = 0;
    protected static final int THREAD_ID_COL = 1;
    protected static final int INITIAL_COL = 2;
    protected static final int STOPPED_COL = 3;
    protected static final int MODULE_COL = 4;
    protected static final int LINE_NUM_COL = 5;
    protected static final int STMT_NUM_COL = 6;
    protected static final int PGM_NAME_COL = 7;
    protected static final int PGM_LIB_COL = 8;
    protected TabPanel.TabScrollPane m_scrollPane;
    protected Tbl m_table;
    protected TblModel m_tableModel = new TblModel();
    protected ImageIcon m_empty;
    protected ImageIcon m_checkOnly;
    protected ImageIcon m_grayNoCheck;
    protected ImageIcon m_grayCheck;
    protected ContextMenu m_contextMenu;
    protected boolean m_notCurrent;
    protected boolean m_readOnly = true;
    protected ThreadDescriptor[] m_threads;
    protected int m_enabledThreads;
    protected int m_currentColumnCount;
    protected int[] m_currentColumns;
    protected HashMap m_columnNameToId;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$javax$swing$ImageIcon;
    static /* synthetic */ Class class$java$lang$Boolean;

    public ThreadsPanel() {
        super(MRI.get("DBG_THREADS"), MRI.getIcon(0, GIF));
        this.m_table = new Tbl(this.m_tableModel);
        this.m_scrollPane = new TabPanel.TabScrollPane(this, this.m_table);
        this.m_empty = MRI.getIcon(0, EMPTY_GIF);
        this.m_checkOnly = MRI.getIcon(0, CHECKONLY_GIF);
        this.m_grayNoCheck = MRI.getIcon(0, GRAYNOCHECK_GIF);
        this.m_grayCheck = MRI.getIcon(0, GRAYCHECK_GIF);
        this.m_table.getTableHeader().setReorderingAllowed(false);
        if (this.m_table.getRowHeight() < 18) {
            this.m_table.setRowHeight(18);
        }
        this.m_table.getSelectionModel().addListSelectionListener(this);
        this.m_table.addMouseListener(this);
        this.m_scrollPane.getViewport().addMouseListener(this);
        this.m_table.addFocusListener(this);
        this.m_scrollPane.getViewport().addFocusListener(this);
        this.m_columnNameToId = new HashMap();
        int n = 0;
        while (n < 9) {
            this.m_columnNameToId.put(this.getColumnNameFromId(n), new Integer(n));
            ++n;
        }
        Util.setAccessible((Accessible)this.m_table, this.m_name);
        Util.setOrientation(this.m_scrollPane);
    }

    protected void lookAndFeelModifications() {
        this.m_scrollPane.getViewport().setBackground(this.m_table.getBackground());
        Settings settings = this.m_ctxt.getConfig();
        this.m_contextMenu = (ContextMenu)Util.loadObject(settings.getString("threadsContextMenu", null));
        this.m_contextMenu.init(this.m_ctxt.getActionGroup());
    }

    public void clear(boolean bl) {
        this.m_threads = null;
        this.m_enabledThreads = 0;
        this.m_notCurrent = false;
        this.m_tableModel.fireTableDataChanged();
        this.clearActionContext();
    }

    protected void setReadOnly(boolean bl) {
        if (bl != this.m_readOnly) {
            this.m_readOnly = bl;
            if (this.m_threads != null && this.m_threads.length > 0) {
                this.m_tableModel.fireTableDataChanged();
                this.prepareActionContext();
            }
        }
    }

    protected void clearActionContext() {
        this.m_ctxt.getActionGroup().clearThreadContext();
        this.m_ctxt.enableAction("curthd", false);
        this.m_ctxt.enableAction("copy", false);
    }

    protected void prepareActionContext() {
        int n;
        if (!this.m_table.hasFocus()) {
            return;
        }
        boolean bl = false;
        this.m_ctxt.getActionGroup().clearThreadContext();
        if (!this.m_readOnly && this.m_threads != null && this.m_table.getSelectedRowCount() > 0 && (n = this.m_table.getSelectedRow()) >= 0) {
            ThreadDescriptor threadDescriptor = this.m_threads[n];
            this.m_ctxt.getActionGroup().setThreadContext(threadDescriptor);
            if (!threadDescriptor.isCurrentThread()) {
                bl = true;
            }
        }
        this.m_ctxt.enableAction("curthd", bl);
        this.m_ctxt.enableAction("copy", this.m_table.getSelectedRowCount() > 0);
    }

    protected void requestThreads() {
        ThreadsRequest threadsRequest = new ThreadsRequest(2);
        this.m_ctxt.sendRequest(threadsRequest);
    }

    public void setThreads(ThreadDescriptor[] threadDescriptorArray) {
        this.m_threads = threadDescriptorArray;
        this.m_enabledThreads = 0;
        if (this.m_threads != null) {
            int n = 0;
            while (n < threadDescriptorArray.length) {
                if (this.m_threads[n].getState() == 1) {
                    ++this.m_enabledThreads;
                }
                ++n;
            }
        }
        this.m_tableModel.fireTableDataChanged();
        this.m_notCurrent = false;
    }

    public void threadModified(int n, ThreadDescriptor threadDescriptor) {
        if (this.m_threads == null) {
            return;
        }
        boolean bl = false;
        String string = threadDescriptor.getThreadId();
        int n2 = -1;
        int n3 = 0;
        while (!bl && n3 < this.m_threads.length) {
            if (this.m_threads[n3].getThreadId().equals(string)) {
                this.m_threads[n3] = threadDescriptor;
                n2 = n3;
                Object[] objectArray = new Object[]{threadDescriptor.getThreadId()};
                String string2 = null;
                switch (n) {
                    case 1: {
                        string2 = MessageFormat.format(MRI.get("DBG_THREAD_ENABLED_FMT"), objectArray);
                        bl = true;
                        ++this.m_enabledThreads;
                        break;
                    }
                    case 0: {
                        string2 = MessageFormat.format(MRI.get("DBG_THREAD_DISABLED_FMT"), objectArray);
                        bl = true;
                        --this.m_enabledThreads;
                        break;
                    }
                    case 2: {
                        string2 = MessageFormat.format(MRI.get("DBG_THREAD_CURRENT_FMT"), objectArray);
                    }
                }
                this.m_ctxt.setMessage(string2);
            } else if (n == 2) {
                this.m_threads[n3].resetIsCurrentThread();
            }
            ++n3;
        }
        this.m_tableModel.fireTableDataChanged();
        if (n2 >= 0) {
            this.m_table.setRowSelectionInterval(n2, n2);
        }
    }

    protected int maxColCount() {
        return 9;
    }

    protected boolean isValidColId(int n) {
        return true;
    }

    protected int mapColIndex(int n) {
        if (!this.m_isLtoR) {
            n = this.m_currentColumnCount - n - 1;
        }
        return n;
    }

    public void init(DebugContext debugContext, TabbedPane tabbedPane) {
        super.init(debugContext, tabbedPane);
        this.lookAndFeelModifications();
        this.restoreSettings();
        this.m_table.init();
        this.m_ctxt.getManager("ctxtmgr").addListener(this);
        this.m_ctxt.getManager("settmgr").addListener(this);
        this.m_ctxt.getManager("lafmgr").addListener(this);
    }

    public void cleanUp() {
        this.m_ctxt.getManager("ctxtmgr").removeListener(this);
        this.m_ctxt.getManager("settmgr").removeListener(this);
        this.m_ctxt.getManager("lafmgr").removeListener(this);
        this.m_table.removeFocusListener(this);
        this.m_scrollPane.getViewport().removeFocusListener(this);
        this.m_scrollPane = null;
        this.m_table = null;
        this.m_tableModel = null;
        this.m_empty = null;
        this.m_checkOnly = null;
        this.m_grayNoCheck = null;
        this.m_grayCheck = null;
        this.m_contextMenu = null;
        this.m_threads = null;
        this.m_columnNameToId = null;
        super.cleanUp();
    }

    public String getHelpId() {
        return "dbgthread_p";
    }

    public String getKey() {
        return KEY;
    }

    public JComponent getComponent() {
        return this.m_scrollPane;
    }

    public void setActivePanel(boolean bl) {
        super.setActivePanel(bl);
        if (bl) {
            this.prepareActionContext();
        } else {
            this.clearActionContext();
        }
    }

    public void setExposed(boolean bl) {
        super.setExposed(bl);
        if (bl && this.m_notCurrent && !this.isSuspended()) {
            this.requestThreads();
        }
    }

    public boolean canDoCopy() {
        return this.m_table.getSelectedRowCount() > 0;
    }

    public void copy() {
        Object object;
        int n = this.m_table.getSelectedRow();
        int n2 = this.m_table.getSelectedColumn();
        if (n2 < 0) {
            n2 = 0;
        }
        if (n >= 0 && n2 >= 0 && (object = this.m_tableModel.getValueAt(n, n2)) instanceof String) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection stringSelection = new StringSelection((String)object);
            clipboard.setContents(stringSelection, this);
        }
    }

    public boolean canDoCopyPanel() {
        return true;
    }

    public void copyPanel() {
        Object object;
        String[][] stringArray;
        StringBuffer stringBuffer = new StringBuffer(500);
        if (this.m_threads != null || this.m_threads.length > 0) {
            stringArray = new String[this.m_threads.length + 1][this.m_currentColumnCount];
            object = new int[this.m_currentColumnCount];
            int n = 0;
            while (n < this.m_currentColumnCount) {
                stringArray[0][n] = this.m_tableModel.getColumnName(n);
                object[n] = stringArray[0][n].length();
                ++n;
            }
            int n2 = 0;
            while (n2 < this.m_threads.length) {
                int n3 = 0;
                while (n3 < this.m_currentColumnCount) {
                    Object object2 = this.m_tableModel.getValueAt(n2, n3);
                    String string = null;
                    string = object2 instanceof ImageIcon ? (object2 == this.m_grayCheck || object2 == this.m_checkOnly ? "x" : "") : (object2 instanceof Boolean ? ((Boolean)object2 == true ? "x" : "") : (String)object2);
                    stringArray[n2 + 1][n3] = string;
                    if (string.length() > object[n3]) {
                        object[n3] = string.length();
                    }
                    ++n3;
                }
                ++n2;
            }
            String string = "                                                         ";
            int n4 = 0;
            while (n4 < this.m_threads.length + 1) {
                int n5 = 0;
                while (n5 < this.m_currentColumnCount) {
                    reference var9_13 = object[n5] - stringArray[n4][n5].length() + 3;
                    while (var9_13 > string.length()) {
                        string = string + string;
                    }
                    stringBuffer.append(stringArray[n4][n5]);
                    stringBuffer.append(string.substring(0, (int)var9_13));
                    ++n5;
                }
                stringBuffer.append('\n');
                ++n4;
            }
        }
        stringArray = Toolkit.getDefaultToolkit().getSystemClipboard();
        object = new StringSelection(stringBuffer.toString());
        stringArray.setContents((Transferable)object, this);
    }

    public boolean canDoSuspend() {
        return true;
    }

    public void setSuspended(boolean bl) {
        super.setSuspended(bl);
        if (bl) {
            this.clear(true);
        } else {
            this.requestThreads();
        }
        this.m_scrollPane.setText(bl ? MRI.get("DBG_SUSPENDED") : null);
    }

    public boolean canDoColumns() {
        return true;
    }

    public ArrayList getAvailableColumns() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.m_currentColumnCount < this.maxColCount()) {
            int n = 0;
            while (n < 9) {
                if (this.isValidColId(n)) {
                    boolean bl = false;
                    int n2 = 0;
                    while (n2 < this.m_currentColumnCount) {
                        if (this.m_currentColumns[n2] == n) {
                            bl = true;
                            break;
                        }
                        ++n2;
                    }
                    if (!bl) {
                        arrayList.add(this.getColumnNameFromId(n));
                    }
                }
                ++n;
            }
        }
        return arrayList;
    }

    public ArrayList getCurrentColumns() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < this.m_currentColumnCount) {
            arrayList.add(this.getColumnNameFromId(this.m_currentColumns[this.mapColIndex(n)]));
            ++n;
        }
        return arrayList;
    }

    public void setCurrentColumns(ArrayList arrayList) {
        this.m_currentColumnCount = arrayList.size();
        this.m_currentColumns = new int[this.m_currentColumnCount];
        int n = 0;
        while (n < this.m_currentColumnCount) {
            String string = (String)arrayList.get(n);
            Integer n2 = (Integer)this.m_columnNameToId.get(string);
            int n3 = this.mapColIndex(n);
            this.m_currentColumns[n3] = n2;
            ++n;
        }
        this.m_tableModel.fireTableStructureChanged();
    }

    public void saveSettings() {
        int n;
        String string = this.getKey();
        if (this.m_currentColumnCount != this.maxColCount()) {
            n = this.m_currentColumnCount;
            while (n < 9) {
                this.m_userCfg.remove(string + "Col" + n);
                this.m_userCfg.remove(string + "Col" + n + "Width");
                ++n;
            }
        }
        this.m_userCfg.setInt(string + "Cols", this.m_currentColumnCount);
        n = 0;
        while (n < this.m_currentColumnCount) {
            int n2 = this.mapColIndex(n);
            this.m_userCfg.setInt(string + "Col" + n, this.m_currentColumns[n2]);
            this.m_userCfg.setInt(string + "Col" + n + "Width", this.m_table.getColumnModel().getColumn(n2).getWidth());
            ++n;
        }
    }

    public void restoreSettings() {
        int n;
        String string = this.getKey();
        this.m_currentColumnCount = this.m_userCfg.getInt(string + "Cols", 0);
        if (this.m_currentColumnCount <= 0) {
            this.initDefaultColumns();
            return;
        }
        this.m_currentColumns = new int[this.m_currentColumnCount];
        int n2 = 0;
        while (n2 < this.m_currentColumnCount) {
            n = this.mapColIndex(n2);
            this.m_currentColumns[n] = this.m_userCfg.getInt(string + "Col" + n2, -1);
            if (this.m_currentColumns[n] < 0) {
                this.initDefaultColumns();
                return;
            }
            ++n2;
        }
        this.m_tableModel.fireTableStructureChanged();
        n = 0;
        while (n < this.m_currentColumnCount) {
            int n3 = this.mapColIndex(n);
            int n4 = this.m_userCfg.getInt(string + "Col" + n + "Width", -1);
            if (n4 >= 0) {
                this.m_table.getColumnModel().getColumn(n3).setPreferredWidth(n4);
            }
            ++n;
        }
    }

    protected void initDefaultColumns() {
        this.m_currentColumnCount = this.maxColCount();
        this.m_currentColumns = new int[this.m_currentColumnCount];
        int n = 0;
        int n2 = 0;
        while (n2 < 9) {
            if (this.isValidColId(n2)) {
                this.m_currentColumns[this.mapColIndex((int)n)] = n2;
                ++n;
            }
            ++n2;
        }
        this.m_tableModel.fireTableStructureChanged();
    }

    protected String getColumnNameFromId(int n) {
        switch (n) {
            case 0: {
                return MRI.get("DBG_ENABLED");
            }
            case 1: {
                return MRI.get("DBG_THREAD_ID");
            }
            case 2: {
                return MRI.get("DBG_INITIAL_THREAD");
            }
            case 3: {
                return MRI.get("DBG_STOPPED_THREAD");
            }
            case 4: {
                return MRI.get("DBG_MODULE");
            }
            case 5: {
                return MRI.get("DBG_LINE");
            }
            case 6: {
                return MRI.get("DBG_STATEMENT");
            }
            case 7: {
                return MRI.get("DBG_PROGRAM");
            }
            case 8: {
                return MRI.get("DBG_LIBRARY");
            }
        }
        return "";
    }

    public void contextChanged(ContextEvent contextEvent) {
        switch (contextEvent.getType()) {
            case 0: 
            case 1: {
                if (!this.isSuspended() && this.isExposed()) {
                    this.requestThreads();
                } else {
                    this.m_notCurrent = true;
                }
                this.setReadOnly(false);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.setReadOnly(true);
                break;
            }
            case 4: {
                this.clear(true);
                this.setReadOnly(true);
            }
        }
    }

    public void lookAndFeelChanged(LAFEvent lAFEvent) {
        this.lookAndFeelModifications();
    }

    public void settingsChanged(SettingsEvent settingsEvent) {
        if (settingsEvent.colorsChanged() || settingsEvent.fontsChanged()) {
            this.m_table.settingsChanged(settingsEvent.getType());
        }
    }

    protected boolean handlePopupMenu(MouseEvent mouseEvent) {
        boolean bl = false;
        if (mouseEvent.isPopupTrigger()) {
            int n = this.m_table.rowAtPoint(mouseEvent.getPoint());
            if (n >= 0) {
                if (this.m_table.isRowSelected(n)) {
                    this.prepareActionContext();
                } else {
                    this.m_table.setRowSelectionInterval(n, n);
                }
            } else {
                this.clearActionContext();
            }
            this.m_contextMenu.show((JComponent)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
            bl = true;
        }
        return bl;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n;
        this.m_ctxt.setActivePanel(this);
        ((JComponent)mouseEvent.getSource()).requestFocus();
        if (!this.handlePopupMenu(mouseEvent) && mouseEvent.getClickCount() == 2 && (n = this.m_table.rowAtPoint(mouseEvent.getPoint())) >= 0) {
            this.prepareActionContext();
            this.m_ctxt.clearMessage();
            if (this.m_readOnly) {
                this.m_ctxt.setMessage(MRI.get("DBG_CURRENT_THREAD_NOT_CHANGED"));
            } else {
                Action action = this.m_ctxt.getAction("curthd");
                if (action != null && action.isEnabled()) {
                    action.run();
                } else if (this.m_threads[n].isCurrentThread() && (action = this.m_ctxt.getAction("gosrc")) != null) {
                    this.m_ctxt.getActionGroup().setGotoSrcContext(this.m_threads[n].getViewId(), this.m_threads[n].getLineNum());
                    action.run();
                }
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.handlePopupMenu(mouseEvent);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.prepareActionContext();
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class TblModel
    extends AbstractTableModel {
        protected TblModel() {
        }

        public int getColumnCount() {
            return ThreadsPanel.this.m_currentColumnCount;
        }

        public int getRowCount() {
            return ThreadsPanel.this.m_threads != null ? ThreadsPanel.this.m_threads.length : 0;
        }

        public String getColumnName(int n) {
            return ThreadsPanel.this.getColumnNameFromId(ThreadsPanel.this.m_currentColumns[n]);
        }

        public Object getValueAt(int n, int n2) {
            if (ThreadsPanel.this.m_threads == null || ThreadsPanel.this.m_threads.length == 0) {
                return "";
            }
            switch (ThreadsPanel.this.m_currentColumns[n2]) {
                case 0: {
                    int n3 = ThreadsPanel.this.m_threads[n].getState();
                    if (ThreadsPanel.this.m_readOnly || ThreadsPanel.this.m_threads.length == 1) {
                        return n3 == 1 ? ThreadsPanel.this.m_grayCheck : ThreadsPanel.this.m_grayNoCheck;
                    }
                    return new Boolean(n3 == 1);
                }
                case 1: {
                    return ThreadsPanel.this.m_threads[n].getThreadId();
                }
                case 2: {
                    return ThreadsPanel.this.m_threads[n].isInitialThread() ? ThreadsPanel.this.m_checkOnly : ThreadsPanel.this.m_empty;
                }
                case 3: {
                    return ThreadsPanel.this.m_threads[n].isStoppedThread() ? ThreadsPanel.this.m_checkOnly : ThreadsPanel.this.m_empty;
                }
                case 4: {
                    return ThreadsPanel.this.m_threads[n].getModuleName();
                }
                case 5: {
                    String string = ThreadsPanel.this.m_threads[n].getAddress();
                    if (string != null) {
                        return string;
                    }
                    return ThreadsPanel.this.m_threads[n].getLineNum() > 0 ? String.valueOf(ThreadsPanel.this.m_threads[n].getLineNum()) : "";
                }
                case 6: {
                    return ThreadsPanel.this.m_threads[n].getStatement() > 0 ? String.valueOf(ThreadsPanel.this.m_threads[n].getStatement()) : "";
                }
                case 7: {
                    return ThreadsPanel.this.m_threads[n].getPgmName();
                }
                case 8: {
                    return ThreadsPanel.this.m_threads[n].getPgmLibrary();
                }
            }
            return "";
        }

        public void setValueAt(Object object, int n, int n2) {
            if (ThreadsPanel.this.m_currentColumns[n2] == 0 && ThreadsPanel.this.m_threads != null && ThreadsPanel.this.m_threads.length > 1) {
                int n3 = ThreadsPanel.this.m_threads[n].getState();
                if (n3 != 2) {
                    int n4 = n3 == 1 ? 0 : 1;
                    ModifyThreadRequest modifyThreadRequest = new ModifyThreadRequest(n4, ThreadsPanel.this.m_threads[n]);
                    ThreadsPanel.this.m_ctxt.sendRequest(modifyThreadRequest);
                }
                ThreadsPanel.this.m_table.setRowSelectionInterval(n, n);
            }
        }

        public Class getColumnClass(int n) {
            if (n >= ThreadsPanel.this.m_currentColumnCount) {
                return class$java$lang$String == null ? (class$java$lang$String = ThreadsPanel.class$("java.lang.String")) : class$java$lang$String;
            }
            switch (ThreadsPanel.this.m_currentColumns[n]) {
                case 0: {
                    if (ThreadsPanel.this.m_readOnly || ThreadsPanel.this.m_threads == null || ThreadsPanel.this.m_threads.length <= 1) {
                        return class$javax$swing$ImageIcon == null ? (class$javax$swing$ImageIcon = ThreadsPanel.class$("javax.swing.ImageIcon")) : class$javax$swing$ImageIcon;
                    }
                    return class$java$lang$Boolean == null ? (class$java$lang$Boolean = ThreadsPanel.class$("java.lang.Boolean")) : class$java$lang$Boolean;
                }
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    return class$java$lang$String == null ? (class$java$lang$String = ThreadsPanel.class$("java.lang.String")) : class$java$lang$String;
                }
                case 2: 
                case 3: {
                    return class$javax$swing$ImageIcon == null ? (class$javax$swing$ImageIcon = ThreadsPanel.class$("javax.swing.ImageIcon")) : class$javax$swing$ImageIcon;
                }
            }
            return class$java$lang$String == null ? (class$java$lang$String = ThreadsPanel.class$("java.lang.String")) : class$java$lang$String;
        }

        public boolean isCellEditable(int n, int n2) {
            if (ThreadsPanel.this.m_currentColumns[n2] == 0) {
                if (ThreadsPanel.this.m_readOnly || ThreadsPanel.this.m_threads == null || ThreadsPanel.this.m_threads.length <= 1 || ThreadsPanel.this.m_threads[n].getState() == 2) {
                    return false;
                }
                if (ThreadsPanel.this.m_enabledThreads == 1) {
                    return ThreadsPanel.this.m_threads[n].getState() == 0;
                }
                return true;
            }
            return false;
        }
    }

    protected class Tbl
    extends JTable {
        private DefaultTableCellRenderer m_renderer = null;
        private BreakpointIcon m_icon = null;

        public Tbl(AbstractTableModel abstractTableModel) {
            super(abstractTableModel);
        }

        public void init() {
            Settings settings = ThreadsPanel.this.m_ctxt.getUserConfig();
            FontMetrics fontMetrics = ((Component)this).getFontMetrics(this.getFont());
            int n = fontMetrics.getAscent() + fontMetrics.getDescent();
            if (n % 2 == 0) {
                --n;
            }
            this.m_icon = new BreakpointIcon(n, settings.getColor("srcStopPosBackground", Color.yellow), true);
            this.m_renderer = new DefaultTableCellRenderer();
            this.m_renderer.setIconTextGap(5);
            this.m_renderer.setIcon(this.m_icon);
        }

        public boolean isFocusTraversable() {
            return this.getRowCount() > 0;
        }

        public TableCellRenderer getCellRenderer(int n, int n2) {
            if (ThreadsPanel.this.m_threads != null && ThreadsPanel.this.m_currentColumns[n2] == 1) {
                this.m_icon.setVisible(ThreadsPanel.this.m_threads[n].isCurrentThread());
                return this.m_renderer;
            }
            return super.getCellRenderer(n, n2);
        }

        public void settingsChanged(int n) {
            Settings settings = ThreadsPanel.this.m_ctxt.getUserConfig();
            FontMetrics fontMetrics = ((Component)this).getFontMetrics(this.getFont());
            int n2 = fontMetrics.getAscent() + fontMetrics.getDescent();
            if (n2 % 2 == 0) {
                --n2;
            }
            this.m_icon.setSize(n2);
            this.m_icon.setColor(settings.getColor("srcStopPosBackground", Color.yellow));
            this.repaint(this.getVisibleRect());
        }
    }
}

